using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Drawing;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera
{
    //internal enum HandlingOverflow
    //{
    //    CHECKED = 0,
    //    UNCHECKED = 1,
    //    EXCEPTION = 2,
    //}

    internal enum DisplayWarningFlag
    {
        IGNORE = 0,
        LATER = 1,
        ONCE = 2,
        DISPLAY = 3,
    }

	internal enum ReduceArgumentOnLoadFlag
	{
		YES = 0,
		ONCE = 1,
		NO = 2,
	}
    /// <summary>
    /// vOŜŎgplWindow쐬Oɐݒ肵ĈȌύXȂ
    /// </summary>
	internal class Config
	{
		static Config()
		{
		}
		private Config()
		{
		}
		public Config(Config config)
		{
			this.ignoreCase = instance.ignoreCase;
			this.useRenameFile = instance.useRenameFile;
			this.useMouse = instance.useMouse;
			this.useMenu = instance.useMenu;
			this.useDebugCommand = instance.useDebugCommand;
			this.allowMultipleInstances = instance.allowMultipleInstances;
			this.autoSave = instance.autoSave;
			this.sizableWindow = instance.sizableWindow;
			this.useGDIplus = instance.useGDIplus;
			
			this.windowX = instance.windowX;
			this.windowY = instance.windowY;
			this.maxLog = instance.maxLog;
			this.printCPerLine = instance.printCPerLine;
			this.printCLength = instance.printCLength;
			this.foreColor = instance.foreColor;
			this.backColor = instance.backColor;
			this.focusColor = instance.focusColor;
			this.logColor = instance.logColor;
			
			this.fontsize = instance.fontsize;
			this.fontname = instance.fontname;
			this.font = instance.font;
			this.lineHeight = instance.lineHeight;
			this.fps = instance.fps;
			this.skipFrame = instance.skipFrame;

			this.displayWarningLevel = instance.displayWarningLevel;
			this.displayReport = instance.displayReport;
			this.reduceArgumentOnLoad = instance.reduceArgumentOnLoad;
			this.reduceFormattedStringOnLoad = instance.reduceFormattedStringOnLoad;
			this.ignoreUncalledFunction = instance.ignoreUncalledFunction;
			this.functionNotFoundWarning = instance.functionNotFoundWarning;
			this.functionNotCalledWarning = instance.functionNotCalledWarning;

			this.lastKey = instance.lastKey;

			this.changeMasterNameIfDebug = instance.changeMasterNameIfDebug;
			this.ignoreWarningFiles.AddRange(instance.ignoreWarningFiles);
		}

		private static Config instance = new Config();
		public static Config Instance { get { return instance; } }
		private bool ignoreCase = true;
		private bool useRenameFile = false;
		private bool useMouse = true;
		private bool useMenu = true;
		private bool useDebugCommand = false;
		private bool allowMultipleInstances = true;
		private bool autoSave = true;
		private bool sizableWindow = true;
		private bool useGDIplus = true;

		private int windowX = 760;
		private int windowY = 480;
		private int maxLog = 5000;
		private int printCPerLine = 3;
		private int printCLength = 25;
		private Color foreColor = Color.FromArgb(192, 192, 192);//LIGHTGRAY
		private Color backColor = Color.FromArgb(0, 0, 0);//BLACK
		private Color focusColor = Color.FromArgb(255, 255, 0);//YELLOW
		private Color logColor = Color.FromArgb(192, 192, 192);//LIGHTGRAY//Color.FromArgb(128, 128, 128);//GRAY

		private int fontsize = 18;
		private string fontname = "lr SVbN";
		private Font font = new Font("lr SVbN", 18.0f, GraphicsUnit.Pixel);
		private int lineHeight = 19;
		private int fps = 15;
		private int skipFrame = 3;

		private int displayWarningLevel = 1;
		private bool displayReport = false;
		private ReduceArgumentOnLoadFlag reduceArgumentOnLoad = ReduceArgumentOnLoadFlag.NO;
		private bool reduceFormattedStringOnLoad = true;
		private bool ignoreUncalledFunction = true;
		private DisplayWarningFlag functionNotFoundWarning = DisplayWarningFlag.IGNORE;
		private DisplayWarningFlag functionNotCalledWarning = DisplayWarningFlag.IGNORE;
		private List<string> ignoreWarningFiles = new List<string>();

		private long lastKey = 0;

		private bool changeMasterNameIfDebug = true;//{̃CJT}B݂Ȃɂ͂Ȃ傾
		public bool ChangeMasterNameIfDebug { get { return changeMasterNameIfDebug; } }

		public readonly static Encoding Encode = Encoding.GetEncoding("SHIFT-JIS");

		public bool IgnoreCase { get { return ignoreCase; } set { ignoreCase = value; } }
		public bool UseRenameFile { get { return useRenameFile; } set { useRenameFile = value; } }
		public bool UseMouse { get { return useMouse; } set { useMouse = value; } }
		public bool UseMenu { get { return useMenu; } set { useMenu = value; } }
		public bool UseDebugCommand { get { return useDebugCommand; } set { useDebugCommand = value; } }
		public bool AllowMultipleInstances { get { return allowMultipleInstances; } set { allowMultipleInstances = value; } }
		public bool AutoSave { get { return autoSave; } set { autoSave = value; } }
		public bool SizableWindow { get { return sizableWindow; } set { sizableWindow = value; } }
		public bool UseGDIplus { get { return useGDIplus; } set { useGDIplus = value; } }
		public int WindowX { get { return windowX; } set { windowX = value; } }
		public int WindowY { get { return windowY; } set { windowY = value; } }
		public int MaxLog { get { return maxLog; } set { maxLog = value; } }
		public int PrintCPerLine { get { return printCPerLine; } set { printCPerLine = value; } }
		public int PrintCLength { get { return printCLength; } set { printCLength = value; } }
		public Color ForeColor { get { return foreColor; } set { foreColor = value; } }
		public Color BackColor { get { return backColor; } set { backColor = value; } }
		public Color FocusColor { get { return focusColor; } set { focusColor = value; } }
		public Color LogColor { get { return logColor; } set { logColor = value; } }
		public int Fontsize { get { return fontsize; } set { fontsize = value; } }
		public string Fontname { get { return fontname; } set { fontname = value; } }
		public Font Font { get { return font; } set { font = value; } }
		public int LineHeight { get { return lineHeight; } set { lineHeight = value; } }
		public int FPS { get { return fps; } set { fps = value; } }
		public int SkipFrame { get { return skipFrame; } set { skipFrame = value; } }

		public int DisplayWarningLevel { get { return displayWarningLevel; } set { displayWarningLevel = value; } }
		public bool DisplayReport { get { return displayReport; } set { displayReport = value; } }
		public ReduceArgumentOnLoadFlag ReduceArgumentOnLoad { get { return reduceArgumentOnLoad; } set { reduceArgumentOnLoad = value; } }
		public bool ReduceFormattedStringOnLoad { get { return reduceFormattedStringOnLoad; } set { reduceFormattedStringOnLoad = value; } }
		public bool IgnoreUncalledFunction { get { return ignoreUncalledFunction; } set { ignoreUncalledFunction = value; } }
		public DisplayWarningFlag FunctionNotFoundWarning { get { return functionNotFoundWarning; } set { functionNotFoundWarning = value; } }
		public DisplayWarningFlag FunctionNotCalledWarning { get { return functionNotCalledWarning; } set { functionNotCalledWarning = value; } }
		public List<string> IgnoreWarningFiles { get { return ignoreWarningFiles; } set { ignoreWarningFiles = value; } }

		public long LastKey { get { return lastKey; } set { lastKey = value; } }
		bool updated = false;
		public bool NeedReduceArgumentOnLoad
		{
			get
			{
				if (reduceArgumentOnLoad == ReduceArgumentOnLoadFlag.ONCE)
					return updated;
				if (reduceArgumentOnLoad == ReduceArgumentOnLoadFlag.YES)
					return true;
				//if (reduceArgumentOnLoad == ReduceArgumentOnLoadFlag.NO)

				return false;
			}
		}

		private long getUpdateKey()
		{
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
			string[] erbFiles = Directory.GetFiles(erbDir, "*.ERB", SearchOption.TopDirectoryOnly);
			string[] csvFiles = Directory.GetFiles(erbDir, "*.csv", SearchOption.TopDirectoryOnly);
			long[] writetimes = new long[erbFiles.Length + csvFiles.Length];
			for(int i = 0;i<erbFiles.Length;i++)
				writetimes[i] = System.IO.File.GetLastWriteTime( erbFiles[i]).ToBinary();
			for(int i = 0;i<csvFiles.Length;i++)
				writetimes[i+erbFiles.Length] = System.IO.File.GetLastWriteTime( csvFiles[i]).ToBinary();
			long key = 0;
			for (int i = 0; i < writetimes.Length; i++)
			{
				unchecked
				{
					key ^= writetimes[i] * 1103515245 + 12345;
				}
			}
			return key;
		}

		private void checkUpdate(string confPath)
		{
			if (reduceArgumentOnLoad != ReduceArgumentOnLoadFlag.ONCE)
				return;
			updated = true;
			if (!File.Exists(confPath))
			{
				return;
			}
			long key = getUpdateKey();
			updated = lastKey != key;
			lastKey = key;
			if (updated)
				SaveConfig(confPath);
		}

		public bool LoadConfig(string confPath)
		{
			if (!File.Exists(confPath))
			{
				IgnoreWarningFiles.Add("EVENT_K.ERB");
				IgnoreWarningFiles.Add("EVENT_K_DUMMY.ERB");
				if (!SaveConfig(confPath))
				{
					MessageBox.Show("RtBOt@Cǂݍ߂܂ł", "s");
					return false;
				}
			}
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(confPath))
				return false;
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(new char[] { ',', ':' });
					if (tokens.Length < 2)
						continue;
					string param = tokens[1].Trim();
					double d = 0.0;
					switch (tokens[0])
					{
						case "IgnoreCase":
						case "啶̈Ⴂ𖳎":
							tryStringToBool(param, ref ignoreCase);
							break;
						case "UseRenameFile":
						case "_Rename.csv𗘗p":
							tryStringToBool(param, ref useRenameFile);
							break;
						case "UseMouse":
						case "}EXgp":
							tryStringToBool(param, ref useMouse);
							break;
						case "UseMenu":
						case "j[gp":
							tryStringToBool(param, ref useMenu);
							break;
						case "UseDebugCommand":
						case "fobOR}hgp":
							tryStringToBool(param, ref useDebugCommand);
							break;
						case "AllowMultipleInstances":
						case "dN":
							tryStringToBool(param, ref allowMultipleInstances);
							break;
						case "AutoSave":
						case "I[gZ[usȂ":
							tryStringToBool(param, ref autoSave);
							break;
						case "SizableWindow":
						case "EBhE̍ςɂ":
							tryStringToBool(param, ref sizableWindow);
							break;
						case "UseGDIplus":
						case "`GDI+p":
							tryStringToBool(param, ref useGDIplus);
							break;
						case "WindowX":
						case "EBhE":
							Int32.TryParse(param, out windowX);
							if (windowX < 160)
								windowX = 160;
							break;
						case "WindowY":
						case "EBhE":
							Int32.TryParse(param, out windowY);
							if (windowY < 120)
								windowY = 120;
							break;
						case "MaxLog":
						case "O̍s":
							Int32.TryParse(param, out maxLog);
							if (maxLog < 20)
								maxLog = 20;
							break;
						case "PrintCPerLine":
						case "PRINTCׂ鐔":
							Int32.TryParse(param, out printCPerLine);
							if (printCPerLine < 1)
								printCPerLine = 1;
							break;
						case "PrintCLength":
						case "PRINTC̕":
							Int32.TryParse(param, out printCLength);
							if (printCLength < 5)
								printCLength = 5;
							break;
						case "FontName":
						case "tHg":
							fontname = tokens[1];
							break;
						case "FontSize":
						case "tHgTCY":
							Int32.TryParse(param, out fontsize);
							if (fontsize < 4)
								fontsize = 4;
							break;
						case "LineHeight":
						case "s̍":
							Double.TryParse(param, out d);
							if (d < 4.0)
								break;
							lineHeight = (int)d;
							break;
						case "BackColor":
						case "wiF":
							tryStringsToColor(tokens, ref backColor);
							break;
						case "ForeColor":
						case "F":
							tryStringsToColor(tokens, ref foreColor);
							break;
						case "FocusColor":
						case "I𒆕F":
							tryStringsToColor(tokens, ref focusColor);
							break;
						case "LogColor":
						case "𕶎F":
							tryStringsToColor(tokens, ref logColor);
							break;
						case "FPS":
						case "t[b":
							Int32.TryParse(param, out fps);
							break;
						case "SkipFrame":
						case "őXLbvt[":
							Int32.TryParse(param, out skipFrame);
							break;
						case "DisplayWarningLevel":
						case "\Œxx":
							Int32.TryParse(param, out displayWarningLevel);
							break;
						case "DisplayReport":
						case "[hɃ|[g\":
							tryStringToBool(param, ref displayReport);
							break;
						case "ReduceArgumentOnLoad":
						case "[hɈ͂":
							param = param.ToUpper();
							if (!Enum.IsDefined(typeof(ReduceArgumentOnLoadFlag), param))
								break;
							reduceArgumentOnLoad = (ReduceArgumentOnLoadFlag)Enum.Parse(typeof(ReduceArgumentOnLoadFlag), param);
							break;

						case "ReduceFormattedStringOnLoad":
						case "[hFORM͂":
							tryStringToBool(param, ref reduceFormattedStringOnLoad);
							break;
						case "IgnoreUncalledFunction":
						case "ĂяoȂ֐𖳎":
							tryStringToBool(param, ref ignoreUncalledFunction);
							break;

						case "FunctionNotFoundWarning":
						case "֐Ȃẍ":
							param = param.ToUpper();
							if (!Enum.IsDefined(typeof(DisplayWarningFlag), param))
								break;
							functionNotFoundWarning = (DisplayWarningFlag)Enum.Parse(typeof(DisplayWarningFlag), param);
							break;
						case "FunctionNotCalledWarning":
						case "֐ĂяoȂẍ":
							param = param.ToUpper();
							if (!Enum.IsDefined(typeof(DisplayWarningFlag), param))
								break;
							functionNotCalledWarning = (DisplayWarningFlag)Enum.Parse(typeof(DisplayWarningFlag), param);
							break;
						case "IgnoreWarningFile":
						case "w肵t@Čx𖳎":
							param = param.ToUpper();
							if ((param.Length != 0) && (!ignoreWarningFiles.Contains(param)))
								ignoreWarningFiles.Add(param);
							break;

						case "ChangeMasterNameIfDebug":
						case "fobOR}hgpMASTER̖OύX":
							tryStringToBool(param, ref changeMasterNameIfDebug);
							break;

						case "LastKey":
						case "ŏIXVR[h":
							Int64.TryParse(param, out lastKey);
							break;

						case "":
							break;

#if DEBUG
                        default:
                            throw new Exception("RtBOt@C");
#endif
					}

				}
				if (lineHeight < fontsize)
					lineHeight = (int)fontsize;
				if (font != null)
					font.Dispose();
				font = new Font(fontname, fontsize, GraphicsUnit.Pixel);
			}
			catch
			{
				return false;
			}
			finally
			{
				eReader.Dispose();
			}
			checkUpdate(confPath);
			return true;
		}

		private string boolToString(bool p)
		{
			if (p)
				return "YES";
			return "NO";
		}

		private bool tryStringToBool(string str, ref bool p)
		{
			if (str == null)
				return false;
			int i = 0;
			if (Int32.TryParse(str, out i))
			{
				p = (i != 0);
				return true;
			}
			if (str.Equals("NO", StringComparison.CurrentCultureIgnoreCase)
				|| str.Equals("FALSE", StringComparison.CurrentCultureIgnoreCase))
			{
				p = false;
				return true;
			}
			if (str.Equals("YES", StringComparison.CurrentCultureIgnoreCase)
				|| str.Equals("TRUE", StringComparison.CurrentCultureIgnoreCase))
			{
				p = true;
				return true;
			}
			return false;
		}

		private string colorToString(Color c)
		{
			return string.Format("{0},{1},{2}", c.R, c.G, c.B);
		}
		private bool tryStringsToColor(string[] tokens, ref Color c)
		{
			int r, g, b;
			if (tokens.Length < 4)
				return false;
			if (!Int32.TryParse(tokens[1], out r) || (r < 0) || (r > 255))
				return false;
			if (!Int32.TryParse(tokens[2], out g) || (g < 0) || (g > 255))
				return false;
			if (!Int32.TryParse(tokens[3], out b) || (b < 0) || (b > 255))
				return false;
			c = Color.FromArgb(r, g, b);
			return true;
		}


		public bool SaveConfig(string confPath)
		{
			StreamWriter writer = null;
			try
			{
				writer = new StreamWriter(confPath, false, Encode);
				writer.WriteLine("啶̈Ⴂ𖳎:" + boolToString(ignoreCase));
				writer.WriteLine("_Rename.csv𗘗p:" + boolToString(useRenameFile));
				writer.WriteLine("}EXgp:" + boolToString(useMouse));
				writer.WriteLine("j[gp:" + boolToString(useMenu));
				writer.WriteLine("fobOR}hgp:" + boolToString(useDebugCommand));
				if(changeMasterNameIfDebug == false)
					writer.WriteLine("fobOR}hgpMASTER̖OύX:" + boolToString(changeMasterNameIfDebug));
				writer.WriteLine("dN:" + boolToString(allowMultipleInstances));
				writer.WriteLine("I[gZ[usȂ:" + boolToString(autoSave));
				writer.WriteLine("EBhE̍ςɂ:" + boolToString(sizableWindow));
				writer.WriteLine("`GDI+p:" + boolToString(useGDIplus));
				writer.WriteLine("EBhE:" + windowX.ToString());
				writer.WriteLine("EBhE:" + windowY.ToString());
				writer.WriteLine("O̍s:" + maxLog.ToString());
				writer.WriteLine("PRINTCׂ鐔:" + printCPerLine.ToString());
				writer.WriteLine("PRINTC̕:" + printCLength.ToString());
				writer.WriteLine("tHg:" + fontname);
				writer.WriteLine("tHgTCY:" + fontsize.ToString());
				writer.WriteLine("s̍:" + lineHeight.ToString());
				writer.WriteLine("wiF:" + colorToString(backColor));
				writer.WriteLine("F:" + colorToString(foreColor));
				writer.WriteLine("I𒆕F:" + colorToString(focusColor));
				writer.WriteLine("𕶎F:" + colorToString(logColor));
				writer.WriteLine("t[b:" + fps.ToString());
				writer.WriteLine("őXLbvt[:" + skipFrame.ToString());
				writer.WriteLine("\Œxx:" + displayWarningLevel.ToString());
				writer.WriteLine("[hɃ|[g\:" + boolToString(displayReport));
				writer.WriteLine("[hɈ͂:" + reduceArgumentOnLoad.ToString());
				writer.WriteLine("[hFORM͂:" + boolToString(reduceFormattedStringOnLoad));
				writer.WriteLine("ĂяoȂ֐𖳎:" + boolToString(ignoreUncalledFunction));
				writer.WriteLine("֐Ȃẍ:" + functionNotFoundWarning.ToString());
				writer.WriteLine("֐ĂяoȂẍ:" + functionNotCalledWarning.ToString());
				foreach (string filename in ignoreWarningFiles)
					writer.WriteLine("w肵t@Čx𖳎:" + filename);
				if(lastKey != 0)
					writer.WriteLine("ŏIXVR[h:" + lastKey.ToString());
			}
			catch (Exception)
			{
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
			}
			return true;
		}
	}
}
