using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Expression
{
	delegate SingleTerm UnaryMethod(SingleTerm operand);
	delegate SingleTerm BinaryMethod(SingleTerm left, SingleTerm right);
	internal static class OperatorMethod
	{
		readonly static Dictionary<OperatorCode, UnaryMethod> unaryDic = new Dictionary<OperatorCode, UnaryMethod>();
		readonly static Dictionary<OperatorCode, BinaryMethod> binaryDic = new Dictionary<OperatorCode, BinaryMethod>();
		static OperatorMethod()
		{
			unaryDic[OperatorCode.Plus] = Plus;
			unaryDic[OperatorCode.Minus] = Minus;
			unaryDic[OperatorCode.Not] = Not;
			unaryDic[OperatorCode.BitNot] = BitNot;

			binaryDic[OperatorCode.Plus] = Plus;
			binaryDic[OperatorCode.Minus] = Minus;
			binaryDic[OperatorCode.Mult] = Mult;
			binaryDic[OperatorCode.Div] = Div;
			binaryDic[OperatorCode.Mod] = Mod;
			binaryDic[OperatorCode.Equal] = Equal;
			binaryDic[OperatorCode.Greater] = Greater;
			binaryDic[OperatorCode.Less] = Less;
			binaryDic[OperatorCode.GreaterEqual] = GreaterEqual;
			binaryDic[OperatorCode.LessEqual] = LessEqual;
			binaryDic[OperatorCode.NotEqual] = NotEqual;
			binaryDic[OperatorCode.And] = And;
			binaryDic[OperatorCode.Or] = Or;
			binaryDic[OperatorCode.BitAnd] = BitAnd;
			binaryDic[OperatorCode.BitOr] = BitOr;
			binaryDic[OperatorCode.BitXor] = BitXor;
			binaryDic[OperatorCode.RightShift] = RightShift;
			binaryDic[OperatorCode.LeftShift] = LeftShift;
		}

		public static UnaryMethod GetUnaryMethod(OperatorCode op)
		{
			if (unaryDic.ContainsKey(op))
				return unaryDic[op];
			return null;
		}

		public static BinaryMethod GetBinaryMethod(OperatorCode op)
		{
			if (binaryDic.ContainsKey(op))
				return binaryDic[op];
			return null;
		}


		public static Type GetReturnType(Type operand, OperatorCode op)
		{
			if (operand == typeof(Int64))
			{
				switch (op)
				{
					case OperatorCode.Plus:
					case OperatorCode.Minus:
					case OperatorCode.Not:
					case OperatorCode.BitNot:
						return typeof(Int64);
				}
			}
			return typeof(void);
		}

		public static Type GetReturnType(Type right, Type left, OperatorCode op)
		{
			if ((left == typeof(Int64)) && (right == typeof(Int64)))
				return typeof(Int64);
			else if ((left == typeof(string)) && (right == typeof(string)))
			{
				switch (op)
				{
					case OperatorCode.Plus:
						return typeof(string);
					case OperatorCode.Equal:
					case OperatorCode.NotEqual:
						return typeof(Int64);
					default:
						return typeof(void);
				}
			}
			else if (((left == typeof(Int64)) && (right == typeof(string)))
				 || ((left == typeof(string)) && (right == typeof(Int64))))
			{
				if(op == OperatorCode.Mult)
						return typeof(string);
			}
			return typeof(void);
		}

		public static SingleTerm Plus(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(left.Int + right.Int); }
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(left.Str + right.Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Minus(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(left.Int - right.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}
		
		public static SingleTerm Mult(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(left.Int * right.Int); }
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(Int64)))
			{
				long value = right.Int;
				string str = left.Str;
				if (value < 0)
					throw new CodeEE("ɕ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if (value >= 10000)
					throw new CodeEE("10000ȏ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if ((str == "") || (value == 0))
					return new SingleTerm("");
				StringBuilder builder = new StringBuilder();
				builder.Capacity = str.Length * (int)value;
				for (int i = 0; i < value; i++)
				{
					builder.Append(str);
				}
				return new SingleTerm(builder.ToString());
			}
			else if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(string)))
			{
				long value = left.Int;
				string str = right.Str;
				if (value < 0)
					throw new CodeEE("ɕ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if (value >= 10000)
					throw new CodeEE("10000ȏ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if ((str == "") || (value == 0))
					return new SingleTerm("");
				StringBuilder builder = new StringBuilder();
				builder.Capacity = str.Length * (int)value;
				for (int i = 0; i < value; i++)
				{
					builder.Append(str);
				}
				return new SingleTerm(builder.ToString());
			}
			throw new ExeEE("s\ȉZ");
		}
		
		public static SingleTerm Div(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				if(right.Int == 0)
					throw new CodeEE("0ɂ鏜ZsȂ܂");
				unchecked { return new SingleTerm(left.Int / right.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Mod(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				if (right.Int == 0)
					throw new CodeEE("0ɂ鏜ZsȂ܂");
				unchecked { return new SingleTerm(left.Int % right.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}


		public static SingleTerm Equal(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int == right.Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(left.Str == right.Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm NotEqual(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int != right.Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(left.Str != right.Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Greater(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int > right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Less(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int < right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm GreaterEqual(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int >= right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm LessEqual(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int <= right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}


		public static SingleTerm And(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int != 0 && right.Int != 0);
			}
			throw new ExeEE("s\ȉZ");
		}
		public static SingleTerm Or(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int != 0 || right.Int != 0);
			}
			throw new ExeEE("s\ȉZ");
		}


		public static SingleTerm BitAnd(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int & right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}
		public static SingleTerm BitOr(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int | right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}
		public static SingleTerm BitXor(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(left.Int ^ right.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm RightShift(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(left.Int >> (int)right.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm LeftShift(SingleTerm left, SingleTerm right)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(left.Int << (int)right.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}


		public static SingleTerm Plus(SingleTerm term)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(term.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Minus(SingleTerm term)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				unchecked { return new SingleTerm(-term.Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		public static SingleTerm Not(SingleTerm term)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(term.Int == 0);
			}
			throw new ExeEE("s\ȉZ");
		}
		public static SingleTerm BitNot(SingleTerm term)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(~term.Int);
			}
			throw new ExeEE("s\ȉZ");
		}

	}
}
