using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.Sub
{


	internal enum BuiltInFunctionCode
	{
		__NULL__ = 0x000,
		__FLOW_CONTROL__ = 0x10000,
		__EXTENDED__ = 0x20000,//g
		__ARG_VOID__ = 0x00100000,//i
		__ARG_INT_EXPRESSION__ = 0x00200000,//^
		__ARG_STR_EXPRESSION__ = 0x00300000,//񎮌^
		__ARG_STR__ = 0x00500000,//P^
		__ARG_FORM_STR__ = 0x00600000,//t^
		__ARG_SP_PRINTV__ = 0x00700000,//^B'``,
		__ARG_SP_TIMES__ = 0x00800000,//lϐE^B
		__ARG_SP_BAR__ = 0x00900000,//EE^
		__ARG_SP_SET__ = 0x00A00000,//ϐlϐE^B
		__ARG_SP_SETS__ = 0x00B00000,//ϕϐEP͕^B
		__ARG_SP_SUBSTRING__ = 0x00C00000,//<ϐ>,<l>,<l>^
		__ARG_SP_SWAP__ = 0x00D00000,//<ϐ>,<l>,<l>^
		__ARG_SP_VARSIZE__ = 0x00E00000,//
		SET = 0x0001 | __ARG_SP_SET__,//l
		SETS = 0x0002 | __ARG_SP_SETS__,//
		PRINT = 0x0100 | __ARG_STR__,//\
		PRINTL = 0x0101 | __ARG_STR__,//s
		PRINTW = 0x0102 | __ARG_STR__,//͑҂(s)

		PRINTV = 0x0103 | __ARG_SP_PRINTV__,//ϐ̓e
		PRINTVL = 0x0104 | __ARG_SP_PRINTV__,
		PRINTVW = 0x0105 | __ARG_SP_PRINTV__,

		PRINTS = 0x0106 | __ARG_STR_EXPRESSION__,//ϐ̓e
		PRINTSL = 0x0107 | __ARG_STR_EXPRESSION__,
		PRINTSW = 0x0108 | __ARG_STR_EXPRESSION__,

		PRINTFORM = 0x0109 | __ARG_FORM_STR__,//{}A%ϐ%Ȃǂ̏gB
		PRINTFORML = 0x010A | __ARG_FORM_STR__,
		PRINTFORMW = 0x010B | __ARG_FORM_STR__,

		PRINTFORMS = 0x010C | __ARG_STR_EXPRESSION__,//ϐ̓eϊĕ\܂B
		PRINTFORMSL = 0x010D | __ARG_STR_EXPRESSION__,
		PRINTFORMSW = 0x010E | __ARG_STR_EXPRESSION__,

		PRINTC = 0x010F | __ARG_STR__,//??

		WAIT = 0x0200 | __ARG_VOID__,//s҂B
		INPUT = 0x0201 | __ARG_VOID__,//́B͂RESULTցB
		INPUTS = 0x0202 | __ARG_VOID__,//́B͂RESULTSցB

		DRAWLINE = 0x0401 | __ARG_VOID__,//ʂ̍[E[܂----ƐB
		BAR = 0x0402 | __ARG_SP_BAR__,//[*****....]̂悤ȃOtBBAR (ϐ) , (ől), ()
		BARL = 0x0403 | __ARG_SP_BAR__,//stB
		TIMES = 0x0404 | __ARG_SP_TIMES__,//vZBTIMES (ϐ) , (l)Ƃ`ŎgB

		PRINT_ABL = 0x0801 | __ARG_INT_EXPRESSION__,//\́B͓o^ԍ
		PRINT_TALENT = 0x0802 | __ARG_INT_EXPRESSION__,//f
		PRINT_MARK = 0x0803 | __ARG_INT_EXPRESSION__,//
		PRINT_EXP = 0x0804 | __ARG_INT_EXPRESSION__,//o
		PRINT_PALAM = 0x0805 | __ARG_INT_EXPRESSION__,//p[^

		PRINT_ITEM = 0x0806 | __ARG_VOID__,//ACe
		PRINT_SHOPITEM = 0x0807 | __ARG_VOID__,//VbvŔĂACe
		UPCHECK = 0x1001 | __ARG_VOID__,//p[^̕ϓ
		ADDCHARA = 0x1002 | __ARG_INT_EXPRESSION__,//(Lԍ)̃LN^ǉ
		ADDSPCHARA = 0x1003 | __ARG_INT_EXPRESSION__,//(Lԍ)SPLN^ǉitO01ɂč쐬j
		DELCHARA = 0x1004 | __ARG_INT_EXPRESSION__,//(Lo^ԍ)̃LN^폜B


		PUTFORM = 0x1007 | __ARG_FORM_STR__,//@SAVEINFO֐ł̂ݎgp\BPRINTFORMƓl̏ŃZ[uf[^ɊTvB
		QUIT = 0x1008 | __ARG_VOID__,//Q[I

		BEGIN = 0x02 | __FLOW_CONTROL__ | __ARG_STR__,//VXe֐̎sBsCALĽĂяoȂǂYĂ܂B

		SAVEGAME = 0x03 | __FLOW_CONTROL__ | __ARG_VOID__,//Z[uʂĂԁBVbv̂݁B
		LOADGAME = 0x04 | __FLOW_CONTROL__ | __ARG_VOID__,//

		SIF = 0x10 | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,//ŝIF
		IF = 0x11 | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		ELSE = 0x12 | __FLOW_CONTROL__ | __ARG_VOID__,
		ELSEIF = 0x13 | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		ENDIF = 0x14 | __FLOW_CONTROL__ | __ARG_VOID__,

		REPEAT = 0x21 | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,//REND܂ŌJԂBJԂ񐔂COUNTցBlXgsB
		REND = 0x22 | __FLOW_CONTROL__ | __ARG_VOID__,
		CONTINUE = 0x23 | __FLOW_CONTROL__ | __ARG_VOID__,//REPEATɖ߂
		BREAK = 0x24 | __FLOW_CONTROL__ | __ARG_VOID__,//REND̎̍s܂

		GOTO = 0x31 | __FLOW_CONTROL__ | __ARG_STR__,//$xփWv

		JUMP = 0x32 | __FLOW_CONTROL__ | __ARG_STR__,//֐Ɉړ
		CALL = 0x33 | __FLOW_CONTROL__ | __ARG_STR__,//֐ɈړBړLARETURNŋAB
		RETURN = 0x34 | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,//֐̏IBRESULTɐi[\BȗꍇAOB(@``RETURNƌȂB)
		RESTART = 0x35 | __FLOW_CONTROL__ | __ARG_VOID__,//֐̍ĊJB֐̍ŏɖ߂B


		STRLEN = 0x40 | __EXTENDED__ | __ARG_STR__,
		STRLENS = 0x41 | __EXTENDED__ | __ARG_STR_EXPRESSION__,
		STRLENFORM = 0x42 | __EXTENDED__ | __ARG_FORM_STR__,
		PRINTFORMC = 0x43 | __EXTENDED__ | __ARG_FORM_STR__,
		SUBSTRING = 0x44 | __EXTENDED__ | __ARG_SP_SUBSTRING__,
		SWAPCHARA = 0x45 | __EXTENDED__ | __ARG_SP_SWAP__,
		VARSIZE = 0x46 | __EXTENDED__| __ARG_SP_VARSIZE__ ,//
	}
	internal static class BuiltInFunctionManager
	{
		readonly static Dictionary<string, BuiltInFunctionCode> nameDic = new Dictionary<string, BuiltInFunctionCode>();
		static BuiltInFunctionManager()
		{
			//Enum.IsDefined(typeof(BuiltInFunctionCode), key)ƂƏdB
			//`FbNParseėOɂ܂ƂɏdB
			//Ȃ̂ł炩ߕϊĂB
			Array array = Enum.GetValues(typeof(BuiltInFunctionCode));
			foreach (object name in array)
			{
				BuiltInFunctionCode func = (BuiltInFunctionCode)name;
				string key = func.ToString();
				if ((key == null) || (key.StartsWith("__") && key.EndsWith("__")))
					continue;
				if ((key == "SET") || (key == "SETS"))
					continue;
				if (Config.Instance.IgnoreCase)
					key = key.ToUpper();
				nameDic.Add(key, func);
			}
		}

		public static BuiltInFunctionCode ToBuiltInFunction(string str)
		{
			string key = str;
			if (string.IsNullOrEmpty(key))
				return BuiltInFunctionCode.__NULL__;
			if (Config.Instance.IgnoreCase)
				key = key.ToUpper();
			if (!nameDic.ContainsKey(key))
				return BuiltInFunctionCode.__NULL__;
			return nameDic[key];
		}
			

		internal static bool IsFlowContorol(BuiltInFunctionCode builtInFunctionName)
		{
			return ((builtInFunctionName & BuiltInFunctionCode.__FLOW_CONTROL__) == BuiltInFunctionCode.__FLOW_CONTROL__);
		}
	}
}
