using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Text;

namespace MinorShift.Emuera
{
	internal enum ConfigDialogResult
	{
		Cancel = 0,
		Save = 1,
		SaveReboot = 2,
	}

	internal partial class ConfigDialog : Form
	{
		public ConfigDialog()
		{
			InitializeComponent();
			numericUpDown2.Maximum = 10000;
			numericUpDown3.Maximum = 10000;
			numericUpDown4.Maximum = 1000000;
			numericUpDown1.Maximum = 100;
			numericUpDown9.Maximum = 100;
			numericUpDown6.Maximum = 144;
			numericUpDown7.Maximum = 240;
			numericUpDown8.Maximum = 100;
			numericUpDown5.Maximum = 144;
			numericUpDown10.Maximum = 100000;

			InstalledFontCollection ifc = new InstalledFontCollection();
			foreach (FontFamily ff in ifc.Families)
			{
				comboBox2.Items.Add(ff.Name);
			}

		}

		private void buttonSave_Click(object sender, EventArgs e)
		{
			SaveConfig();
			Result = ConfigDialogResult.Save;
			this.Close();
		}

		private void buttonReboot_Click(object sender, EventArgs e)
		{
			SaveConfig();
			Result = ConfigDialogResult.SaveReboot;
			this.Close();
		}

		private void buttonCancel_Click(object sender, EventArgs e)
		{
			Result = ConfigDialogResult.Cancel;
			this.Close();
		}
		public ConfigDialogResult Result = ConfigDialogResult.Cancel;

		delegate void ChangeNumericUpDown(NumericUpDown updown, decimal value);
		public void SetConfig()
		{
			Config config = Config.Instance;
			checkBox1.Checked = config.IgnoreCase;
			checkBox2.Checked = config.UseRenameFile;
			checkBox3.Checked = config.UseMouse;
			checkBox4.Checked = config.UseMenu;
			checkBox5.Checked = config.UseDebugCommand;
			checkBox6.Checked = config.AllowMultipleInstances;
			checkBox7.Checked = config.AutoSave;
			checkBox8.Checked = config.SizableWindow;
			checkBox9.Checked = config.UseGDIplus;

			checkBox12.Checked = config.ReduceFormattedStringOnLoad;
			checkBox11.Checked = config.IgnoreUncalledFunction;

			checkBox13.Checked = config.DisplayReport;
			ChangeNumericUpDown changeNumericUpDown = delegate(NumericUpDown updown, decimal value)
			{
				if (updown.Maximum < value)
					updown.Maximum = value;
				if (updown.Minimum > value)
					updown.Minimum = value;
				updown.Value = value;
			};
			changeNumericUpDown(numericUpDown2, config.WindowX);
			changeNumericUpDown(numericUpDown3, config.WindowY);
			changeNumericUpDown(numericUpDown4, config.MaxLog);
			changeNumericUpDown(numericUpDown1, config.PrintCPerLine);
			changeNumericUpDown(numericUpDown9, config.PrintCLength);
			changeNumericUpDown(numericUpDown6, config.LineHeight);
			changeNumericUpDown(numericUpDown7, config.FPS);
			changeNumericUpDown(numericUpDown8, config.SkipFrame);
			changeNumericUpDown(numericUpDown5, config.Fontsize);
			changeNumericUpDown(numericUpDown10, config.InfiniteLoopAlertTime);

			colorBoxFG.SelectingColor = config.ForeColor;
			colorBoxBG.SelectingColor = config.BackColor;
			colorBoxSelecting.SelectingColor = config.FocusColor;
			colorBoxBacklog.SelectingColor = config.LogColor;

			string fontname = config.Fontname;
			int nameIndex = comboBox2.Items.IndexOf(fontname);
			if (nameIndex >= 0)
				comboBox2.SelectedIndex = nameIndex;
			else
			{
				nameIndex = comboBox2.Items.IndexOf("lr SVbN");
				if (nameIndex >= 0)
					comboBox2.SelectedIndex = nameIndex;
			}

			switch (config.ReduceArgumentOnLoad)
			{
				case ReduceArgumentOnLoadFlag.NO:
					comboBoxReduceArgumentOnLoad.SelectedIndex = 0; break;
				case ReduceArgumentOnLoadFlag.ONCE:
					comboBoxReduceArgumentOnLoad.SelectedIndex = 1; break;
				case ReduceArgumentOnLoadFlag.YES:
					comboBoxReduceArgumentOnLoad.SelectedIndex = 2; break;
			}
			if(config.DisplayWarningLevel <= 0)
				comboBox5.SelectedIndex = 0;
			else if (config.DisplayWarningLevel >= 3)
				comboBox5.SelectedIndex = 3;
			else
				comboBox5.SelectedIndex = config.DisplayWarningLevel;
			switch (config.FunctionNotFoundWarning)
			{
				case DisplayWarningFlag.IGNORE:
					comboBox3.SelectedIndex = 0; break;
				case DisplayWarningFlag.LATER:
					comboBox3.SelectedIndex = 1; break;
				case DisplayWarningFlag.ONCE:
					comboBox3.SelectedIndex = 2; break;
				case DisplayWarningFlag.DISPLAY:
					comboBox3.SelectedIndex = 3; break;
			}
			switch (config.FunctionNotCalledWarning)
			{
				case DisplayWarningFlag.IGNORE:
					comboBox4.SelectedIndex = 0; break;
				case DisplayWarningFlag.LATER:
					comboBox4.SelectedIndex = 1; break;
				case DisplayWarningFlag.ONCE:
					comboBox4.SelectedIndex = 2; break;
				case DisplayWarningFlag.DISPLAY:
					comboBox4.SelectedIndex = 3; break;
			}



			foreach (string filename in config.IgnoreWarningFiles)
				listBoxFilenames.Items.Add(filename);
		}

		private void SaveConfig()
		{
			Config config = new Config(Config.Instance);
			checkBox1.Checked = checkBox1.Checked;
			config.UseRenameFile = checkBox2.Checked;
			config.UseMouse = checkBox3.Checked;
			config.UseMenu = checkBox4.Checked;
			config.UseDebugCommand = checkBox5.Checked;
			config.AllowMultipleInstances = checkBox6.Checked;
			config.AutoSave = checkBox7.Checked;
			config.SizableWindow = checkBox8.Checked;
			config.UseGDIplus = checkBox9.Checked;

			config.ReduceFormattedStringOnLoad = checkBox12.Checked;
			config.IgnoreUncalledFunction = checkBox11.Checked;

			config.DisplayReport = checkBox13.Checked;

			config.WindowX = (int)numericUpDown2.Value;
			config.WindowY = (int)numericUpDown3.Value;
			config.MaxLog = (int)numericUpDown4.Value;
			config.PrintCPerLine = (int)numericUpDown1.Value;
			config.PrintCLength = (int)numericUpDown9.Value;
			config.LineHeight = (int)numericUpDown6.Value;
			config.FPS = (int)numericUpDown7.Value;
			config.SkipFrame = (int)numericUpDown8.Value;
			config.InfiniteLoopAlertTime = (int)numericUpDown10.Value;

			config.Fontsize = (int)numericUpDown5.Value;
			int nameIndex = comboBox2.SelectedIndex;
			if (nameIndex >= 0)
				config.Fontname = (string)comboBox2.SelectedItem;



			config.ForeColor = colorBoxFG.SelectingColor;
			config.BackColor = colorBoxBG.SelectingColor;
			config.FocusColor = colorBoxSelecting.SelectingColor;
			config.LogColor = colorBoxBacklog.SelectingColor;


			switch (comboBoxReduceArgumentOnLoad.SelectedIndex)
			{
				case 0:
					config.ReduceArgumentOnLoad = ReduceArgumentOnLoadFlag.NO; break;
				case 1:
					config.ReduceArgumentOnLoad = ReduceArgumentOnLoadFlag.ONCE; break;
				case 2:
					config.ReduceArgumentOnLoad = ReduceArgumentOnLoadFlag.YES; break;
			}
			config.DisplayWarningLevel = comboBox5.SelectedIndex;


			switch (comboBox3.SelectedIndex)
			{
				case 0:
					config.FunctionNotFoundWarning = DisplayWarningFlag.IGNORE; break;
				case 1:
					config.FunctionNotFoundWarning = DisplayWarningFlag.LATER; break;
				case 2:
					config.FunctionNotFoundWarning = DisplayWarningFlag.ONCE; break;
				case 3:
					config.FunctionNotFoundWarning = DisplayWarningFlag.DISPLAY; break;
			}
			switch (comboBox4.SelectedIndex)
			{
				case 0:
					config.FunctionNotCalledWarning = DisplayWarningFlag.IGNORE; break;
				case 1:
					config.FunctionNotCalledWarning = DisplayWarningFlag.LATER; break;
				case 2:
					config.FunctionNotCalledWarning = DisplayWarningFlag.ONCE; break;
				case 3:
					config.FunctionNotCalledWarning = DisplayWarningFlag.DISPLAY; break;
			}
			config.IgnoreWarningFiles.Clear();
			foreach (string filename in listBoxFilenames.Items)
				config.IgnoreWarningFiles.Add(filename);

			config.SaveConfig(Program.ConfigPath);
		}

		private void buttonAddFilename_Click(object sender, EventArgs e)
		{
			if (textBoxFilename.Text == "")
				return;
			string filename = textBoxFilename.Text.ToUpper();
			if(!filename.EndsWith(".ERB"))
				filename += ".ERB";
			if (!listBoxFilenames.Items.Contains(filename))
				listBoxFilenames.Items.Add(filename);
			textBoxFilename.Text = "";
		}

		private void buttonDeleteFilename_Click(object sender, EventArgs e)
		{
			if (listBoxFilenames.SelectedIndex < 0)
				return;
			listBoxFilenames.Items.RemoveAt(listBoxFilenames.SelectedIndex);

		}

		private void comboBoxReduceArgumentOnLoad_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (comboBoxReduceArgumentOnLoad.SelectedIndex == 0)
			{
				comboBox3.Enabled = false;
				comboBox4.Enabled = false;
				comboBox5.Enabled = false;
				checkBox12.Enabled = false;
				checkBox11.Enabled = false;
			}
			else
			{
				comboBox3.Enabled = true;
				comboBox4.Enabled = true;
				comboBox5.Enabled = true;
				checkBox12.Enabled = true;
				checkBox11.Enabled = true;
			}

		}
	}
}