using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Variable
{
	/// <summary>
	/// ϐS
	/// </summary>
	internal sealed class VariableData : IDisposable
	{

		readonly Int64[] dataInteger;
		readonly string[] dataString;
		readonly Int64[][] dataIntegerArray;
		readonly string[][] dataStringArray;
		readonly VariableLocal localVars;
		public Int64[] DataInteger { get { return dataInteger; } }
		public string[] DataString { get { return dataString; } }
		public Int64[][] DataIntegerArray { get { return dataIntegerArray; } }
		public string[][] DataStringArray { get { return dataStringArray; } }
		public VariableLocal LocalVars { get { return localVars; } }

		public VariableData(GameBase gamebase, ConstantData constant)
		{
			dataInteger = new Int64[(int)VariableCode.__COUNT_INTEGER__];

			dataIntegerArray = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY__][];
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = new Int64[constant.VariableIntArrayLength[i]];

			for (int i = 0; i < dataIntegerArray.Length; i++)
			{
				switch (i)
				{
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE):
						constant.ItemPrice.CopyTo(dataIntegerArray[i], 0);
						break;
				}
			}
			dataString = new string[(int)VariableCode.__COUNT_STRING__];

			dataStringArray = new string[(int)VariableCode.__COUNT_STRING_ARRAY__][];

			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = new string[constant.VariableStrArrayLength[i]];
			for (int i = 0; i < dataStringArray.Length; i++)
			{
				switch (i)
				{
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.STR):
						constant.Str.CopyTo(dataStringArray[i], 0);
						break;
				}
			}
			localVars = new VariableLocal(constant.VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.LOCAL)]);

			Int64[] palamlv = dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.PALAMLV];
			//palamlv[0] = 0;
			palamlv[1] = 100;
			palamlv[2] = 500;
			palamlv[3] = 3000;
			palamlv[4] = 10000;
			palamlv[5] = 30000;
			palamlv[6] = 60000;
			palamlv[7] = 100000;
			palamlv[8] = 150000;
			palamlv[9] = 250000;

			Int64[] explv = dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXPLV];
			//explv[0] = 0;
			explv[1] = 1;
			explv[2] = 4;
			explv[3] = 20;
			explv[4] = 50;
			explv[5] = 200;

			//dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ASSIPLAY][0] = 0;
			//dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MASTER][0] = 0;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ASSI][0] = -1;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TARGET][0] = 1;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.PBAND][0] = 4;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EJAC][0] = 10000;

		}




		const int strCount = (int)VariableCode.__COUNT_SAVE_STRING__;
		const int intCount = (int)VariableCode.__COUNT_SAVE_INTEGER__;
		const int intArrayCount = (int)VariableCode.__COUNT_SAVE_INTEGER_ARRAY__;
		const int strArrayCount = (int)VariableCode.__COUNT_SAVE_STRING_ARRAY__;
		public void SaveToStream(EraDataWriter writer)
		{

			for (int i = 0; i < strCount; i++)
				writer.Write(dataString[i]);
			for (int i = 0; i < intCount; i++)
				writer.Write(dataInteger[i]);
			for (int i = 0; i < intArrayCount; i++)
				writer.Write(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				writer.Write(dataStringArray[i]);
		}

		public void LoadFromStream(EraDataReader reader)
		{

			for (int i = 0; i < strCount; i++)
				dataString[i] = reader.ReadString();
			for (int i = 0; i < intCount; i++)
				dataInteger[i] = reader.ReadInt64();
			for (int i = 0; i < intArrayCount; i++)
				reader.ReadInt64Array(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				reader.ReadStringArray(dataStringArray[i]);
		}

		#region IDisposable o

		public void Dispose()
		{
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = null;
			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = null;

		}

		#endregion

	}
}