using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using System.Text.RegularExpressions;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData;

namespace MinorShift.Emuera.GameProc
{
    internal delegate void PrintWarning(string str, LogicalLine line, int level, bool isError);
    internal static class LogicalLineParser
    {
        readonly static Regex regexCom = new Regex("COM[0-9]+");
        readonly static Regex regexComAble = new Regex("COM_ABLE[0-9]+");
        readonly static Regex regexAblup = new Regex("ABLUP[0-9]+");
        private static bool isSystemLabel(string labelName)
        {
            switch (labelName)
            {
                case "EVENTFIRST":
                case "EVENTTRAIN":
                case "EVENTSHOP":
                case "EVENTBUY":
                case "EVENTCOM":
                case "EVENTTURNEND":
                case "EVENTCOMEND":
                case "EVENTEND":
                case "SHOW_STATUS":
                case "SHOW_USERCOM":
                case "USERCOM":
                case "SOURCE_CHECK":
                case "SHOW_JUEL":
                case "SHOW_ABLUP_SELECT":
                case "USERABLUP":
                case "SHOW_SHOP":
                case "SAVEINFO":
				case "USERSHOP":

				case "EVENTLOAD":
				case "TITLE_LOADGAME":
				case "SYSTEM_AUTOSAVE":
                    return true;
            }

            if (labelName.StartsWith("COM"))
            {
                if (regexCom.IsMatch(labelName))
                    return true;
                if (regexComAble.IsMatch(labelName))
                    return true;
            }
            if (labelName.StartsWith("ABLUP"))
                if (regexAblup.IsMatch(labelName))
                    return true;
            return false;
        }

        public static LogicalLine ParseLine(string str, EmueraConsole console)
        {
            ScriptPosition position = new ScriptPosition(str);
            StringStream stream = new StringStream(str);
            return ParseLine(stream, position, console);
        }

        public static LogicalLine ParseLine(StringStream stream, ScriptPosition position, EmueraConsole console)
        {
            int lineNo = position.LineNo;
            string rowLine = stream.Substring();
            string s1 = null;
            string s2 = null;
            string s3 = null;
            string errMes = "";
            TokenReader.SkipWhiteSpace(stream);//擪̃zCgXy[Xǂݔ΂
            if (stream.EOS)
                return null;
            //Rgsǂ͂ɗOɔ肵Ă
            //x
            if ((stream.Current == '$') || (stream.Current == '@'))
            {
                bool isFunction = (stream.Current == '@');
                stream.ShiftNext();//@$
                string labelName = TokenReader.ReadSingleIdentifer(stream);
                if (labelName.Length == 0)
                {
                    errMes = "x܂";
                    goto err;
                }
				if (Config.Instance.IgnoreCase)
                    labelName = labelName.ToUpper();
                if (isFunction)
                {
                    FunctionLabelLine labelLine = new FunctionLabelLine(position, labelName);
                    if (isSystemLabel(labelName))
                        labelLine.Depth = 0;
                    return labelLine;
                }
                else
                {
                    return new GotoLabelLine(position, labelName);
                }
            }
            s1 = TokenReader.ReadIdentiferWithIndex(stream);
            BuiltInFunctionCode func = BuiltInFunctionManager.ToBuiltInFunction(s1);
            //ߕ
            if (func != BuiltInFunctionCode.__NULL__)//֐
            {
                if (stream.EOS) //̖֐
                    return new InstructionLine(position, func, null);
                stream.ShiftNext();
                s2 = rowLine.Substring(stream.CurrentPosition, rowLine.Length - stream.CurrentPosition);
                return new InstructionLine(position, func, s2);
            }
            //xł߂łȂ̂ő̂͂BϐŎn܂ĂȂ΂B
            if (!VariableParser.IsVariable(s1))
            {
                errMes = "xEߕÊƂ߂łȂsł";
                goto err;
            }
            if (VariableParser.IsInteger(s1))
                func = BuiltInFunctionCode.SET;
            else
                func = BuiltInFunctionCode.SETS;

            TokenReader.SkipWhiteSpace(stream);//̒P܂œǂݔ΂
            //"ϐ@Zq@"Ƃ`̂͂B
            if ((stream.EOS) || (TokenReader.GetNextTokenType(stream) != TokenType.Operator))
            {
                errMes = "sϐŎn܂Ă܂Zq܂";
                goto err;
            }
            s2 = TokenReader.ReadOperatorString(stream);
            if (s2 == "==")
            {
                if (console != null)
                    console.PrintWarning("Zq\"==\"gĂ܂", position, 0);
                s2 = "=";//"=="Ɏĝ͖{͂\gĂ̂ŎdlɂB
            }
            if (func == BuiltInFunctionCode.SET)
                TokenReader.SkipWhiteSpace(stream);//̑Ȃ玟̒P܂œǂݔ΂
            else if (stream.Current == ' ')
                TokenReader.SkipHalfSpace(stream);//̑Ȃ甼pXy[Xǂݔ΂

            if (stream.EOS)
                s3 = "";
            else
                s3 = rowLine.Substring(stream.CurrentPosition, rowLine.Length - stream.CurrentPosition);


            if (func == BuiltInFunctionCode.SETS)
            {
                if (s2 != "=")
                {
                    errMes = "ϐ̑ɂ͕Zq͎g܂";
                    goto err;
                }
            }
            string right = null;
            if (func == BuiltInFunctionCode.SETS)
                right = s3;
            else
            {
                right = OperatorManager.ReduceAssignmentOperator(s2, s1, s3);
                if (right == null)
                {
                    errMes = "ɎgpłȂZqg܂";
                    goto err;
                }
            }

            return new InstructionLine(position, func, s1, right);
        err:
            return new InvalidLine(position, errMes);
        }

        private static void printWarning(string str, LogicalLine line, int level, bool isError)
        {
            if (isError)
            {
                line.IsError = true;
                line.ErrMes = str;
            }
            if (printWarningLoad == null)
                return;
            printWarningLoad(str, line, level, isError);
        }

        static PrintWarning printWarningLoad = null;
        public static bool SetArgumentTo(InstructionLine line, PrintWarning printW)
        {
            if (line == null)
                return false;
            if (line.Argument != null)
                return true;
            printWarningLoad = printW;
            ArgumentType type = (ArgumentType)((int)ArgumentType.__MASK__ & (int)line.Function);
            string rowStr = line.ArgumentStr;
            StringStream st = new StringStream(rowStr);
            Argument arg = null;
            IOperandTerm term = null;
            VariableToken varToken = null;
            StringForm strForm = null;
            try
            {
                switch (type)
                {
                    case ArgumentType.VOID:
                        if ((rowStr != null) && (rowStr.Length != 0) && (rowStr.Trim().Length != 0))
                            printWarning("svȖ\"" + line.Function.ToString() + "\"Ɉw肳Ă܂", line, 1, false);
                        arg = new VoidArgument();
                        break;
                    case ArgumentType.INT_EXPRESSION:
                        term = ExpressionParser.ReduceIntegerTerm(st);
                        arg = new ExpressionArgument(term);
                        break;
                    case ArgumentType.STR_EXPRESSION:
                        term = ExpressionParser.ReduceStringTerm(st);
                        arg = new ExpressionArgument(term);
                        break;
                    case ArgumentType.STR:
                        if (rowStr == null)
                            rowStr = "";
                        arg = new StrArgument(rowStr);
                        break;
                    case ArgumentType.FORM_STR:
                        if (rowStr == null)
                            rowStr = "";
                        strForm = new StringForm(rowStr);
						if (Config.Instance.ReduceFormattedStringOnLoad)
                            strForm.Reduce();
                        arg = new FormStrArgument(strForm);
                        break;
                    case ArgumentType.SP_PRINTV:
                        {
                            List<IOperandTerm> list = new List<IOperandTerm>();
                            while (!st.EOS)
                            {
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == '\'')
                                    list.Add(new SingleTerm(TokenReader.ReadString(st)));
                                else
                                    list.Add(ExpressionParser.ReduceIntegerTerm(st));
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    st.ShiftNext();
                                else
                                    break;
                            }
                            arg = new SpPrintVArgument(list);
                        }
                        break;
                    case ArgumentType.SP_TIMES:
                        TokenReader.SkipWhiteSpace(st);
                        varToken = VariableParser.ReduceVariable(st);
                        if (varToken == null)
                            printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true);
                        else if (varToken.IsString)
                            printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true);
                        else if (varToken.Identifier.Readonly)
                            printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true);

                        TokenReader.SkipWhiteSpace(st);
                        if (st.Current != ',')
                        {
                            if (st.EOS)
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
                            else
                                printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true);
                            break;
                        }
                        st.ShiftNext();
                        TokenReader.SkipWhiteSpace(st);
                        double d = 0.0;
                        if ((TokenReader.GetNextTokenType(st) != TokenType.Numeric) && (st.Current != '-') && (st.Current != '.'))
                            printWarning("\"" + line.Function.ToString() + "\"̑Qlł͂܂i0Ɖ߂܂j", line, 1, false);
                        else
                        {
                            try
                            {
                                d = ExpressionParser.ReduceDoubleTerm(st);
                            }
                            catch
                            {
                                printWarning("\"" + line.Function.ToString() + "\"̑Qlł͂܂i0Ɖ߂܂j", line, 1, false);
                            }
                        }
                        arg = new SpTimesArgument(varToken, d);
                        break;
                    case ArgumentType.SP_BAR:
                        {
                            TokenReader.SkipWhiteSpace(st);
                            IOperandTerm value = ExpressionParser.ReduceIntegerTerm(st);
                            TokenReader.SkipWhiteSpace(st);
                            if (st.Current != ',')
                            {
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
                                break;
                            }
                            st.ShiftNext();
                            IOperandTerm max = ExpressionParser.ReduceIntegerTerm(st);
                            TokenReader.SkipWhiteSpace(st);
                            if (st.Current != ',')
                            {
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
                                break;
                            }
                            st.ShiftNext();
                            IOperandTerm length = ExpressionParser.ReduceIntegerTerm(st);
                            TokenReader.SkipWhiteSpace(st);
                            if (st.Current == ',')
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false);
                            arg = new SpBarArgument(value, max, length);
                        }
                        break;
                    case ArgumentType.SP_SET:
                        varToken = VariableParser.ReduceVariable(new StringStream(line.AssignmentDestStr));
                        term = ExpressionParser.ReduceIntegerTerm(st);
                        arg = new SpSetArgument(varToken, term);
                        break;

                    case ArgumentType.SP_SETS:
                        varToken = VariableParser.ReduceVariable(new StringStream(line.AssignmentDestStr));
                        strForm = new StringForm(rowStr);
						if (Config.Instance.ReduceFormattedStringOnLoad)
                            strForm.Reduce();
                        arg = new SpSetsArgument(varToken, strForm);
                        break;

					case ArgumentType.SP_SUBSTRING:
						{
							TokenReader.SkipWhiteSpace(st);
							varToken = VariableParser.ReduceVariable(st);
							if (varToken == null)
								printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true);
							else if (!varToken.IsString)
								printWarning("\"" + line.Function.ToString() + "\"̑P𐔒l^ϐɂ邱Ƃ͂ł܂", line, 2, true);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								if (st.EOS)
									printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
								else
									printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true);
								break;
							}
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
							IOperandTerm start = ExpressionParser.ReduceIntegerTerm(st);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
								break;
							}
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
							IOperandTerm length = ExpressionParser.ReduceIntegerTerm(st);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current == ',')
								printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false);

							arg = new SpSubstringArgument(varToken, start, length);
						}
						break;
					case ArgumentType.SP_SWAP:
						{
							TokenReader.SkipWhiteSpace(st);
							IOperandTerm x = ExpressionParser.ReduceIntegerTerm(st);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
								break;
							}
							st.ShiftNext();
							IOperandTerm y = ExpressionParser.ReduceIntegerTerm(st);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current == ',')
								printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false);
							arg = new SpSwapCharaArgument(x, y);
						}
						break;
					case ArgumentType.SP_VARSIZE:
						TokenReader.SkipWhiteSpace(st);
						varToken = VariableParser.ReduceVariable(st);
						if (varToken == null)
							printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true);
						else if ((!varToken.Identifier.IsArray) || (varToken.Identifier.Code == VariableCode.RAND))
							printWarning("\"" + line.Function.ToString() + "\"̑PɔzłȂϐw肷邱Ƃ͂ł܂", line, 2, true);

						TokenReader.SkipWhiteSpace(st);
						if (!st.EOS)
						{
							if (st.Current == ',')
								printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, true);
							else
								printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, true);
							break;
						}
						arg = new SpVarsizeArgument(varToken.Identifier);

						break;
					case ArgumentType.SP_SAVEDATA:
						{
							TokenReader.SkipWhiteSpace(st);
							IOperandTerm target = ExpressionParser.ReduceIntegerTerm(st);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								if (st.EOS)
									printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true);
								else
									printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true);
								break;
							}
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
							varToken = VariableParser.ReduceVariable(st);
							if (varToken == null)
								printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true);
							else if (!varToken.IsString)
								printWarning("\"" + line.Function.ToString() + "\"̑Q͕ϐłKv܂", line, 2, true);
							TokenReader.SkipWhiteSpace(st);
							if (!st.EOS)
							{
								if (st.Current == ',')
									printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, true);
								else
									printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, true);
								break;
							}
							arg = new SpSaveDataArgument(target, varToken);
							break;
						}
                    default:
                        printWarning("ݒ肳ĂȂ^", line, 2, true);
                        return false;
                }
            }
            catch (CodeEE e)
            {
                printWarning(e.Message, line, 2, true);
                return false;
            }
            if (arg == null)
            {
                if (!line.IsError)
                    printWarning("߂̈͒ɓłȂG[", line, 2, true);
                return false;
            }
            line.Argument = arg;
            return true;
        }
    }
}
