﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace MinorShift.Emuera.GameView
{
	/// <summary>
	/// 装飾付文字列(ConsoleStyledString)用のスタイル構造体
	/// </summary>
	internal struct StringStyle
	{
		public StringStyle(Color color, FontStyle fontStyle)
		{
			this.Color = color;
			this.FontStyle = fontStyle;
		}

		public Color Color;
		public FontStyle FontStyle;
		public override bool Equals(object obj)
		{
			if ((obj == null) || (!(obj is StringStyle)))
				return false;
			StringStyle ss = (StringStyle)obj;
			return ((this.Color == ss.Color) && (this.FontStyle == ss.FontStyle));
		}
		public override int GetHashCode()
		{
			return Color.GetHashCode() ^ FontStyle.GetHashCode();
		}
		public static bool operator ==(StringStyle x, StringStyle y)
		{
			return ((x.Color == y.Color) && (x.FontStyle == y.FontStyle));
		}
		public static bool operator !=(StringStyle x, StringStyle y)
		{
			return !(x == y);
		}
	}
}
