using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using MinorShift._Library;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.Forms;
namespace MinorShift.Emuera
{
	internal partial class MainWindow : Form
	{

		public MainWindow()
		{
			InitializeComponent();
			if (Config.Instance.SetWindowPos)
			{
				this.StartPosition = FormStartPosition.Manual;
				this.Location = new Point(Config.Instance.WindowPosX, Config.Instance.WindowPosY);
			}

			((EraPictureBox)mainPicBox).SetStyle();
			this.ResizeEnd += new EventHandler(MainWindow_ResizeEnd);
			this.Resize += new EventHandler(MainWindow_Resize);
			lastState = WindowState;
			int winX = Program.ClientX;
			Program.ClientX = 0;
			if (winX == 0)
				winX = Config.Instance.WindowX;
			winY = Program.ClientY;
			Program.ClientY = 0;
			if (winY == 0)
				winY = Config.Instance.WindowY;
			if (Config.Instance.SizableWindow)
				this.FormBorderStyle = FormBorderStyle.Sizable;
			else
				this.FormBorderStyle = FormBorderStyle.Fixed3D;
			setWindowSize(Config.Instance.WindowX, winY);

			int minimamY = 100;
			if (minimamY > this.Height)
				minimamY = this.Height;
			int maximamY = 2560;
			if (maximamY < this.Height)
				maximamY = this.Height;
			this.MinimumSize = new Size(this.Width, minimamY);
			this.MaximumSize = new Size(this.Width, maximamY);
			mainText.ForeColor = Config.Instance.ForeColor;
			mainText.BackColor = Config.Instance.BackColor;
			mainPicBox.BackColor = Config.Instance.BackColor;
			this.BackColor = Config.Instance.BackColor;

			mainText.Font = Config.Instance.Font;
			this.MaximizeBox = Config.Instance.SizableWindow;

			if (Program.state != FormWindowState.Normal)
			{
				WindowState = Program.state;
				Program.state = FormWindowState.Normal;
			}

            folderSelectDialog.SelectedPath = Program.ExeDir + "erb\\";
            folderSelectDialog.ShowNewFolderButton = false;

            openFileDialog.InitialDirectory = Program.ExeDir + "erb\\";
            openFileDialog.Filter = "ERBt@C (*.erb)|*.erb";
            openFileDialog.FileName = "";
            openFileDialog.Multiselect = true;
            openFileDialog.RestoreDirectory = true;
            
            timer.Enabled = true;
			console = new EmueraConsole(this);
		}

		public PictureBox MainPicBox { get { return mainPicBox; } }
		public VScrollBar ScrollBar { get { return vScrollBar; } }
		private EmueraConsole console = null;

		protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
		{
			if ((int)keyData == (int)Keys.Control + (int)Keys.B)
			{
				if (WindowState != FormWindowState.Minimized)
				{
					WindowState = FormWindowState.Minimized;
					return true;
				}
			}
			else if ((int)keyData == (int)Keys.Control + (int)Keys.C)
			{
				if (this.mainText.SelectedText == "")
				{
					ClipBoardDialog dialog = new ClipBoardDialog();
					dialog.Setup(this, console);
					dialog.ShowDialog();
					return true;
				}
			}
            else if (Config.Instance.UseKeyMacro)
            {
                if ((int)keyData == (int)Keys.F1 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F1, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F1)
                {
                    this.mainText.Text = Config.Instance.MacroF1;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F2 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F2, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F2)
                {
                    this.mainText.Text = Config.Instance.MacroF2;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F3 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F3, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F3)
                {
                    this.mainText.Text = Config.Instance.MacroF3;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F4 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F4, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F4)
                {
                    this.mainText.Text = Config.Instance.MacroF4;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F5 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F5, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F5)
                {
                    this.mainText.Text = Config.Instance.MacroF5;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F6 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F6, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F6)
                {
                    this.mainText.Text = Config.Instance.MacroF6;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F7 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F7, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F7)
                {
                    this.mainText.Text = Config.Instance.MacroF7;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F8 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F8, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F8)
                {
                    this.mainText.Text = Config.Instance.MacroF8;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F9 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F9, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F9)
                {
                    this.mainText.Text = Config.Instance.MacroF9;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F10 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F10, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F10)
                {
                    this.mainText.Text = Config.Instance.MacroF10;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F11 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F11, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F11)
                {
                    this.mainText.Text = Config.Instance.MacroF11;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
                else if ((int)keyData == (int)Keys.F12 + (int)Keys.Shift)
                {
                    if (this.mainText.Text != "")
                        Config.Instance.SetMacro(Keys.F12, this.mainText.Text);
                    return true;
                }
                else if ((int)keyData == (int)Keys.F12)
                {
                    this.mainText.Text = Config.Instance.MacroF12;
                    this.mainText.SelectionStart = this.mainText.Text.Length;
                    return true;
                }
            }
			return base.ProcessCmdKey(ref msg, keyData);
		}

		private void timer_Tick(object sender, EventArgs e)
		{
			if (!this.Created)
				return;
			timer.Enabled = false;
			console.Initialize();
		}
		int winY;

		void MainWindow_ResizeEnd(object sender, EventArgs e)
		{
			windowResized();
		}

		FormWindowState lastState;
		//ő剻AŏResizeEndł͕߂܂ȂB
		void MainWindow_Resize(object sender, EventArgs e)
		{
			if (WindowState == lastState)
				return;
			if (WindowState == FormWindowState.Minimized)
				return;
			lastState = WindowState;
			windowResized();
		}

		private void windowResized()
		{
			int height = this.ClientSize.Height;

			if (Config.Instance.UseMenu)
			{
				height -= menuStrip.Height;
			}
			if (winY == height)
				return;
			winY = height;
			setWindowSize(Config.Instance.WindowX, winY);
		}

		private void setWindowSize(int windowX, int windowY)
		{
			this.SuspendLayout();
			Size menuSize = new Size(0, 0);
			if (Config.Instance.UseMenu)
			{
				menuStrip.Enabled = true;
				menuStrip.Visible = true;
				menuStrip.Size = new Size(windowX + vScrollBar.Width, menuStrip.Height);
				menuSize = menuStrip.Size;
			}
			else
			{
				menuStrip.Enabled = false;
				menuStrip.Visible = false;
			}
			this.ClientSize = new Size(windowX + vScrollBar.Width, windowY + menuSize.Height);
			vScrollBar.Size = new Size(vScrollBar.Width, windowY);
			vScrollBar.Location = new Point(this.ClientSize.Width - vScrollBar.Width, menuSize.Height);//new Point(windowX, menuSize.Height);
			mainPicBox.Size = new Size(windowX, windowY - (int)Config.Instance.Font.Size);
			mainPicBox.Location = new Point(0, menuSize.Height);
			mainPicBox.BackColor = Config.Instance.BackColor;
			this.BackColor = Config.Instance.BackColor;
			if (mainPicBox.Image != null)
				mainPicBox.Image.Dispose();
			if (Config.Instance.UseImageBuffer)
				mainPicBox.Image = new Bitmap(mainPicBox.Size.Width, mainPicBox.Size.Height, System.Drawing.Imaging.PixelFormat.Format32bppPArgb);
			else
				mainPicBox.Image = null;
			mainText.Size = new Size(windowX, (int)Config.Instance.Font.Size);
			mainText.Location = new Point(0, menuSize.Height + mainPicBox.Height);
			this.ResumeLayout();
			if (console != null)
			{
				console.MainPicBoxSizeChanged();
				//ImageBuffergȂłOnPaintŕ`悷
				if (Config.Instance.UseImageBuffer)
					console.RefreshStrings(true);
			}
		}


		private void mainPicBox_MouseMove(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			console.MoveMouse(e.Location);
		}

		private void mainPicBox_MouseDown(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			if (vScrollBar.Value != vScrollBar.Maximum)
			{//\
				if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
				{
					vScrollBar.Value = vScrollBar.Maximum;
					console.RefreshStrings(true);
				}
				return;
			}
			if (console.IsWaitingAnyKey)
			{
				if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
				{
					if (e.Button == MouseButtons.Right)
						PressEnterKey(true);
					else
						PressEnterKey(false);
					return;
				}

			}
			if (console.SelectingButton == null)//I𒆂łȂȂ疳
				return;
			//ꂽȂIB
			if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
			{
				string str = console.SelectedString;
				if (str == null)
					return;
				mainText.Text = str;
				//EςȂȂXLbvǉB
				if ((Control.MouseButtons & MouseButtons.Right) == MouseButtons.Right)
					PressEnterKey(true);
				else
					PressEnterKey(false);
				return;
			}
		}



		private void vScrollBar_Scroll(object sender, ScrollEventArgs e)
		{
			//[ł[łȂȂ`T߂ɁB
			console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));

		}


		void mainText_MouseWheel(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			//if (!Config.UseMouse)
			//	return;
			if (!vScrollBar.Enabled)
				return;
			//e.Deltaɂ͑傫ȒlĂ̂ŕ̂ݍ̗p
			int move = -Math.Sign(e.Delta) * vScrollBar.SmallChange * Config.Instance.ScrollHeight;
			int value = vScrollBar.Value + move;
			if (value >= vScrollBar.Maximum)
				vScrollBar.Value = vScrollBar.Maximum;
			else if (value <= vScrollBar.Minimum)
				vScrollBar.Value = vScrollBar.Minimum;
			else
				vScrollBar.Value = value;
			//[ł[łȂȂ`T߂ɁB
			console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));
		}

		private void mainText_KeyDown(object sender, KeyEventArgs e)
		{
			if (vScrollBar.Value != vScrollBar.Maximum)
			{
				vScrollBar.Value = vScrollBar.Maximum;
				console.RefreshStrings(true);
			}
			if (e.KeyCode == Keys.Return)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(false);
				return;
			}
			if (e.KeyCode == Keys.Escape)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(true);
				return;
			}
			if (console.IsRunning)
				return;
			if (e.KeyCode == Keys.Up)
			{
				e.SuppressKeyPress = true;
				movePrev(-1);
				return;
			}
			if (e.KeyCode == Keys.Down)
			{
				e.SuppressKeyPress = true;
				movePrev(1);
				return;
			}

		}
		public void PressEnterKey(bool mesSkip)
		{
			string str = mainText.Text;
			updateInputs();
			console.PressEnterKey(mesSkip, str);
		}

		string[] prevInputs = new string[100];
		int selectedInputs = 100;
		int lastSelected = 100;
		void updateInputs()
		{
			string cur = mainText.Text;
			if (string.IsNullOrEmpty(cur))
				return;
			for (int i = 0; i < prevInputs.Length - 1; i++)
			{
				prevInputs[i] = prevInputs[i + 1];
			}
			prevInputs[prevInputs.Length - 1] = cur;
			mainText.Text = "";
			//1729a eramakerƓnɕύX 1730a ďC
			if (selectedInputs != prevInputs.Length && cur == prevInputs[selectedInputs - 1])
				lastSelected = --selectedInputs;
			else
				lastSelected = 100;
			selectedInputs = prevInputs.Length;
		}

		void movePrev(int move)
		{
			if (move == 0)
				return;
			//if((selectedInputs != prevInputs.Length) &&(prevInputs[selectedInputs] != mainText.Text))
			//	selectedInputs =  prevInputs.Length;
			int next;
			if (lastSelected != prevInputs.Length && selectedInputs == prevInputs.Length)
			{
				if (move == -1)
					move = 0;
				next = lastSelected + move;
			}
			else
				next = selectedInputs + move;
			if ((next < 0) || (next > prevInputs.Length))
				return;
			if (next == prevInputs.Length)
			{
				selectedInputs = next;
				mainText.Text = "";
				return;
			}
            if (string.IsNullOrEmpty(prevInputs[next]))
                if (++next == prevInputs.Length)
                    return;

			selectedInputs = next;
			mainText.Text = prevInputs[next];
			mainText.SelectionStart = 0;
			mainText.SelectionLength = mainText.Text.Length;
			return;
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("Q[I܂", "I", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Close();

		}

		private void rebootToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("Q[ċN܂", "ċN", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Reboot();
		}

		private void loadToolStripMenuItem_Click(object sender, EventArgs e)
		{
			openFileDialog.InitialDirectory = Program.ExeDir;
			DialogResult result = openFileDialog.ShowDialog();
			string filepath = openFileDialog.FileName;
			if (!File.Exists(filepath))
			{
				MessageBox.Show("t@C܂", "File Not Found");
				return;
			}
		}

		public void Reboot()
		{
			Program.Reboot = true;
			Program.state = WindowState;
			if (WindowState != FormWindowState.Normal)
				WindowState = FormWindowState.Normal;
			Program.ClientX = mainPicBox.Width;
			Program.ClientY = mainPicBox.Height + (int)Config.Instance.Font.Size;
			this.Close();
		}

		public void GotoTitle()
		{
			console.GotoTitle();
		}

		public void ReloadErb()
		{
			console.ReloadErb();
		}

		private void mainPicBox_MouseLeave(object sender, EventArgs e)
		{
			if (Config.Instance.UseMouse)
				console.LeaveMouse();
		}


		private void RtBOCToolStripMenuItem_Click(object sender, EventArgs e)
		{
			ShowConfigDialog();
		}

		public void ShowConfigDialog()
		{
			ConfigDialog dialog = new ConfigDialog();
			dialog.SetConfig(this);
			dialog.ShowDialog();
			if (dialog.Result == ConfigDialogResult.SaveReboot)
			{
				Program.Reboot = true;
				this.Close();
			}
		}

		private void ^Cg֖߂TToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("^Cgʂ֖߂܂", "^Cgʂɖ߂", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.GotoTitle();
		}

		private void R[hǂݒcToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("ERBt@Cǂݒ܂", "ERBt@Cǂݒ", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.ReloadErb();

		}

		private void mainPicBox_Paint(object sender, PaintEventArgs e)
		{
			if (!Config.Instance.UseImageBuffer)
			{
				e.Graphics.Clear(Config.Instance.BackColor);
				console.RefreshStrings(true, e.Graphics);
			}
		}

		private void OۑSToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			saveFileDialog.InitialDirectory = Program.ExeDir;
			DateTime time = DateTime.Now;
			string fname = time.ToString("yyyyMMdd-HHmmss");
			fname += ".log";
			saveFileDialog.FileName = fname;
			DialogResult result = saveFileDialog.ShowDialog();
			if (result == DialogResult.OK)
			{
				console.OutputEmueraLog(saveFileDialog.FileName);
			}
		}

		private void ONbv{[hɃRs[ToolStripMenuItem_Click(object sender, EventArgs e)
		{
			ClipBoardDialog dialog = new ClipBoardDialog();
			dialog.Setup(this, console);
			dialog.ShowDialog();
		}

		private void t@CǂݒFToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			DialogResult result = openFileDialog.ShowDialog();
			List<string> filepath = new List<string>();
			if (result == DialogResult.OK)
			{
				foreach (string fname in openFileDialog.FileNames)
				{
					if (!File.Exists(fname))
					{
						MessageBox.Show("t@C܂", "File Not Found");
						return;
					}
					if (Path.GetExtension(fname).ToUpper() != ".ERB")
					{
						MessageBox.Show("ERBt@CȊO͓ǂݍ߂܂", "t@C`G[");
						return;
					}
					if (fname.StartsWith(Program.ExeDir + "ERB\\"))
						filepath.Add(Program.ExeDir + "erb\\" + fname.Substring(Program.ExeDir.Length + "erb\\".Length));
					else
						filepath.Add(fname);
				}
				console.ReloadPartialErb(filepath);
			}
		}

		private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
		{
            if (Config.Instance.UseKeyMacro)
                Config.Instance.SaveMacro();
		}

		private void tH_ǂݒFToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			List<KeyValuePair<string, string>> filepath = new List<KeyValuePair<string, string>>();
			if (folderSelectDialog.ShowDialog() == DialogResult.OK)
			{
				console.ReloadFolder(folderSelectDialog.SelectedPath);
			}
		}
	}
}