using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using MinorShift._Library;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.Forms;

namespace MinorShift.Emuera
{
	internal sealed partial class MainWindow : Form
	{

		public MainWindow()
		{
			InitializeComponent();
			if (Config.Instance.SetWindowPos)
			{
				this.StartPosition = FormStartPosition.Manual;
				this.Location = new Point(Config.Instance.WindowPosX, Config.Instance.WindowPosY);
			}
			if (Program.DebugMode)
				デバッグToolStripMenuItem.Visible = true;

			((EraPictureBox)mainPicBox).SetStyle();
			this.ResizeEnd += new EventHandler(MainWindow_ResizeEnd);
			this.Resize += new EventHandler(MainWindow_Resize);
			lastState = WindowState;
			int winX = Program.ClientX;
			Program.ClientX = 0;
			if (winX == 0)
				winX = Config.Instance.WindowX;
			winY = Program.ClientY;
			Program.ClientY = 0;
			if (winY == 0)
				winY = Config.Instance.WindowY;
			if (Config.Instance.SizableWindow)
				this.FormBorderStyle = FormBorderStyle.Sizable;
			else
				this.FormBorderStyle = FormBorderStyle.Fixed3D;
			setWindowSize(Config.Instance.WindowX, winY);

			int minimamY = 100;
			if (minimamY > this.Height)
				minimamY = this.Height;
			int maximamY = 2560;
			if (maximamY < this.Height)
				maximamY = this.Height;
			this.MinimumSize = new Size(this.Width, minimamY);
			this.MaximumSize = new Size(this.Width, maximamY);
			richTextBox1.ForeColor = Config.Instance.ForeColor;
			richTextBox1.BackColor = Config.Instance.BackColor;
			mainPicBox.BackColor = Config.Instance.BackColor;
			this.BackColor = Config.Instance.BackColor;

			richTextBox1.Font = Config.Instance.Font;
            richTextBox1.LanguageOption = RichTextBoxLanguageOptions.UIFonts;
			this.MaximizeBox = Config.Instance.SizableWindow;
            if (Config.Instance.SizableWindow && Config.Instance.WindowMaximixed)
                this.WindowState = FormWindowState.Maximized;

			if (Program.state != FormWindowState.Normal)
			{
				WindowState = Program.state;
				Program.state = FormWindowState.Normal;
			}

            folderSelectDialog.SelectedPath = Program.ExeDir + "erb\\";
            folderSelectDialog.ShowNewFolderButton = false;

            openFileDialog.InitialDirectory = Program.ExeDir + "erb\\";
            openFileDialog.Filter = "ERBファイル (*.erb)|*.erb";
            openFileDialog.FileName = "";
            openFileDialog.Multiselect = true;
            openFileDialog.RestoreDirectory = true;
            
            timer.Enabled = true;
			console = new EmueraConsole(this);
		}

		public PictureBox MainPicBox { get { return mainPicBox; } }
		public VScrollBar ScrollBar { get { return vScrollBar; } }
		private EmueraConsole console = null;

		protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
		{
            if ((keyData & Keys.KeyCode) == Keys.B && ((keyData & Keys.Modifiers) & Keys.Control) == Keys.Control)
			{
				if (WindowState != FormWindowState.Minimized)
				{
					WindowState = FormWindowState.Minimized;
					return true;
				}
			}
			else if (((keyData & Keys.KeyCode) == Keys.C && ((keyData & Keys.Modifiers) & Keys.Control) == Keys.Control) || (keyData & Keys.KeyCode) == Keys.Insert && ((keyData & Keys.Modifiers) & Keys.Control) == Keys.Control)
			{
				if (this.richTextBox1.SelectedText == "")
				{
					ClipBoardDialog dialog = new ClipBoardDialog();
					dialog.Setup(this, console);
					dialog.ShowDialog();
					return true;
				}
			}
			else if (((keyData & Keys.KeyCode) == Keys.V && ((keyData & Keys.Modifiers) & Keys.Control) == Keys.Control) || (keyData & Keys.KeyCode) == Keys.Insert && ((keyData & Keys.Modifiers) & Keys.Shift) == Keys.Shift)
			{
				if (!Clipboard.ContainsText())
					return true;
				else
					Clipboard.SetText(Clipboard.GetText(TextDataFormat.UnicodeText));
			}
			//else if (((int)keyData == (int)Keys.Control + (int)Keys.D) && Program.DebugMode)
			//{
			//    console.OpenDebugDialog();
			//    return true;
			//}
			//else if (((int)keyData == (int)Keys.Control + (int)Keys.R) && Program.DebugMode)
			//{
			//    if ((console.DebugDialog != null) && (console.DebugDialog.Created))
			//        console.DebugDialog.UpdateData();
			//}
			else if (Config.Instance.UseKeyMacro)
			{
				if ((int)keyData == (int)Keys.F1 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F1, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F1)
				{
					this.richTextBox1.Text = Config.Instance.MacroF1;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F2 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F2, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F2)
				{
					this.richTextBox1.Text = Config.Instance.MacroF2;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F3 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F3, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F3)
				{
					this.richTextBox1.Text = Config.Instance.MacroF3;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F4 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F4, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F4)
				{
					this.richTextBox1.Text = Config.Instance.MacroF4;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F5 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F5, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F5)
				{
					this.richTextBox1.Text = Config.Instance.MacroF5;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F6 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F6, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F6)
				{
					this.richTextBox1.Text = Config.Instance.MacroF6;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F7 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F7, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F7)
				{
					this.richTextBox1.Text = Config.Instance.MacroF7;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F8 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F8, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F8)
				{
					this.richTextBox1.Text = Config.Instance.MacroF8;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F9 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F9, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F9)
				{
					this.richTextBox1.Text = Config.Instance.MacroF9;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F10 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F10, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F10)
				{
					this.richTextBox1.Text = Config.Instance.MacroF10;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F11 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F11, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F11)
				{
					this.richTextBox1.Text = Config.Instance.MacroF11;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
				else if ((int)keyData == (int)Keys.F12 + (int)Keys.Shift)
				{
					if (this.richTextBox1.Text != "")
						Config.Instance.SetMacro(Keys.F12, this.richTextBox1.Text);
					return true;
				}
				else if ((int)keyData == (int)Keys.F12)
				{
					this.richTextBox1.Text = Config.Instance.MacroF12;
					this.richTextBox1.SelectionStart = this.richTextBox1.Text.Length;
					return true;
				}
			}
			return base.ProcessCmdKey(ref msg, keyData);
		}

		private void timer_Tick(object sender, EventArgs e)
		{
			if (!this.Created)
				return;
			timer.Enabled = false;
			console.Initialize();
		}
		int winY;

		void MainWindow_ResizeEnd(object sender, EventArgs e)
		{
			windowResized();
		}

		FormWindowState lastState;
		//最大化、最小化はResizeEndでは捕まえられない。
		void MainWindow_Resize(object sender, EventArgs e)
		{
			if (WindowState == lastState)
				return;
			if (WindowState == FormWindowState.Minimized)
				return;
			lastState = WindowState;
			windowResized();
		}

		private void windowResized()
		{
			int height = this.ClientSize.Height;

			if (Config.Instance.UseMenu)
			{
				height -= menuStrip.Height;
			}
			if (winY == height)
				return;
			winY = height;
			setWindowSize(Config.Instance.WindowX, winY);
		}

		private void setWindowSize(int windowX, int windowY)
		{
			this.SuspendLayout();
			Size menuSize = new Size(0, 0);
			if (Config.Instance.UseMenu)
			{
				menuStrip.Enabled = true;
				menuStrip.Visible = true;
				menuStrip.Size = new Size(windowX + vScrollBar.Width, menuStrip.Height);
				menuSize = menuStrip.Size;
			}
			else
			{
				menuStrip.Enabled = false;
				menuStrip.Visible = false;
			}
			this.ClientSize = new Size(windowX + vScrollBar.Width, windowY + menuSize.Height);
			vScrollBar.Size = new Size(vScrollBar.Width, windowY);
			vScrollBar.Location = new Point(this.ClientSize.Width - vScrollBar.Width, menuSize.Height);//new Point(windowX, menuSize.Height);
            mainPicBox.Size = new Size(windowX, windowY - (int)Config.Instance.LineHeight);
			mainPicBox.Location = new Point(0, menuSize.Height);
			mainPicBox.BackColor = Config.Instance.BackColor;
			this.BackColor = Config.Instance.BackColor;
			if (mainPicBox.Image != null)
				mainPicBox.Image.Dispose();
			if (Config.Instance.UseImageBuffer)
				mainPicBox.Image = new Bitmap(mainPicBox.Size.Width, mainPicBox.Size.Height, System.Drawing.Imaging.PixelFormat.Format32bppPArgb);
			else
				mainPicBox.Image = null;
			richTextBox1.Size = new Size(windowX, (int)Config.Instance.LineHeight);
			richTextBox1.Location = new Point(0, menuSize.Height + mainPicBox.Height);
			this.ResumeLayout();
			if (console != null)
			{
				console.MainPicBoxSizeChanged();
				//ImageBufferを使わない方式ではOnPaintで描画する
				if (Config.Instance.UseImageBuffer)
					console.RefreshStrings(true);
			}
		}


		private void mainPicBox_MouseMove(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			console.MoveMouse(e.Location);
		}
        bool changeTextbyMouse = false;
		private void mainPicBox_MouseDown(object sender, MouseEventArgs e)
		{
			if (!Config.Instance.UseMouse)
				return;
			if (console.IsWaitingAnyKey && !console.IsError)
			{
				if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
				{
                    if (vScrollBar.Value != vScrollBar.Maximum)
                    {
                        vScrollBar.Value = vScrollBar.Maximum;
                        console.RefreshStrings(true);
                        //WAIT系の時は戻るだけにしておく
                        return;
                    }
                    if (e.Button == MouseButtons.Right)
						PressEnterKey(true);
					else
						PressEnterKey(false);
					return;
				}

			}
            if (console.SelectingButton == null)//選択中でないなら無視
            {
                if (console.IsError)
                {
                    PressEnterKey(false);
                    return;
                }
                if (vScrollBar.Value != vScrollBar.Maximum)
                {//履歴表示中
                    if ((e.Button == MouseButtons.Left) || (e.Button == MouseButtons.Right))
                    {
                        vScrollBar.Value = vScrollBar.Maximum;
                        console.RefreshStrings(true);
                    }
                }
                return;
            }
			//左が押されたなら選択。
			if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
			{
				string str = console.SelectedString;
				if (str == null)
					return;
				if (vScrollBar.Value != vScrollBar.Maximum)
				{
					vScrollBar.Value = vScrollBar.Maximum;
					console.RefreshStrings(true);
				}
				changeTextbyMouse = console.IsWaintingOnePhrase;
				richTextBox1.Text = str;
				ScriptPosition pos = console.SelectedPos;
				//右が押しっぱなしならスキップ追加。
				if ((Control.MouseButtons & MouseButtons.Right) == MouseButtons.Right)
					PressEnterKey(true, pos);
				else
					PressEnterKey(false, pos);
				return;
			}
		}

		private void vScrollBar_Scroll(object sender, ScrollEventArgs e)
		{
			//上端でも下端でもないなら描画を控えめに。
			console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));
		}

		public void PressEnterKey(bool mesSkip)
		{
			string str = richTextBox1.Text;
			updateInputs();
			console.PressEnterKey(mesSkip, str, null);
		}

		public void PressEnterKey(bool mesSkip, ScriptPosition ErrPos)
		{
			string str = richTextBox1.Text;
			updateInputs();
			console.PressEnterKey(mesSkip, str, ErrPos);
		}

		string[] prevInputs = new string[100];
		int selectedInputs = 100;
		int lastSelected = 100;
        bool entered = false;
		void updateInputs()
		{
			string cur = richTextBox1.Text;
            if (string.IsNullOrEmpty(cur))
                return;
			for (int i = 0; i < prevInputs.Length - 1; i++)
			{
				prevInputs[i] = prevInputs[i + 1];
			}
			prevInputs[prevInputs.Length - 1] = cur;
            //entered = console.IsWaintingOnePhrase;
			richTextBox1.Text = "";
			//1729a eramakerと同じ処理系に変更 1730a 再修正
			if (selectedInputs != prevInputs.Length && cur == prevInputs[selectedInputs - 1])
				lastSelected = --selectedInputs;
			else
				lastSelected = 100;
			selectedInputs = prevInputs.Length;
		}

		void movePrev(int move)
		{
			if (move == 0)
				return;
			//if((selectedInputs != prevInputs.Length) &&(prevInputs[selectedInputs] != richTextBox1.Text))
			//	selectedInputs =  prevInputs.Length;
			int next;
			if (lastSelected != prevInputs.Length && selectedInputs == prevInputs.Length)
			{
				if (move == -1)
					move = 0;
				next = lastSelected + move;
			}
			else
				next = selectedInputs + move;
			if ((next < 0) || (next > prevInputs.Length))
				return;
			if (next == prevInputs.Length)
			{
				selectedInputs = next;
				richTextBox1.Text = "";
				return;
			}
            if (string.IsNullOrEmpty(prevInputs[next]))
                if (++next == prevInputs.Length)
                    return;

			selectedInputs = next;
			richTextBox1.Text = prevInputs[next];
			richTextBox1.SelectionStart = 0;
			richTextBox1.SelectionLength = richTextBox1.Text.Length;
			return;
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("ゲームを終了します", "終了", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Close();

		}

		private void rebootToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("ゲームを再起動します", "再起動", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.Reboot();
		}

		//private void loadToolStripMenuItem_Click(object sender, EventArgs e)
		//{
		//    openFileDialog.InitialDirectory = Config.Instance.SavDir;
		//    DialogResult result = openFileDialog.ShowDialog();
		//    string filepath = openFileDialog.FileName;
		//    if (!File.Exists(filepath))
		//    {
		//        MessageBox.Show("ファイルがありません", "File Not Found");
		//        return;
		//    }
		//}

		public void Reboot()
		{
			Program.Reboot = true;
			Program.state = WindowState;
			if (WindowState != FormWindowState.Normal)
				WindowState = FormWindowState.Normal;
			Program.ClientX = mainPicBox.Width;
			Program.ClientY = mainPicBox.Height + (int)Config.Instance.Font.Size;
			this.Close();
		}

		public void GotoTitle()
		{
			console.GotoTitle();
		}

		public void ReloadErb()
		{
			console.ReloadErb();
		}

		private void mainPicBox_MouseLeave(object sender, EventArgs e)
		{
			if (Config.Instance.UseMouse)
				console.LeaveMouse();
		}


		private void コンフィグCToolStripMenuItem_Click(object sender, EventArgs e)
		{
			ShowConfigDialog();
		}

		public void ShowConfigDialog()
		{
			ConfigDialog dialog = new ConfigDialog();
			dialog.SetConfig(this, console.DebugDialog);
			dialog.ShowDialog();
			if (dialog.Result == ConfigDialogResult.SaveReboot)
			{
				Program.Reboot = true;
				this.Close();
			}
		}

		private void タイトルへ戻るTToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("タイトル画面へ戻ります", "タイトル画面に戻る", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.GotoTitle();
		}

		private void コードを読み直すcToolStripMenuItem_Click(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("ERBファイルを読み直します", "ERBファイル読み直し", MessageBoxButtons.OKCancel);
			if (result != DialogResult.OK)
				return;
			this.ReloadErb();

		}

		private void mainPicBox_Paint(object sender, PaintEventArgs e)
		{
			if (!Config.Instance.UseImageBuffer)
			{
                e.Graphics.Clear(Config.Instance.BackColor);
                console.RefreshStrings(true, e.Graphics);
			}
		}

		private void ログを保存するSToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			saveFileDialog.InitialDirectory = Program.ExeDir;
			DateTime time = DateTime.Now;
			string fname = time.ToString("yyyyMMdd-HHmmss");
			fname += ".log";
			saveFileDialog.FileName = fname;
			DialogResult result = saveFileDialog.ShowDialog();
			if (result == DialogResult.OK)
			{
				console.outputLog(Path.GetFileName(saveFileDialog.FileName));
			}
		}

		private void ログをクリップボードにコピーToolStripMenuItem_Click(object sender, EventArgs e)
		{
			ClipBoardDialog dialog = new ClipBoardDialog();
			dialog.Setup(this, console);
			dialog.ShowDialog();
		}

		private void ファイルを読み直すFToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			DialogResult result = openFileDialog.ShowDialog();
			List<string> filepath = new List<string>();
			if (result == DialogResult.OK)
			{
				foreach (string fname in openFileDialog.FileNames)
				{
					if (!File.Exists(fname))
					{
						MessageBox.Show("ファイルがありません", "File Not Found");
						return;
					}
					if (Path.GetExtension(fname).ToUpper() != ".ERB")
					{
						MessageBox.Show("ERBファイル以外は読み込めません", "ファイル形式エラー");
						return;
					}
					if (fname.StartsWith(Program.ExeDir + "ERB\\"))
						filepath.Add(Program.ExeDir + "erb\\" + fname.Substring(Program.ExeDir.Length + "erb\\".Length));
					else
						filepath.Add(fname);
				}
				console.ReloadPartialErb(filepath);
			}
		}

		private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
		{
            if (Config.Instance.UseKeyMacro)
                Config.Instance.SaveMacro();
			//ほっとしても勝手に閉じるが、その場合はDebugDialogのClosingイベントが発生しない
			if ((Program.DebugMode)&&(console.DebugDialog != null)&& (console.DebugDialog.Created))
				console.DebugDialog.Close();
		}

		private void フォルダを読み直すFToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (console == null)
				return;
			List<KeyValuePair<string, string>> filepath = new List<KeyValuePair<string, string>>();
			if (folderSelectDialog.ShowDialog() == DialogResult.OK)
			{
				console.ReloadFolder(folderSelectDialog.SelectedPath);
			}
		}

        void richTextBox1_MouseWheel(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            //if (!Config.UseMouse)
            //	return;
            if (!vScrollBar.Enabled)
                return;
            //e.Deltaには大きな値が入っているので符号のみ採用する
            int move = -Math.Sign(e.Delta) * vScrollBar.SmallChange * Config.Instance.ScrollHeight;
            //スクロールが必要ないならリターンする
            if ((vScrollBar.Value == vScrollBar.Maximum && move > 0) || (vScrollBar.Value == vScrollBar.Minimum && move < 0))
                return;
            int value = vScrollBar.Value + move;
            if (value >= vScrollBar.Maximum)
                vScrollBar.Value = vScrollBar.Maximum;
            else if (value <= vScrollBar.Minimum)
                vScrollBar.Value = vScrollBar.Minimum;
            else
                vScrollBar.Value = value;
            //上端でも下端でもないなら描画を控えめに。
            console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));
            //ボタンとの関係をチェック
            if (Config.Instance.UseMouse)
                console.MoveMouse(mainPicBox.PointToClient(Cursor.Position));
        }

        private void richTextBox1_TextChanged(object sender, EventArgs e)
        {
            if (!console.IsWaintingOnePhrase)
                return;
            if (string.IsNullOrEmpty(richTextBox1.Text))
                return;
            if (changeTextbyMouse)
            {
                changeTextbyMouse = false;
                if (richTextBox1.Text.Length > 1)
                    richTextBox1.Text = richTextBox1.Text.Remove(1);
                return;
            }
            if (entered)
            {
                entered = false;
                return;
            }
            if (richTextBox1.Text.Length > 1)
                richTextBox1.Text = richTextBox1.Text.Remove(1);
            PressEnterKey(false);

        }

        private void richTextBox1_KeyDown(object sender, KeyEventArgs e)
        {
	        if ((int)e.KeyData== (int)Keys.PageUp || (int)e.KeyData == (int)Keys.PageDown)
            {
                e.SuppressKeyPress = true;
                int move = 10;
                if ((int)e.KeyData == (int)Keys.PageUp)
                    move *= -1;
                //スクロールが必要ないならリターンする
                if ((vScrollBar.Value == vScrollBar.Maximum && move > 0) || (vScrollBar.Value == vScrollBar.Minimum && move < 0))
                    return;
                int value = vScrollBar.Value + move;
                if (value >= vScrollBar.Maximum)
                    vScrollBar.Value = vScrollBar.Maximum;
                else if (value <= vScrollBar.Minimum)
                    vScrollBar.Value = vScrollBar.Minimum;
                else
                    vScrollBar.Value = value;
                //上端でも下端でもないなら描画を控えめに。
                console.RefreshStrings((vScrollBar.Value == vScrollBar.Maximum) || (vScrollBar.Value == vScrollBar.Minimum));
                return;
            }
            else if (vScrollBar.Value != vScrollBar.Maximum)
			{
				vScrollBar.Value = vScrollBar.Maximum;
				console.RefreshStrings(true);
			}
			if (e.KeyCode == Keys.Return)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(false);
				return;
			}
			if (e.KeyCode == Keys.Escape)
			{
				e.SuppressKeyPress = true;
				if (!console.IsRunning)
					PressEnterKey(true);
				return;
			}
            if (e.KeyCode == Keys.Left || e.KeyCode == Keys.Home || e.KeyCode == Keys.Back)
			{
				if ((richTextBox1.SelectionStart == 0 && richTextBox1.SelectedText.Length == 0) || richTextBox1.Text.Length == 0)
                {
                    e.SuppressKeyPress = true;
                    return;
                }
            }
            if (e.KeyCode == Keys.Right || e.KeyCode == Keys.End)
            {
                if (richTextBox1.SelectionStart == richTextBox1.Text.Length || richTextBox1.Text.Length == 0)
                {
                    e.SuppressKeyPress = true;
                    return;
                }
            }
			if (e.KeyCode == Keys.Up)
			{
				e.SuppressKeyPress = true;
                if (console.IsRunning)
                    return;
				movePrev(-1);
				return;
			}
            if (e.KeyCode == Keys.Down)
            {
                e.SuppressKeyPress = true;
                if (console.IsRunning)
                    return;
                movePrev(1);
                return;
            }
        }

		private void デバッグウインドウを開くToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (!Program.DebugMode)
				return;
			console.OpenDebugDialog();
		}

		private void デバッグ情報の更新ToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (!Program.DebugMode)
				return;
			if ((console.DebugDialog != null) && (console.DebugDialog.Created))
				console.DebugDialog.UpdateData();
		}
	}
}