using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameData
{
    internal enum CharacterStrData
    {
        NAME = 0,
        CALLNAME = 1,
        NICKNAME = 2,
        MASTERNAME = 3,
        CSTR = 4,
    }

    internal enum CharacterIntData
    {
        BASE = 0,
        ABL = 1,
        TALENT = 2,
        MARK = 3,
        EXP = 4,
        RELATION = 5,
        CFLAG = 6,
        EQUIP = 7,
        JUEL = 8,
    }
    
    internal sealed class ConstantData
	{
		public static int MaxAbl { get; private set; }
		public static int MaxTalent { get; private set; }
		public static int MaxExp { get; private set; }
		public static int MaxMark { get; private set; }
		public static int MaxTrain { get; private set; }
		public static int MaxParam { get; private set; }
		public static int MaxItem { get; private set; }
		public static int MaxBasedata { get; private set; }
		public static int MaxSource { get; private set; }
		public static int MaxEx { get; private set; }
		public static int MaxEquip { get; private set; }
		public static int MaxTequip { get; private set; }
		public static int MaxFlag { get; private set; }
		public static int MaxTFlag { get; private set; }
		public static int MaxCFlag { get; private set; }
        public static int MaxTCVar { get; private set; }
        public static int MaxCStr { get; private set; }

		public static int MaxStr { get; private set; }

		static ConstantData()
		{
			MaxAbl = 100;
			MaxTalent = 1000;
			MaxExp = 100;
			MaxMark = 100;
			MaxTrain = 1000;
			MaxParam = 200;
			MaxItem = 1000;
			MaxBasedata = 100;
			MaxSource = 1000;
			MaxEx = 100;
			MaxEquip = 100;
			MaxTequip = 100;
			MaxFlag = 10000;
			MaxTFlag = 1000;
			MaxCFlag = 1000;
            MaxTCVar = 100;
            MaxCStr = 100;

			MaxStr = 20000;
		}

		public int[] VariableIntArrayLength;
		public int[] VariableStrArrayLength;
		public int[] CharacterIntArrayLength;
		public int[] CharacterStrArrayLength;
		public Int64[] VariableIntArray2DLength;
		public Int64[] VariableStrArray2DLength;
        public Int64[] VariableIntArray3DLength;
        public Int64[] VariableStrArray3DLength;

		private void setArray()
		{
			AblName = new string[MaxAbl];
			BaseName = new string[MaxBasedata];
			TalentName = new string[MaxTalent];
			ExpName = new string[MaxExp];
			ParamName = new string[MaxParam];
			TrainName = new string[MaxTrain];
			MarkName = new string[MaxMark];
			SourceName = new string[MaxSource];
			ExName = new string[MaxEx];
			EquipName = new string[MaxEquip];
			TequipName = new string[MaxTequip];
			FlagName = new string[MaxFlag];
			TFlagName = new string[MaxTFlag];
			CFlagName = new string[MaxCFlag];
            TCVarName = new string[MaxTCVar];
            CStrName = new string[MaxCStr];

			ItemName = new string[MaxItem];
			ItemPrice = new Int64[MaxItem];

			Str = new string[MaxStr];
		}

		public ConstantData(GameBase gamebase)
		{
			this.gamebase = gamebase;
			setDefaultArrayLength();

			CharacterTmplList = new List<CharacterTemplate>();
		}

		private void setDefaultArrayLength()
		{

			VariableIntArrayLength = new int[(int)VariableCode.__COUNT_INTEGER_ARRAY__];
			VariableStrArrayLength = new int[(int)VariableCode.__COUNT_STRING_ARRAY__];
			CharacterIntArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_INTEGER_ARRAY__];
			CharacterStrArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_STRING_ARRAY__];
			VariableIntArray2DLength = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_2D__];
			VariableStrArray2DLength = new Int64[(int)VariableCode.__COUNT_STRING_ARRAY_2D__];
            VariableIntArray3DLength = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_3D__];
            VariableStrArray3DLength = new Int64[(int)VariableCode.__COUNT_STRING_ARRAY_3D__];
            for (int i = 0; i < VariableIntArrayLength.Length; i++)
				VariableIntArrayLength[i] = 1000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = 10000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = ConstantData.MaxItem;

			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.RANDDATA)] = 625;
			
			for (int i = 0; i < VariableStrArrayLength.Length; i++)
				VariableStrArrayLength[i] = 100;
			VariableStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.STR)] = ConstantData.MaxStr;

			for (int i = 0; i < CharacterIntArrayLength.Length; i++)
				CharacterIntArrayLength[i] = 100;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)] = 200;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.GOTJUEL)] = 200;

			for (int i = 0; i < CharacterStrArrayLength.Length; i++)
				CharacterStrArrayLength[i] = 100;

			for (int i = 0; i < VariableIntArray2DLength.Length; i++)
				VariableIntArray2DLength[i] = (100L << 32) + 100L;
			for (int i = 0; i < VariableStrArray2DLength.Length; i++)
				VariableStrArray2DLength[i] = (100L << 32) + 100L;

            for (int i = 0; i < VariableIntArray3DLength.Length; i++)
                VariableIntArray3DLength[i] = (100L << 32) + (100L << 16) + 100L;
            for (int i = 0; i < VariableStrArray3DLength.Length; i++)
                VariableStrArray3DLength[i] = (100L << 32) + (100L << 16) + 100L;
        }

        private void loadVariableSizeData(string csvPath)
		{
			if (!File.Exists(csvPath))
				return;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
                output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;
			if (Config.Instance.DisplayReport)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//前方のホワイトスペース読み捨て
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					changeVariableSizeData(line, position);
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					output.PrintWarning("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Close();
			}
            decideActualArraySize(position);
		}

        List<VariableCode> changedCode = new List<VariableCode>();

		private void changeVariableSizeData(string line, ScriptPosition position)
		{
			string[] tokens = line.Split(',');
			if (tokens.Length < 2)
			{
				output.PrintWarning("\",\"が必要です", position, 1);
				return;
			}
			string idtoken = tokens[0].Trim();
			VariableIdentifier id = VariableIdentifier.GetVariableId(idtoken);
			if (id == null)
			{
				output.PrintWarning("一つ目の値を変数名として認識できません", position, 1);
				return;
			}
			if ((!id.IsArray1D) && (!id.IsArray2D) && (!id.IsArray3D))
			{
				output.PrintWarning("配列変数でない変数" + id.ToString() + "のサイズを変更できません", position, 1);
				return;
			}
			int length = 0;
			int length2 = 0;
            int length3 = 0;
			if (!int.TryParse(tokens[1], out length))
			{
				output.PrintWarning("二つ目の値を整数値として認識できません", position, 1);
				return;
			}
			if (length < 100)
			{
				output.PrintWarning("配列サイズを100以下には出来ません", position, 1);
				return;
			}
			if (id.IsArray2D)
			{
				if (tokens.Length < 3)
				{
					output.PrintWarning("二次元配列のサイズ指定には2つの数値が必要です", position, 1);
					return;
				}
				if (!int.TryParse(tokens[2], out length2))
				{
					output.PrintWarning("三つ目の値を整数値として認識できません", position, 1);
					return;
				}
				if (length2 < 10)
				{
					output.PrintWarning("配列サイズを10以下には出来ません", position, 1);
					return;
				}
			}
            if (id.IsArray3D)
            {
                if (tokens.Length < 4)
                {
                    output.PrintWarning("二次元配列のサイズ指定には3つの数値が必要です", position, 1);
                    return;
                }
                if (!int.TryParse(tokens[2], out length2))
                {
                    output.PrintWarning("三つ目の値を整数値として認識できません", position, 1);
                    return;
                }
                if (length2 < 10)
                {
                    output.PrintWarning("配列サイズを10以下には出来ません", position, 1);
                    return;
                }
                if (!int.TryParse(tokens[3], out length3))
                {
                    output.PrintWarning("三つ目の値を整数値として認識できません", position, 1);
                    return;
                }
                if (length3 < 10)
                {
                    output.PrintWarning("配列サイズを10以下には出来ません", position, 1);
                    return;
                }
                if (length * length2 * length3 > 1000000)
                {
                    output.PrintWarning("三重配列の要素数は最大で100万個までです", position, 1);
                    return;
                }
            }
            switch (id.Code)
            {
                //1753a PALAMだけ仕様が違うのはかえって問題なので、変数と要素文字列配列数の同期は全部バックアウト
                //基本的には旧来の処理に戻しただけ
                case VariableCode.ITEMNAME:
                case VariableCode.ITEMPRICE:
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = length;
                    ConstantData.MaxItem = length; break;
                case VariableCode.ABLNAME:
                    ConstantData.MaxAbl = length; break;
                case VariableCode.TALENTNAME:
                    ConstantData.MaxTalent = length; break;
                case VariableCode.EXPNAME:
                    ConstantData.MaxExp = length; break;
                case VariableCode.MARKNAME:
                    ConstantData.MaxMark = length; break;
                case VariableCode.PALAMNAME:
                    ConstantData.MaxParam = length; break;
                case VariableCode.TRAINNAME:
                    ConstantData.MaxTrain = length; break;
                case VariableCode.BASENAME:
                    ConstantData.MaxBasedata = length; break;
                case VariableCode.SOURCENAME:
                    ConstantData.MaxSource = length; break;
                case VariableCode.EXNAME:
                    ConstantData.MaxEx = length; break;
                case VariableCode.EQUIPNAME:
                    ConstantData.MaxEquip = length; break;
                case VariableCode.TEQUIPNAME:
                    ConstantData.MaxTequip = length; break;
                case VariableCode.FLAGNAME:
                    ConstantData.MaxFlag = length; break;
                case VariableCode.TFLAGNAME:
                    ConstantData.MaxTFlag = length; break;
                case VariableCode.CFLAGNAME:
                    ConstantData.MaxCFlag = length; break;
                case VariableCode.STR:
                    VariableStrArrayLength[id.CodeInt] = length;
                    ConstantData.MaxStr = length; break;
                case VariableCode.TCVARNAME:
                    ConstantData.MaxTCVar = length; break;
                case VariableCode.CSTRNAME:
                    ConstantData.MaxCStr = length; break;
                default:
                    {
                        if ((id.IsCalc) || (id.Code == VariableCode.RANDDATA))
                        {
                            output.PrintWarning(id.ToString() + "のサイズは変更できません", position, 1);
                        }
                        else if (id.IsArray2D)
                        {
                            Int64 length64 = (((Int64)length) << 32) + ((Int64)length2);
                            if (id.IsInteger)
                                VariableIntArray2DLength[id.CodeInt] = length64;
                            else if (id.IsString)
                                VariableStrArray2DLength[id.CodeInt] = length64;
                        }
                        else if (id.IsArray3D)
                        {
                            Int64 length3d = ((Int64)length << 32) + ((Int64)length2 << 16) + (Int64)length3;
                            if (id.IsInteger)
                                VariableIntArray3DLength[id.CodeInt] = length3d;
                            else
                                VariableStrArray3DLength[id.CodeInt] = length3d;
                        }
                        else if (id.IsCharacterData)
                        {
                            if (id.IsInteger)
                                CharacterIntArrayLength[id.CodeInt] = length;
                            else if (id.IsString)
                                CharacterStrArrayLength[id.CodeInt] = length;
                        }
                        else
                        {
                            if (id.IsInteger)
                                VariableIntArrayLength[id.CodeInt] = length;
                            else if (id.IsString)
                                VariableStrArrayLength[id.CodeInt] = length;
                        }
                    }
                    break;
            }
            changedCode.Add(id.Code);
		}

        private void decideActualArraySize(ScriptPosition position)
        {
            //ABL
            if (changedCode.Contains(VariableCode.ABLNAME) && changedCode.Contains(VariableCode.ABL))
            {
                if (MaxAbl > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)] = MaxAbl;
                else if (MaxAbl < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)])
                    MaxAbl = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
            }
            else if (changedCode.Contains(VariableCode.ABLNAME) && !changedCode.Contains(VariableCode.ABL))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)] = MaxAbl;
            else if (!changedCode.Contains(VariableCode.ABLNAME) && changedCode.Contains(VariableCode.ABL))
                MaxAbl = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
            //TALENT
            if (changedCode.Contains(VariableCode.TALENTNAME) && changedCode.Contains(VariableCode.TALENT))
            {
                if (MaxTalent > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = MaxTalent;
                else if (MaxTalent < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)])
                    MaxTalent = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
            }
            else if (changedCode.Contains(VariableCode.TALENTNAME) && !changedCode.Contains(VariableCode.TALENT))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = MaxTalent;
            else if (!changedCode.Contains(VariableCode.TALENTNAME) && changedCode.Contains(VariableCode.TALENT))
                MaxTalent = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
            //EXP
            if (changedCode.Contains(VariableCode.EXPNAME) && changedCode.Contains(VariableCode.EXP))
            {
                if (MaxExp > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)] = MaxExp;
                else if (MaxExp < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)])
                    MaxExp = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
            }
            else if (changedCode.Contains(VariableCode.EXPNAME) && !changedCode.Contains(VariableCode.EXP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)] = MaxExp;
            else if (!changedCode.Contains(VariableCode.EXPNAME) && changedCode.Contains(VariableCode.EXP))
                MaxExp = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
            //MARK
            if (changedCode.Contains(VariableCode.MARKNAME) && changedCode.Contains(VariableCode.MARK))
            {
                if (MaxMark > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)] = MaxMark;
                else if (MaxMark < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)])
                    MaxMark = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
            }
            else if (changedCode.Contains(VariableCode.MARKNAME) && !changedCode.Contains(VariableCode.MARK))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)] = MaxMark;
            else if (!changedCode.Contains(VariableCode.MARKNAME) && changedCode.Contains(VariableCode.MARK))
                MaxMark = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
            //PALAM(JUEL込み)
            //PALAMかJUELが変わっていれば、そのうち大きい方にPALAMNAMEをあわせる
            if (changedCode.Contains(VariableCode.PALAM) || changedCode.Contains(VariableCode.JUEL))
                MaxParam = Math.Max(CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.PALAM)], CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)]);
            //PALAMとJUEL不変でPALAMNAMEが変わっている場合
            else if (changedCode.Contains(VariableCode.PALAMNAME))
            {
                //PALAMを想定のPALAMNAMEにあわせる
                if (!changedCode.Contains(VariableCode.PALAM))
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.PALAM)] = MaxParam;
                //想定のPALAMNAMEがJUELより小さければ警告出してJUELにあわせる
                if (MaxParam < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)])
                {
                    output.PrintWarning("PALAMNAMEの要素数がJUELより少なくなっています", position, 1);
                    MaxParam = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)];
                }
            }
            //BASE
            if (changedCode.Contains(VariableCode.BASENAME) && changedCode.Contains(VariableCode.BASE))
            {
                if (MaxBasedata > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)] = MaxBasedata;
                else if (MaxBasedata < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)])
                    MaxBasedata = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)];
            }
            else if (changedCode.Contains(VariableCode.BASENAME) && !changedCode.Contains(VariableCode.BASE))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)] = MaxBasedata;
            else if (!changedCode.Contains(VariableCode.BASENAME) && changedCode.Contains(VariableCode.BASE))
                MaxBasedata = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)];
            //SOURCE
            if (changedCode.Contains(VariableCode.SOURCENAME) && changedCode.Contains(VariableCode.SOURCE))
            {
                if (MaxSource > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)] = MaxSource;
                else if (MaxSource < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)])
                    MaxSource = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)];
            }
            else if (changedCode.Contains(VariableCode.SOURCENAME) && !changedCode.Contains(VariableCode.SOURCE))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)] = MaxSource;
            else if (!changedCode.Contains(VariableCode.SOURCENAME) && changedCode.Contains(VariableCode.SOURCE))
                MaxSource = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)];
            //EX
            if (changedCode.Contains(VariableCode.EXNAME) && changedCode.Contains(VariableCode.EX))
            {
                if (MaxEx > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)] = MaxEx;
                else if (MaxEx < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)])
                    MaxEx = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)];
            }
            else if (changedCode.Contains(VariableCode.EXNAME) && !changedCode.Contains(VariableCode.EX))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)] = MaxEx;
            else if (!changedCode.Contains(VariableCode.EXNAME) && changedCode.Contains(VariableCode.EX))
                MaxEx = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)];
            //EQUIP
            if (changedCode.Contains(VariableCode.EQUIPNAME) && changedCode.Contains(VariableCode.EQUIP))
            {
                if (MaxEquip > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)] = MaxEquip;
                else if (MaxEquip < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)])
                    MaxEquip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
            }
            else if (changedCode.Contains(VariableCode.EQUIPNAME) && !changedCode.Contains(VariableCode.EQUIP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)] = MaxEquip;
            else if (!changedCode.Contains(VariableCode.EQUIPNAME) && changedCode.Contains(VariableCode.EQUIP))
                MaxEquip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
            //TEQUIP
            if (changedCode.Contains(VariableCode.TEQUIPNAME) && changedCode.Contains(VariableCode.TEQUIP))
            {
                if (MaxTequip > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)] = MaxTequip;
                else if (MaxTequip < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)])
                    MaxTequip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)];
            }
            else if (changedCode.Contains(VariableCode.TEQUIPNAME) && !changedCode.Contains(VariableCode.TEQUIP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)] = MaxTequip;
            else if (!changedCode.Contains(VariableCode.TEQUIPNAME) && changedCode.Contains(VariableCode.TEQUIP))
                MaxTequip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)];
            //FLAG
            if (changedCode.Contains(VariableCode.FLAGNAME) && changedCode.Contains(VariableCode.FLAG))
            {
                if (MaxFlag > VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)])
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = MaxFlag;
                else if (MaxFlag < VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)])
                    MaxFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)];
            }
            else if (changedCode.Contains(VariableCode.FLAGNAME) && !changedCode.Contains(VariableCode.FLAG))
                VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = MaxFlag;
            else if (!changedCode.Contains(VariableCode.FLAGNAME) && changedCode.Contains(VariableCode.FLAG))
                MaxFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)];
            //TFLAG
            if (changedCode.Contains(VariableCode.TFLAGNAME) && changedCode.Contains(VariableCode.TFLAG))
            {
                if (MaxTFlag > VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)])
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)] = MaxTFlag;
                else if (MaxTFlag < VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)])
                    MaxTFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)];
            }
            else if (changedCode.Contains(VariableCode.TFLAGNAME) && !changedCode.Contains(VariableCode.TFLAG))
                VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)] = MaxTFlag;
            else if (!changedCode.Contains(VariableCode.TFLAGNAME) && changedCode.Contains(VariableCode.TFLAG))
                MaxTFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)];
            //CFLAG
            if (changedCode.Contains(VariableCode.CFLAGNAME) && changedCode.Contains(VariableCode.CFLAG))
            {
                if (MaxCFlag > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = MaxCFlag;
                else if (MaxCFlag < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)])
                    MaxCFlag = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
            }
            else if (changedCode.Contains(VariableCode.CFLAGNAME) && !changedCode.Contains(VariableCode.CFLAG))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = MaxCFlag;
            else if (!changedCode.Contains(VariableCode.CFLAGNAME) && changedCode.Contains(VariableCode.CFLAG))
                MaxCFlag = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
            //TCVAR
            if (changedCode.Contains(VariableCode.TCVARNAME) && changedCode.Contains(VariableCode.TCVAR))
            {
                if (MaxTCVar > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)] = MaxTCVar;
                else if (MaxTCVar < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)])
                    MaxTCVar = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)];
            }
            else if (changedCode.Contains(VariableCode.TCVARNAME) && !changedCode.Contains(VariableCode.TCVAR))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)] = MaxTCVar;
            else if (!changedCode.Contains(VariableCode.TCVARNAME) && changedCode.Contains(VariableCode.TCVAR))
                MaxTCVar = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)];
            //CSTR
            if (changedCode.Contains(VariableCode.CSTRNAME) && changedCode.Contains(VariableCode.CSTR))
            {
                if (MaxCStr > CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)])
                    CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)] = MaxCStr;
                else if (MaxCStr < CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)])
                    MaxCStr = CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
            }
            else if (changedCode.Contains(VariableCode.CSTRNAME) && !changedCode.Contains(VariableCode.CSTR))
                CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)] = MaxCStr;
            else if (!changedCode.Contains(VariableCode.CSTRNAME) && changedCode.Contains(VariableCode.CSTR))
                MaxCStr = CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
            //もう使わないのでデータ破棄
            changedCode.Clear();
        }

		private readonly GameBase gamebase;
		private string[][] names = new string[18][];
		public string[] AblName { get { return names[0]; } private set { names[0] = value; } }
		public string[] ExpName { get { return names[1]; } private set { names[1] = value; } }
		public string[] TalentName { get { return names[2]; } private set { names[2] = value; } }
		public string[] ParamName { get { return names[3]; } private set { names[3] = value; } }
		public string[] TrainName { get { return names[4]; } private set { names[4] = value; } }
		public string[] MarkName { get { return names[5]; } private set { names[5] = value; } }
		public string[] ItemName { get { return names[6]; } private set { names[6] = value; } }
		public string[] BaseName { get { return names[7]; } private set { names[7] = value; } }
		public string[] SourceName { get { return names[8]; } private set { names[8] = value; } }
		public string[] ExName { get { return names[9]; } private set { names[9] = value; } }
		public string[] Str { get { return names[10]; } private set { names[10] = value; } }
		public string[] EquipName { get { return names[11]; } private set { names[11] = value; } }
		public string[] TequipName { get { return names[12]; } private set { names[12] = value; } }
		public string[] FlagName { get { return names[13]; } private set { names[13] = value; } }
		public string[] TFlagName { get { return names[14]; } private set { names[14] = value; } }
		public string[] CFlagName { get { return names[15]; } private set { names[15] = value; } }
        public string[] TCVarName { get { return names[16]; } private set { names[16] = value; } }
        public string[] CStrName { get { return names[17]; } private set { names[17] = value; } }
        public Int64[] ItemPrice;

		private readonly List<CharacterTemplate> CharacterTmplList;

		private EmueraConsole output;
		public void LoadData(string csvDir, EmueraConsole console)
		{
			output = console;
			loadVariableSizeData(csvDir + "VariableSize.CSV");
			setArray();
            definedNames.Clear();
            
			loadDataTo(csvDir + "ABL.CSV", AblName, null);
            definedNames.Add("ABL", new List<string>());
            foreach (string str in AblName)
                definedNames["ABL"].Add(str);

            loadDataTo(csvDir + "EXP.CSV", ExpName, null);
            definedNames.Add("EXP", new List<string>());
            foreach (string str in ExpName)
                definedNames["EXP"].Add(str);

            loadDataTo(csvDir + "TALENT.CSV", TalentName, null);
            definedNames.Add("TALENT", new List<string>());
            foreach (string str in TalentName)
                definedNames["TALENT"].Add(str);

            loadDataTo(csvDir + "PALAM.CSV", ParamName, null);
            definedNames.Add("PALAM", new List<string>());
            foreach (string str in ParamName)
                definedNames["PALAM"].Add(str);

            loadDataTo(csvDir + "TRAIN.CSV", TrainName, null);
            definedNames.Add("TRAIN", new List<string>());
            foreach (string str in TrainName)
                definedNames["TRAIN"].Add(str);

			loadDataTo(csvDir + "MARK.CSV", MarkName, null);
            definedNames.Add("MARK", new List<string>());
            foreach (string str in MarkName)
                definedNames["MARK"].Add(str);

            loadDataTo(csvDir + "ITEM.CSV", ItemName, ItemPrice);
            definedNames.Add("ITEM", new List<string>());
            foreach (string str in ItemName)
                definedNames["ITEM"].Add(str);

            loadDataTo(csvDir + "BASE.CSV", BaseName, null);
            definedNames.Add("BASE", new List<string>());
            foreach (string str in BaseName)
                definedNames["BASE"].Add(str);

            loadDataTo(csvDir + "SOURCE.CSV", SourceName, null);
            definedNames.Add("SOURCE", new List<string>());
            foreach (string str in SourceName)
                definedNames["SOURCE"].Add(str);

            loadDataTo(csvDir + "EX.CSV", ExName, null);
            definedNames.Add("EX", new List<string>());
            foreach (string str in ExName)
                definedNames["EX"].Add(str);

            loadDataTo(csvDir + "EQUIP.CSV", EquipName, null);
            definedNames.Add("EQUIP", new List<string>());
            foreach (string str in EquipName)
                definedNames["EQUIP"].Add(str);

            loadDataTo(csvDir + "TEQUIP.CSV", TequipName, null);
            definedNames.Add("TEQUIP", new List<string>());
            foreach (string str in TequipName)
                definedNames["TEQUIP"].Add(str);

            loadDataTo(csvDir + "FLAG.CSV", FlagName, null);
            definedNames.Add("FLAG", new List<string>());
            foreach (string str in FlagName)
                definedNames["FLAG"].Add(str);

            loadDataTo(csvDir + "TFLAG.CSV", TFlagName, null);
            definedNames.Add("TFLAG", new List<string>());
            foreach (string str in TFlagName)
                definedNames["TFLAG"].Add(str);

            loadDataTo(csvDir + "CFLAG.CSV", CFlagName, null);
            definedNames.Add("CFLAG", new List<string>());
            foreach (string str in CFlagName)
                definedNames["CFLAG"].Add(str);

            loadDataTo(csvDir + "STR.CSV", Str, null);
            definedNames.Add("STR", new List<string>());
            foreach (string str in Str)
                definedNames["STR"].Add(str);

            loadDataTo(csvDir + "TCVAR.CSV", TCVarName, null);
            definedNames.Add("TCVAR", new List<string>());
            foreach (string str in TCVarName)
                definedNames["TCVAR"].Add(str);

            loadDataTo(csvDir + "CSTR.CSV", CStrName, null);
            definedNames.Add("CSTR", new List<string>());
            foreach (string str in CStrName)
                definedNames["CSTR"].Add(str);

            //if (!Program.AnalysisMode)
            loadCharacterData(csvDir);
			//definedNames.Clear();
            //foreach (string[] strs in names)
            //    foreach (string str in strs)
            //        definedNames.Add(str);
            definedCharaNames.Clear();
            foreach (CharacterTemplate chara in CharacterTmplList)
			{
				definedCharaNames.Add(chara.Name);
				definedCharaNames.Add(chara.Callname);
			}
		}

        private static readonly Dictionary<string, List<string>> definedNames = new Dictionary<string, List<string>>();
        private static readonly List<String> definedCharaNames = new List<string>();

		public static bool isDefined(VariableCode varCode, string str)
		{
			if (string.IsNullOrEmpty(str))
				return false;
            string id = null;
            switch (varCode)
            {
                case VariableCode.ITEM:
                case VariableCode.ITEMSALES:
                    id = "ITEM";
                    break;
                case VariableCode.LOSEBASE:
                case VariableCode.BASE:
                case VariableCode.MAXBASE:
                case VariableCode.DOWNBASE:
                    id = "BASE";
                    break;

                case VariableCode.ABL:
                    id = "ABL";
                    break;

                case VariableCode.TALENT:
                    id = "TALENT";
                    break;
                case VariableCode.EXP:
                    id = "EXP";
                    break;
                case VariableCode.MARK:
                    id = "MARK";
                    break;
                case VariableCode.SOURCE:
                    id = "SOURCE";
                    break;
                case VariableCode.EX:
                case VariableCode.NOWEX:
                    id = "EX";
                    break;
                case VariableCode.EQUIP:
                    id = "EQUIP";
                    break;
                case VariableCode.TEQUIP:
                    id = "TEQUIP";
                    break;
                case VariableCode.FLAG:
                    id = "FLAG";
                    break;
                case VariableCode.TFLAG:
                    id = "TFLAG";
                    break;
                case VariableCode.CFLAG:
                    id = "CFLAG";
                    break;
                case VariableCode.UP:
                case VariableCode.DOWN:
                case VariableCode.PALAM:
                case VariableCode.JUEL:
                case VariableCode.GOTJUEL:
                case VariableCode.CUP:
                case VariableCode.CDOWN:
                    id = "PALAM";
                    break;
                case VariableCode.TRAINNAME:
                    id = "TRAIN";
                    break;
                case VariableCode.STR:
                    id = "STR";
                    break;
                case VariableCode.TCVAR:
                    id = "TCVAR";
                    break;
                case VariableCode.CSTR:
                    id = "CSTR";
                    break;
            }
            if (id != null)
            {
                if (definedNames[id].Contains(str))
                {
                    return true;
                }
            }
            return definedCharaNames.Contains(str);
		}

		public int KeywordToInteger(VariableCode code, string key)
		{
			if (string.IsNullOrEmpty(key))
				throw new CodeEE("キーワードを空には出来ません");
			int p1 = -1;
			string errPos = null;
			switch (code)
			{
				case VariableCode.ITEM:
				case VariableCode.ITEMSALES:
					p1 = ((IList<string>)ItemName).IndexOf(key);
					errPos = "Item.csv";
					break;
				case VariableCode.LOSEBASE:
				case VariableCode.BASE:
				case VariableCode.MAXBASE:
                case VariableCode.DOWNBASE:
					p1 = ((IList<string>)BaseName).IndexOf(key);
					errPos = "base.csv";
					break;

				case VariableCode.ABL:
					p1 = ((IList<string>)AblName).IndexOf(key);
					errPos = "abl.csv";
					break;

				case VariableCode.TALENT:
					p1 = ((IList<string>)TalentName).IndexOf(key);
					errPos = "talent.csv";
					break;

				case VariableCode.EXP:
					p1 = ((IList<string>)ExpName).IndexOf(key);
					errPos = "exp.csv";
					break;
				case VariableCode.MARK:
					p1 = ((IList<string>)MarkName).IndexOf(key);
					errPos = "mark.csv";
					break;
				case VariableCode.SOURCE:
					p1 = ((IList<string>)SourceName).IndexOf(key);
					errPos = "source.csv";
					break;
				case VariableCode.EX:
				case VariableCode.NOWEX:
					p1 = ((IList<string>)ExName).IndexOf(key);
					errPos = "ex.csv";
					break;
				case VariableCode.EQUIP:
					p1 = ((IList<string>)EquipName).IndexOf(key);
					errPos = "equip.csv";
					break;
				case VariableCode.TEQUIP:
					p1 = ((IList<string>)TequipName).IndexOf(key);
					errPos = "tequip.csv";
					break;
				case VariableCode.FLAG:
					p1 = ((IList<string>)FlagName).IndexOf(key);
					errPos = "flag.csv";
					break;
				case VariableCode.TFLAG:
					p1 = ((IList<string>)TFlagName).IndexOf(key);
					errPos = "tflag.csv";
					break;
				case VariableCode.CFLAG:
					p1 = ((IList<string>)CFlagName).IndexOf(key);
					errPos = "cflag.csv";
					break;
                case VariableCode.TCVAR:
                    p1 = ((IList<string>)TCVarName).IndexOf(key);
                    errPos = "tcvar.csv";
                    break;
                case VariableCode.CSTR:
                    p1 = ((IList<string>)CStrName).IndexOf(key);
                    errPos = "cstr.csv";
                    break;
                case VariableCode.RELATION:
					for (int i = 0; i < CharacterTmplList.Count; i++)
					{
						if ((CharacterTmplList[i].Name == key) 
							|| (CharacterTmplList[i].Callname == key)
							|| (CharacterTmplList[i].Nickname == key))
						{
							p1 = (int)CharacterTmplList[i].No;
							break;
						}
					}
					errPos = "chara*.csv";
					break;


				case VariableCode.UP:
				case VariableCode.DOWN:
				case VariableCode.PALAM:
				case VariableCode.JUEL:
				case VariableCode.GOTJUEL:
                case VariableCode.CUP:
                case VariableCode.CDOWN:
                    p1 = ((IList<string>)ParamName).IndexOf(key);
					errPos = "palam.csv";
					break;

                case VariableCode.TRAINNAME:
                    p1 = ((IList<string>)TrainName).IndexOf(key);
                    errPos = "train.csv";
                    break;
                    
				//case VariableCode.STAIN:
			}
			if (p1 < 0)
			{
				if (errPos == null)
					throw new CodeEE("配列変数" + code.ToString() + "の要素を文字列で指定することはできません");
				else
					throw new CodeEE(errPos + "の中に\"" + key + "\"の定義がありません");
			}
			return p1;
		}

		public CharacterTemplate GetCharacterTemplate(Int64 index, bool sp)
		{
			foreach (CharacterTemplate chara in CharacterTmplList)
			{
				if (chara.No != index)
					continue;
				if (sp == (chara.CFlag[0] != 0))
					return chara;
			}
			return null;
		}

        public CharacterTemplate GetCharacterTemplateFromCsvNo(Int64 index)
        {
            foreach (CharacterTemplate chara in CharacterTmplList)
            {
                if (chara.csvNo != index)
                    continue;
                return chara;
            }
            return null;
        }

        public CharacterTemplate GetPseudoChara()
        {
            return new CharacterTemplate(0, this);
        }

		private void loadCharacterData(string csvDir)
		{
			if (!Directory.Exists(csvDir))
				return;
			List<KeyValuePair<string, string>> csvPaths = Config.Instance.GetFiles(csvDir, "CHARA*.CSV");
			for (int i = 0; i < csvPaths.Count; i++)
                loadCharacterDataFile(csvPaths[i].Value, csvPaths[i].Key);
			if (Config.Instance.CompatiCALLNAME)
			{
				foreach (CharacterTemplate tmpl in CharacterTmplList)
					if (string.IsNullOrEmpty(tmpl.Callname))
						tmpl.Callname = tmpl.Name;
			}
		}

		private void loadCharacterDataFile(string csvPath, string csvName)
		{
			CharacterTemplate tmpl = null;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath, csvName))
			{
                output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;
			if (Config.Instance.DisplayReport)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				Int64 index = -1;
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//前方のホワイトスペース読み捨て
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					string[] tokens = line.Split(',');
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					if (tokens.Length < 2)
					{
						output.PrintWarning("\",\"が必要です", position, 1);
						continue;
					}
					if (tokens[0].Length == 0)
					{
						output.PrintWarning("\",\"で始まっています", position, 1);
						continue;
					}
					if ((tokens[0].Equals("NO", StringComparison.CurrentCultureIgnoreCase))
						|| (tokens[0].Equals("番号", StringComparison.CurrentCultureIgnoreCase)))
					{
						if (tmpl != null)
						{
							output.PrintWarning("番号が二重に定義されました", position, 1);
							continue;
						}
						if (!Int64.TryParse(tokens[1].TrimEnd(), out index))
						{
							output.PrintWarning(tokens[1] + "を整数値に変換できません", position, 1);
							continue;
						}
						tmpl = new CharacterTemplate(index, this);
                        string no = eReader.Filename.ToUpper();
                        no = no.Substring(no.IndexOf("CHARA"), 5);
                        StringBuilder sb = new StringBuilder();
                        StringStream ss = new StringStream(no);
                        while (!ss.EOS && char.IsNumber(ss.Current))
                        {
                            sb.Append(ss.Current);
                            ss.ShiftNext();
                        }
                        if (sb.Length > 0)
                            tmpl.csvNo = Convert.ToInt64(sb.ToString());
                        else
                            tmpl.csvNo = index;
						CharacterTmplList.Add(tmpl);
						continue;
					}
					if (tmpl == null)
					{
						output.PrintWarning("番号が定義される前に他のデータが始まりました", position, 1);
						continue;
					}
					toCharacterTemplate(gamebase, position, tmpl, tokens);
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					output.PrintWarning("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Dispose();
			}
		}

		private bool tryToInt64(string str, out Int64 p)
		{
			p = -1;
			if (string.IsNullOrEmpty(str))
				return false;
			StringStream st = new StringStream(str);
            if (TokenReader.GetNextTokenType(st) != TokenType.Numeric)
            {
                //符号付きの値が渡されてる可能性があるので、それを判定
                if (st.Current != '+' && st.Current != '-')
                    return false;
            }
			try
			{
				p = (TokenReader.ReadInt64(st, false)).Int;
			}
			catch
			{
				return false;
			}
			return true;
		}

		private void toCharacterTemplate(GameBase gamebase, ScriptPosition position, CharacterTemplate chara, string[] tokens)
		{
			if (chara == null)
				return;
			Int64 p1 = -1;
			Int64 p2 = -1;
			Int64[] intArray = null;
			string[] strArray = null;
			string[] namearray = null;
			switch (tokens[0].ToUpper())
			{
				case "NAME":
				case "名前":
					chara.Name = tokens[1];
					return;
				case "CALLNAME":
				case "呼び名":
					chara.Callname = tokens[1];
					return;
				case "NICKNAME":
				case "あだ名":
					chara.Nickname = tokens[1];
					return;
				case "MASTERNAME":
				case "主人の呼び方":
					chara.Mastername = tokens[1];
					return;
				case "MARK":
				case "刻印":
					intArray = chara.Mark;
					namearray = MarkName;
					break;
				case "EXP":
				case "経験":
					intArray = chara.Exp;
					namearray = ExpName;
					break;
				case "ABL":
				case "能力":
					intArray = chara.Abl;
					namearray = AblName;
					break;
				case "BASE":
				case "基礎":
					intArray = chara.Maxbase;
					namearray = BaseName;
					break;
				case "TALENT":
				case "素質":
					intArray = chara.Talent;
					namearray = TalentName;
					break;
				case "RELATION":
				case "相性":
					intArray = chara.Relation;
					namearray = null;
					break;
				case "CFLAG":
				case "フラグ":
					intArray = chara.CFlag;
					namearray = CFlagName;
					break;
                case "EQUIP":
                case "装着物":
                    intArray = chara.Equip;
                    namearray = EquipName;
                    break;
                case "JUEL":
                case "珠":
                    intArray = chara.Juel;
                    namearray = ParamName;
                    break;
				case "CSTR":
					strArray = chara.CStr;
					namearray = CStrName;
					break;
				default:
					output.PrintWarning("\"" + tokens[0] + "\"は解釈できない識別子です", position, 1);
					return;
			}
			int length = -1;
			if(intArray != null)
				length = intArray.Length;
			else if(strArray != null)
				length = strArray.Length;
			if (length < 0)
			{
				output.PrintWarning("プログラムミス", position, 3);
				return;
			}
			bool p1isNumeric = tryToInt64(tokens[1].TrimEnd(), out p1);
			if ((!p1isNumeric) && (namearray != null))
				p1 = ((IList<string>)namearray).IndexOf(tokens[1]);

			if ((p1 < 0) || (p1 >= length))
			{
				if (p1isNumeric)
					output.PrintWarning(p1.ToString() + "は配列の範囲外です", position, 1);
				else if (tokens[1].Length == 0)
					output.PrintWarning("二つ目の識別子がありません", position, 1);
				else
					output.PrintWarning("\"" + tokens[1] + "\"は解釈できない識別子です", position, 1);
				return;
			}
			if (strArray != null)
			{
				if (tokens.Length < 3)
					output.PrintWarning("三つ目の識別子がありません", position, 1);
				strArray[p1] = tokens[2];
			}
			else
			{
				if ((tokens.Length < 3) || !tryToInt64(tokens[2], out p2))
					p2 = 1;
                intArray[p1] = p2;
			}
		}


		private void loadDataTo(string csvPath, string[] target, Int64[] targetI)
		{

			if (!File.Exists(csvPath))
				return;
			if (target == null)
				return;

			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
				output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;

            if (Config.Instance.DisplayReport || Program.AnalysisMode)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//前方のホワイトスペース読み捨て
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					string[] tokens = line.Split(',');
					if (tokens.Length < 2)
					{
						output.PrintWarning("\",\"が必要です", position, 1);
						continue;
					}
					int index = 0;
					if (!Int32.TryParse(tokens[0], out index))
					{
						output.PrintWarning("一つ目の値を整数値に変換できません", position, 1);
						continue;
					}
					if ((index < 0) || (target.Length <= index))
					{
						output.PrintWarning(index.ToString() + "は配列の範囲外です", position, 1);
						continue;
					}
					target[index] = tokens[1];
					if ((targetI != null) && (tokens.Length >= 3))
					{
						Int64 price;

						if (!Int64.TryParse(tokens[2].TrimEnd(), out price))
						{
							output.PrintWarning("金額が読み取れません", position, 1);
							continue;
						}

						targetI[index] = price;
					}
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					output.PrintWarning("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Close();
			}


		}
	}

	internal sealed class CharacterTemplate
	{
		public CharacterTemplate(Int64 index, ConstantData constant)
		{
			int[] arraySize = constant.CharacterIntArrayLength;
			No = index;
			Abl = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)]];
			Mark = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)]];
			Exp = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)]];
			Talent = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)]];
			Relation = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.RELATION)]];
			CFlag = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)]];
            Equip = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)]];
            Juel = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)]];
			int baseSize = arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MAXBASE)];
			baseSize = Math.Min(baseSize, arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)]);
			Maxbase = new Int64[baseSize];

			CStr = new string[
					constant.CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)]
				];

		}
        public int ArrayLength(CharacterIntData type)
        {
            switch (type)
            {
                case CharacterIntData.BASE:
                    return Maxbase.Length;
                case CharacterIntData.MARK:
                    return Mark.Length;
                case CharacterIntData.ABL:
                    return Abl.Length;
                case CharacterIntData.EXP:
                    return Exp.Length;
                case CharacterIntData.RELATION:
                    return Relation.Length;
                case CharacterIntData.TALENT:
                    return Talent.Length;
                case CharacterIntData.CFLAG:
                    return CFlag.Length;
                case CharacterIntData.EQUIP:
                    return Equip.Length;
                case CharacterIntData.JUEL:
                    return Juel.Length;
                default:
                    throw new CodeEE("存在しないキーを参照しました");
            }
        }

        public int cstrArrayLength()
        {
            return CStr.Length;
        }

		public string Name;
		public string Callname;
		public string Nickname;
		public string Mastername;
		public readonly Int64 No;
		public readonly Int64[] Maxbase;
		public readonly Int64[] Mark;
		public readonly Int64[] Exp;
		public readonly Int64[] Abl;
		public readonly Int64[] Talent;
		public readonly Int64[] Relation;
		public readonly Int64[] CFlag;
        public readonly Int64[] Equip;
        public readonly Int64[] Juel;
		public readonly string[] CStr;
        public Int64 csvNo;
	}
}
