using System;
using System.Collections.Generic;
using System.Collections;
using System.IO;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameProc;
using MinorShift._Library;

namespace MinorShift.Emuera.GameData.Variable
{
	internal sealed class FixedVariablePointer
	{
		public VariableIdentifier ID;
		public Int64 Index1;
		public Int64 Index2;
        public Int64 Index3;
		public override string ToString()
		{
			if (ID == null)
				return base.ToString();
            if (!ID.IsArray3D)
                return string.Format("{0}:{1}:{2}", ID, Index1, Index2);
            else
                return string.Format("{0}:{1}:{2}:{3}", ID, Index1, Index2, Index3);
		}
	}

	internal sealed class VariableEvaluator : IDisposable
	{
		readonly GameBase gamebase;
		readonly ConstantData constant;
		//readonly SysnonymManager synonym = new SysnonymManager();
		readonly VariableData varData;
		readonly List<CharacterData> characterList;
		//Random rand = new Random();
		MTRandom rand = new MTRandom();
		internal GameBase Gamebase { get { return gamebase; } }
		internal ConstantData Constant { get { return constant; } }
		string scope = "";
		internal string Scope { set { scope = value; } }
		public VariableEvaluator(GameBase gamebase, ConstantData constant)
		{
			this.gamebase = gamebase;
			this.constant = constant;
			varData = new VariableData(gamebase, constant);
			characterList = new List<CharacterData>();
		}
		#region set/get

		private void throwOutOfRangeException(FixedVariablePointer p)
		{
			checkElement(p);
			throw new ExeEE("配列外参照があったがEmueraは原因を特定できなかった");
		}

		private void checkElement(FixedVariablePointer p)
		{
			if (p.ID.IsCalc)
				return;
			if (p.ID.IsCharacterData)
			{
				if ((p.Index1 < 0) || (p.Index1 >= characterList.Count))
					throw new CodeEE("キャラクタ配列変数" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")はキャラ登録番号の範囲外です");
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
				{
					if (p.ID.IsInteger)
					{
						Int64[] dataList = chara.DataIntegerArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							throw new CodeEE("キャラクタ配列変数" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
					}
					else
					{
						string[] dataList = chara.DataStringArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							throw new CodeEE("キャラクタ配列変数" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
					}
				}
			}
            else if (p.ID.IsArray3D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[,,] dataList = varData.DataIntegerArray3D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
                    if ((p.Index3 < 0) || (p.Index3 >= dataList.GetLength(2)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第３引数(" + p.Index3.ToString() + ")は配列の範囲外です");
                }
                else
                {
                    string[, ,] dataList = varData.DataStringArray3D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
                    if ((p.Index3 < 0) || (p.Index3 >= dataList.GetLength(2)))
                        throw new CodeEE("三次元配列" + p.ID.ToString() + "の第３引数(" + p.Index3.ToString() + ")は配列の範囲外です");
                }
            }
            else if (p.ID.IsArray2D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[,] dataList = varData.DataIntegerArray2D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("二次元配列" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("二次元配列" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
                }
                else
                {
                    string[,] dataList = varData.DataStringArray2D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("二次元配列" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("二次元配列" + p.ID.ToString() + "の第２引数(" + p.Index2.ToString() + ")は配列の範囲外です");
                }
            }
            else if (p.ID.IsArray1D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[] dataList = varData.DataIntegerArray[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
                        throw new CodeEE("配列変数" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                }
                else
                {
                    string[] dataList = varData.DataStringArray[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
                        throw new CodeEE("配列変数" + p.ID.ToString() + "の第１引数(" + p.Index1.ToString() + ")は配列の範囲外です");
                }
            }
		}

        public void isArrayRangeValid(FixedVariablePointer p, Int64 index1, Int64 index2, string funcName, Int64 i1, Int64 i2)
        {
            checkElement(p);

            if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                if (p.ID.IsInteger)
                {
                    Int64[] dataList = chara.DataIntegerArray[p.ID.CodeInt];
                    if (index1 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                    if (index2 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                }
                else
                {
                    string[] dataList = chara.DataStringArray[p.ID.CodeInt];
                    if (index1 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                    if (index2 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                }
            }
            else if (p.ID.IsArray3D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[, ,] dataList = varData.DataIntegerArray3D[p.ID.CodeInt];
                    if (index1 > dataList.GetLength(2))
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + ":" + p.Index2.ToString() + "の範囲外です");
                    if (index2 > dataList.GetLength(2))
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + ":" + p.Index2.ToString() + "の範囲外です");
                }
                else
                {
                    string[, ,] dataList = varData.DataStringArray3D[p.ID.CodeInt];
                    if (index1 > dataList.GetLength(2))
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + ":" + p.Index2.ToString() + "の範囲外です");
                    if (index2 > dataList.GetLength(2))
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + ":" + p.Index2.ToString() + "の範囲外です");

                }
            }
            else if (p.ID.IsArray2D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[,] dataList = varData.DataIntegerArray2D[p.ID.CodeInt];
                    if (index1 > dataList.GetLength(1))
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + "の範囲外です");
                    if (index2 > dataList.GetLength(1))
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + "の範囲外です");
                }
                else
                {
                    string[,] dataList = varData.DataStringArray2D[p.ID.CodeInt];
                    if (index1 > dataList.GetLength(1))
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + "の範囲外です");
                    if (index2 > dataList.GetLength(1))
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + ":" + p.Index1.ToString() + "の範囲外です");
                }
            }
            else if (p.ID.IsArray1D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[] dataList = varData.DataIntegerArray[p.ID.CodeInt];
                    if (index1 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                    if (index2 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                }
                else
                {
                    string[] dataList = varData.DataStringArray[p.ID.CodeInt];
                    if (index1 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i1.ToString() + "引数(" + index1.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                    if (index2 > dataList.Length)
                        throw new CodeEE(funcName + "命令の第" + i2.ToString() + "引数(" + index2.ToString() + ")は配列" + p.ID.ToString() + "の範囲外です");
                }
            }
            return;
        }

		//1.60で完全に廃止。CheckConstElement群。
		//引数が定数である変数について、配列の範囲内かどうかロード時にチェックしようとしたが意外と困難が多かった。
		//private CharacterData createTestChara() { return new CharacterData(constant); }
		//public static void SetTestData(VariableEvaluator vEv)
		//{
		//    //testData = vEv.varData;
		//    //testChara = vEv.createTestChara();
		//}
		//static VariableData testData;
		//static CharacterData testChara;
		//public static bool CheckConstElement(FixedVariablePointer p)
		//{
		//    if (p.ID.IsCalc)
		//    {
		//        if (p.ID.Code == VariableCode.RAND)
		//            if (p.Index1 <= 0)
		//                return false;
		//        if (p.ID.Code == VariableCode.CHARANUM)
		//            return true;
		//        return true;
		//    }
		//    else if (p.ID.IsCharacterData)
		//    {
		//        if (p.ID.IsArray1D)
		//        {
		//            if (p.ID.IsInteger)
		//            {
		//                Int64[] dataList = testChara.DataIntegerArray[p.ID.CodeInt];
		//                if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
		//                    return false;
		//            }
		//        }
		//    }
		//    else if (p.ID.IsArray1D)
		//    {
		//        if (p.ID.IsInteger)
		//        {
		//            Int64[] dataList = testData.DataIntegerArray[p.ID.CodeInt];
		//            if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
		//                    return false;
		//        }
		//        else
		//        {
		//            string[] dataList = testData.DataStringArray[p.ID.CodeInt];
		//            if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
		//                    return false;
		//        }
		//    }
		//    return true;
		//}

		public void Randomize(Int64 seed)
		{
			rand = new MTRandom(seed);
		}

		public void InitRanddata()
		{
			rand.SetRand(this.RANDDATA);
		}

		public void DumpRanddata()
		{
			rand.GetRand(this.RANDDATA);
		}
		public Int64 GetNextRand(Int64 max)
		{
			return rand.NextInt64(max);
		}


		public Int64 GetInteger(FixedVariablePointer p)
		{
			try
			{
				return m_GetInteger(p);
			}
			catch(IndexOutOfRangeException)
			{//C#には複数種類の例外をまとめて捕まえる方法がない？
				throwOutOfRangeException(p);
			}
			catch (ArgumentOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
			return 0;
		}

		private Int64 m_GetInteger(FixedVariablePointer p)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("整数型でない変数" + p.ID.ToString() + "を整数型として呼び出しました");
			//checkElement(p);
			if (p.ID.IsCalc)
			{
				switch (p.ID.Code)
				{
					case VariableCode.RAND:
						if (Config.Instance.CompatiRAND)
						{
							if (p.Index1 == 0)//RAND:0は常に0
								return 0;
							long i = Math.Abs(p.Index1);//引数が負の値なら絶対値に直す
							return GetNextRand(32768) % i;//0-32767の乱数を引数で除算した余り
						}
						else
						{
							if (p.Index1 <= 0)
								throw new CodeEE("RANDの引数に0以下の値(" + p.Index1.ToString() + ")が指定されました");
							//if (p.Index1 > Int32.MaxValue)
							//    throw new CodeEE("RANDの引数に大きすぎる値(" + p.Index1.ToString() + ")が指定されました");

							return GetNextRand(p.Index1);
						}

					case VariableCode.CHARANUM:
						return characterList.Count;
					case VariableCode.GAMEBASE_GAMECODE: return gamebase.ScriptUniqueCode;
					case VariableCode.GAMEBASE_VERSION: return gamebase.ScriptVersion;
					case VariableCode.GAMEBASE_ALLOWVERSION: return gamebase.ScriptCompatibleMinVersion;
					case VariableCode.GAMEBASE_DEFAULTCHARA: return gamebase.DefaultCharacter;
					case VariableCode.GAMEBASE_NOITEM: return gamebase.DefaultNoItem;
					case VariableCode.LASTLOAD_NO: return varData.LastLoadNo;
					case VariableCode.LASTLOAD_VERSION: return varData.LastLoadVersion;
					case VariableCode.__LINE__:
						{
							if (!Program.DebugMode)
								return 0;
							ScriptPosition pos = Process.Instance.GetRunningPosition();
							if (pos == null)
								return -1;
							return pos.LineNo;
						}
					default:
						throw new ExeEE("未定義の変数" + p.ID.ToString());
				}
			}
			else if (p.ID.IsLocal)
			{
				if (p.ID.Code == VariableCode.LOCAL)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.LocalVars.GetValue(varScope, p.Index1);
				}
				if (p.ID.Code == VariableCode.ARG)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.ArgVars.GetValue(varScope, p.Index1);
				}
				throw new ExeEE("未定義の変数" + p.ID.ToString());
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					return chara.DataIntegerArray[p.ID.CodeInt][p.Index2];
				else
					return chara.DataInteger[p.ID.CodeInt];
			}
            else if (p.ID.IsArray3D)
                return varData.DataIntegerArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3];
            else if (p.ID.IsArray2D)
				return varData.DataIntegerArray2D[p.ID.CodeInt][p.Index1, p.Index2];
			else if (p.ID.IsArray1D)
				return varData.DataIntegerArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataInteger[p.ID.CodeInt];
		}

        public Int64 getPalamLv(FixedVariablePointer p, Int64 maxlv)
        {
            Int64 pl = GetInteger(p);
            for (int i = 0; i < (int)maxlv; i++)
            {
                if (pl < varData.DataIntegerArray[(int)(VariableCode.PALAMLV & VariableCode.__LOWERCASE__)][i + 1])
                    return i;
            }
            return maxlv;
        }

        public Int64 getExpLv(FixedVariablePointer p, Int64 maxlv)
        {
            Int64 pl = GetInteger(p);
            for (int i = 0; i < (int)maxlv; i++)
            {
                if (pl < varData.DataIntegerArray[(int)(VariableCode.EXPLV & VariableCode.__LOWERCASE__)][i + 1])
                    return i;
            }
            return maxlv;
        }

        public string GetString(FixedVariablePointer p)
		{
			try
			{
				string ret = m_GetString(p);
				if (ret == null)
					return "";
				return ret;
			}
			catch(IndexOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
			catch (ArgumentOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
			return "";
		}

		private string m_GetString(FixedVariablePointer p)
		{
			if (!p.ID.IsString)
				throw new CodeEE("文字列型でない変数" + p.ID.ToString() + "を文字列型として呼び出しました");
			if (p.ID.IsCalc)
			{
				string[] array = null;
				switch (p.ID.Code)
				{
					case VariableCode.ABLNAME:
						array = constant.AblName;
						break;
					case VariableCode.TALENTNAME:
						array = constant.TalentName;
						break;
					case VariableCode.EXPNAME:
						array = constant.ExpName;
						break;
					case VariableCode.MARKNAME:
						array = constant.MarkName;
						break;
					case VariableCode.PALAMNAME:
						array = constant.ParamName;
						break;
					case VariableCode.ITEMNAME:
						array = constant.ItemName;
						break;
					case VariableCode.TRAINNAME:
						array = constant.TrainName;
						break;
					case VariableCode.BASENAME:
						array = constant.BaseName;
						break;
					case VariableCode.SOURCENAME:
						array = constant.SourceName;
						break;
					case VariableCode.EXNAME:
						array = constant.ExName;
						break;
					case VariableCode.EQUIPNAME:
						array = constant.EquipName;
						break;
					case VariableCode.TEQUIPNAME:
						array = constant.TequipName;
						break;
					case VariableCode.FLAGNAME:
						array = constant.FlagName;
						break;
					case VariableCode.TFLAGNAME:
						array = constant.TFlagName;
						break;
					case VariableCode.CFLAGNAME:
						array = constant.CFlagName;
						break;
                    case VariableCode.TCVARNAME:
                        array = constant.TCVarName;
                        break;
                    case VariableCode.CSTRNAME:
                        array = constant.CStrName;
                        break;
					case VariableCode.GAMEBASE_AUTHER: return gamebase.ScriptAutherName;
					case VariableCode.GAMEBASE_AUTHOR: return gamebase.ScriptAutherName;
					case VariableCode.GAMEBASE_INFO: return gamebase.ScriptDetail;
					case VariableCode.GAMEBASE_TITLE: return gamebase.ScriptTitle;
					case VariableCode.GAMEBASE_YEAR: return gamebase.ScriptYear;
					case VariableCode.LASTLOAD_TEXT: return varData.LastLoadText;
					case VariableCode.WINDOW_TITLE: return Process.Instance.Console.GetWindowTitle();
					case VariableCode.__FUNCTION__:
						{
							if (!Program.DebugMode)
								return "";
							return scope;
						}
					case VariableCode.__FILE__:
						{
							if (!Program.DebugMode)
								return "";
							ScriptPosition pos = Process.Instance.GetRunningPosition();
							if (pos == null)
								return "";
							return pos.Filename;
						}
				}
				if (array == null)
					throw new ExeEE(p.ID.Code.ToString() + "がIsCalcの文字列型として指定された");
				if ((p.Index1 < 0) || (p.Index1 >= array.Length))
					return null;
				return array[p.Index1];
			}
			//checkElement(p);
			if (p.ID.IsLocal)
			{
				if (p.ID.Code == VariableCode.LOCALS)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.LocalString.GetValue(varScope, p.Index1);
				}
				else if (p.ID.Code == VariableCode.ARGS)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.ArgString.GetValue(varScope, p.Index1);
				}
				throw new ExeEE("未定義のローカル変数");
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					return chara.DataStringArray[p.ID.CodeInt][p.Index2];
				else
					return chara.DataString[p.ID.CodeInt];
			}
            else if (p.ID.IsArray3D)
                return varData.DataStringArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3];
            else if (p.ID.IsArray2D)
				return varData.DataStringArray2D[p.ID.CodeInt][p.Index1, p.Index2];
			else if (p.ID.IsArray1D)
				return varData.DataStringArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataString[p.ID.CodeInt];
		}

		public void SetValueAll(FixedVariablePointer p, Int64 srcValue, int start, int end)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("整数型でない変数" + p.ID.ToString() + "に整数値を代入しようとしました");
			if (p.ID.Readonly)
				throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
			if (p.ID.IsCalc)
				throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");

            checkElement(p);
            isArrayRangeValid(p, (Int64)start, (Int64)end, "VARSET", 3L, 4L);
			long[] array = null;
			if (p.ID.Code == VariableCode.LOCAL)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.LocalVars.GetVarList(varScope);
			}
			else if (p.ID.Code == VariableCode.ARG)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.ArgVars.GetVarList(varScope);
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					array = chara.DataIntegerArray[p.ID.CodeInt];
				else
				{
					chara.DataInteger[p.ID.CodeInt] = srcValue;
					return;
				}
			}
			else if (p.ID.IsArray1D)
				array = varData.DataIntegerArray[p.ID.CodeInt];
			else if (p.ID.IsArray3D)
			{
				long[,,] a3 = varData.DataIntegerArray3D[p.ID.CodeInt];
				for (int x = 0; x < a3.GetLength(0); x++)
					for (int y = 0; y < a3.GetLength(1); y++)
						for (int z = 0; z < a3.GetLength(2); z++)
							a3[x,y,z] = srcValue;
				return;
			}
			else if (p.ID.IsArray2D)
			{
				long[, ] a2 = varData.DataIntegerArray2D[p.ID.CodeInt];
				for (int x = 0; x < a2.GetLength(0); x++)
					for (int y = 0; y < a2.GetLength(1); y++)
							a2[x, y] = srcValue;
				return;
			}
			else
			{
				varData.DataInteger[p.ID.CodeInt] = srcValue;
				return;
			}
			for (int i = start; i < end; i++)
				array[i] = srcValue;
		}

        public void SetValueAll(FixedVariablePointer p, string srcValue, int start, int end)
		{
			if (!p.ID.IsString)
				throw new CodeEE("文字列型でない変数" + p.ID.ToString() + "に文字列型を代入しようとしました");
			if (p.ID.Readonly)
				throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
			if (p.ID.IsCalc)
			{
				if (p.ID.Code == VariableCode.WINDOW_TITLE)
				{
					Process.Instance.Console.SetWindowTitle(srcValue);
					return;
				}
				throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");
			}
			checkElement(p);
            isArrayRangeValid(p, (Int64)start, (Int64)end, "VARSET", 3L, 4L);
            string[] array = null;
			if (p.ID.Code == VariableCode.LOCALS)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.LocalString.GetVarList(varScope);
			}
			else if (p.ID.Code == VariableCode.ARGS)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.ArgString.GetVarList(varScope);
			}
            else if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];

                if (p.ID.IsArray1D)
                    array = chara.DataStringArray[p.ID.CodeInt];
                else
                {
                    chara.DataString[p.ID.CodeInt] = srcValue;
                    return;
                }
            }
            else if (p.ID.IsArray1D)
                array = varData.DataStringArray[p.ID.CodeInt];
            else if (p.ID.IsArray3D)
            {
                string[, ,] a3 = varData.DataStringArray3D[p.ID.CodeInt];
                for (int x = 0; x < a3.GetLength(0); x++)
                    for (int y = 0; y < a3.GetLength(1); y++)
                        for (int z = 0; z < a3.GetLength(2); z++)
                            a3[x, y, z] = srcValue;
                return;
            }
            else if (p.ID.IsArray2D)
            {
                string[,] a2 = varData.DataStringArray2D[p.ID.CodeInt];
                for (int x = 0; x < a2.GetLength(0); x++)
                    for (int y = 0; y < a2.GetLength(1); y++)
                        a2[x, y] = srcValue;
                return;
            }
            else
            {
                varData.DataString[p.ID.CodeInt] = srcValue;
                return;
            }
			for (int i = start; i < end; i++)
				array[i] = srcValue;
		}

        public void SetValueAllEachChara(FixedVariablePointer p, SingleTerm index, Int64 srcValue, int start, int end)
        {
            if (!p.ID.IsInteger)
                throw new CodeEE("整数型でない変数" + p.ID.ToString() + "に整数値を代入しようとしました");
            if (p.ID.Readonly)
                throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
            if (p.ID.IsCalc)
                throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");
            if (characterList.Count == 0)
                return;

            CharacterData chara = characterList[0];
            Int64 indexNum = -1;

            if (p.ID.IsArray1D)
            {
                if (index.GetOperandType() == typeof(Int64))
                    indexNum = index.Int;
                else
                    indexNum = constant.KeywordToInteger(p.ID.Code, index.Str);
                long[] array = chara.DataIntegerArray[p.ID.CodeInt];
                if (indexNum < 0 || indexNum >= array.Length)
                    throw new CodeEE("キャラクタ配列変数" + p.ID.ToString() + "の第２引数(" + indexNum.ToString() + ")は配列の範囲外です");
            }

            for (int i = start; i < end; i++)
            {
                chara = characterList[i];
                if (p.ID.IsArray1D)
                    chara.DataIntegerArray[p.ID.CodeInt][indexNum] = srcValue;
                else
                    chara.DataInteger[p.ID.CodeInt] = srcValue;
            }
        }

        public void SetValueAllEachChara(FixedVariablePointer p, SingleTerm index, string srcValue, int start, int end)
        {
            if (!p.ID.IsString)
                throw new CodeEE("文字列型でない変数" + p.ID.ToString() + "に文字列型を代入しようとしました");
            if (p.ID.Readonly)
                throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
            if (p.ID.IsCalc)
            {
                if (p.ID.Code == VariableCode.WINDOW_TITLE)
                {
                    Process.Instance.Console.SetWindowTitle(srcValue);
                    return;
                }
                throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");
            }
            if (characterList.Count == 0)
                return;

            CharacterData chara = characterList[0];
            Int64 indexNum = -1;

            if (p.ID.IsArray1D)
            {
                if (index.GetOperandType() == typeof(Int64))
                    indexNum = index.Int;
                else
                    indexNum = constant.KeywordToInteger(p.ID.Code, index.Str);
                string[]  array = chara.DataStringArray[p.ID.CodeInt];
                if (indexNum < 0 || indexNum >= array.Length)
                    throw new CodeEE("キャラクタ配列変数" + p.ID.ToString() + "の第２引数(" + indexNum.ToString() + ")は配列の範囲外です");
            }

            for (int i = start; i < end; i++)
            {
                chara = characterList[i];
                if (p.ID.IsArray1D)
                    chara.DataStringArray[p.ID.CodeInt][indexNum] = srcValue;
                else
                    chara.DataString[p.ID.CodeInt] = srcValue;
            }
        }

		public void SetValue(FixedVariablePointer p, Int64 srcValue)
		{
			try
			{
				m_SetValue(p, srcValue);
			}
			catch (IndexOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
			catch (ArgumentOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
		}

		public void SetValue(FixedVariablePointer p, string srcValue)
		{
			try
			{
				m_SetValue(p, srcValue);
			}
			catch (IndexOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
			catch (ArgumentOutOfRangeException)
			{
				throwOutOfRangeException(p);
			}
		}

		private void m_SetValue(FixedVariablePointer p, Int64 srcValue)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("整数型でない変数" + p.ID.ToString() + "に整数値を代入しようとしました");
			if (p.ID.Readonly)
				throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
			if (p.ID.IsCalc)
			{
				throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");
			}
			//checkElement(p);

			if (p.ID.Code == VariableCode.LOCAL)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				varData.LocalVars.SetValue(varScope, p.Index1, srcValue);
			}
            else if (p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.ArgVars.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					chara.DataIntegerArray[p.ID.CodeInt][p.Index2] = srcValue;
				else
					chara.DataInteger[p.ID.CodeInt] = srcValue;

			}
            else if (p.ID.IsArray3D)
                varData.DataIntegerArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3] = srcValue;
            else if (p.ID.IsArray2D)
				varData.DataIntegerArray2D[p.ID.CodeInt][p.Index1, p.Index2] = srcValue;
			else if (p.ID.IsArray1D)
				varData.DataIntegerArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataInteger[p.ID.CodeInt] = srcValue;
		}

		private void m_SetValue(FixedVariablePointer p, string srcValue)
		{
			if (!p.ID.IsString)
				throw new CodeEE("文字列型でない変数" + p.ID.ToString() + "に文字列型を代入しようとしました");
			if (p.ID.Readonly)
				throw new CodeEE("読み取り専用の変数" + p.ID.ToString() + "に代入しようとしました");
			if (p.ID.IsCalc)
			{
				if (p.ID.Code == VariableCode.WINDOW_TITLE)
				{
					Process.Instance.Console.SetWindowTitle(srcValue);
					return;
				}
				throw new ExeEE("READONLYでないCALC変数の代入処理が設定されていない");
			}
			//checkElement(p);
            if (p.ID.Code == VariableCode.LOCALS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.LocalString.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.Code == VariableCode.ARGS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.ArgString.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					chara.DataStringArray[p.ID.CodeInt][p.Index2] = srcValue;
				else
					chara.DataString[p.ID.CodeInt] = srcValue;
			}
            else if (p.ID.IsArray3D)
                varData.DataStringArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3] = srcValue;
            else if (p.ID.IsArray2D)
				varData.DataStringArray2D[p.ID.CodeInt][p.Index1, p.Index2] = srcValue;
			else if (p.ID.IsArray1D)
				varData.DataStringArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataString[p.ID.CodeInt] = srcValue;
		}

        public Int64 GetArraySum(FixedVariablePointer p, Int64 index1, Int64 index2)
        {
            Int64 sum = 0;

            if (p.ID.Code == VariableCode.LOCAL || p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                Int64[] dataArray = null;
                if (p.ID.Code == VariableCode.LOCAL)
                    dataArray = varData.LocalVars.GetVarList(varScope);
                else
                    dataArray = varData.ArgVars.GetVarList(varScope);
                if (index1 == -1)
                    index1 = 0;
                if (index2 == -1)
                    index2 = dataArray.Length;
                for (int i = (int)index1; i < (int)index2; i++)
                    sum += dataArray[i];
            }
            else if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                Int64[] dataArray = chara.DataIntegerArray[p.ID.CodeInt];
                if (index1 == -1)
                    index1 = 0;
                if (index2 == -1)
                    index2 = dataArray.Length;
                for (int i = (int)index1; i < (int)index2; i++)
                    sum += dataArray[i];
            }
            else
            {
                if (p.ID.IsArray1D)
                {
                    Int64[] dataArray = varData.DataIntegerArray[p.ID.CodeInt];
                    if (index1 == -1)
                        index1 = 0;
                    if (index2 == -1)
                        index2 = dataArray.Length;
                    for (int i = (int)index1; i < (int)index2; i++)
                        sum += dataArray[i];
                }
                else if (p.ID.IsArray2D)
                {
                    Int64[,] dataArray = varData.DataIntegerArray2D[p.ID.CodeInt];
                    if (index1 == -1)
                        index1 = 0;
                    if (index2 == -1)
                        index2 = dataArray.GetLength(1);
                    for (int i = (int)index1; i < (int)index2; i++)
                        sum += dataArray[p.Index1, i];
                }
                else
                {
                    Int64[, ,] dataArray = varData.DataIntegerArray3D[p.ID.CodeInt];
                    if (index1 == -1)
                        index1 = 0;
                    if (index2 == -1)
                        index2 = dataArray.GetLength(2);
                    for (int i = (int)index1; i < (int)index2; i++)
                        sum += dataArray[p.Index1, p.Index2, i];
                }
            }

            return sum;
        }

        public Int64 GetArraySumChara(FixedVariablePointer p, Int64 index1, Int64 index2)
        {
            Int64 sum = 0;

            if (index1 == -1)
                index1 = 0;
            if (index2 == -1)
                index2 = characterList.Count;
            CharacterData chara;
            if (p.ID.IsArray1D)
            {
                Int64[] dataArray;
                for (int i = (int)index1; i < (int)index2; i++)
                {
                    chara = characterList[i];
                    dataArray = chara.DataIntegerArray[p.ID.CodeInt];
                    sum += dataArray[p.Index2];
                }
            }
            else
            {
                for (int i = (int)index1; i < (int)index2; i++)
                {
                    chara = characterList[i];
                    sum += chara.DataInteger[p.ID.CodeInt];
                }
            }
            return sum;
        }

        public Int64 GetMatch(FixedVariablePointer p, Int64 target, Int64 start, Int64 end)
        {
            Int64[] array;
            if (p.ID.Code == VariableCode.LOCAL || p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                if (p.ID.Code == VariableCode.LOCAL)
                    array = varData.LocalVars.GetVarList(varScope);
                else
                    array = varData.ArgVars.GetVarList(varScope);
            }
            else if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                array = chara.DataIntegerArray[p.ID.CodeInt];
            }
            else
                 array = varData.DataIntegerArray[p.ID.CodeInt];
            Int64 ret = 0;

            if (start == -1)
                start = 0;
            if (end == -1)
                end = array.Length;

            for (int i = (int)start; i < (int)end; i++)
                if (array[i] == target)
                    ret++;

            return ret;
        }

        public Int64 GetMatch(FixedVariablePointer p, string target, Int64 start, Int64 end)
        {
            string[] array;
            if (p.ID.Code == VariableCode.LOCALS || p.ID.Code == VariableCode.ARGS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                if (p.ID.Code == VariableCode.LOCALS)
                    array = varData.LocalString.GetVarList(varScope);
                else
                    array = varData.ArgString.GetVarList(varScope);
            }
            else if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                array = chara.DataStringArray[p.ID.CodeInt];
            }
            else
                array = varData.DataStringArray[p.ID.CodeInt]; 
            Int64 ret = 0;

            if (start == -1)
                start = 0;
            if (end == -1)
                end = array.Length;

            for (int i = (int)start; i < (int)end; i++)
                if (array[i] == target)
                    ret++;

            return ret;
        }

        public Int64 GetMatchChara(FixedVariablePointer p, Int64 target, Int64 start, Int64 end)
        {
            Int64[] array;
            CharacterData chara;
            Int64 ret = 0;

            if (start == -1)
                start = 0;
            if (end == -1)
                end = characterList.Count;

            if (p.ID.IsArray1D)
            {
                for (int i = (int)start; i < (int)end; i++)
                {
                    chara = characterList[i];
                    array = chara.DataIntegerArray[p.ID.CodeInt];
                    if (array[p.Index2] == target)
                        ret++;
                }
            }
            else
            {
                for (int i = (int)start; i < (int)end; i++)
                {
                    chara = characterList[i];
                    if (chara.DataInteger[p.ID.CodeInt] == target)
                        ret++;
                }            
            }
            return ret;
        }

        public Int64 GetMatchChara(FixedVariablePointer p, string target, Int64 start, Int64 end)
        {
            string[] array;
            CharacterData chara;
            Int64 ret = 0;

            if (start == -1)
                start = 0;
            if (end == -1)
                end = characterList.Count;

            if (p.ID.IsArray1D)
            {
                for (int i = (int)start; i < (int)end; i++)
                {
                    chara = characterList[i];
                    array = chara.DataStringArray[p.ID.CodeInt];
                    if (array[p.Index2] == target)
                        ret++;
                }
            }
            else
            {
                for (int i = (int)start; i < (int)end; i++)
                {
                    chara = characterList[i];
                    if (chara.DataString[p.ID.CodeInt] == target)
                        ret++;
                }
            }
            return ret;
        }

        public Int64 GetMaxArray(FixedVariablePointer p, Int64 start, Int64 end, bool isMax)
        {
            Int64[] array;
            if (p.ID.Code == VariableCode.LOCAL || p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                if (p.ID.Code == VariableCode.LOCAL)
                    array = varData.LocalVars.GetVarList(varScope);
                else
                    array = varData.ArgVars.GetVarList(varScope);
            }
            else if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                array = chara.DataIntegerArray[p.ID.CodeInt];
            }
            else
                array = varData.DataIntegerArray[p.ID.CodeInt];

            if (start == -1)
                start = 0;
            if (end == -1)
                end = array.Length;

            Int64 ret = array[start];
            for (int i = (int)start + 1; i < (int)end; i++)
            {
                if (isMax)
                {
                    if (array[i] > ret)
                        ret = array[i];
                }
                else
                {
                    if (array[i] < ret)
                        ret = array[i];
                }
            }
            return ret;
        }

        public Int64 GetMaxArrayChara(FixedVariablePointer p, Int64 start, Int64 end, bool isMax)
        {
            Int64[] array;
            CharacterData chara;

            if (start == -1)
                start = 0;
            if (end == -1)
                end = characterList.Count;

            Int64 ret;
            if (p.ID.IsArray1D)
            {
                ret = characterList[(int)start].DataIntegerArray[p.ID.CodeInt][p.Index2];
                for (int i = (int)start + 1; i < (int)end; i++)
                {
                    chara = characterList[i];
                    array = chara.DataIntegerArray[p.ID.CodeInt];
                    if (isMax)
                    {
                        if (array[p.Index2] > ret)
                            ret = array[p.Index2];
                    }
                    else
                    {
                        if (array[p.Index2] < ret)
                            ret = array[p.Index2];
                    }
                }
            }
            else
            {
                ret = characterList[(int)start].DataInteger[p.ID.CodeInt];
                for (int i = (int)start + 1; i < (int)end; i++)
                {
                    chara = characterList[i];
                    if (isMax)
                    {
                        if (chara.DataInteger[p.ID.CodeInt] > ret)
                            ret = chara.DataInteger[p.ID.CodeInt];
                    }
                    else
                    {
                        if (chara.DataInteger[p.ID.CodeInt] < ret)
                            ret = chara.DataInteger[p.ID.CodeInt];
                    }
                }            
            }
            return ret;
        }

        public void ShiftArray(FixedVariablePointer p, int shift, Int64 def, int start, int num)
        {
            Int64[] array;
            if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                array = chara.DataIntegerArray[p.ID.CodeInt];
            }
            else if (p.ID.Code == VariableCode.LOCAL || p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                if (p.ID.Code == VariableCode.LOCAL)
                    array = varData.LocalVars.GetVarList(varScope);
                else
                    array = varData.ArgVars.GetVarList(varScope);
            }
            else
            {
                array = varData.DataIntegerArray[p.ID.CodeInt];
            }

            if (start >= array.Length)
                throw new CodeEE("命令ARRAYREMOVEの第４引数(" + start.ToString() + ")が配列" + p.ID.Code.ToString() + "の範囲を超えています");

             if (num == -1)
                num = array.Length - start;
            if ((start + num) > array.Length)
                num = array.Length - start;

            if (Math.Abs(shift) >= array.Length && start == 0 && num >= array.Length)
            {
                for (int i = 0; i < array.Length; i++)
                    array[i] = def;
                return;
            }
            
            Int64[] temp = new Int64[(int)array.Length];
            array.CopyTo(temp, 0);
            for (int i = 0; i < array.Length; i++)
                array[i] = 0;

            int sourceStart = start;
            int destStart = start + shift;
            int length = num - Math.Abs(shift);
            if (destStart < start)
            {
                sourceStart = start - shift;
                destStart = start;
            }

            if (destStart > start)
            {
                if (destStart < (start + num))
                    for (int i = start; i < destStart; i++)
                        array[i] = def;
                else
                    for (int i = start; i < (start + num); i++)
                        array[i] = def;
            }
            else
            {
                if (length > 0)
                    for (int i = (start + length); i < (start + num); i++)
                        array[i] = def;
                else
                    for (int i = start; i < (start + num); i++)
                        array[i] = def;
            }

            if (start > 0)
                Array.Copy(temp, 0, array, 0, start);

            if (length > 0)
                Array.Copy(temp, sourceStart, array, destStart, length);

            if ((start + num) < array.Length)
                Array.Copy(temp, (start + num), array, (start + num), array.Length - (start + num));
        }

        public void ShiftArray(FixedVariablePointer p, int shift, string def, int start, int num)
        {
            string[] arrays;
            if (p.ID.IsCharacterData)
            {
                CharacterData chara = characterList[(int)p.Index1];
                arrays = chara.DataStringArray[p.ID.CodeInt];
            }
            else if (p.ID.Code == VariableCode.LOCALS || p.ID.Code == VariableCode.ARGS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                if (p.ID.Code == VariableCode.LOCALS)
                    arrays = varData.LocalString.GetVarList(varScope);
                else
                    arrays = varData.ArgString.GetVarList(varScope);
            }
            else
            {
                arrays = varData.DataStringArray[p.ID.CodeInt];
            }

            if (start >= arrays.Length)
                throw new CodeEE("命令ARRAYREMOVEの第４引数(" + start.ToString() + ")が配列" + p.ID.Code.ToString() + "の範囲を超えています");

            if (Math.Abs(shift) >= arrays.Length && start == 0 && num >= arrays.Length)
            {
                for (int i = 0; i < arrays.Length; i++)
                    arrays[i] = def;
                return;
            }

            string[] temps = new string[(int)arrays.Length];
            arrays.CopyTo(temps, 0);
            for (int i = 0; i < arrays.Length; i++)
                arrays[i] = "";

            if (num == -1)
                num = arrays.Length - start;
            if ((start + num) > arrays.Length)
                num = arrays.Length - start;

            if (start > 0)
                Array.Copy(temps, 0, arrays, 0, start);
            
            int sourceStart = start;
            int destStart = start + shift;
            int length = num - Math.Abs(shift);
            if (destStart < start)
            {
                sourceStart = start - shift;
                destStart = start;
            }

            if (destStart > start)
            {
                if (destStart < (start + num))
                    for (int i = start; i < destStart; i++)
                        arrays[i] = def;
                else
                    for (int i = start; i < (start + num); i++)
                        arrays[i] = def;
            }
            else
            {
                if (length > 0)
                    for (int i = (start + length); i < (start + num); i++)
                        arrays[i] = def;
                else
                    for (int i = start; i < (start + num); i++)
                        arrays[i] = def;
            }

            if (length > 0)
                Array.Copy(temps, sourceStart, arrays, destStart, length);
            if ((start + num) < arrays.Length)
                Array.Copy(temps, (start + num), arrays, (start + num), arrays.Length - (start + num));
        }

        public void RemoveArray(FixedVariablePointer p, int start, int num)
        {
            if (p.ID.IsInteger)
            {
                Int64[] array;
                if (p.ID.IsCharacterData)
                {
                    CharacterData chara = characterList[(int)p.Index1];
                    array = chara.DataIntegerArray[p.ID.CodeInt];
                }
                else if (p.ID.Code == VariableCode.LOCAL || p.ID.Code == VariableCode.ARG)
                {
                    string varScope = p.ID.Scope;
                    if (varScope == null)
                        varScope = this.scope;
                    if (p.ID.Code == VariableCode.LOCAL)
                        array = varData.LocalVars.GetVarList(varScope);
                    else
                        array = varData.ArgVars.GetVarList(varScope);
                }
                else
                {
                    array = varData.DataIntegerArray[p.ID.CodeInt];
                }
                if (start >= array.Length)
                    throw new CodeEE("命令ARRAYREMOVEの第１引数(" + start.ToString() + ")が配列" + p.ID.Code.ToString() + "の範囲を超えています");
                if (num <= 0)
                    num = array.Length;
                Int64[] temp = new Int64[(int)array.Length];
                array.CopyTo(temp, 0);
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
                if (start > 0)
                    Array.Copy(temp, 0, array, 0, start);
                if ((start + num) < array.Length)
                    Array.Copy(temp, (start + num), array, start, (array.Length - (start + num)));
            }
            else
            {
                string[] arrays;
                if (p.ID.IsCharacterData)
                {
                    CharacterData chara = characterList[(int)p.Index1];
                    arrays = chara.DataStringArray[p.ID.CodeInt];
                }
                else if (p.ID.Code == VariableCode.LOCALS || p.ID.Code == VariableCode.ARGS)
                {
                    string varScope = p.ID.Scope;
                    if (varScope == null)
                        varScope = this.scope;
                    if (p.ID.Code == VariableCode.LOCALS)
                        arrays = varData.LocalString.GetVarList(varScope);
                    else
                        arrays = varData.ArgString.GetVarList(varScope);
                }
                else
                {
                    arrays = varData.DataStringArray[p.ID.CodeInt];
                }
                if (num <= 0)
                    num = arrays.Length;
                string[] temps = new string[(int)arrays.Length];
                arrays.CopyTo(temps, 0);
                for (int i = 0; i < arrays.Length; i++)
                    arrays[i] = "";
                if (start > 0)
                    Array.Copy(temps, 0, arrays, 0, start);
                if ((start + num) < arrays.Length)
                    Array.Copy(temps, (start + num), arrays, start, (arrays.Length - (start + num)));
            }
        }

		public string GetTrainComString(int trainCode, int comNo)
        {
			string trainName = constant.TrainName[trainCode];
			return string.Format("{0}[{1,3}]", trainName, comNo);
		}


		public string GetHavingItemsString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEM];
			string[] itemnames = this.ITEMNAME;
			int count = 0;
			StringBuilder builder = new StringBuilder();
			builder.Append("所持アイテム：");
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] == 0)
					continue;
				if (i >= itemnames.Length)
					break;
				count++;
				if (itemnames[i] != null)
					builder.Append(itemnames[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(") ");
			}
			if (count == 0)
				builder.Append("なし");
			return builder.ToString();
		}

		public string GetItemSalesString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEMSALES];
			StringBuilder builder = new StringBuilder();
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] != 0)
					continue;
				builder.Append(constant.ItemName[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(")");
			}
			return builder.ToString();
		}

		public string GetCharacterDataString(Int64 target, BuiltInFunctionCode func)
		{
			StringBuilder builder = new StringBuilder();
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("存在しない登録キャラクタを参照しようとしました");
			CharacterData chara = characterList[(int)target];
			Int64[] array = null;
			int i = 0;
			switch (func)
			{
				case BuiltInFunctionCode.PRINT_ABL:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ABL];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.AblName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.AblName[i]))
							continue;
						builder.Append(constant.AblName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");

					}
					break;
				case BuiltInFunctionCode.PRINT_TALENT:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TALENT];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.TalentName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.TalentName[i]))
							continue;
						builder.Append("[");
						builder.Append(constant.TalentName[i]);
						builder.Append("]");
					}
					break;
				case BuiltInFunctionCode.PRINT_MARK:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MARK];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.MarkName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.MarkName[i]))
							continue;
						builder.Append(constant.MarkName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				case BuiltInFunctionCode.PRINT_EXP:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXP];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.ExpName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.ExpName[i]))
							continue;
						builder.Append(constant.ExpName[i]);
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				default:
					throw new ExeEE("未定義の関数");
			}
			return builder.ToString();
		}

		public string GetCharacterParamString(Int64 target, int paramCode)
		{
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("存在しない登録キャラクタを参照しようとしました");
			if ((paramCode < 0) || (paramCode >= constant.ParamName.Length))
				throw new ExeEE("存在しない名称を取得しようとした");
			CharacterData chara = characterList[(int)target];
			Int64 param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)][paramCode];
			Int64[] paramlv = varData.DataIntegerArray[(int)(VariableCode.PALAMLV & VariableCode.__LOWERCASE__)];
			string paramName = constant.ParamName[paramCode];
			if ((param == 0) && (string.IsNullOrEmpty(paramName)))
				return null;
			if (paramName == null)
				paramName = "";
			char c = '-';
			Int64 border = paramlv[1];
			if (param >= border)
			{
				c = '=';
				border = paramlv[2];
			}
			if (param >= border)
			{
				c = '>';
				border = paramlv[3];
			}
			if (param >= border)
			{
				c = '*';
				border = paramlv[4];
			}
			StringBuilder bar = new StringBuilder();
			bar.Append('[');
			if ((border <= 0) || (border <= param))
				bar.Append(c, 10);
			else if (param <= 0)
				bar.Append('.', 10);
			else
			{
				unchecked
				{
					int count = (int)(param * 10 / border);
					bar.Append(c, count);
					bar.Append('.', 10 - count);
				}
			}
			bar.Append(']');
			return string.Format("{0}{1}{2,6}", paramName, bar.ToString(), ToKmgtString(param));

		}

		public void AddCharacter(Int64 charaTmplNo, bool isSp)
		{
			CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
			if (tmpl == null)
				throw new CodeEE("定義していないキャラクタを作成しようとしました");
			CharacterData chara = new CharacterData(constant, tmpl);
			characterList.Add(chara);
		}

        public void AddCharacterFromCsvNo(Int64 CsvNo)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplateFromCsvNo(CsvNo);
            if (tmpl == null)
                //throw new CodeEE("定義していないキャラクタを作成しようとしました");
                tmpl = constant.GetPseudoChara();
            CharacterData chara = new CharacterData(constant, tmpl);
            characterList.Add(chara);
        }

        public void AddPseudoCharacter()
        {
            CharacterTemplate tmpl = constant.GetPseudoChara();
            CharacterData chara = new CharacterData(constant, tmpl);
            characterList.Add(chara);
        }
        
        public void DelCharacter(Int64 charaNo)
		{
			if ((charaNo < 0) || (charaNo >= characterList.Count))
				throw new CodeEE("存在しない登録キャラクタを削除しようとしました");
			characterList[(int)charaNo].Dispose();
			characterList.RemoveAt((int)charaNo);
		}

		public void DelAllCharacter()
		{
			if (characterList.Count == 0)
				return;
			foreach (CharacterData chara in characterList)
				chara.Dispose();
			characterList.Clear();
		}

        public void PickUpChara(Int64[] NoList)
        {
            List<Int64> pickList = new List<long>();
            Int64 oldTarget = this.TARGET;
            Int64 oldAssi = this.ASSI;
            Int64 oldMaster = this.MASTER;
            this.TARGET = -1;
            this.ASSI = -1;
            this.MASTER = -1;
            //同じキャラが複数出てこないようにリストを整理
            for (int i = 0; i < NoList.Length; i++)
            {
                if (!pickList.Contains(NoList[i]) && NoList[i] >= 0)
                    pickList.Add(NoList[i]);
            }
            for (int i = 0; i < pickList.Count; i++)
            {
                if (i != pickList[i])
                {
                    SwapChara(pickList[i], (Int64)i);
                    if (pickList.IndexOf((Int64)i) > i)
                        pickList[pickList.IndexOf((Int64)i)] = pickList[i];
                }
                if (this.TARGET < 0 && pickList[i] == oldTarget)
                    this.TARGET = i;
                if (this.ASSI < 0 && pickList[i] == oldAssi)
                    this.ASSI = i;
                if (this.MASTER < 0 && pickList[i] == oldMaster)
                    this.MASTER = i;
            }
            if (pickList.Count < characterList.Count)
            {
                for (int i = (characterList.Count - 1); i >= pickList.Count; i--)
                    DelCharacter((Int64)i);
            }
        }

        public void ResetData()
		{
			//グローバルは初期化しない方が都合がよい。
			//varData.SetDefalutGlobalValue();
			varData.SetDefalutLocalValue();
			varData.SetDefalutValue(constant);
			foreach (CharacterData chara in characterList)
				chara.Dispose();
			characterList.Clear();
		}

		public void ResetGlobalData()
		{
			varData.SetDefalutGlobalValue();
		}

		public void SwapChara(Int64 x, Int64 y)
		{
			if (((x < 0) || (x >= characterList.Count)) || ((y < 0) || (y >= characterList.Count)))
				throw new CodeEE("存在しない登録キャラクタを入れ替えようとしました");
			if (x == y)
				return;
			CharacterData data = characterList[(int)y];
			characterList[(int)y] = characterList[(int)x];
			characterList[(int)x] = data;
		}

		public void SortChara(VariableIdentifier sortkey, Int64 elem, SortOrder sortorder,bool fixMaster)
		{
			if (characterList.Count <= 1)
				return;
            if (sortorder == SortOrder.UNDEF)
                sortorder = SortOrder.ASCENDING;
			if (sortkey == null)
				sortkey = VariableIdentifier.GetVariableId("NO");
			CharacterData masterChara = null;
			CharacterData targetChara = null;
			CharacterData assiChara = null;
			if (this.MASTER >= 0 && this.MASTER < characterList.Count)
				masterChara = characterList[(int)this.MASTER];
			if (this.TARGET >= 0 && this.TARGET < characterList.Count)
				targetChara = characterList[(int)this.TARGET];
			if (this.ASSI >= 0 && this.ASSI < characterList.Count)
				assiChara = characterList[(int)this.ASSI];

			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].temp_CurrentOrder = i;
				characterList[i].SetSortKey(sortkey, elem);
			}
			if ((fixMaster) && (masterChara != null))
			{
				if (characterList.Count <= 2)
					return;
				characterList.Remove(masterChara);
			}
            if (sortorder == SortOrder.ASCENDING)
				characterList.Sort(CharacterData.AscCharacterComparison);
            else if (sortorder == SortOrder.DESENDING)
				characterList.Sort(CharacterData.DescCharacterComparison);
			else
				throw new ExeEE("ソート順序不明");

			if ((fixMaster) && (masterChara != null))
			{
				characterList.Insert((int)this.MASTER, masterChara);
			}
			for (int i = 0; i < characterList.Count; i++)
				characterList[i].temp_CurrentOrder = i;
			if ((masterChara != null) && (!fixMaster))
				this.MASTER = masterChara.temp_CurrentOrder;
			if (targetChara != null)
				this.TARGET = targetChara.temp_CurrentOrder;
			if (assiChara != null)
				this.ASSI = assiChara.temp_CurrentOrder;
		}


		internal Int64 FindChara(VariableIdentifier varID, Int64 elem, string word, Int64 startIndex)
		{
			if (characterList.Count <= startIndex)
				return -1;
			FixedVariablePointer fvp = new FixedVariablePointer();
			fvp.ID = varID;
			fvp.Index2 = elem;
			for (Int64 i = startIndex; i < characterList.Count; i++)
			{
				fvp.Index1 = i;
				if(word == GetString(fvp))
					return i;
			}
			return -1;
		}

		internal Int64 FindChara(VariableIdentifier varID, Int64 elem, Int64 word, Int64 startIndex)
		{
			if (characterList.Count <= startIndex)
				return -1;
			FixedVariablePointer fvp = new FixedVariablePointer();
			fvp.ID = varID;
			fvp.Index2 = elem;
			for (Int64 i = startIndex; i < characterList.Count; i++)
			{
				fvp.Index1 = i;
				if (word == GetInteger(fvp))
					return i;
			}
			return -1;
		}

		//1.54uまで
		//public Int64[] SortChara(bool flag, Int64 target, Int64 assi)
		//{
		//    Int64[] ret = new Int64[2];
		//    ret[0] = target;
		//    ret[1] = assi;
		//    if (characterList.Count <= 1)
		//        return ret;
		//    List<KeyValuePair<Int64, CharacterData>> keyset = new List<KeyValuePair<long, CharacterData>>(characterList.Count);
		//    for (int i = 1; i < characterList.Count; i++)
		//    {
		//        keyset.Add(new KeyValuePair<Int64, CharacterData>((Int64)i, characterList[i]));
		//    }
		//    if (flag)
		//    {
		//        keyset.Sort(delegate(KeyValuePair<Int64, CharacterData> x, KeyValuePair<Int64, CharacterData> y)
		//        {

		//            Int64 noA = x.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];
		//            Int64 noB = y.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];

		//            if (noA - noB != 0)
		//                return (int)(noA - noB);
		//            else
		//                return x.Key.CompareTo(y.Key);
		//        });
		//    }
		//    else
		//    {
		//        keyset.Sort(delegate(KeyValuePair<Int64, CharacterData> x, KeyValuePair<Int64, CharacterData> y)
		//        {
		//            Int64 noA = x.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];
		//            Int64 noB = y.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];

		//            if (noA - noB != 0)
		//                return (int)(noB - noA);
		//            else
		//                return x.Key.CompareTo(y.Key);
		//        });
		//    }
		//    for (int i = 1; i < characterList.Count; i++)
		//    {
		//        characterList[i] = keyset[i - 1].Value;
		//        if (keyset[i - 1].Key == target)
		//            ret[0] = i;
		//        else if (keyset[i - 1].Key == assi)
		//            ret[1] = i;
		//    }
		//    return ret;
		//}
        
        public Int64 GetChara(Int64 charaNo, bool getSp)
        {
		   //後天的にNOを変更する場合も考慮し、chara*.csvで定義されているかどうかは調べない。
			//CharacterTemplate tmpl = constant.GetCharacterTemplate(charaNo, false);
			//if (tmpl == null)
			//    return -1;
            int i;
            for (i = 0; i < characterList.Count; i++)
            {
				if (characterList[i].NO == charaNo)
				{
					bool isSp = characterList[i].CFlag[0] != 0;
					if(isSp == getSp)
	                    return (Int64)i;
				}
            }
            return -1;
        }

        public Int64 ExistCsv(Int64 charaNo, bool getSp)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaNo, getSp);
            if (tmpl == null)
                return 0;
            else
                return 1;
        }

        public string GetCharacterStrfromCSVData(Int64 charaTmplNo, CharacterStrData type, bool isSp, Int64 arg2)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
            if (tmpl == null)
                throw new CodeEE("定義していないキャラクタを参照しようとしました");
            switch (type)
            {
                case CharacterStrData.CALLNAME:
                    if (tmpl.Callname != null)
                        return tmpl.Callname;
                    else
                        return "";
                case CharacterStrData.NAME:
                    if (tmpl.Name != null)
                        return tmpl.Name;
                    else
                        return "";
                case CharacterStrData.NICKNAME:
                    if (tmpl.Nickname != null)
                        return tmpl.Nickname;
                    else
                        return "";
                case CharacterStrData.MASTERNAME:
                    if (tmpl.Mastername != null)
                        return tmpl.Mastername;
                    else
                        return "";
                case CharacterStrData.CSTR:
                    if (tmpl.CStr != null)
                    {
                        if (arg2 >= tmpl.cstrArrayLength() || arg2 < 0)
                            throw new CodeEE("CSTRの参照可能範囲外を参照しました");
                        if (tmpl.CStr[arg2] != null)
                            return tmpl.CStr[arg2];
                        else
                            return "";
                    }
                    else
                        return "";
                default:
                    throw new CodeEE("存在しないデータを参照しようとしました");
            }
        }

        public Int64 GetCharacterIntfromCSVData(Int64 charaTmplNo, CharacterIntData type, bool isSp, Int64 arg2)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
            if (tmpl == null)
                throw new CodeEE("定義していないキャラクタを参照しようとしました");
            if (arg2 >= tmpl.ArrayLength(type) || arg2 < 0)
                throw new CodeEE("参照可能範囲外を参照しました");
            switch (type)
            {
                case CharacterIntData.BASE:
                    return tmpl.Maxbase[arg2];
                case CharacterIntData.MARK:
                    return tmpl.Mark[arg2];
                case CharacterIntData.ABL:
                    return tmpl.Abl[arg2];
                case CharacterIntData.EXP:
                    return tmpl.Exp[arg2];
                case CharacterIntData.RELATION:
                    return tmpl.Relation[arg2];
                case CharacterIntData.TALENT:
                    return tmpl.Talent[arg2];
                case CharacterIntData.CFLAG:
                    return tmpl.CFlag[arg2];
                case CharacterIntData.EQUIP:
                    return tmpl.Equip[arg2];
                case CharacterIntData.JUEL:
                    return tmpl.Juel[arg2];
                default:
                    throw new CodeEE("存在しないデータを参照しようとしました");
            }
        }

        public void UpdateInBeginTrain()
		{
			ASSIPLAY = 0;
			PREVCOM = -1;
			NEXTCOM = -1;
			Int64[] array;
            string[] sarray;
			array = varData.DataIntegerArray[(int)(VariableCode.TFLAG & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
            sarray = varData.DataStringArray[(int)(VariableCode.TSTR & VariableCode.__LOWERCASE__)];
            for (int i = 0; i < sarray.Length; i++)
                sarray[i] = "";
			//本家の仕様にあわせ、選択中以外のキャラクタも全部リセット。
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.GOTJUEL & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.TEQUIP & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.EX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
                //STAINは関数に切り出す（RESET_STAIN対応のため）
                setDefaultStain(chara);
				array = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//1.728 このタイミングでSOURCEも更新されていた
				array = chara.DataIntegerArray[(int)(VariableCode.SOURCE & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//1.728 NOWEXはここでは更新されていない
                //1736f CTFLAGはTFLAGと同じ仕様で
                array = chara.DataIntegerArray[(int)(VariableCode.TCVAR & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
			}
		}

		public void UpdateAfterShowUsercom()
		{
			//UP = 0,DOWN = 0,LOSEBASE = 0
			Int64[] array;
			array = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.LOSEBASE & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
            foreach (CharacterData chara in characterList)
            {
                array = chara.DataIntegerArray[(int)(VariableCode.DOWNBASE & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
                array = chara.DataIntegerArray[(int)(VariableCode.CUP & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
                array = chara.DataIntegerArray[(int)(VariableCode.CDOWN & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
            }

            //SOURCEはリセットタイミングが違うので消し
			//1.728 NOWEXも微妙に違うので移動
		}

        //1.728 NOWEXもリセットタイミングが違うので移動
        //UP,DOWN,LOSEBASEはUSERCOMに移動する場合にもリセットされるがNOWEXはCOMが実行される場合のみ更新される
        //なのでEVENTCOM直前に呼ぶ
        public void UpdateAfterInputCom()
		{
			//本家の仕様にあわせ、選択中以外のキャラクタも全部リセット。
			Int64[] array;
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.NOWEX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
			}
		}

        //SOURCEのリセットタイミングはUP、DOWN、LOSEBASE、NOWEXと違いSOURCECHECK終了後なので切り分け
        public void UpdateAfterSourceCheck()
		{
			//本家の仕様にあわせ、選択中以外のキャラクタも全部リセット。
            Int64[] array;
            foreach (CharacterData chara in characterList)
            {
                array = chara.DataIntegerArray[(int)(VariableCode.SOURCE & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
            }
        }

		//PREVCOMは更新されない。スクリプトの方で更新する必要がある。
		//Data側からEmueraConsoleを操作するのはここだけ。
		public void UpdateInUpcheck(EmueraConsole window, bool skipPrint)
		{
            Int64[] up, down, param;
			up = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			down = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
            Int64 target = TARGET;
			if ((target < 0) || (target >= characterList.Count))
				goto end;
			CharacterData chara = characterList[(int)target];
			param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
			int length = param.Length;
			if (param.Length > up.Length)
				length = up.Length;
			if (param.Length > down.Length)
				length = down.Length;

			for (int i = 0; i < length; i++)
			{
				//本家の仕様では負の値は無効。
				if ((up[i] <= 0) && (down[i] <= 0))
					continue;
                StringBuilder builder = new StringBuilder();
                if (!skipPrint)
                {
                    builder.Append(constant.ParamName[i]);
                    builder.Append(' ');
                    builder.Append(ToKmgtString(param[i]));
                    if (up[i] > 0)
                    {
                        builder.Append('+');
                        builder.Append(ToKmgtString(up[i]));
                    }
                    if (down[i] > 0)
                    {
                        builder.Append('-');
                        builder.Append(ToKmgtString(down[i]));
                    }
                }
				unchecked { param[i] += up[i] - down[i]; }
                if (!skipPrint)
                {
                    builder.Append('=');
                    builder.Append(ToKmgtString(param[i]));
                    window.Print(builder.ToString());
                    window.NewLine();
                }

			}
		end:
			for (int i = 0; i < up.Length; i++)
				up[i] = 0;
			for (int i = 0; i < down.Length; i++)
				down[i] = 0;
        }

        public void CUpdateInUpcheck(EmueraConsole window, Int64 target, bool skipPrint)
        {
            Int64[] up, down, param;
            if ((target < 0) || (target >= characterList.Count))
                return;
            CharacterData chara = characterList[(int)target];
            up = chara.DataIntegerArray[(int)(VariableCode.CUP & VariableCode.__LOWERCASE__)];
            down = chara.DataIntegerArray[(int)(VariableCode.CDOWN & VariableCode.__LOWERCASE__)];
            param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
            int length = param.Length;
            if (param.Length > up.Length)
                length = up.Length;
            if (param.Length > down.Length)
                length = down.Length;

            for (int i = 0; i < length; i++)
            {
                //本家の仕様では負の値は無効。
                if ((up[i] <= 0) && (down[i] <= 0))
                    continue;
                StringBuilder builder = new StringBuilder();
                if (!skipPrint)
                {
                    builder.Append(constant.ParamName[i]);
                    builder.Append(' ');
                    builder.Append(ToKmgtString(param[i]));
                    if (up[i] > 0)
                    {
                        builder.Append('+');
                        builder.Append(ToKmgtString(up[i]));
                    }
                    if (down[i] > 0)
                    {
                        builder.Append('-');
                        builder.Append(ToKmgtString(down[i]));
                    }
                }
                unchecked { param[i] += up[i] - down[i]; }
                if (!skipPrint)
                {
                    builder.Append('=');
                    builder.Append(ToKmgtString(param[i]));
                    window.Print(builder.ToString());
                    window.NewLine();
                }
            }
            for (int i = 0; i < up.Length; i++)
                up[i] = 0;
            for (int i = 0; i < down.Length; i++)
                down[i] = 0;
        }

        private void setDefaultStain(CharacterData chara)
        {
            long[] array = chara.DataIntegerArray[(int)(VariableCode.STAIN & VariableCode.__LOWERCASE__)];
            for (int i = 0; i < array.Length; i++)
                array[i] = 0;
            //標準の汚れ
            //_Replace.csvでの変更に対応
            List<Int64> stain = Config.Instance.StainDefault;
            for (int i = 0; i < stain.Count; i++)
            {
                array[i] = stain[i];
            }
            //array[2] = 2;
            //array[3] = 1;
            //array[4] = 8;
        }

        public void setDefaultStain(Int64 no)
        {
            if (no < 0 || no >= characterList.Count)
                throw new CodeEE("存在しないキャラクターを参照しようとしました");
            CharacterData chara = characterList[(int)no];
            setDefaultStain(chara);
        }

		private static readonly string[] kMGT = { "", "k", "M", "G", "T", "P" };
		public static string ToKmgtString(Int64 integer)
		{
#if NOTUSE
			////TODO:
			////作っては見たがどうしよう。
			//ERBの方で対応したようなので廃棄。
			StringBuilder builer = new StringBuilder();
			if (integer < 0)
			{
				builer.Append('-');
				integer = -integer;
			}
			int i = 0;
			for (i = 0; i < kMGT.Length; i++)
			{
				if (integer < 100000)
					break;
				integer /= 1000;
			}
			builer.Append(integer.ToString());
			builer.Append(kMGT[i]);
			return builer.ToString();
#else
			return integer.ToString();
#endif
		}

		/// <summary>
		/// RESULTに配列のサイズを代入。二次元配列ならRESULT:1に二番目のサイズを代入。三次元配列ならRESULT:1に二番目、RESULT:2に三番目のサイズを代入
		/// </summary>
		/// <param name="varID"></param>
		/// <returns></returns>
		public void VarSize(VariableIdentifier varID)
		{
			if (varID.IsArray2D)
			{
				Int64 length64;
				Int64[] resultArray = varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)];
				if (varID.IsInteger)
				{
					length64 = constant.VariableIntArray2DLength[varID.CodeInt];
				}
				else
				{
					length64 = constant.VariableStrArray2DLength[varID.CodeInt];
				}
				resultArray[0] = length64 >> 32;
				resultArray[1] = length64 & 0xFFFFFFFF;
			}
            else if (varID.IsArray3D)
            {
                Int64 length64;
                Int64[] resultArray = varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)];
                if (varID.IsInteger)
                {
                    length64 = constant.VariableIntArray3DLength[varID.CodeInt];
                }
                else
                {
                    length64 = constant.VariableStrArray3DLength[varID.CodeInt];
                }
                resultArray[0] = (length64 >> 32) & 0xFFFF;
                resultArray[1] = (length64 >> 16) & 0xFFFF;
                resultArray[2] = length64 & 0xFFFF;
            }
            else
            {
                this.RESULT = GetVariableSize(varID);
            }
		}

		public Int64 GetVariableSize(VariableIdentifier varID)
		{
            if (varID.IsArray3D)
            {
                throw new CodeEE("3次元配列変数\"" + varID.Code.ToString() + "\"の長さを取得しようとしました");
            }
            if (varID.IsArray2D)
			{
				throw new CodeEE("2次元配列変数\"" + varID.Code.ToString() + "\"の長さを取得しようとしました");
			}
			if ((!varID.IsArray1D) || (varID.Code == VariableCode.RAND))
			{
				throw new CodeEE("非配列変数\"" + varID.Code.ToString() + "\"の長さを取得しようとしました");
			}
			if (varID.IsCalc)
			{
				switch (varID.Code)
				{
					//case CHARANUM:
					//case RAND:
					//case VariableCode.ITEMPRICE:
					//	return constant.ItemPrice.Length;
					case VariableCode.ABLNAME:
						return constant.AblName.Length;
					case VariableCode.TALENTNAME:
						return constant.TalentName.Length;
					case VariableCode.EXPNAME:
						return constant.ExpName.Length;
					case VariableCode.MARKNAME:
						return constant.MarkName.Length;
					case VariableCode.PALAMNAME:
						return constant.ParamName.Length;
					case VariableCode.ITEMNAME:
						return constant.ItemName.Length;
					case VariableCode.TRAINNAME:
						return constant.TrainName.Length;
					case VariableCode.BASENAME:
						return constant.BaseName.Length;
					case VariableCode.SOURCENAME:
						return constant.SourceName.Length;
					case VariableCode.EXNAME:
						return constant.ExName.Length;
                    case VariableCode.EQUIPNAME:
                        return constant.EquipName.Length;
                    case VariableCode.TEQUIPNAME:
                        return constant.TequipName.Length;
                    case VariableCode.FLAGNAME:
                        return constant.FlagName.Length;
                    case VariableCode.TFLAGNAME:
                        return constant.TFlagName.Length;
                    case VariableCode.CFLAGNAME:
                        return constant.CFlagName.Length;
                    case VariableCode.TCVARNAME:
                        return constant.TCVarName.Length;
                    case VariableCode.CSTRNAME:
                        return constant.CStrName.Length;
                    default:
						break;
				}
			}
			else if (varID.IsCharacterData)
			{
				if (varID.IsInteger)
					return constant.CharacterIntArrayLength[varID.CodeInt];
				else
					return constant.CharacterStrArrayLength[varID.CodeInt];
			}
            else if (varID.IsLocal)
            {
                string scope = varID.Scope;
                if (varID.Code == VariableCode.LOCAL)
                    return varData.LocalVars.Size;
                if (varID.Code == VariableCode.LOCALS)
                    return varData.LocalString.Size;
                if (varID.Code == VariableCode.ARG)
                    return varData.ArgVars.Size;
                if (varID.Code == VariableCode.ARGS)
                    return varData.ArgString.Size;
            }
            else
            {
                if (varID.IsInteger)
                    return constant.VariableIntArrayLength[varID.CodeInt];
                else
                    return constant.VariableStrArrayLength[varID.CodeInt];
            }
			throw new ExeEE("\"" + varID.Code.ToString() + "\"の長さ取得関数の異常");
		}

		public bool ItemSales(Int64 itemNo)
		{
			Int64[] itemSales = ITEMSALES;
			string[] itemNames = constant.ItemName;
			if ((itemNo < 0) || (itemNo >= itemSales.Length) || (itemNo >= itemNames.Length))
				return false;
			int index = (int)itemNo;
			return ((itemSales[index] != 0) && (itemNames[index] != null));
		}

		public bool BuyItem(Int64 itemNo)
		{

			if (!ItemSales(itemNo))
				return false;

			Int64[] itemPrice = constant.ItemPrice;
			if (itemNo >= itemPrice.Length)
				return false;
			int index = (int)itemNo;
			if (MONEY < itemPrice[index])
				return false;
			MONEY -= itemPrice[index];
			ITEM[index]++;
			BOUGHT = itemNo;
			return true;
		}

        public void setEncodingResult(byte[] bytes)
        {
            Int64[] resultArray = varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)];
            resultArray[0] = bytes.Length / 4;
            for (int i = 0; i < (bytes.Length / 4); i++)
            {
                resultArray[i+1] = (Int64)BitConverter.ToInt32(bytes, i * 4);
            }
        }

		#endregion

		//ちーと
		public void IamaMunchkin()
		{
			if ((MASTER < 0) || (MASTER >= characterList.Count))
				return;
            characterList[(int)MASTER].DataString[(int)(VariableCode.NAME & VariableCode.__LOWERCASE__)] = "イカサマ";
			characterList[(int)MASTER].DataString[(int)(VariableCode.CALLNAME & VariableCode.__LOWERCASE__)] = "イカサマ";
			characterList[(int)MASTER].DataString[(int)(VariableCode.NICKNAME & VariableCode.__LOWERCASE__)] = "イカサマ";

		}

		public void SetResultX(Int64 value, int index)
		{
			if (index >= varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)].Length)
				return;
			varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][index] = value;
		}

		#region File
		public void SaveToStream(EraDataWriter writer, string saveDataText)
		{
			writer.Write(gamebase.ScriptUniqueCode);
			writer.Write(gamebase.ScriptVersion);
			writer.Write(saveDataText);
			writer.Write(characterList.Count);
			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].SaveToStream(writer);
			}
			varData.SaveToStream(writer);
			writer.EmuStart();
			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].SaveToStreamExtended(writer);
			}
			varData.SaveToStreamExtended(writer);
		}

		public void LoadFromStream(EraDataReader reader, int dataIndex)
		{
			if (reader.ReadInt64() != gamebase.ScriptUniqueCode)
				throw new FileEE("異なるゲームのセーブデータです");
			Int64 version = reader.ReadInt64();
			if ( ((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000)) 
				&& (gamebase.ScriptCompatibleMinVersion > version))
				throw new FileEE("セーブデータのバーションが異なります");
			string text = reader.ReadString();//PUTFORM
			varData.SetDefalutValue(constant);
			varData.SetDefalutLocalValue();
			varData.LastLoadVersion = version;
			varData.LastLoadNo = dataIndex;
			varData.LastLoadText = text;

			int charaCount = (int)reader.ReadInt64();
			characterList.Clear();
			for (int i = 0; i < charaCount; i++)
			{
				CharacterData chara = new CharacterData(constant);
				characterList.Add(chara);
				chara.LoadFromStream(reader);
			}
			varData.LoadFromStream(reader);
			if (reader.SeekEmuStart())
			{

				for (int i = 0; i < charaCount; i++)
				{
					characterList[i].LoadFromStreamExtended(reader);
				}
				varData.LoadFromStreamExtended(reader);
			}
        }

		public void SaveGlobalToStream(EraDataWriter writer)
		{
			writer.Write(gamebase.ScriptUniqueCode);
			writer.Write(gamebase.ScriptVersion);
			varData.SaveGlobalToStream(writer);
		}

		public bool LoadGlobalFromStream(EraDataReader reader)
		{
			try
			{
				if (reader.ReadInt64() != gamebase.ScriptUniqueCode)
					return false;
				//	throw new FileEE("異なるゲームのセーブデータです");
				Int64 version = reader.ReadInt64();
				if (((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000))
					&& (gamebase.ScriptCompatibleMinVersion > version))
					return false;
				//	throw new FileEE("セーブデータのバーションが異なります");
				varData.LoadGlobalFromStream(reader);
				return true;
			}
			catch
			{
				return false;
			}
		}

        //これは理屈上VariableEvaluator上で動くはず
        public EraDataResult checkData(int saveIndex)
        {
			string filename = string.Format("{0}save{1:00}.sav", Config.Instance.SavDir, saveIndex);
            EraDataResult result = new EraDataResult();
            GameBase gb = gamebase;
            StreamReader stream = null;
            EraDataReader reader = null;
            try
            {
                if (!File.Exists(filename))
                {
                    result.State = EraDataState.FILENOTFOUND;
                    result.DataMes = "----";
                    return result;
                }
                stream = new StreamReader(filename, Config.Encode);
                reader = new EraDataReader(stream);
                if (reader.ReadInt64() != gb.ScriptUniqueCode)
                {
                    result.State = EraDataState.GAME_ERROR;
                    result.DataMes = "異なるゲームのセーブデータです";
                    return result;
                }
                Int64 version = reader.ReadInt64();
                if (((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000))
                    && (gamebase.ScriptCompatibleMinVersion > version))
                {
                    result.State = EraDataState.VIRSION_ERROR;
                    result.DataMes = "セーブデータのバーションが異なります";
                    return result;
                }
                result.State = EraDataState.OK;
                result.DataMes = reader.ReadString();
                return result;
            }
            catch (FileEE fee)
            {
                result.State = EraDataState.ETC_ERROR;
                result.DataMes = fee.Message;
            }
            catch (Exception)
            {
                result.State = EraDataState.ETC_ERROR;
                result.DataMes = "読み込み中にエラーが発生しました";
            }
            finally
            {
                if (reader != null)
                    reader.Close();
                else if (stream != null)
                    stream.Close();
            }
            return result;
        }

		#endregion
		#region IDisposable メンバ

		public void Dispose()
		{


			varData.Dispose();

			for (int i = 0; i < characterList.Count; i++)
				characterList[i].Dispose();
			characterList.Clear();
		}

		#endregion
		#region Property
		public Int64 RESULT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 COUNT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public string RESULTS
		{
			get
			{
				string ret = varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0];
				if (ret == null)
					return "";
				return ret;
			}
			set { varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 TARGET
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 MASTER
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSI
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSIPLAY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 PREVCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 SELECTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 NEXTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}

		public string[] ITEMNAME
		{
			get { return constant.ItemName; }
		}

		public Int64[] ITEMSALES
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEMSALES & VariableCode.__LOWERCASE__)]; }
		}

		public Int64[] ITEMPRICE
		{
			get { return constant.ItemPrice; }
		}

		private Int64[] ITEM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEM & VariableCode.__LOWERCASE__)]; }
		}

		public Int64[] RANDDATA
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.RANDDATA & VariableCode.__LOWERCASE__)]; }
		}

		private Int64 MONEY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0] = value; }
		}

		private Int64 BOUGHT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public string SAVEDATA_TEXT
		{
			get { return varData.DataString[(int)(VariableCode.SAVEDATA_TEXT & VariableCode.__LOWERCASE__)]; }
			set { varData.DataString[(int)(VariableCode.SAVEDATA_TEXT & VariableCode.__LOWERCASE__)] = value; }
		}
		#endregion

	}

	//public class ForwardSort : IComparer
	//{
	//    int IComparer.Compare(Object x, Object y)
	//    {
	//        CharacterData charaA = (CharacterData)x;
	//        CharacterData charaB = (CharacterData)y;
	//        return (int)(charaA.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO] - charaB.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO]);
	//    }
	//}

	//public class InverseSort : IComparer
	//{
	//    int IComparer.Compare(Object x, Object y)
	//    {
	//        CharacterData charaA = (CharacterData)x;
	//        CharacterData charaB = (CharacterData)y;
	//        return (int)(charaB.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO] - charaA.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO]);
	//    }
	//}
}
