using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Drawing;
using Microsoft.VisualBasic;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift._Library;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Function;

namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{
		private void runScriptProc()
		{
            while(true)
            {
                bool sequential = state.Sequential;
                state.ShfitNextLine();
                LogicalLine line = state.CurrentLine;
                vEvaluator.Scope = state.Scope;
                if (line == null)
                    throw new ExeEE("Emuera.exeは次に実行する行を見失いました");
                else if (line.IsError)
                    throw new CodeEE(line.ErrMes);
                else if (line is InstructionLine)
                {//1753 InstructionLineを先に持ってきてみる。わずかに速くなった気がしないでもない
                    InstructionLine func = (InstructionLine)line;
                    InstructionLine jumpTo = null;

					if (!Program.DebugMode && (func.Function & BuiltInFunctionCode.__DEBUG__) == BuiltInFunctionCode.__DEBUG__)
					{//非DebugモードでのDebug系命令。何もしない。（SIF文のためにコメント行扱いにはできない）
						continue;
					}
                    if (func.Argument == null)
                        LogicalLineParser.SetArgumentTo(func, null);
                    if (func.IsError)
                        throw new CodeEE(func.ErrMes);
                    BuiltInFunctionCode iFunc = func.Function;
                    if (!BuiltInFunctionManager.IsFlowContorol(iFunc))
                    {
                        #region fastPathNoramlFunction
                        if ((iFunc & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
                        {
                            FunctionArgument arg = (FunctionArgument)func.Argument;
                            Type type = arg.MethodTerm.GetOperandType();
                            if (arg.MethodTerm.GetOperandType() == typeof(Int64))
                                vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
                            else if (arg.MethodTerm.GetOperandType() == typeof(string))
                                vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
                            else
                                throw new ExeEE(func.Function.ToString() + "命令の型が不明");
                        }
                        else if (iFunc == BuiltInFunctionCode.SET)
                        {
                            SpSetArgument spsetarg = (SpSetArgument)func.Argument;
                            FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                            vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
                        }
                        else if (iFunc == BuiltInFunctionCode.SETS)
                        {
                            SpSetsArgument spsetsarg = (SpSetsArgument)func.Argument;
                            FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                            vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
                        }
                        #endregion
                        else
                            doNormalFunction(func);
                    }
                    else
                    {
                        #region fastPathFlowFunction
                        if (iFunc == BuiltInFunctionCode.SIF || iFunc == BuiltInFunctionCode.IF || iFunc == BuiltInFunctionCode.SELECTCASE
                            || iFunc == BuiltInFunctionCode.ELSEIF || iFunc == BuiltInFunctionCode.ELSE || iFunc == BuiltInFunctionCode.CASE
                            || iFunc == BuiltInFunctionCode.CASEELSE
                            || iFunc == BuiltInFunctionCode.ENDIF || iFunc == BuiltInFunctionCode.ENDSELECT || iFunc == BuiltInFunctionCode.ENDCATCH
                            || iFunc == BuiltInFunctionCode.ENDFUNC || iFunc == BuiltInFunctionCode.DO)
                        {
                            ExpressionArgument expArg = null;
                            if (iFunc == BuiltInFunctionCode.ELSE || iFunc == BuiltInFunctionCode.ELSEIF
                                || iFunc == BuiltInFunctionCode.CASE || iFunc == BuiltInFunctionCode.CASEELSE)
                            {
                                if (func.JumpTo == null)
                                    throw new ExeEE(func.Function.ToString() + "のジャンプ先が設定されていない");
                                state.JumpTo(func.JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.SIF)
                            {
                                expArg = (ExpressionArgument)func.Argument;
                                if (eEvaluator.GetInteger(expArg.Term) == 0)//評価式が真ならそのまま流れ落ちる
                                    state.ShfitNextLine();//偽なら一行とばす。順に来たときと同じ扱いにする
                            }
                            else if (iFunc == BuiltInFunctionCode.IF)
                            {
                                LogicalLine ifJumpto = null;
                                if (func.IfCaseList == null)
                                    throw new ExeEE("IFのIF-ELSEIFリストが適正に作成されていない");
                                if (func.JumpTo == null)
                                    throw new ExeEE("IFに対応するENDIFが設定されていない");

                                for (int i = 0; i < func.IfCaseList.Count; i++)
                                {
                                    if (func.IfCaseList[i].IsError)
                                        continue;
                                    if (func.IfCaseList[i].Function == BuiltInFunctionCode.ELSE)
                                    {
                                        ifJumpto = func.IfCaseList[i];
                                        break;
                                    }

                                    expArg = (ExpressionArgument)(func.IfCaseList[i].Argument);
                                    if (expArg == null)
                                        throw new ExeEE("IFチェック中。引数が解析されていない。", func.IfCaseList[i].Position);

                                    //1730 ELSEIFが出したエラーがIFのエラーとして検出されていた
                                    state.RunningLine = func.IfCaseList[i];
                                    if (eEvaluator.GetInteger(expArg.Term) != 0)//式が真
                                    {
                                        ifJumpto = func.IfCaseList[i];
                                        break;
                                    }
                                }
                                if (ifJumpto == null)
                                    ifJumpto = func.JumpTo;//ENDIF
                                if (ifJumpto != func)//自分自身がジャンプ先ならそのまま
                                    state.JumpTo(ifJumpto);
                                state.RunningLine = null;
                            }
                            else if (iFunc == BuiltInFunctionCode.SELECTCASE)
                            {
                                LogicalLine caseJumpto = null;
                                SingleTerm term = eEvaluator.GetValue(((ExpressionArgument)func.Argument).Term);
                                if (func.IfCaseList == null)
                                    throw new ExeEE("SELECTCASEのCASEリストが適正に作成されていない");
                                if (func.JumpTo == null)
                                    throw new ExeEE("SELECTCASEに対応するENDSELECTが設定されていない");
                                for (int i = 0; i < func.IfCaseList.Count; i++)
                                {
                                    if (func.IfCaseList[i].IsError)
                                        continue;
                                    if (func.IfCaseList[i].Function == BuiltInFunctionCode.CASEELSE)
                                    {
                                        caseJumpto = func.IfCaseList[i];
                                        break;
                                    }
                                    CaseArgument caseArg = (CaseArgument)(func.IfCaseList[i].Argument);
                                    if (caseArg == null)
                                        throw new ExeEE("CASEチェック中。引数が解析されていない。", func.IfCaseList[i].Position);

                                    //1730 CASEが出したエラーがSELECTCASEのエラーとして検出されていた
                                    state.RunningLine = func.IfCaseList[i];
									if (term.GetOperandType() == typeof(Int64))
									{
										Int64 Is = term.Int;
										foreach (CaseExpression caseExp in caseArg.CaseExps)
										{
											if (eEvaluator.GetCase(caseExp, Is))
											{
												caseJumpto = func.IfCaseList[i];
												goto casefound;
											}
										}
									}
									else
									{
										string Is = term.Str;
										foreach (CaseExpression caseExp in caseArg.CaseExps)
										{
											if (eEvaluator.GetCase(caseExp, Is))
											{
												caseJumpto = func.IfCaseList[i];
												goto casefound;
											}
										}
									}

                                }
                            casefound:
                                if (caseJumpto == null)
                                    caseJumpto = func.JumpTo;//ENDSELECT
                                state.JumpTo(caseJumpto);
                                state.RunningLine = null;
                            }
                        }
                        else if (iFunc == BuiltInFunctionCode.RETURN|| iFunc == BuiltInFunctionCode.RETURNFORM || iFunc == BuiltInFunctionCode.CONTINUE
                            || iFunc == BuiltInFunctionCode.RESTART|| iFunc == BuiltInFunctionCode.BREAK|| iFunc == BuiltInFunctionCode.REND
                            || iFunc == BuiltInFunctionCode.NEXT || iFunc == BuiltInFunctionCode.WEND || iFunc == BuiltInFunctionCode.LOOP)
                        {
                            if (iFunc == BuiltInFunctionCode.REND || iFunc == BuiltInFunctionCode.NEXT
                                || (iFunc == BuiltInFunctionCode.CONTINUE && ((((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.REPEAT) || ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.FOR)))
                            {
                                jumpTo = (InstructionLine)func.JumpTo;
                                //ループ変数が不明(REPEAT、FORを経由せずにループしようとした場合は無視してループを抜ける(eramakerがこういう仕様だったりする))
                                if (jumpTo.LoopCounter == null)
                                    state.JumpTo(jumpTo.JumpTo);
                                else
                                {
                                    unchecked
                                    {
                                        vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                                    }
                                    if (((jumpTo.LoopStep > 0) && (jumpTo.LoopEnd > vEvaluator.GetInteger(jumpTo.LoopCounter)))
                                        || ((jumpTo.LoopStep < 0) && (jumpTo.LoopEnd < vEvaluator.GetInteger(jumpTo.LoopCounter))))//まだ回数が残っているなら、
                                        state.JumpTo(func.JumpTo);
                                    else if (func.Function == BuiltInFunctionCode.CONTINUE)
                                        state.JumpTo(jumpTo.JumpTo);
                                }
                            }
                            else if (iFunc == BuiltInFunctionCode.WEND || (iFunc == BuiltInFunctionCode.CONTINUE && ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.WHILE))
                            {
                                jumpTo = (InstructionLine)func.JumpTo;
                                if (eEvaluator.GetInteger(((ExpressionArgument)jumpTo.Argument).Term) != 0)
                                    state.JumpTo(func.JumpTo);
                                else if (func.Function == BuiltInFunctionCode.CONTINUE)
                                    state.JumpTo(jumpTo.JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.LOOP || (iFunc == BuiltInFunctionCode.CONTINUE && ((InstructionLine)func.JumpTo).Function == BuiltInFunctionCode.DO))
                            {
                                InstructionLine tFunc = func;
                                if (iFunc == BuiltInFunctionCode.CONTINUE)
                                    tFunc = (InstructionLine)((InstructionLine)func.JumpTo).JumpTo;
                                if (tFunc.Argument == null)
                                    LogicalLineParser.SetArgumentTo(tFunc, null);
                                ExpressionArgument expArg = (ExpressionArgument)tFunc.Argument;
                                if (eEvaluator.GetInteger(expArg.Term) != 0)//式が真
                                    state.JumpTo(tFunc.JumpTo);
                                else if (iFunc == BuiltInFunctionCode.CONTINUE)
                                    state.JumpTo((InstructionLine)((InstructionLine)func.JumpTo).JumpTo);
                            }
                            else if (iFunc == BuiltInFunctionCode.BREAK)
                            {
                                ////BREAKのJUMP先はRENDまたはNEXT。そのジャンプ先であるREPEATかFORをiLineに代入。
                                //1.723 仕様変更。BREAKのJUMP先にはREPEAT、FOR、WHILEを記憶する。そのJUMP先が本当のJUMP先。
                                jumpTo = (InstructionLine)func.JumpTo;
                                InstructionLine iLine = (InstructionLine)jumpTo.JumpTo;
                                //WHILEとDOはカウンタがないので、即ジャンプ
                                if (jumpTo.Function != BuiltInFunctionCode.WHILE && jumpTo.Function != BuiltInFunctionCode.DO)
                                {
                                    unchecked
                                    {//本家ではBREAK時にCOUNTが回る
                                        vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                                    }
                                }
                                state.JumpTo(iLine);
                            }
                            else if (iFunc == BuiltInFunctionCode.RESTART)
                                state.JumpTo(func.JumpTo);
							else if (iFunc == BuiltInFunctionCode.RETURN)
							{
								int termnum = 0;
								foreach (IOperandTerm term in ((ExpressionArrayArgument)func.Argument).TermList)
								{
									vEvaluator.SetResultX(eEvaluator.GetInteger(term), termnum);
									termnum++;
								}
								state.Return(vEvaluator.RESULT);
								if (state.GetCurrentReturnAddress is NullLine)
									return;
							}
							else if (iFunc == BuiltInFunctionCode.RETURNFORM)
							{
								int termnum = 0;
								foreach (IOperandTerm term in ((ExpressionArrayArgument)func.Argument).TermList)
								{
									string arg = eEvaluator.GetString(term);
									StringStream aSt = new StringStream(arg);
									vEvaluator.SetResultX(eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null)), termnum);
									termnum++;
								}
								state.Return(vEvaluator.RESULT);
								if (state.GetCurrentReturnAddress is NullLine)
									return;
							}
                        }
                        #endregion
                        else if (!doFlowControlFunction(func, sequential))
                            return;
                    }
                    //lineCount++;
                    //WinmmTimerから時間を取得するのはそれ自体結構なコストがかかるので10000行に一回くらいで。
                    if ((lineCount % 10000 == 0 || (lineCount - 1) % 10000 == 0) && Config.Instance.InfiniteLoopAlertTime > 0)
                        checkInfiniteLoop();
                    if (console.IsRunning && !state.ScriptEnd)
                        continue;
                    return;
                }
				else if (line is NullLine)
				{//ファイル終端
					if (!state.IsFunctionMethod)
						vEvaluator.RESULT = 0;
					state.Return(0);
					if (!(state.GetCurrentReturnAddress is NullLine))
						continue;
					return;
				}
				else if (line is FunctionLabelLine)
				{
					if (sequential)
					{//流れ落ちてきた（関数終端）
						if (!state.IsFunctionMethod)
							vEvaluator.RESULT = 0;
						state.Return(0);
						if (!(state.GetCurrentReturnAddress is NullLine))
							continue;
						return;
					}
					//1750 飛んできた直後にShiftNextが入るのでここが実行されることは無いはず
					else//CALLやJUMPで飛んできた
						return;
				}
				else if (line is GotoLabelLine)
					continue;//＄ラベル。何もすることはない。
                else if (line is InvalidLine)
                {
                    if (string.IsNullOrEmpty(line.ErrMes))
                        throw new CodeEE("読込に失敗した行が実行されました。エラーの詳細は読込時の警告を参照してください。");
                    else
                        throw new CodeEE(line.ErrMes);
                }
                else
                    throw new ExeEE("定義されていない種類の行です");
            }
		}

		public void DoDebugNormalFunction(InstructionLine line, bool munchkin)
		{
            if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
            {
                FunctionArgument arg = (FunctionArgument)line.Argument;
                Type type = arg.MethodTerm.GetOperandType();
                if (arg.MethodTerm.GetOperandType() == typeof(Int64))
                    vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
                else if (arg.MethodTerm.GetOperandType() == typeof(string))
                    vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
                else
                    throw new ExeEE(line.Function.ToString() + "命令の型が不明");
            }
            else if (line.Function == BuiltInFunctionCode.SET)
            {
                SpSetArgument spsetarg = (SpSetArgument)line.Argument;
                FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
            }
            else if (line.Function == BuiltInFunctionCode.SETS)
            {
                SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
                FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
            }
            else
                doNormalFunction(line);
			if (munchkin)
	            vEvaluator.IamaMunchkin();
        }

		#region normal
		void doNormalFunction(InstructionLine line)
		{
            //if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
            //{
            //    FunctionArgument arg = (FunctionArgument)line.Argument;
            //    Type type = arg.MethodTerm.GetOperandType();
            //    if (arg.MethodTerm.GetOperandType() == typeof(Int64))
            //        vEvaluator.RESULT = eEvaluator.GetInteger(arg.MethodTerm);
            //    else if (arg.MethodTerm.GetOperandType() == typeof(string))
            //        vEvaluator.RESULTS = eEvaluator.GetString(arg.MethodTerm);
            //    else
            //        throw new ExeEE(line.Function.ToString() + "命令の型が不明");
            //    return;
            //}
			string str = null;
			IOperandTerm term = null;
			switch (line.Function)
			{
                //case BuiltInFunctionCode.SET:
                //    {
                //        SpSetArgument spsetarg = (SpSetArgument)line.Argument;
                //        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                //        vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
                //    }
                //    break;
                //case BuiltInFunctionCode.SETS:
                //    {
                //        SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
                //        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
                //        vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
                //    }
                //    break;
				case BuiltInFunctionCode.PRINT://文字を表示する
                case BuiltInFunctionCode.PRINTD:
                case BuiltInFunctionCode.PRINTL://改行
                case BuiltInFunctionCode.PRINTDL:
				case BuiltInFunctionCode.PRINTW://入力待ち(実質改行)
                case BuiltInFunctionCode.PRINTDW:
				case BuiltInFunctionCode.PRINTSINGLE://強制一行
                case BuiltInFunctionCode.PRINTSINGLED:
				case BuiltInFunctionCode.PRINTS://文字列変数の内容
                case BuiltInFunctionCode.PRINTSD:
                case BuiltInFunctionCode.PRINTSL:
                case BuiltInFunctionCode.PRINTSDL:
				case BuiltInFunctionCode.PRINTSW:
                case BuiltInFunctionCode.PRINTSDW:
				case BuiltInFunctionCode.PRINTSINGLES:
                case BuiltInFunctionCode.PRINTSINGLESD:
				case BuiltInFunctionCode.PRINTFORM://{数式}、%文字列変数%などの書式が使える。
                case BuiltInFunctionCode.PRINTFORMD:
				case BuiltInFunctionCode.PRINTFORML:
                case BuiltInFunctionCode.PRINTFORMDL:
				case BuiltInFunctionCode.PRINTFORMW:
                case BuiltInFunctionCode.PRINTFORMDW:
				case BuiltInFunctionCode.PRINTSINGLEFORM:
                case BuiltInFunctionCode.PRINTSINGLEFORMD:
                case BuiltInFunctionCode.PRINTK:
                case BuiltInFunctionCode.PRINTKL:
                case BuiltInFunctionCode.PRINTKW:
                case BuiltInFunctionCode.PRINTSINGLEK:
                case BuiltInFunctionCode.PRINTSK:
                case BuiltInFunctionCode.PRINTSKL:
                case BuiltInFunctionCode.PRINTSKW:
                case BuiltInFunctionCode.PRINTSINGLESK:
                case BuiltInFunctionCode.PRINTFORMK:
                case BuiltInFunctionCode.PRINTFORMKL:
                case BuiltInFunctionCode.PRINTFORMKW:
                case BuiltInFunctionCode.PRINTSINGLEFORMK:
                    {
                        if (SkipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                            str = convertStringType(str);
                        outputToConsole(str, line.Function);
					}
					break;

				case BuiltInFunctionCode.PRINTV://変数の内容
                case BuiltInFunctionCode.PRINTVD:
				case BuiltInFunctionCode.PRINTVL:
                case BuiltInFunctionCode.PRINTVDL:
				case BuiltInFunctionCode.PRINTVW:
                case BuiltInFunctionCode.PRINTVDW:
				case BuiltInFunctionCode.PRINTSINGLEV:
                case BuiltInFunctionCode.PRINTSINGLEVD:
                case BuiltInFunctionCode.PRINTVK:
                case BuiltInFunctionCode.PRINTVKL:
                case BuiltInFunctionCode.PRINTVKW:
                case BuiltInFunctionCode.PRINTSINGLEVK:
					{
                        if (SkipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        StringBuilder builder = new StringBuilder();
						foreach (IOperandTerm termV in ((SpPrintVArgument)line.Argument).Terms)
						{
							if (termV.GetOperandType() == typeof(Int64))
								builder.Append(eEvaluator.GetInteger(termV).ToString());
							else
								builder.Append(((SingleTerm)termV).Str);
						}
						str = builder.ToString();
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                            str = convertStringType(str);
                        outputToConsole(str, line.Function);
                    }
					break;
				case BuiltInFunctionCode.PRINTFORMS://文字列変数の内容を変換して表示をします。
                case BuiltInFunctionCode.PRINTFORMSD:
				case BuiltInFunctionCode.PRINTFORMSL:
                case BuiltInFunctionCode.PRINTFORMSDL:
				case BuiltInFunctionCode.PRINTFORMSW:
                case BuiltInFunctionCode.PRINTFORMSDW:
				case BuiltInFunctionCode.PRINTSINGLEFORMS:
                case BuiltInFunctionCode.PRINTSINGLEFORMSD:
                case BuiltInFunctionCode.PRINTFORMSK:
                case BuiltInFunctionCode.PRINTFORMSKL:
                case BuiltInFunctionCode.PRINTFORMSKW:
                case BuiltInFunctionCode.PRINTSINGLEFORMSK:
					{
                        if (SkipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term).Replace("\\", "\\\\");
						StringForm strForm = new StringForm(str);
						str = strForm.GetString(eEvaluator);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                            str = convertStringType(str);
                        outputToConsole(str, line.Function);
                    }
					break;
				case BuiltInFunctionCode.PRINTC:
                case BuiltInFunctionCode.PRINTCD:
				case BuiltInFunctionCode.PRINTLC:
                case BuiltInFunctionCode.PRINTLCD:
				case BuiltInFunctionCode.PRINTFORMC:
                case BuiltInFunctionCode.PRINTFORMCD:
				case BuiltInFunctionCode.PRINTFORMLC:
                case BuiltInFunctionCode.PRINTFORMLCD:
                case BuiltInFunctionCode.PRINTCK:
                case BuiltInFunctionCode.PRINTLCK:
                case BuiltInFunctionCode.PRINTFORMCK:
                case BuiltInFunctionCode.PRINTFORMLCK:
					{
                        if (SkipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
                        if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                            str = convertStringType(str);
                        if ((line.Function == BuiltInFunctionCode.PRINTFORMC)
							||(line.Function == BuiltInFunctionCode.PRINTC)
                            ||(line.Function == BuiltInFunctionCode.PRINTCD)
                            ||(line.Function == BuiltInFunctionCode.PRINTFORMCD))
							console.PrintC(str, true);
						else
							console.PrintC(str, false);
                        console.UseUserStyle = true;
                    }
					break;
				case BuiltInFunctionCode.PRINTBUTTON://変数の内容
					{
                        if (SkipPrint)
                            break;
                        SpButtonArgument bArg = (SpButtonArgument)line.Argument;
						str = eEvaluator.GetString(bArg.PrintStrTerm);
                        //ボタン処理に絡んで表示がおかしくなるため、PRINTBUTTONでの改行コードはオミット
                        str = str.Replace("\n", "");
                        if (bArg.ButtonWord.GetOperandType() == typeof(long))
							console.PrintButton(str,  eEvaluator.GetInteger(bArg.ButtonWord));
						else
							console.PrintButton(str, eEvaluator.GetString(bArg.ButtonWord));
					}
					break;
                case BuiltInFunctionCode.PRINTBUTTONC://変数の内容
                case BuiltInFunctionCode.PRINTBUTTONLC:
                    {
                        if (SkipPrint)
                            break;
                        SpButtonArgument bArg = (SpButtonArgument)line.Argument;
                        str = eEvaluator.GetString(bArg.PrintStrTerm);
                        //ボタン処理に絡んで表示がおかしくなるため、PRINTBUTTONでの改行コードはオミット
                        str = str.Replace("\n", "");
                        bool isRight = (line.Function == BuiltInFunctionCode.PRINTBUTTONC) ? true : false;
                        if (bArg.ButtonWord.GetOperandType() == typeof(long))
                            console.PrintButtonC(str, eEvaluator.GetInteger(bArg.ButtonWord), isRight);
                        else
                            console.PrintButtonC(str, eEvaluator.GetString(bArg.ButtonWord), isRight);
                    }
                    break;
                case BuiltInFunctionCode.PRINTPLAIN:
                case BuiltInFunctionCode.PRINTPLAINFORM:
                    {
                        if (SkipPrint)
                            break;
                        term = ((ExpressionArgument)line.Argument).Term;
                        console.PrintPlain(eEvaluator.GetString(term));
                    }
                    break;
                case BuiltInFunctionCode.PRINTDATA:
                case BuiltInFunctionCode.PRINTDATAD:
                case BuiltInFunctionCode.PRINTDATAL:
                case BuiltInFunctionCode.PRINTDATADL:
                case BuiltInFunctionCode.PRINTDATAW:
                case BuiltInFunctionCode.PRINTDATADW:
                case BuiltInFunctionCode.PRINTDATAK:
                case BuiltInFunctionCode.PRINTDATAKL:
                case BuiltInFunctionCode.PRINTDATAKW:
                    {
                        if (SkipPrint)
                            break;
                        console.UseUserStyle = !BuiltInFunctionManager.IsPrintDFunction(line.Function);
                        int count = line.dataList.Count;
                        int choice = (int)vEvaluator.GetNextRand(count);
                        VariableToken iTerm = ((PrintDataArgument)line.Argument).Var;
                        if (iTerm != null)
                            vEvaluator.SetValue(eEvaluator.GetFixedVariable(iTerm), choice);
                        List<InstructionLine> iList = line.dataList[choice];
                        int i = 0;
                        foreach (InstructionLine selectedLine in iList)
                        {
							state.RunningLine = selectedLine;
							if (selectedLine.Argument == null)
								LogicalLineParser.SetArgumentTo(selectedLine, null);
                            term = ((ExpressionArgument)selectedLine.Argument).Term;
                            str = eEvaluator.GetString(term);
                            if (BuiltInFunctionManager.IsPrintKFunction(line.Function) && (forceHiragana | forceKatakana | halftoFull))
                                str = convertStringType(str);
                            console.Print(str);
                            if (++i < (int)iList.Count)
                                console.NewLine();
                        }
                        if (BuiltInFunctionManager.IsNewLine(line.Function) || BuiltInFunctionManager.IsWaitInput(line.Function))
                            console.NewLine();
                        if (BuiltInFunctionManager.IsWaitInput(line.Function))
                            console.ReadAnyKey();
                        console.UseUserStyle = true;
                        //ジャンプするが、流れが連続であることを保証。
                        state.JumpTo(line.JumpTo);
						state.RunningLine = null;
                    }
                    break;
                case BuiltInFunctionCode.ENDDATA:
                    //何もしない
                    break;
				case BuiltInFunctionCode.CLEARLINE:
					{
                        if (SkipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int32 delNum = (Int32)eEvaluator.GetInteger(intExpArg.Term);
						console.deleteLine(delNum);
						console.RefreshStrings(false);
					}
					break;
				case BuiltInFunctionCode.REUSELASTLINE:
					{
                        if (SkipPrint)
                            break;
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						console.PrintTemporaryLine(str);
					}
					break;
				case BuiltInFunctionCode.WAIT://改行待ち。
                    if (SkipPrint)
                        break;
                    console.ReadAnyKey();
					break;
				case BuiltInFunctionCode.TWAIT:
					{
                        if (SkipPrint)
                            break;
                        SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						Int64 time = eEvaluator.GetInteger(arg.X);
						Int64 flag = eEvaluator.GetInteger(arg.Y);
						console.waitInputWithTimer(time, flag);
						break;
					}
				case BuiltInFunctionCode.INPUT://整数入力。入力はRESULTへ。
                    if (SkipPrint)
                    {
                        if (userDefinedSkip)
                        {
                            console.PrintError("表示スキップ中にINPUTに遭遇しました");
                            console.PrintError("INPUTに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                            throw new CodeEE("無限ループに入る可能性が高いため実行を終了します");
                        }
                        break;
                    }
                    console.ReadInteger();
					break;
                case BuiltInFunctionCode.ONEINPUT:
                    if (SkipPrint)
                    {
                        if (userDefinedSkip)
                        {
                            console.PrintError("表示スキップ中にINPUTに遭遇しました");
                            console.PrintError("ONEINPUTに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                            throw new CodeEE("無限ループに入る可能性が高いため実行を終了します");
                        }
                        break;
                    }
                    console.ReadOneInteger();
                    break;
				case BuiltInFunctionCode.INPUTS://文字列入力。入力はRESULTSへ。
                    if (SkipPrint)
                    {
                        if (userDefinedSkip)
                        {
                            console.PrintError("表示スキップ中にINPUTSに遭遇しました");
                            console.PrintError("INPUTSに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                            throw new CodeEE("無限ループに入る可能性が高いため実行を終了します");
                        }
                        break;
                    }
                    console.ReadString();
					break;
                case BuiltInFunctionCode.ONEINPUTS:
                    if (SkipPrint)
                    {
                        if (userDefinedSkip)
                        {
                            console.PrintError("表示スキップ中にINPUTに遭遇しました");
                            console.PrintError("ONEINPUTSに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                            throw new CodeEE("無限ループに入る可能性が高いため実行を終了します");
                        }
                        break;
                    }
                    console.ReadOneString();
                    break;
                case BuiltInFunctionCode.TINPUT:
					{
                        if (SkipPrint)
                        {
                            if (userDefinedSkip)
                            {
                                console.PrintError("表示スキップ中にTINPUTに遭遇しました");
                                console.PrintError("TINPUTに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                                console.PrintError("デフォルト値をRESULTに代入し処理を続行します");
                                vEvaluator.RESULT = eEvaluator.GetInteger(((SpBarArgument)line.Argument).Terms[1]);
                            }
                            break;
                        }
                        SpBarArgument arg = (SpBarArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.Terms[0]);
						long y = eEvaluator.GetInteger(arg.Terms[1]);
						long z = eEvaluator.GetInteger(arg.Terms[2]);
						console.ReadIntegerWithTimer(x, y, z);
                    }
					break;
				case BuiltInFunctionCode.TINPUTS:
					{
                        if (SkipPrint)
                        {
                            if (userDefinedSkip)
                            {
                                console.PrintError("表示スキップ中にTINPUTSに遭遇しました");
                                console.PrintError("TINPUTSに必要な処理をNOSKIP～ENDNOSKIPで囲むか、SKIPDISP 0～SKIPDISP 1で囲ってください");
                                console.PrintError("デフォルト値をRESULTSに代入し処理を続行します");
                                vEvaluator.RESULTS = eEvaluator.GetString(((SpTInputsArgument)line.Argument).Def);
                            }
                            break;
                        }
                        SpTInputsArgument arg = (SpTInputsArgument)line.Argument;
						Int64 x = eEvaluator.GetInteger(arg.Time);
						string strs = eEvaluator.GetString(arg.Def);
						Int64 z = eEvaluator.GetInteger(arg.Disp);
						console.ReadStringWithTimer(x, strs, z);
                    }
					break;
				case BuiltInFunctionCode.DRAWLINE://画面の左端から右端まで----と線を引く。
                    if (SkipPrint)
                        break;
                    console.PrintBar();
					console.NewLine();
					break;
				case BuiltInFunctionCode.CUSTOMDRAWLINE:
					{
                        if (SkipPrint)
                            break;
                        term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						console.setStBar(str);
						console.PrintBar();
						console.NewLine();
						console.setStBar(Config.Instance.DrawLineString);
					}
					break;
				case BuiltInFunctionCode.BAR://[*****....]のようなグラフを書く。BAR (変数) , (最大値), (長さ)
				case BuiltInFunctionCode.BARL://改行付き。
					{
                        if (SkipPrint)
                            break;
                        SpBarArgument barArg = (SpBarArgument)line.Argument;
						Int64 var = eEvaluator.GetInteger(barArg.Terms[0]);
						Int64 max = eEvaluator.GetInteger(barArg.Terms[1]);
						Int64 length = eEvaluator.GetInteger(barArg.Terms[2]);
						console.Print(createBar(var, max, length));
					}
					if (line.Function == BuiltInFunctionCode.BARL)
						console.NewLine();
					break;
				case BuiltInFunctionCode.TIMES://小数計算。TIMES (変数) , (小数値)という形で使う。
					{
						SpTimesArgument timesArg = (SpTimesArgument)line.Argument;
						VariableToken var = timesArg.VariableDest;
						double d = eEvaluator.GetInteger(var) * timesArg.DoubleValue;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(var);
						unchecked
						{
							vEvaluator.SetValue(p, (Int64)d);
						}
					}
					break;
				case BuiltInFunctionCode.PRINT_ABL://能力。引数は登録番号
				case BuiltInFunctionCode.PRINT_TALENT://素質
				case BuiltInFunctionCode.PRINT_MARK://刻印
				case BuiltInFunctionCode.PRINT_EXP://経験
					{
                        if (SkipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						console.Print(vEvaluator.GetCharacterDataString(target, line.Function));
						console.NewLine();
					}
					break;
				case BuiltInFunctionCode.PRINT_PALAM://パラメータ
					{
                        if (SkipPrint)
                            break;
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						int count = 0;
						///100以降は否定の珠とかなので表示しない
						for (int i = 0; i < 100; i++)
						{
							string printStr = vEvaluator.GetCharacterParamString(target, i);
							if (printStr != null)
							{
								console.PrintC(printStr, true);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.PRINT_ITEM://所持アイテム
                    if (SkipPrint)
                        break;
                    console.Print(vEvaluator.GetHavingItemsString());
					console.NewLine();
					break;
				case BuiltInFunctionCode.PRINT_SHOPITEM://ショップで売っているアイテム
					{
                        if (SkipPrint)
                            break;
						int length = Math.Min(vEvaluator.ITEMSALES.Length, vEvaluator.ITEMNAME.Length);
						int count = 0;
						for (int i = 0; i < length; i++)
						{
							if (vEvaluator.ItemSales(i))
							{
								string printStr = vEvaluator.ITEMNAME[i];
								if (printStr == null)
									printStr = "";
								Int64 price = vEvaluator.ITEMPRICE[i];
								// 1.52a改変部分　（単位の差し替えおよび前置、後置に対応）
								if (Config.Instance.MoneyFirst)
									console.PrintC(string.Format("[{2}] {0}({3}{1})", printStr, price, i, Config.Instance.MoneyLabel), false);
								else
									console.PrintC(string.Format("[{2}] {0}({1}{3})", printStr, price, i, Config.Instance.MoneyLabel), false);
								count++;
								if ((Config.Instance.PrintCPerLine > 0) && (count % Config.Instance.PrintCPerLine == 0))
									console.PrintFlush(false);
							}
						}
						console.PrintFlush(false);
					}
					break;
				case BuiltInFunctionCode.UPCHECK://パラメータの変動
                    vEvaluator.UpdateInUpcheck(console, SkipPrint);
					break;
                case BuiltInFunctionCode.CUPCHECK://パラメータの変動(任意キャラ版)
                    {
                        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
                        Int64 target = eEvaluator.GetInteger(intExpArg.Term);
                        vEvaluator.CUpdateInUpcheck(console, target, SkipPrint);
                    }
                    break;
                case BuiltInFunctionCode.ADDCHARA://(キャラ番号)のキャラクタを追加
				case BuiltInFunctionCode.ADDSPCHARA://(キャラ番号)のSPキャラクタを追加（フラグ0が非0であるcsvを探して追加）
				case BuiltInFunctionCode.DELCHARA://(キャラ登録番号)のキャラクタを削除。
					{
						ExpressionArrayArgument intExpArg = (ExpressionArrayArgument)line.Argument;
						Int64 integer = -1;
						//for (int i = 0; i < intExpArg.TermList.Length; i++)
						foreach (IOperandTerm int64Term in intExpArg.TermList)
						{
							integer = eEvaluator.GetInteger(int64Term);
							if (line.Function == BuiltInFunctionCode.ADDCHARA)
								vEvaluator.AddCharacter(integer, false);
							else if (line.Function == BuiltInFunctionCode.ADDSPCHARA)
								vEvaluator.AddCharacter(integer, true);
							else
								vEvaluator.DelCharacter(integer);
						}
					}
					break;
				case BuiltInFunctionCode.DELALLCHARA:
					{
						vEvaluator.DelAllCharacter();
						break;
					}
                case BuiltInFunctionCode.PICKUPCHARA:
                    {
                        ExpressionArrayArgument intExpArg = (ExpressionArrayArgument)line.Argument;
                        Int64[] NoList = new Int64[intExpArg.TermList.Length];
                        int charaNum = (int)eEvaluator.VEvaluator.GetInteger(eEvaluator.GetFixedVariable(new VariableToken(VariableIdentifier.GetVariableId("CHARANUM"), new SingleTerm(0), new SingleTerm(0), new SingleTerm(0))));
                        for (int i = 0; i < intExpArg.TermList.Length; i++)
                        {
                            IOperandTerm term_i = intExpArg.TermList[i];
                            NoList[i] = eEvaluator.GetInteger(term_i);
                            if (!(term_i is VariableToken) || ((((VariableToken)term_i).Identifier.Code != VariableCode.MASTER) && (((VariableToken)term_i).Identifier.Code != VariableCode.ASSI) && (((VariableToken)term_i).Identifier.Code != VariableCode.TARGET)))
                            if (NoList[i] < 0 || NoList[i] >= charaNum)
                                throw new CodeEE("命令PICKUPCHARAの第" + (i + 1).ToString() + "引数にキャラリストの範囲外の値(" + NoList[i].ToString() + ")が与えられました");
                        }
                        vEvaluator.PickUpChara(NoList);
                    }
                    break;
                case BuiltInFunctionCode.ADDDEFCHARA:
                    {
                        if (state.Scope != "SYSTEM_TITLE")
                            throw new CodeEE("@SYSTEM_TITLE以外でこの命令を使うことはできません");
                        vEvaluator.AddCharacterFromCsvNo(0);
                        if (Process.instance.gamebase.DefaultCharacter > 0)
                            vEvaluator.AddCharacterFromCsvNo(Process.instance.gamebase.DefaultCharacter);
                        break;
                    }
                case BuiltInFunctionCode.ADDVOIDCHARA:
                    {
                        vEvaluator.AddPseudoCharacter();
                    }
                    break;
				case BuiltInFunctionCode.PUTFORM://@SAVEINFO関数でのみ使用可能。PRINTFORMと同様の書式でセーブデータに概要をつける。
					{
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						if (vEvaluator.SAVEDATA_TEXT != null)
							vEvaluator.SAVEDATA_TEXT += str;
						else
							vEvaluator.SAVEDATA_TEXT = str;
						break;
					}
				case BuiltInFunctionCode.QUIT://ゲームを終了
					console.Quit();
					break;


				case BuiltInFunctionCode.STRLEN://RESULTに文字数（バイト数）を代入
				//case BuiltInFunctionCode.STRLENS:
				case BuiltInFunctionCode.STRLENFORM:
					term = ((ExpressionArgument)line.Argument).Term;
					str = eEvaluator.GetString(term);
					this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(str);
					break;

                case BuiltInFunctionCode.STRLENU://RESULTに文字数（バイト数）を代入
                case BuiltInFunctionCode.STRLENFORMU:
                    term = ((ExpressionArgument)line.Argument).Term;
                    str = eEvaluator.GetString(term);
                    this.vEvaluator.RESULT = str.Length;
                    break;

				case BuiltInFunctionCode.SWAPCHARA:
					{
						SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.X);
						long y = eEvaluator.GetInteger(arg.Y);
						vEvaluator.SwapChara(x, y);
					}
					break;
				case BuiltInFunctionCode.SORTCHARA:
					{
						SpSortcharaArgument spSortArg = (SpSortcharaArgument)line.Argument;
						Int64 elem = 0;
						if (spSortArg.SortKey.Element2 != null)
							elem = eEvaluator.GetInteger(spSortArg.SortKey.Element2);
						vEvaluator.SortChara(spSortArg.SortKey.Identifier, elem, spSortArg.SortOrder, true);
					}
					break;
				case BuiltInFunctionCode.VARSIZE:
					{
						SpVarsizeArgument versizeArg = (SpVarsizeArgument)line.Argument;
						VariableIdentifier varID = versizeArg.VariableID;
						vEvaluator.VarSize(varID);
					}
					break;
				case BuiltInFunctionCode.SAVEDATA:
					{
						SpSaveDataArgument spSavedataArg = (SpSaveDataArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(spSavedataArg.Target);
						if (target < 0)
							throw new CodeEE("SAVEDATAの引数に負の値(" + target.ToString() + ")が指定されました");
						else if (target > int.MaxValue)
							throw new CodeEE("SAVEDATAの引数(" + target.ToString() + ")が大きすぎます");
						string savemes = eEvaluator.GetString(spSavedataArg.StrExpression);
                        if (savemes.Contains("\n"))
                            throw new CodeEE("SAVEDATAのセーブテキストに改行文字が与えられました（セーブデータが破損するため改行文字は使えません）");
						saveTo((int)target, savemes);
					}
					break;
				case BuiltInFunctionCode.DELDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("DELDATAの引数に負の値(" + target.ToString() + ")が指定されました");
						else if (target > int.MaxValue)
							throw new CodeEE("DELDATAの引数(" + target.ToString() + ")が大きすぎます");
						delData((int)target);
					}
					break;
                //case BuiltInFunctionCode.CHKDATA:
                //    {
                //        ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
                //        Int64 target = eEvaluator.GetInteger(intExpArg.Term);
                //        if (target < 0)
                //            throw new CodeEE("CHKDATAの引数に負の値(" + target.ToString() + ")が指定されました");
                //        else if (target > int.MaxValue)
                //            throw new CodeEE("CHKDATAの引数(" + target.ToString() + ")が大きすぎます");
                //        EraDataResult result = vEvaluator.checkData((int)target);
                //        vEvaluator.RESULT = (long)result.State;
                //        vEvaluator.RESULTS = result.DataMes;
                //    }
                //    break;
				case BuiltInFunctionCode.SAVEGLOBAL:
					saveGlobal();
					break;
				case BuiltInFunctionCode.LOADGLOBAL:
					if (loadGlobal())
						vEvaluator.RESULT = 1;
					else
						vEvaluator.RESULT = 0;
					break;
				case BuiltInFunctionCode.POWER:
					{
						SpPowerArgument powerArg = (SpPowerArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(powerArg.VariableDest);
						double x = eEvaluator.GetInteger(powerArg.X);
						double y = eEvaluator.GetInteger(powerArg.Y);
						double pow = Math.Pow(x, y);
						if (double.IsNaN(pow))
							throw new CodeEE("累乗結果が非数値です");
						else if (double.IsInfinity(pow))
							throw new CodeEE("累乗結果が無限大です");
						else if ((pow >= Int64.MaxValue) || (pow <= Int64.MinValue))
							throw new CodeEE("累乗結果(" + pow.ToString() + ")が64ビット符号付き整数の範囲外です");
						vEvaluator.SetValue(p, (long)pow);
						break;
					}
				case BuiltInFunctionCode.SWAP:
					{
						SpSwapVarArgument arg = (SpSwapVarArgument)line.Argument;
						FixedVariablePointer p1 = eEvaluator.GetFixedVariable(arg.var1);
						FixedVariablePointer p2 = eEvaluator.GetFixedVariable(arg.var2);
						if (arg.var1.GetOperandType() != arg.var2.GetOperandType())
							throw new CodeEE("入れ替える変数の型が異なります");
						if (arg.var1.GetOperandType() == typeof(Int64))
						{
                            Int64 temp = vEvaluator.GetInteger(p1);
                            vEvaluator.SetValue(p1, vEvaluator.GetInteger(p2));
							vEvaluator.SetValue(p2, temp);
						}
						else if (arg.var1.GetOperandType() == typeof(string))
						{
                            string temps = vEvaluator.GetString(p1);
                            vEvaluator.SetValue(p1, vEvaluator.GetString(p2));
							vEvaluator.SetValue(p2, temps);
						}
						else
						{
							throw new CodeEE("不明な変数型です");
						}
						break;
					}
				case BuiltInFunctionCode.GETTIME:
					{
						long date = DateTime.Now.Year;
						date = date * 100 + DateTime.Now.Month;
						date = date * 100 + DateTime.Now.Day;
						date = date * 100 + DateTime.Now.Hour;
						date = date * 100 + DateTime.Now.Minute;
						date = date * 100 + DateTime.Now.Second;
						date = date * 1000 + DateTime.Now.Millisecond;
						vEvaluator.RESULT = date;//17桁。2京くらい。
                        vEvaluator.RESULTS = DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss");
					}
					break;
				case BuiltInFunctionCode.SETCOLOR:
					{
						SpColorArgument colorArg = (SpColorArgument)line.Argument;
						Int64 colorR;
						Int64 colorG;
						Int64 colorB;
						if (colorArg.RGB != null)
						{
							Int64 colorRGB = eEvaluator.GetInteger(colorArg.RGB);
							colorR = (colorRGB & 0xFF0000) >> 16;
							colorG = (colorRGB & 0x00FF00) >> 8;
							colorB = (colorRGB & 0x0000FF);
						}
						else
						{
							colorR = eEvaluator.GetInteger(colorArg.R);
							colorG = eEvaluator.GetInteger(colorArg.G);
							colorB = eEvaluator.GetInteger(colorArg.B);
							if ((colorR < 0) || (colorG < 0) || (colorB < 0))
								throw new CodeEE("SETCOLORの引数に0未満の値が指定されました");
							if ((colorR > 255) || (colorG > 255) || (colorB > 255))
								throw new CodeEE("SETCOLORの引数に255を超える値が指定されました");
						}
						Color c = Color.FromArgb((Int32)colorR, (Int32)colorG, (Int32)colorB);
						console.SetStringStyle(c);
					}
					break;
				case BuiltInFunctionCode.RESETCOLOR:
					console.SetStringStyle(Config.Instance.ForeColor);
					break;
				case BuiltInFunctionCode.FONTBOLD:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Bold);
					break;
				case BuiltInFunctionCode.FONTITALIC:
					console.SetStringStyle(console.StringStyle.FontStyle | FontStyle.Italic);
					break;
				case BuiltInFunctionCode.FONTREGULAR:
					console.SetStringStyle(FontStyle.Regular);
					break;
				case BuiltInFunctionCode.FONTSTYLE:
					{
						FontStyle fs = FontStyle.Regular;
						Int64 i = eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term);
						if ((i & 1) != 0)
							fs |= FontStyle.Bold;
						if ((i & 2) != 0)
							fs |= FontStyle.Italic;
						if ((i & 4) != 0)
							fs |= FontStyle.Strikeout;
						if ((i & 8) != 0)
							fs |= FontStyle.Underline;
						console.SetStringStyle(fs);
					}
					break;
				case BuiltInFunctionCode.SETFONT:
					term = ((ExpressionArgument)line.Argument).Term;
					console.SetFont(eEvaluator.GetString(term));
					break;
				case BuiltInFunctionCode.ALIGNMENT:
					str = line.ArgumentStr;
					if (Config.Instance.IgnoreCase)
						str = str.ToUpper();
					if (!Enum.IsDefined(typeof(DisplayLineAlignment), str))
						throw new CodeEE("ALIGNMENTのキーワード\"" + str + "\"は未定義です");
					console.Alignment = (DisplayLineAlignment)Enum.Parse(typeof(DisplayLineAlignment), str);
					break;
				case BuiltInFunctionCode.RESETDATA:
					vEvaluator.ResetData();
                    console.ResetStyle();
                    break;
				case BuiltInFunctionCode.RESETGLOBAL:
					vEvaluator.ResetGlobalData();
					break;
				case BuiltInFunctionCode.RANDOMIZE:
					vEvaluator.Randomize(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
				case BuiltInFunctionCode.INITRAND:
					vEvaluator.InitRanddata();
					break;
				case BuiltInFunctionCode.DUMPRAND:
					vEvaluator.DumpRanddata();
					break;
				case BuiltInFunctionCode.REDRAW:
					console.SetRedraw(eEvaluator.GetInteger(((ExpressionArgument)line.Argument).Term));
					break;
                case BuiltInFunctionCode.SETBIT:
                case BuiltInFunctionCode.CLEARBIT:
                case BuiltInFunctionCode.INVERTBIT:
                    {
                        BitArgument spsetarg = (BitArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
                        Int64 x = eEvaluator.GetInteger(spsetarg.Term);
                        if ((x < 0) || (x > 63))
                            throw new CodeEE("第2引数がビットのレンジ(0から63)を超えています");
                        Int64 baseValue = vEvaluator.GetInteger(p);
                        Int64 shift = 1L << (int)x;
                        if (line.Function == BuiltInFunctionCode.SETBIT)
                            baseValue |= shift;
                        else if (line.Function == BuiltInFunctionCode.CLEARBIT)
                            baseValue &= ~shift;
                        else
                            baseValue ^= shift;
                        vEvaluator.SetValue(p, baseValue);
                    }
                    break;
				case BuiltInFunctionCode.VARSET:
					{
						SpVarSetArgument spvarsetarg = (SpVarSetArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spvarsetarg.VariableDest);
                        int start = 0;
                        if (spvarsetarg.Start != null)
                            start = (int)eEvaluator.GetInteger(spvarsetarg.Start);
                        int end = 0;
                        if (spvarsetarg.End != null)
                            end = (int)eEvaluator.GetInteger(spvarsetarg.End);
                        else if (spvarsetarg.VariableDest.Identifier.IsArray1D)
                            end = (int)eEvaluator.VEvaluator.GetVariableSize(p.ID);
                        if (start > end)
                        {
                            int temp = start;
                            start = end;
                            end = start;
                        }
                        if (p.ID.IsString)
						{
							string src = eEvaluator.GetString(spvarsetarg.Term);
							vEvaluator.SetValueAll(p, src, start, end);
						}
						else
						{
							long src = eEvaluator.GetInteger(spvarsetarg.Term);
                            vEvaluator.SetValueAll(p, src, start, end);
						}
					}
					break;
                case BuiltInFunctionCode.CVARSET:
                    {
                        SpCVarSetArgument spvarsetarg = (SpCVarSetArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spvarsetarg.VariableDest);
                        SingleTerm index = eEvaluator.GetValue(spvarsetarg.Index);
                        int charaNum = (int)eEvaluator.VEvaluator.GetInteger(eEvaluator.GetFixedVariable(new VariableToken(VariableIdentifier.GetVariableId("CHARANUM"), new SingleTerm(0), new SingleTerm(0), new SingleTerm(0))));
                        int start = 0;
                        if (spvarsetarg.Start != null)
                        {
                            start = (int)eEvaluator.GetInteger(spvarsetarg.Start);
                            if (start < 0 || start >= charaNum)
                                throw new CodeEE("命令CVARSETの第４引数(" + start.ToString() + ")がキャラクタの範囲外です");
                        }
                        int end = 0;
                        if (spvarsetarg.End != null)
                        {
                            end = (int)eEvaluator.GetInteger(spvarsetarg.End);
                            if (end < 0 || end > charaNum)
                                throw new CodeEE("命令CVARSETの第５引数(" + end.ToString() + ")がキャラクタの範囲外です");
                        }
                        else
                            end = charaNum;
                        if (start > end)
                        {
                            int temp = start;
                            start = end;
                            end = start;
                        }
                        if (!p.ID.IsCharacterData)
                            throw new CodeEE("命令CVARSETにキャラクタ変数でない変数" + p.ID.ToString() + "が渡されました");
                        if (index.GetOperandType() == typeof(string) && p.ID.IsArray1D)
                        {
                            if (!ConstantData.isDefined(p.ID.Code, index.Str))
                                throw new CodeEE("文字列" + index.Str + "は配列変数" + p.ID.Code.ToString() + "の要素ではありません");
                        }
                        if (p.ID.IsString)
                        {
                            string src = eEvaluator.GetString(spvarsetarg.Term);
                            vEvaluator.SetValueAllEachChara(p, index, src, start, end);
                        }
                        else
                        {
                            long src = eEvaluator.GetInteger(spvarsetarg.Term);
                            vEvaluator.SetValueAllEachChara(p, index, src, start, end);
                        }
                    }
                    break;
                case BuiltInFunctionCode.RESET_STAIN:
                    {
                        ExpressionArgument expArg = (ExpressionArgument)line.Argument;
                        Int64 no = eEvaluator.GetInteger(expArg.Term);
                        vEvaluator.setDefaultStain(no);
                    }
                    break;
                case BuiltInFunctionCode.SPLIT:
                    {
                        SpSplitArgument spSplitArg = (SpSplitArgument)line.Argument;
                        FixedVariablePointer p;
                        string target = eEvaluator.GetString(spSplitArg.TargetStr);
                        string[] split = new string[] { eEvaluator.GetString(spSplitArg.Split) };
                        string[] retStr = target.Split(split, StringSplitOptions.None);
                        for (int i = 0; i < retStr.Length; i++)
                        {
                            p = eEvaluator.GetFixedVariable(VariableParser.ReduceVariable(spSplitArg.Var, new SingleTerm(i), null, null));
                            vEvaluator.SetValue(p, retStr[i]);
                        }
                        vEvaluator.RESULT = retStr.Length;
                    }
                    break;
                case BuiltInFunctionCode.PRINTCPERLINE:
                    {
                        SpGetIntArgument spGetintArg = (SpGetIntArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spGetintArg.VarToken);
                        vEvaluator.SetValue(p, (Int64)Config.Instance.PrintCPerLine);
                    }
                    break;
                case BuiltInFunctionCode.SAVENOS:
                    {
                        SpGetIntArgument spGetintArg = (SpGetIntArgument)line.Argument;
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(spGetintArg.VarToken);
                        vEvaluator.SetValue(p, (Int64)Config.Instance.SaveDataNos);
                    }
                    break;
                case BuiltInFunctionCode.FORCEKANA:
                    {
                        ExpressionArgument arg = (ExpressionArgument)line.Argument;
                        Int64 flag = eEvaluator.GetInteger(arg.Term);
                        if (flag < 0 || flag > 3)
                            throw new CodeEE("命令FORCEKANAの引数が指定可能な範囲(0～3)を超えています");
                        forceKatakana = (flag == 1) ? true : false;
                        forceHiragana = (flag > 1) ? true : false;
                        halftoFull = (flag == 3) ? true : false;
                    }
                    break;
                case BuiltInFunctionCode.CALLF:
                    {
                        string label = ((SpCallArgment)line.Argument).Str;
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        IOperandTerm mToken = FunctionMethodCreator.GetFunctionMethod(labelDic, label, ((SpCallArgment)line.Argument).Args);
                        if (mToken == null)
                            throw new CodeEE("式中関数\"@" + label + "\"が見つかりません");
                        eEvaluator.GetValue(mToken);
                        break;
                    }
                case BuiltInFunctionCode.CALLFORMF:
                    {
                        SpCallformArgment spCallformArg = (SpCallformArgment)line.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        IOperandTerm mToken = FunctionMethodCreator.GetFunctionMethod(labelDic, label, spCallformArg.Args);
                        if (mToken == null)
                            throw new CodeEE("式中関数\"@" + label + "\"が見つかりません");
                        eEvaluator.GetValue(mToken);
                        break;
                    }
                case BuiltInFunctionCode.SKIPDISP:
                    {
                        ExpressionArgument arg = (ExpressionArgument)line.Argument;
                        Int64 skip = eEvaluator.GetInteger(arg.Term);
                        if (skip != 0)
                        {
                            SkipPrint = true;
                            userDefinedSkip = true;
                        }
                        else
                        {
                            SkipPrint = false;
                            userDefinedSkip = false;
                        }
                        vEvaluator.RESULT = eEvaluator.GetInteger(new SingleTerm(SkipPrint));
                    }
                    break;
                case BuiltInFunctionCode.NOSKIP:
                    {
                        if (line.JumpTo == null)
                            throw new CodeEE("対応するENDNOSKIPのないNOSKIPです");
                        if (skipPrint)
                        {
                            saveSkip = true;
                            skipPrint = false;
                        }
                        else
                            saveSkip = false;
                    }
                    break;
                case BuiltInFunctionCode.ENDNOSKIP:
                    {
                        if (line.JumpTo == null)
                            throw new CodeEE("対応するNOSKIPのないENDNOSKIPです");
                        if (saveSkip)
                            skipPrint = true;
                    }
                    break;
                case BuiltInFunctionCode.OUTPUTLOG:
                    console.outputLog(null);
                    break;
                case BuiltInFunctionCode.ARRAYSHIFT: //配列要素をずらす
                    {
                        SpArrayShiftArgument arrayArg = (SpArrayShiftArgument)line.Argument;
                        if (!arrayArg.VarToken.Identifier.IsArray1D)
                            throw new CodeEE("ARRAYSHIFTは1次元配列および配列型キャラクタ変数のみに対応しています");
                        FixedVariablePointer dest = eEvaluator.GetFixedVariable(arrayArg.VarToken);
                        int shift = (int)eEvaluator.GetInteger(arrayArg.Num1);
                        if (shift == 0)
                            break;
                        int start = (int)eEvaluator.GetInteger(arrayArg.Num3);
                        if (start <  0)
                            throw new CodeEE("ARRAYSHIFTの第３引数が負の値(" + start.ToString() + ")です");
                        int num;
                        if (arrayArg.Num4 != null)
                        {
                            num = (int)eEvaluator.GetInteger(arrayArg.Num4);
                            if (num < 0)
                                throw new CodeEE("ARRAYSHIFTの第４引数が負の値(" + start.ToString() + ")です");
                            if (num == 0)
                                break;
                        }
                        else
                            num = -1;
                        if (dest.ID.IsInteger)
                        {
                            Int64 def = eEvaluator.GetInteger(arrayArg.Num2);
                            vEvaluator.ShiftArray(dest, shift, def, start, num);
                        }
                        else
                        {
                            string defs = eEvaluator.GetString(arrayArg.Num2);
                            vEvaluator.ShiftArray(dest, shift, defs, start, num);
                        }
                        break;
                    }
                case BuiltInFunctionCode.ARRAYREMOVE:
                    {
                        SpArrayControlArgument arrayArg = (SpArrayControlArgument)line.Argument;
                        if (!arrayArg.VarToken.Identifier.IsArray1D)
                            throw new CodeEE("ARRAYREMOVEは1次元配列および配列型キャラクタ変数のみに対応しています");
                        FixedVariablePointer p = eEvaluator.GetFixedVariable(arrayArg.VarToken);
                        int start = (int)eEvaluator.GetInteger(arrayArg.Num1);
                        int num = (int)eEvaluator.GetInteger(arrayArg.Num2);
                        if (start < 0)
                            throw new CodeEE("ARRAYREMOVEの第１引数が負の値(" + start.ToString() + ")です");
                        vEvaluator.RemoveArray(p, start, num);
                        break;
                    }
                case BuiltInFunctionCode.ENCODETOUNI:
                    {
                        term = ((ExpressionArgument)line.Argument).Term;
                        string target = eEvaluator.GetString(term);
                        int length = Encoding.UTF32.GetEncoder().GetByteCount(target.ToCharArray(), 0, target.Length, false);
                        byte[] bytes = new byte[length];
                        Encoding.UTF32.GetEncoder().GetBytes(target.ToCharArray(), 0, target.Length, bytes, 0, false);
                        vEvaluator.setEncodingResult(bytes);
                    }
					break;
				case BuiltInFunctionCode.DEBUGPRINT:
				case BuiltInFunctionCode.DEBUGPRINTL:
				case BuiltInFunctionCode.DEBUGPRINTFORM:
				case BuiltInFunctionCode.DEBUGPRINTFORML:
                    {
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						console.DebugPrint(str);
						if (BuiltInFunctionManager.IsNewLine(line.Function))
							console.DebugNewLine();
					}
					break;
				case BuiltInFunctionCode.ASSERT:
					term = ((ExpressionArgument)line.Argument).Term;
					if (eEvaluator.GetInteger(term) == 0)
						throw new CodeEE("ASSERT文の引数が0です");
					break;
                default:
					throw new ExeEE("未定義の関数");
			}
			return;
		}

        bool saveSkip = false;
        bool userDefinedSkip = false;

        private void outputToConsole(string str, BuiltInFunctionCode func)
        {
            if (BuiltInFunctionManager.IsPrintSingle(func))
                console.PrintLine(str);
            else
            {
                console.Print(str);
                if (BuiltInFunctionManager.IsNewLine(func) || BuiltInFunctionManager.IsWaitInput(func))
                    console.NewLine();
                if (BuiltInFunctionManager.IsWaitInput(func))
                    console.ReadAnyKey();
            }
            console.UseUserStyle = true;
        }

        private string convertStringType(string str)
        {
            if (forceKatakana)
                return Strings.StrConv(str, VbStrConv.Katakana, 0);
            else if (forceHiragana)
            {
                if (halftoFull)
                    return Strings.StrConv(str, VbStrConv.Hiragana | VbStrConv.Wide, 0);
                else
                    return Strings.StrConv(str, VbStrConv.Hiragana, 0);
            }
            return str;
        }

		private string createBar(Int64 var, Int64 max, Int64 length)
		{
			if (max <= 0)
				throw new CodeEE("BARの最大値が正の値ではありません");
			if (length <= 0)
				throw new CodeEE("BARの長さが正の値ではありません");
			if (length >= 100)//暴走を防ぐため。
				throw new CodeEE("BARが長すぎます");
			StringBuilder builder = new StringBuilder();
			builder.Append('[');
			int count;
			unchecked
			{
				count = (int)(var * length / max);
			}
			if (count < 0)
				count = 0;
			if (count > length)
				count = (int)length;
			builder.Append(Config.Instance.BarChar1, count);
			builder.Append(Config.Instance.BarChar2, (int)length - count);
			builder.Append(']');
			return builder.ToString();
		}

        bool forceKatakana = false;
        bool forceHiragana = false;
        bool halftoFull = false;
		#endregion

		#region flow control

		bool doFlowControlFunction(InstructionLine func, bool sequential)
		{
            StringStream st = new StringStream(func.ArgumentStr);
            ExpressionArgument expArg = null;
            switch (func.Function)
            {
                case BuiltInFunctionCode.BEGIN://システム関数の実行。
                    string keyword = func.ArgumentStr;
                    if (Config.Instance.IgnoreCase)
                        keyword = keyword.ToUpper();
                    if (!Enum.IsDefined(typeof(BeginType), keyword))
                        throw new CodeEE("BEGINのキーワード\"" + keyword + "\"は未定義です");
                    state.SetBegin((BeginType)Enum.Parse(typeof(BeginType), keyword));
                    state.Return(0);
                    console.ResetStyle();
                    return false;
                case BuiltInFunctionCode.SAVEGAME://セーブ画面を呼ぶ。ショップのみ。
                    saveCurrentState(true);
                    state.SaveLoadData(true);
                    return false;
                case BuiltInFunctionCode.LOADGAME://
                    saveCurrentState(true);
                    state.SaveLoadData(false);
                    return false;

                //case BuiltInFunctionCode.SIF://一行のみIF
                //    expArg = (ExpressionArgument)func.Argument;
                //    if (eEvaluator.GetInteger(expArg.Term) != 0)//評価式が真ならそのまま流れ落ちる
                //        break;
                //    state.ShfitNextLine();//偽なら一行とばす。順に来たときと同じ扱いにする
                //    break;
                //case BuiltInFunctionCode.IF:
                //    {//1.723 仕様変更
                //        LogicalLine ifJumpto = null;
                //        if (func.IfCaseList == null)
                //            throw new ExeEE("IFのIF-ELSEIFリストが適正に作成されていない");
                //        if (func.JumpTo == null)
                //            throw new ExeEE("IFに対応するENDIFが設定されていない");

                //        for (int i = 0; i < func.IfCaseList.Count; i++)
                //        {
                //            if (func.IfCaseList[i].IsError)
                //                continue;
                //            if (func.IfCaseList[i].Function == BuiltInFunctionCode.ELSE)
                //            {
                //                ifJumpto = func.IfCaseList[i];
                //                break;
                //            }

                //            expArg = (ExpressionArgument)(func.IfCaseList[i].Argument);
                //            if (expArg == null)
                //                throw new ExeEE("IFチェック中。引数が解析されていない。", func.IfCaseList[i].Position);

                //            //1730 ELSEIFが出したエラーがIFのエラーとして検出されていた
                //            state.RunningLine = func.IfCaseList[i];
                //            if (eEvaluator.GetInteger(expArg.Term) != 0)//式が真
                //            {
                //                ifJumpto = func.IfCaseList[i];
                //                break;
                //            }
                //        }
                //        if (ifJumpto == null)
                //            ifJumpto = func.JumpTo;//ENDIF
                //        if (ifJumpto != func)//自分自身がジャンプ先ならそのまま
                //            state.JumpTo(ifJumpto);
                //        state.RunningLine = null;
                //    }
                //    break;
                //case BuiltInFunctionCode.SELECTCASE:
                //    {//1.724 追加
                //        LogicalLine caseJumpto = null;
                //        SingleTerm term = eEvaluator.GetValue(((ExpressionArgument)func.Argument).Term);
                //        if (func.IfCaseList == null)
                //            throw new ExeEE("SELECTCASEのCASEリストが適正に作成されていない");
                //        if (func.JumpTo == null)
                //            throw new ExeEE("SELECTCASEに対応するENDSELECTが設定されていない");
                //        for (int i = 0; i < func.IfCaseList.Count; i++)
                //        {
                //            if (func.IfCaseList[i].IsError)
                //                continue;
                //            if (func.IfCaseList[i].Function == BuiltInFunctionCode.CASEELSE)
                //            {
                //                caseJumpto = func.IfCaseList[i];
                //                break;
                //            }
                //            CaseArgument caseArg = (CaseArgument)(func.IfCaseList[i].Argument);
                //            if (caseArg == null)
                //                throw new ExeEE("CASEチェック中。引数が解析されていない。", func.IfCaseList[i].Position);

                //            //1730 CASEが出したエラーがSELECTCASEのエラーとして検出されていた
                //            state.RunningLine = func.IfCaseList[i];
                //            foreach (CaseExpression caseExp in caseArg.CaseExps)
                //            {
                //                if (eEvaluator.GetCase(caseExp, term))
                //                {
                //                    caseJumpto = func.IfCaseList[i];
                //                    goto casefound;
                //                }
                //            }
                //        }
                //    casefound:
                //        if (caseJumpto == null)
                //            caseJumpto = func.JumpTo;//ENDSELECT
                //        state.JumpTo(caseJumpto);
                //        state.RunningLine = null;
                //    }
                //    break;
                //case BuiltInFunctionCode.ELSE:
                //case BuiltInFunctionCode.ELSEIF:
                //case BuiltInFunctionCode.CASE:
                //case BuiltInFunctionCode.CASEELSE:
                //    if (sequential)//直接来たならENDIFへ
                //    {
                //        if (func.JumpTo == null)
                //            throw new ExeEE(func.Function.ToString() + "のジャンプ先が設定されていない");
                //        state.JumpTo(func.JumpTo);
                //        break;
                //    }
                    //else//IFから飛ばされたならそのまま次へ
                    //{//1.723 ELSEIFの条件判定はIFで行う。
                    //    break;
                    //}
                //case BuiltInFunctionCode.ENDIF:
                //case BuiltInFunctionCode.ENDSELECT:
                //case BuiltInFunctionCode.ENDCATCH:
                //case BuiltInFunctionCode.ENDFUNC:
                //case BuiltInFunctionCode.DO:
                //    break;//ENDIF, ENDSELECTでするべきことは特に無い

                case BuiltInFunctionCode.REPEAT://RENDまで繰り返し。繰り返した回数がCOUNTへ。ネスト不可。
                case BuiltInFunctionCode.FOR://NEXTまで繰り返し。カウンター変数を設定可能。ネスト可。
                    //if (sequential)//上から来たなら回数のセット
                    //{
                    if (func.Function == BuiltInFunctionCode.FOR)
                    {
                        SpForNextArgment forArg = (SpForNextArgment)func.Argument;
                        func.LoopCounter = eEvaluator.GetFixedVariable(forArg.Cnt);
                        //1.725 順序変更。REPEATにならう。
                        vEvaluator.SetValue(func.LoopCounter, eEvaluator.GetInteger(forArg.Start));
                        func.LoopEnd = eEvaluator.GetInteger(forArg.End);
                        func.LoopStep = eEvaluator.GetInteger(forArg.Step);
                    }
                    else
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        FixedVariablePointer count = new FixedVariablePointer();
                        count.ID = VariableIdentifier.GetVariableId(VariableCode.COUNT);
                        count.Index1 = 0;
                        //1.725 順序変更。eramakerでは引数評価の前にCOUNTに0を代入していた。
                        vEvaluator.SetValue(count, 0);
                        func.LoopEnd = eEvaluator.GetInteger(expArg.Term);
                        func.LoopCounter = count;
                        func.LoopStep = 1;
                    }
                    //}
                    //else//（REND、CONTINUEから）飛んできたならカウンターの増加
                    //{
                    //    unchecked
                    //    {
                    //        vEvaluator.SetValue(func.LoopCounter, vEvaluator.GetInteger(func.LoopCounter) + func.LoopStep);
                    //    }
                    //}
                    if ((func.LoopStep > 0) && (func.LoopEnd > vEvaluator.GetInteger(func.LoopCounter)))//まだ回数が残っているなら、
                        break;//そのまま次の行へ
                    else if ((func.LoopStep < 0) && (func.LoopEnd < vEvaluator.GetInteger(func.LoopCounter)))//まだ回数が残っているなら、
                        break;//そのまま次の行へ
                    state.JumpTo(func.JumpTo);
                    break;
                case BuiltInFunctionCode.WHILE://WENDまで繰り返し、与えられた条件を満たす限り無限に繰り返す。多分ネスト可
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        if (eEvaluator.GetInteger(expArg.Term) != 0)//式が真
                            break;//そのまま中の処理へ
                        state.JumpTo(func.JumpTo);
                        break;
                    }
                //case BuiltInFunctionCode.NEXT://NEXTに戻る
                //case BuiltInFunctionCode.REND://REPEATに戻る
                //    {
                //        InstructionLine jumpLine = (InstructionLine)func.JumpTo;
                //        unchecked
                //        {
                //            vEvaluator.SetValue(jumpLine.LoopCounter, vEvaluator.GetInteger(jumpLine.LoopCounter) + jumpLine.LoopStep);
                //        }
                //        if (((jumpLine.LoopStep > 0) && (jumpLine.LoopEnd > vEvaluator.GetInteger(jumpLine.LoopCounter)))
                //            || ((jumpLine.LoopStep < 0) && (jumpLine.LoopEnd < vEvaluator.GetInteger(jumpLine.LoopCounter))))//まだ回数が残っているなら、
                //            state.JumpTo(func.JumpTo);
                //    }
                //    break;
                //case BuiltInFunctionCode.WEND://WHILEに戻る
                //    if (!sequential)//REPEAT、FOR、WHILE、BREAKから飛んできたなら
                //        break;
                //    //順列で来たならREPEAT、FOR、WHILEに帰る。繰り返し回数の記憶とチェックはREPEAT、FORが行う。
                //    state.JumpTo(func.JumpTo);
                //    break;
                //case BuiltInFunctionCode.BREAK://RENDまでジャンプ
                //    {
                //        ////BREAKのJUMP先はRENDまたはNEXT。そのジャンプ先であるREPEATかFORをiLineに代入。
                //        //1.723 仕様変更。BREAKのJUMP先にはREPEAT、FOR、WHILEを記憶する。そのJUMP先が本当のJUMP先。
                //        InstructionLine iJumpTo = (InstructionLine)func.JumpTo;
                //        InstructionLine iLine = (InstructionLine)iJumpTo.JumpTo;
                //        //WHILEとDOはカウンタがないので、即ジャンプ
                //        if (iJumpTo.Function == BuiltInFunctionCode.WHILE || iJumpTo.Function == BuiltInFunctionCode.DO)
                //        {
                //            state.JumpTo(iLine);
                //            break;
                //        }
                //        unchecked
                //        {//本家ではBREAK時にCOUNTが回る
                //            vEvaluator.SetValue(iJumpTo.LoopCounter, vEvaluator.GetInteger(iJumpTo.LoopCounter) + iJumpTo.LoopStep);
                //        }
                //        state.JumpTo(iLine);
                //        break;
                //    }
                //case BuiltInFunctionCode.CONTINUE://REPEATに戻る
                //    {
                //        InstructionLine jumpTo = (InstructionLine)func.JumpTo;
                //        if (jumpTo.Function == BuiltInFunctionCode.WEND)
                //        {
                //            expArg = (ExpressionArgument)jumpTo.Argument;
                //            if (eEvaluator.GetInteger(expArg.Term) != 0)//式が真
                //                state.JumpTo(func.JumpTo);
                //            else
                //                state.JumpTo(jumpTo.JumpTo);
                //        }
                //        else
                //        {
                //            unchecked
                //            {
                //                vEvaluator.SetValue(jumpTo.LoopCounter, vEvaluator.GetInteger(jumpTo.LoopCounter) + jumpTo.LoopStep);
                //            }
                //            if (((jumpTo.LoopStep > 0) && (jumpTo.LoopEnd > vEvaluator.GetInteger(jumpTo.LoopCounter)))
                //                || ((jumpTo.LoopStep < 0) && (jumpTo.LoopEnd < vEvaluator.GetInteger(jumpTo.LoopCounter))))//まだ回数が残っているなら、
                //                state.JumpTo(func.JumpTo);
                //            else
                //                state.JumpTo(jumpTo.JumpTo);
                //        }
                //    }
                //    break;
                case BuiltInFunctionCode.GOTO://$ラベルへジャンプ
                case BuiltInFunctionCode.TRYGOTO:
                case BuiltInFunctionCode.TRYCGOTO:
                //case BuiltInFunctionCode.RESTART://関数の再開。関数の最初に戻る。
                    if (func.JumpTo == null)
                    {
                        if (func.Function == BuiltInFunctionCode.TRYGOTO)
                            break;
                        else if (func.Function == BuiltInFunctionCode.TRYCGOTO)
                        {
                            if (func.JumpToEndCatch != null)
                                state.JumpTo(func.JumpToEndCatch);
                            break;
                        }
                        if (func.Function == BuiltInFunctionCode.GOTO)
                            throw new CodeEE("ラベル\"$" + func.ArgumentStr + "\"が見つかりません");
                        throw new ExeEE("ジャンプ先が適切に設定されていない");
                    }
                    state.JumpTo(func.JumpTo);
                    break;
                case BuiltInFunctionCode.JUMP://関数に移動
                case BuiltInFunctionCode.TRYJUMP:
                case BuiltInFunctionCode.TRYCJUMP:
                    {
                        if (func.JumpTo == null)
                        {
                            if (func.Function == BuiltInFunctionCode.TRYJUMP)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCJUMP)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("関数\"@" + ((SpCallArgment)func.Argument).Str + "\"が見つかりません");
                        }
                        assignArgs((FunctionLabelLine)func.JumpTo, ((SpCallArgment)func.Argument).Args);
                        string label = ((SpCallArgment)func.Argument).Str;
                        CalledFunction call = CalledFunction.CallFunction(this, label, state.GetCurrentReturnAddress, false);
                        state.ChangeCurrentFunction(call);
                        state.JumpTo(func.JumpTo);
                    }
                    break;
                case BuiltInFunctionCode.CALL://関数に移動。移動元を記憶し、RETURNで帰る。
                case BuiltInFunctionCode.TRYCALL:
                case BuiltInFunctionCode.TRYCCALL:
                    {
                        if ((func.JumpTo == null) && (func.Function == BuiltInFunctionCode.TRYCALL))
                            break;
                        else if ((func.JumpTo == null) && (func.Function == BuiltInFunctionCode.TRYCCALL))
                        {
                            if (func.JumpToEndCatch != null)
                                state.JumpTo(func.JumpToEndCatch);
                            break;
                        }
                        if (!sequential)//RETURNで帰ってきた
                            break;//何もしない
                        string label = ((SpCallArgment)func.Argument).Str;
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        CalledFunction call = CalledFunction.CallFunction(this, label, func, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                            throw new CodeEE("関数\"@" + label + "\"が見つかりません");
                        if (call.Count > 1)
                            throw new ExeEE("関数\"@" + label + "\"の候補が複数返された");
                        //if (call.LabelList.Count > 1 && strArray.Count > 0)
                        //    throw new ExeEE("EVENT関数\"@" + label + "\"に引数を指定することはできません");
                        assignArgs(call.LabelList[0], ((SpCallArgment)func.Argument).Args);
                        state.AddFunction(call);
                        break;
                    }
                //case BuiltInFunctionCode.RETURN://関数の終了。RESULTに整数を格納可能。
                //    {
                //        expArg = (ExpressionArgument)func.Argument;
                //        Int64 ret = eEvaluator.GetInteger(expArg.Term);
                //        vEvaluator.RESULT = ret;
                //        state.Return(ret);
                //        if (state.GetCurrentReturnAddress is NullLine)
                //            return false;
                //        break;
                //    }
                //case BuiltInFunctionCode.RETURNFORM://関数の終了。RESULTに整数を格納可能。
                //    {
                //        string arg = eEvaluator.GetString(((ExpressionArgument)func.Argument).Term);
                //        StringStream aSt = new StringStream(arg);
                //        Int64 ret = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null));
                //        vEvaluator.RESULT = ret;
                //        state.Return(ret);
                //        if (state.GetCurrentReturnAddress is NullLine)
                //            return false;
                //        break;
                //    }
                case BuiltInFunctionCode.RETURNF:
                    {
                        expArg = (ExpressionArgument)func.Argument;
                        SingleTerm ret = null;
                        if (expArg.Term != null)
                        {
                            ret = eEvaluator.GetValue(expArg.Term);
                        }
                        state.ReturnF(ret);
                        return false;
                    }
                case BuiltInFunctionCode.LOADDATA:
                    {
                        ExpressionArgument intExpArg = (ExpressionArgument)func.Argument;
                        Int64 target = eEvaluator.GetInteger(intExpArg.Term);
                        if (target < 0)
                            throw new CodeEE("LOADDATAの引数に負の値(" + target.ToString() + ")が指定されました");
                        else if (target > int.MaxValue)
                            throw new CodeEE("LOADDATAの引数(" + target.ToString() + ")が大きすぎます");
                        EraDataResult result = vEvaluator.checkData((int)target);
                        if (result.State != EraDataState.OK)
                            throw new CodeEE("不正なデータをロードしようとしました");

                        loadFrom((int)target);
                        state.ClearFunctionList();
                        state.SystemState = SystemStateCode.LoadData_DataLoaded;
                        return false;
                    }
                case BuiltInFunctionCode.JUMPFORM:
                case BuiltInFunctionCode.TRYJUMPFORM:
                case BuiltInFunctionCode.TRYCJUMPFORM:
                    {
                        SpCallformArgment spCallformArg = (SpCallformArgment)func.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper(); ;
                        CalledFunction call = CalledFunction.CallFunction(this, label, state.GetCurrentReturnAddress, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                        {
                            if (func.Function == BuiltInFunctionCode.TRYJUMPFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCJUMPFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("関数\"@" + label + "\"が見つかりません");
                        }
                        assignArgs(call.LabelList[0], spCallformArg.Args);
                        state.ChangeCurrentFunction(call);
                        state.JumpTo(call.NextLine);
                        break;
                    }

                case BuiltInFunctionCode.CALLFORM:
                case BuiltInFunctionCode.TRYCALLFORM:
                case BuiltInFunctionCode.TRYCCALLFORM:
                    {
                        if (!sequential)//RETURNで帰ってきた
                            break;//何もしない
                        SpCallformArgment spCallformArg = (SpCallformArgment)func.Argument;
                        StringForm strForm = spCallformArg.StrForm;
                        string label = strForm.GetString(eEvaluator).Trim();
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper(); ;
                        CalledFunction call = CalledFunction.CallFunction(this, label, func, false);
                        if ((call == null) || (call.Count == 0) || (call.NextLine == null))
                        {
                            if (func.Function == BuiltInFunctionCode.TRYCALLFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCCALLFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("関数\"@" + label + "\"が見つかりません");

                        }
                        assignArgs(call.LabelList[0], spCallformArg.Args);
                        state.AddFunction(call);
                        break;
                    }
                case BuiltInFunctionCode.GOTOFORM:
                case BuiltInFunctionCode.TRYGOTOFORM:
                case BuiltInFunctionCode.TRYCGOTOFORM:
                    {
                        string label = eEvaluator.GetString(((ExpressionArgument)func.Argument).Term);
                        if (Config.Instance.IgnoreCase)
                            label = label.ToUpper();
                        LogicalLine jumpto = state.CurrentCalled.CallLabel(this, label);
                        if (jumpto == null)
                        {
                            if (func.Function == BuiltInFunctionCode.TRYGOTOFORM)
                                break;
                            else if (func.Function == BuiltInFunctionCode.TRYCGOTOFORM)
                            {
                                if (func.JumpToEndCatch != null)
                                    state.JumpTo(func.JumpToEndCatch);
                                break;
                            }
                            throw new CodeEE("ラベル\"$" + label + "\"が見つかりません");
                        }
                        state.JumpTo(jumpto);
                        break;
                    }
                case BuiltInFunctionCode.TRYCALLLIST:
                    {
                        if (!sequential)//RETURNで帰ってきた
                        {
                            state.JumpTo(func.JumpTo);
                            break;
                        }
                        string funcName = "";
                        CalledFunction callto = null;
                        SpCallformArgment cfa = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            cfa = (SpCallformArgment)iLine.Argument;
                            funcName = cfa.StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            callto = CalledFunction.CallFunction(this, funcName, func.JumpTo, false);
                            if ((callto != null) && (callto.Count != 0) && (callto.NextLine != null))
                                break;
                        }
                        if ((callto == null) || (callto.Count == 0) || (callto.NextLine == null))
                            state.JumpTo(func.JumpTo);
                        else
                        {
                            assignArgs(callto.LabelList[0], cfa.Args);
                            state.AddFunction(callto);
                        }
                    }
                    break;
                case BuiltInFunctionCode.TRYJUMPLIST:
                    {
                        string funcName = "";
                        CalledFunction callto = null;
                        SpCallformArgment cfa = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            cfa = (SpCallformArgment)iLine.Argument;
                            funcName = cfa.StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            callto = CalledFunction.CallFunction(this, funcName, func, false);
                            if ((callto != null) && (callto.Count != 0) && (callto.NextLine != null))
                                break;
                        }
                        if ((callto == null) || (callto.Count == 0) || (callto.NextLine == null))
                            state.JumpTo(func.JumpTo);
                        else
                        {
                            assignArgs(callto.LabelList[0], cfa.Args);
                            state.ChangeCurrentFunction(callto);
                            state.JumpTo(callto.NextLine);
                        }
                    }
                    break;
                case BuiltInFunctionCode.TRYGOTOLIST:
                    {
                        string funcName = "";
                        LogicalLine jumpto = null;
                        foreach (InstructionLine iLine in func.callList)
                        {
                            if (iLine.Argument == null)
                                LogicalLineParser.SetArgumentTo(iLine, null);
                            funcName = ((SpCallformArgment)iLine.Argument).StrForm.GetString(eEvaluator).Trim();
                            if (Config.Instance.IgnoreCase)
                                funcName = funcName.ToUpper();
                            jumpto = state.CurrentCalled.CallLabel(this, funcName);
                            if (jumpto != null)
                                break;
                        }
                        if (jumpto == null)
                            state.JumpTo(func.JumpTo);
                        else
                            state.JumpTo(jumpto);
                    }
                    break;
                case BuiltInFunctionCode.CALLTRAIN:
                    {
                        ExpressionArgument intExpArg = (ExpressionArgument)func.Argument;
                        Int64 count = eEvaluator.GetInteger(intExpArg.Term);
                        SetCommnds(count);
                        return false;
                    }
                case BuiltInFunctionCode.CATCH:
                    {
                        if (sequential)//上から流れてきたなら何もしないでENDCATCHに飛ぶ
                            state.JumpTo(func.JumpToEndCatch);
                    }
                    break;
                case BuiltInFunctionCode.DOTRAIN:
                    {
                        switch (state.SystemState)
                        {
                            //case SystemStateCode.Train_Begin://BEGIN TRAINから。
                            case SystemStateCode.Train_CallEventTrain://@EVENTTRAINの呼び出し中。スキップ可能
                            case SystemStateCode.Train_CallShowStatus://@SHOW_STATUSの呼び出し中
                            //case SystemStateCode.Train_CallComAbleXX://@COM_ABLExxの呼び出し中。
                            case SystemStateCode.Train_CallShowUserCom://@SHOW_USERCOMの呼び出し中
                            //case SystemStateCode.Train_WaitInput://入力待ち状態。選択が実行可能ならEVENTCOMからCOMxx、そうでなければ@USERCOMにRESULTを渡す
                            //case SystemStateCode.Train_CallEventCom://@EVENTCOMの呼び出し中
                            //case SystemStateCode.Train_CallComXX://@COMxxの呼び出し中
                            //case SystemStateCode.Train_CallSourceCheck://@SOURCE_CHECKの呼び出し中
                            case SystemStateCode.Train_CallEventComEnd://@EVENTCOMENDの呼び出し中。スキップ可能。Train_CallEventTrainへ帰る。@USERCOMの呼び出し中もここ
                                break;
                            default:
                                throw new CodeEE("DOTRAIN命令をこの位置で実行することはできません");
                        }
                        coms.Clear();
                        isCTrain = false;
                        this.count = 0;

                        Int64 train = eEvaluator.GetInteger(((ExpressionArgument)func.Argument).Term);
                        if (train < 0)
                            throw new CodeEE("DOTRAIN命令に0未満の値が渡されました");
                        if (train >= vEvaluator.Constant.TrainName.Length)
                            throw new CodeEE("DOTRAIN命令にTRAINNAMEの配列数以上の値が渡されました");
                        doTrainSelectCom = train;
                        state.SystemState = SystemStateCode.Train_DoTrain;
                        return false;
                    }
                //case BuiltInFunctionCode.LOOP:
                //    if (!sequential)
                //        break;
                //    expArg = (ExpressionArgument)func.Argument;
                //    if (eEvaluator.GetInteger(expArg.Term) == 0)//式が偽
                //        break;//そのまま次の処理へ
                //    state.JumpTo(func.JumpTo);
                //    break;
                default:
                    throw new ExeEE("未定義の関数です");
            }
            return true;
		}

		/// <summary>
		/// 呼び出し先関数への引数の代入。ローカル変数のScopeの都合上、JumpToやAddFunctionの前に呼ぶこと。
		/// </summary>
		/// <param name="called"></param>
		/// <param name="args"></param>
		private void assignArgs(FunctionLabelLine called, IOperandTerm[] args)
		{
            if (called.Arg.Length < args.Length)
                throw new CodeEE("引数の数が関数\"@" + called.LabelName + "\"に設定された数を超えています");
			if (called.Arg.Length == 0)
				return;
            string oldScope = null;
            if (state.CalledByFunction)
                oldScope = state.Scope;
			string newScope = called.LabelName;
			for (int i = 0; i < called.Arg.Length; i++)
			{
				IOperandTerm term = null;
				if (i < args.Length)
					term = args[i];
				FixedVariablePointer pt;
				if (term == null)
				{
					//VEvaluator.Scope = oldScope;
					//string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
                    if (called.Arg[i].Identifier.Code == VariableCode.ARG || called.Arg[i].Identifier.Code == VariableCode.ARGS)
                    {
                        pt = eEvaluator.GetFixedVariable(called.Arg[i]);
                        if (called.Arg[i].GetOperandType() == typeof(string))
                            vEvaluator.SetValue(pt, eEvaluator.GetString(called.Def[i]));
                        else if (called.Arg[i].GetOperandType() == typeof(Int64))
                            vEvaluator.SetValue(pt, eEvaluator.GetInteger(called.Def[i]));
                        else
                            continue;
                    }
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					string str = eEvaluator.GetString(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, str);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l);
				}
				else if ((term.GetOperandType() == typeof(Int64)) && (called.Arg[i].GetOperandType() == typeof(string)))
				{
					vEvaluator.Scope = oldScope;
					Int64 l = eEvaluator.GetInteger(term);
					vEvaluator.Scope = newScope;
					pt = eEvaluator.GetFixedVariable(called.Arg[i]);
					vEvaluator.SetValue(pt, l.ToString());
				}
				else if ((term.GetOperandType() == typeof(string)) && (called.Arg[i].GetOperandType() == typeof(Int64)))
					throw new CodeEE((i + 1).ToString() + "番目の引数を文字列型から整数型に変換できません");
				else
					throw new ExeEE("引数の形式が不明");
			}

		}

		//private List<string> splitArgStr(string str, BuiltInFunctionCode bc)
		//{
		//    List<string> strArray = new List<string>();
		//    StringStream st = new StringStream(str);
		//    string tStr = null;
		//    int count = 0;
		//    while (!st.EOS)
		//    {
		//        TokenReader.SkipWhiteSpace(st);
		//        if (count > 0)
		//        {
		//            tStr = TokenReader.ReadIdentiferWithIndexAndExpression(st);
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//        else
		//        {
		//            if (bc == BuiltInFunctionCode.CALLFORM || bc == BuiltInFunctionCode.TRYCALLFORM)
		//            {
		//                tStr = TokenReader.ReadRawStringWithFormString(st);
		//            }
		//            else
		//            {
		//                tStr = TokenReader.ReadRawString(st);
		//            }
		//            strArray.Add(tStr);
		//            count++;
		//        }
		//    }
		//    return strArray;
		//}


		List<ProcessState> prevStateList = new List<ProcessState>();
		private void saveCurrentState(bool single)
		{
			if (single && (prevStateList.Count > 0))
				throw new ExeEE("記憶している状態があるのに再度記憶しようとした");
			prevStateList.Add(state);
			state = state.Clone();
		}

		private void loadPrevState()
		{
			if (prevStateList.Count == 0)
				throw new ExeEE("記憶している状態がないのに呼び戻しされた");
			state = prevStateList[prevStateList.Count - 1];
			deletePrevState();
		}

		private void deletePrevState()
		{
			if (prevStateList.Count != 0)
				prevStateList.RemoveAt(prevStateList.Count - 1);
		}

		private void deleteAllPrevState()
		{
			prevStateList.Clear();
		}


		#endregion
	}
}
