﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameProc;


namespace MinorShift.Emuera.GameData.Function
{
	internal static partial class FunctionMethodCreator
	{

		static FunctionMethodCreator()
		{
			methodList = new Dictionary<string, FunctionMethod>();
			methodList["GETCHARA"] = new GetcharaMethod();
			methodList["GETSPCHARA"] = new GetspcharaMethod();
			methodList["CSVNAME"] = new CsvStrDataMethod(CharacterStrData.NAME);
			methodList["CSVCALLNAME"] = new CsvStrDataMethod(CharacterStrData.CALLNAME);
			methodList["CSVNICKNAME"] = new CsvStrDataMethod(CharacterStrData.NICKNAME);
			methodList["CSVMASTERNAME"] = new CsvStrDataMethod(CharacterStrData.MASTERNAME);
			methodList["CSVCSTR"] = new CsvcstrMethod();
			methodList["CSVBASE"] = new CsvDataMethod(CharacterIntData.BASE);
			methodList["CSVABL"] = new CsvDataMethod(CharacterIntData.ABL);
			methodList["CSVMARK"] = new CsvDataMethod(CharacterIntData.MARK);
			methodList["CSVEXP"] = new CsvDataMethod(CharacterIntData.EXP);
			methodList["CSVRELATION"] = new CsvDataMethod(CharacterIntData.RELATION);
			methodList["CSVTALENT"] = new CsvDataMethod(CharacterIntData.TALENT);
			methodList["CSVCFLAG"] = new CsvDataMethod(CharacterIntData.CFLAG);
			methodList["CSVEQUIP"] = new CsvDataMethod(CharacterIntData.EQUIP);
			methodList["CSVJUEL"] = new CsvDataMethod(CharacterIntData.JUEL);
			methodList["STRLENS"] = new StrlenMethod();
			methodList["STRLENSU"] = new StrlenuMethod();
			methodList["SUBSTRING"] = new SubstringMethod();
			methodList["SUBSTRINGU"] = new SubstringuMethod();
			methodList["STRFIND"] = new StrfindMethod();
			methodList["STRFINDU"] = new StrfindUMethod();
			methodList["STRCOUNT"] = new StrCountMethod();
			methodList["VARSIZE"] = new VarsizeMethod();
			methodList["GETTIME"] = new GettimeMethod();
			methodList["GETTIMES"] = new GettimesMethod();
			methodList["GETMILLISECOND"] = new GetmsMethod();
			methodList["GETSECOND"] = new GetSecondMethod();
			methodList["CHKFONT"] = new CheckfontMethod();
			methodList["CHKDATA"] = new CheckdataMethod();
			methodList["FINDCHARA"] = new FindcharaMethod();
			methodList["EXISTCSV"] = new ExistCsvMethod();

			methodList["RAND"] = new RandMethod();
			methodList["MIN"] = new MaxMethod(false);
			methodList["MAX"] = new MaxMethod(true);
			methodList["ABS"] = new AbsMethod();
			methodList["POWER"] = new PowerMethod();
			methodList["SQRT"] = new SqrtMethod();
			methodList["CBRT"] = new CbrtMethod();
			methodList["LOG"] = new LogMethod();
			methodList["LOG10"] = new LogMethod(10.0d);
			methodList["EXPONENT"] = new ExpMethod();
			methodList["SIGN"] = new SignMethod();
			methodList["SUMARRAY"] = new SumArrayMethod();
			methodList["SUMCARRAY"] = new SumArrayMethod(true);
			methodList["MATCH"] = new MatchMethod();
			methodList["CMATCH"] = new MatchMethod(true);
			methodList["GROUPMATCH"] = new GroupMatchMethod();
			methodList["NOSAMES"] = new NosamesMethod();
			methodList["ALLSAMES"] = new AllsamesMethod();
			methodList["MAXARRAY"] = new MaxArrayMethod();
			methodList["MAXCARRAY"] = new MaxArrayMethod(true);
			methodList["MINARRAY"] = new MaxArrayMethod(false, false);
			methodList["MINCARRAY"] = new MaxArrayMethod(true, false);
			methodList["GETBIT"] = new GetbitMethod();
			methodList["GETNUM"] = new GetnumMethod();
			methodList["GETPALAMLV"] = new GetPalamLVMethod();
			methodList["GETEXPLV"] = new GetExpLVMethod();
			methodList["LIMIT"] = new GetLimitMethod();
			methodList["PRINTCPERLINE"] = new GetPrintCPerLineMethod();
			methodList["SAVENOS"] = new GetSaveNosMethod();
			methodList["UNICODE"] = new UnicodeMethod();

			methodList["GETCOLOR"] = new GetColorMethod();
			methodList["GETSTYLE"] = new GetStyleMethod();
			methodList["GETFONT"] = new GetFontMethod();
			methodList["TOSTR"] = new ToStrMethod();
			methodList["TOINT"] = new ToIntMethod();
			methodList["TOUPPER"] = new StrChangeStyleMethod(StrFormType.Upper);
			methodList["TOLOWER"] = new StrChangeStyleMethod(StrFormType.Lower);
			methodList["TOHALF"] = new StrChangeStyleMethod(StrFormType.Half);
			methodList["TOFULL"] = new StrChangeStyleMethod(StrFormType.Full);
			methodList["LINEISEMPTY"] = new LineIsEmptyMethod();
			methodList["ISSKIP"] = new IsSkipMethod();
			methodList["REPLACE"] = new ReplaceMethod();
			methodList["UNICODEBYTE"] = new UnicodeByteMethod();
			methodList["CONVERT"] = new ConvertIntMethod();
			
		}

		private static Dictionary<string, FunctionMethod> methodList;
		public static Dictionary<string, FunctionMethod> GetMethodList()
		{
			return methodList;
		}
	}
}