﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Function
{
	internal sealed class UserDefinedMethodTerm : IOperandTerm
	{
		public UserDefinedMethodTerm(IOperandTerm[] args, Type returnType, CalledFunction call) : base(returnType)
		{
			Arguments = args;
            //ReturnType = returnType;
            Call = call;
		}
		public IOperandTerm[] Arguments { get; private set; }
        //public Type ReturnType { get; private set; }
        public CalledFunction Call { get; private set; }

        public override long GetIntValue(ExpressionMediator exm)
        {
            SingleTerm term = exm.Process.GetValue(Call, Arguments);
            if (term == null)
                return 0;
            return term.Int;
        }
        public override string GetStrValue(ExpressionMediator exm)
        {
            SingleTerm term = exm.Process.GetValue(Call, Arguments);
            if (term == null)
                return "";
            return term.Str;
        }
        public override SingleTerm GetValue(ExpressionMediator exm)
        {
            SingleTerm term =  exm.Process.GetValue(Call, Arguments);
            if (term == null)
            {
                if (GetOperandType() == typeof(Int64))
                    return new SingleTerm(0);
                else
                    return new SingleTerm("");
            }
            return term;
        }
		public override IOperandTerm Restructure(ExpressionMediator exm)
		{
			for (int i = 0; i < Arguments.Length; i++)
			{
				if (Arguments[i] == null)
					continue;
				Arguments[i] = Arguments[i].Restructure(exm);
			}
			return this;
		}
	}
}
