﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using System.Text.RegularExpressions;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Function;
using MinorShift.Emuera.GameProc.Function;

namespace MinorShift.Emuera.GameProc
{
	internal static class LogicalLineParser
	{
		public static bool ParseSharpLine(FunctionLabelLine label, StringStream st, ScriptPosition position, List<string> OnlyLabel)
		{
			st.ShiftNext();//'#'を飛ばす
			string token = LexicalAnalyzer.ReadSingleIdentifer(st);
			LexicalAnalyzer.SkipWhiteSpace(st);
			if (token == null)
			{
				ParserMediator.Warn("解釈できない#行です", position, 1);
				return false;
			}
			if (Config.ICFunction)
				token = token.ToUpper();
			try{
				switch (token)
				{
					case "SINGLE":
						if (label.IsMethod)
							ParserMediator.Warn("式中関数では#SINGLEは機能しません", position, 1);
						else if (!label.IsEvent)
							ParserMediator.Warn("イベント関数以外では#SINGLEは機能しません", position, 1);
						else if (label.IsSingle)
							ParserMediator.Warn("#SINGLEが重複して使われています", position, 1);
						label.IsSingle = true;
						break;
					case "LATER":
						if (label.IsMethod)
							ParserMediator.Warn("式中関数では#LATERは機能しません", position, 1);
						else if (!label.IsEvent)
							ParserMediator.Warn("イベント関数以外では#LATERは機能しません", position, 1);
						else if (label.IsLater)
							ParserMediator.Warn("#LATERが重複して使われています", position, 1);
						else if (label.IsPri)
							ParserMediator.Warn("#PRIと#LATERが重複して使われています(この関数は2度呼ばれます)", position, 1);
						label.IsLater = true;
						break;
					case "PRI":
						if (label.IsMethod)
							ParserMediator.Warn("式中関数では#PRIは機能しません", position, 1);
						else if (!label.IsEvent)
							ParserMediator.Warn("イベント関数以外では#PRIは機能しません", position, 1);
						else if (label.IsPri)
							ParserMediator.Warn("#PRIが重複して使われています", position, 1);
						else if (label.IsLater)
							ParserMediator.Warn("#PRIと#LATERが重複して使われています(この関数は2度呼ばれます)", position, 1);
						label.IsPri = true;
						break;
                    case "ONLY":
                        if (label.IsMethod)
                            ParserMediator.Warn("式中関数では#ONLYは機能しません", position, 1);
                        else if (!label.IsEvent)
                            ParserMediator.Warn("イベント関数以外では#ONLYは機能しません", position, 1);
                        else if (label.IsPri)
                            ParserMediator.Warn("#ONLYが重複して使われています", position, 1);
                        else if (OnlyLabel.Contains(label.LabelName))
                            ParserMediator.Warn("このイベント関数\"@" + label.LabelName + "\"にはすでに#ONLYが宣言されています（この関数は実行されません）", position, 1);
                        OnlyLabel.Add(label.LabelName);
                        label.IsOnly = true;
                        break;
                    case "FUNCTION":
					case "FUNCTIONS":
						if (!string.IsNullOrEmpty(label.LabelName) && char.IsDigit(label.LabelName[0]))
						{
							ParserMediator.Warn("#" + token + "属性は関数名が数字で始まる関数には指定できません", position, 1);
							label.IsError = true;
							label.ErrMes = "関数名が数字で始まっています";
							break;
						}
						if (label.IsMethod)
						{
							if ((label.MethodType == typeof(Int64) && token == "FUNCTION") || (label.MethodType == typeof(string) && token == "FUNCTIONS"))
							{
								ParserMediator.Warn("関数" + label.LabelName + "にはすでに" + token + "が宣言されています(この行は無視されます)", position, 1);
								return false;
							}
							if (label.MethodType == typeof(Int64) && token == "FUNCTIONS")
								ParserMediator.Warn("関数" + label.LabelName + "にはすでに#FUNCTIONが宣言されています", position, 2);
							else if (label.MethodType == typeof(string) && token == "FUNCTION")
								ParserMediator.Warn("関数" + label.LabelName + "にはすでに#FUNCTIONSが宣言されています", position, 2);
							return false;
						}
						if (label.Depth == 0)
						{
							ParserMediator.Warn("システム関数に#" + token + "が指定されています", position, 2);
							return false;
						}
						label.IsMethod = true;
						label.Depth = 0;
						if (token == "FUNCTIONS")
							label.MethodType = typeof(string);
						else
							label.MethodType = typeof(Int64);
						break;
                    case "LOCALSIZE":
                    case "LOCALSSIZE":
                        {
                            int size = (int)LexicalAnalyzer.ReadInt64(st, true);
                            if (size <= 0)
                            {
                                ParserMediator.Warn("#" + token + "に0以下の値(" + size.ToString() + ")が与えられました。設定は無視されます", position, 1);
                                size = 0;
                            }
                            if (token == "LOCALSIZE")
                                label.LocalLength = size;
                            else
                                label.LocalsLength = size;
                        }
                        break;
                    case "DIM":
					case "DIMS":
						{
							bool dims = token == "DIMS";
							bool staticVar = true;
							Int64 size = 1;
							int warnLevel = -1;
							string errMes = "";
							string varName = LexicalAnalyzer.ReadSingleIdentifer(st);
							LexicalAnalyzer.SkipWhiteSpace(st);
							if (Config.ICVariable)
								varName = varName.ToUpper();
							if ((varName == "DYNAMIC") || (varName == "STATIC"))
							{
								staticVar = varName == "STATIC";
								varName = LexicalAnalyzer.ReadSingleIdentifer(st);
								LexicalAnalyzer.SkipWhiteSpace(st);
								if (Config.ICVariable)
									varName = varName.ToUpper();
							}
							GlobalStatic.IdentifierDictionary.CheckUserPrivateVarName(ref errMes, ref warnLevel, varName);
							if(warnLevel >= 0)
							{
								ParserMediator.Warn(errMes, position, warnLevel);
								if(warnLevel >= 2)
									return false;
							}
							LexicalAnalyzer.SkipWhiteSpace(st);
							if (!st.EOS)
							{
								if (st.Current != ',')
								{
									ParserMediator.Warn("書式が間違っています", position, 2);
									return false;
								}
								st.ShiftNext();
								LexicalAnalyzer.SkipWhiteSpace(st);
								size = LexicalAnalyzer.ReadInt64(st, false);
								if ((size <= 0) || (size > 1000000))
								{
									ParserMediator.Warn("プライベート変数のサイズは1以上1000000以下でなければなりません", position, 2);
									return false;
								}
							}
							if (!label.AddPrivateVariable(varName, (int)size, dims, staticVar))
							{
								ParserMediator.Warn("変数名" + varName + "は既に使用されています", position, 2);
								return false;
							}
							break;
						}
					default:
						ParserMediator.Warn("解釈できない#行です", position, 1);
						break;
				}
				if (!st.EOS)
				{
					ParserMediator.Warn("#の識別子の後に余分な文字があります", position, 1);
				}
			}
			catch(Exception e)
			{
				ParserMediator.Warn(e.Message, position, 2);
				goto err;
			}
			return true;
		err:
			return false;
		}
		
		public static LogicalLine ParseLine(string str, EmueraConsole console)
		{
			ScriptPosition position = new ScriptPosition(str);
			StringStream stream = new StringStream(str);
			return ParseLine(stream, position, console);
		}

		public static LogicalLine ParseLabelLine(StringStream stream, ScriptPosition position, EmueraConsole console)
		{
			bool isFunction = (stream.Current == '@');
			int lineNo = position.LineNo;
			string labelName = "";
			string errMes = "";
			try
			{
                stream.ShiftNext();//@か$を除去
				labelName = LexicalAnalyzer.ReadString(stream, StrEndWith.LeftParenthesis_Bracket_Comma);
				labelName = labelName.Trim();
				int warnLevel = -1;
				if (Config.ICVariable)
					labelName = labelName.ToUpper();
				GlobalStatic.IdentifierDictionary.CheckUserLabelName(ref errMes, ref warnLevel, isFunction, labelName);
				if(warnLevel >= 0)
				{
					if (warnLevel >= 2)
						goto err;
					ParserMediator.Warn(errMes, position, warnLevel);
				}
				if (!isFunction)//$ならこの時点で終了
				{
					LexicalAnalyzer.SkipWhiteSpace(stream);
					if (!stream.EOS)
						ParserMediator.Warn("$で始まるラベルに引数が設定されています", position, 1);
					return new GotoLabelLine(position, labelName);
				}

                //関数名部分に_renameを使えないように変更
                if (ParserMediator.RenameDic != null && ((stream.ToString().IndexOf("[[") >= 0) && (stream.ToString().IndexOf("]]") >= 0)))
                {
                    string line = stream.ToString();
                    foreach (KeyValuePair<string, string> pair in ParserMediator.RenameDic)
                        line = line.Replace(pair.Key, pair.Value);
                    stream = new StringStream(line);
                }
                WordCollection wc = null;
				wc = LexicalAnalyzer.Analyse(stream, LexEndWith.EoL, false, true);
				if (Program.AnalysisMode)
					console.PrintC("@" + labelName, false);
				FunctionLabelLine funclabelLine = new FunctionLabelLine(position, labelName, wc);
				if (IdentifierDictionary.IsEventLabelName(labelName))
				{
					funclabelLine.IsEvent = true;
					funclabelLine.IsSystem = true;
					funclabelLine.Depth = 0;
				}
				else if (IdentifierDictionary.IsSystemLabelName(labelName))
				{
					funclabelLine.IsSystem = true;
					funclabelLine.Depth = 0;
				}
				return funclabelLine;
			}
			catch (CodeEE e)
			{
				errMes = e.Message;
			}
		err:
			System.Media.SystemSounds.Hand.Play();
			if (isFunction)
			{
				if(labelName.Length == 0)
					labelName = "<Error>";
				return new InvalidLabelLine(position, labelName, errMes);
			}
			return new InvalidLine(position, errMes);
		}
		
		
		public static LogicalLine ParseLine(StringStream stream, ScriptPosition position, EmueraConsole console)
		{
			int lineNo = position.LineNo;
			string errMes = "";
			LexicalAnalyzer.SkipWhiteSpace(stream);//先頭のホワイトスペースを読み飛ばす
			if (stream.EOS)
				return null;
			//コメント行かどうかはここに来る前に判定しておく
			try
			{
				#region 前置インクリメント、デクリメント行
				if (stream.Current == '+' || stream.Current == '-')
				{
					char op = stream.Current;
					WordCollection wc = LexicalAnalyzer.Analyse(stream, LexEndWith.EoL, false, false);
					OperatorWord opWT = wc.Current as OperatorWord;
					if ((opWT == null)|| ((opWT.Code != OperatorCode.Increment) &&(opWT.Code != OperatorCode.Decrement)) )
					{
						if (op == '+')
							errMes = "行が\'+\'から始まっていますが、インクリメントではありません"; 
						else
							errMes = "行が\'-\'から始まっていますが、デクリメントではありません";
						goto err;
					}
					wc.ShiftNext();
					//token = EpressionParser.単語一個分取得(wc)
					//token非変数
					//token文字列形
					//token変更不可能
					//if (wc != EOS)
					//
					return new InstructionLine(position, FunctionIdentifier.SETFunction, opWT.Code, wc, null);
				}
				#endregion

				WordCollection wc1 = LexicalAnalyzer.Analyse(stream, LexEndWith.Single, false, false);
				IdentifierWord idWT = wc1.Current as IdentifierWord;
				if ((wc1.Collection.Count != 1) || (idWT == null))
				{
					errMes = "不正な文字で行が始まっています";
					goto err;
				}
				FunctionIdentifier func = GlobalStatic.IdentifierDictionary.GetFunctionIdentifier(idWT.Code);
				//命令文
				if (func != null)//関数文
				{
					if (stream.EOS) //引数の無い関数
						return new InstructionLine(position, func, stream);
					if ((stream.Current != ' ') && (stream.Current != '\t'))
					{
						errMes = "命令で行が始まっていますが、命令の直後に半角スペース・タブ以外の文字が来ています";
						goto err;
					}
					stream.ShiftNext();
					return new InstructionLine(position, func, stream);
				}
				//命令行ではない→代入行のはず
				OperatorCode assignOP = OperatorCode.NULL;
				if (stream.EOS)
				{
					errMes = "解釈できない行です";
					goto err;
				}
				try
				{
					wc1 = LexicalAnalyzer.Analyse(stream, LexEndWith.Operator, false, false);
					wc1.Collection.Insert(0, idWT);
					assignOP = LexicalAnalyzer.ReadAssignmentOperator(stream);
				}
				catch(CodeEE)
				{
					errMes = "解釈できない行です";
					goto err;
				}
				//eramaker互換警告
				//stream.Jump(-1);
				//if ((stream.Current != ' ') && (stream.Current != '\t'))
				//{
				//	errMes = "変数で行が始まっていますが、演算子の直前に半角スペースまたはタブがありません";
				//	goto err;
				//}
				//stream.ShiftNext();


				if (assignOP == OperatorCode.Equal)
				{
					if (console != null)
						ParserMediator.Warn("代入演算子に\"==\"が使われています", position, 0);
					//"=="を代入文に使うのは本当はおかしいが結構使われているので仕様にする
					assignOP = OperatorCode.Assignment;
				}
				return new InstructionLine(position, FunctionIdentifier.SETFunction, assignOP, wc1, stream);
			err:
				return new InvalidLine(position, errMes);
			}
			catch (CodeEE e)
			{
				System.Media.SystemSounds.Hand.Play();
				return new InvalidLine(position, e.Message);
			}
		}
		
	}
}
