﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameProc
{
	
		/// <summary>
		/// 現在呼び出し中の関数
		/// イベント関数を除いて実行中に内部状態は変化しないので使いまわしても良い
		/// </summary>
	internal sealed class CalledFunction
	{
		private CalledFunction(string label) { FunctionName = label; }
		public static CalledFunction CallEventFunction(Process parent, string label, LogicalLine retAddress)
		{
			CalledFunction called = new CalledFunction(label);
			List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
			called.Finished = false;
			called.eventLabelList = parent.LabelDictionary.GetEventLabels(label);
			if (called.eventLabelList == null)
			{
				FunctionLabelLine line = parent.LabelDictionary.GetNonEventLabel(label);
				if (parent.LabelDictionary.GetNonEventLabel(label) != null)
				{
					throw new CodeEE("イベント関数でない関数@" + label + "(" + line.Position.Filename + ":" + line.Position.LineNo + "行目)に対しEVENT呼び出しが行われました");
				}
				return null;
			}
			called.counter = -1;
			called.group = 0;
			called.ShiftNext();
			called.TopLabel = called.CurrentLabel;
			called.returnAddress = retAddress;
			return called;
		}

		public static CalledFunction CallFunction(Process parent, string label, LogicalLine retAddress)
		{
			CalledFunction called = new CalledFunction(label);
			called.Finished = false;
			FunctionLabelLine labelline = parent.LabelDictionary.GetNonEventLabel(label);
			if (labelline == null)
			{
				if (parent.LabelDictionary.GetEventLabels(label) != null)
				{
					throw new CodeEE("イベント関数@" + label + "に対し通常のCALLが行われました");
				}
				return null;
			}
			called.TopLabel = labelline;
			called.CurrentLabel = labelline;
			called.returnAddress = retAddress;
            return called;
		}

		public static CalledFunction CreateCalledFunctionMethod(FunctionLabelLine labelline, string label)
		{
			CalledFunction called = new CalledFunction(label);
			called.TopLabel = labelline;
			called.CurrentLabel = labelline;
			called.returnAddress = null;
			return called;
		}

		public LogicalLine CallLabel(Process parent, string label)
		{
			return parent.LabelDictionary.GetLabelDollar(label, this.CurrentLabel);
		}

        public void updateRetAddress(LogicalLine line)
        {
            returnAddress = line;
        }

		public CalledFunction Clone()
		{
			CalledFunction called = new CalledFunction(this.FunctionName);
			called.eventLabelList = this.eventLabelList;
			called.CurrentLabel = this.CurrentLabel;
			called.TopLabel = this.TopLabel;
			called.group = this.group;

			called.counter = this.counter;
			called.returnAddress = this.returnAddress;
			return called;
		}

		List<FunctionLabelLine>[] eventLabelList;
		public FunctionLabelLine CurrentLabel { get; private set; }
		public FunctionLabelLine TopLabel { get; private set; }
		int counter = -1;
		int group = 0;
		LogicalLine returnAddress;
		public readonly string FunctionName = "";
		public bool IsJump { get; set; }
		public bool Finished { get; private set; }
		public LogicalLine ReturnAddress
		{
			get { return returnAddress; }
		}
		public bool IsEvent
		{
			get
			{
				return TopLabel.IsEvent;
			}
		}
		public bool HasSingleFlag
		{
			get
			{
				if (CurrentLabel == null)
					return false;
				return CurrentLabel.IsSingle;
			}
		}


		#region イベント関数専用
		public void ShiftNext()
		{
			while (true)
			{
				counter++;
				if (eventLabelList[group].Count > counter)
				{
					CurrentLabel = (eventLabelList[group])[counter];
					return;
				}
				group++;
				counter = -1;
				if (group >= 4)
				{
					CurrentLabel = null;
					return;
				}
			}
		}

		public void ShiftNextGroup()
		{
			counter = -1;
			group++;
			ShiftNext();
		}

        public void FinishEvent()
        {
            group = 4;
            counter = -1;
            CurrentLabel = null;
            return;
        }

        public bool IsOnly
        {
            get { return CurrentLabel.IsOnly; }
        }
		#endregion
	}
}
