﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameProc.Function;

namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		public Process(EmueraConsole view)
		{
			console = view;
		}

        public LogicalLine getCurrentLine { get { return state.CurrentLine; } }



		//public void PrintAnalysisWarning(string str, LogicalLine line, int level)
		//{
		//    console.PrintWarning(str, line.Position, level);
		//}

		/// <summary>
		/// @~~と$~~を集めたもの。CALL命令などで使う
		/// 実行順序はLogicalLine自身が保持する。
		/// </summary>
		LabelDictionary labelDic;
		public LabelDictionary LabelDictionary { get { return labelDic; } }

		/// <summary>
		/// 変数全部。スクリプト中で必要になる変数は（ユーザーが直接触れないものも含め）この中にいれる
		/// </summary>
		private VariableEvaluator vEvaluator;
		public VariableEvaluator VEvaluator { get { return vEvaluator; } }
		private ExpressionMediator exm;
		private GameBase gamebase;
		readonly EmueraConsole console;
		private IdentifierDictionary idDic;
		ProcessState state;
		ProcessState originalState;//リセットする時のために
        bool noError = false;

        public bool Initialize()
		{
            //isInitialized = false;
            state = new ProcessState(console);
            originalState = state;
            try
            {
				ParserMediator.Initialize(console);
                if (Config.UseKeyMacro && !Program.AnalysisMode)
                {
                    if (File.Exists(Program.ExeDir + "macro.txt"))
                    {
                        if (Config.DisplayReport)
                            console.PrintLine("macro.txt読み込み中・・・");
                        KeyMacro.LoadMacroFile(Program.ExeDir + "macro.txt");
                    }
                }
                if (Config.UseReplaceFile && !Program.AnalysisMode)
                {
					if (File.Exists(Program.CsvDir + "_Replace.csv"))
                    {
                        if (Config.DisplayReport)
                            console.PrintLine("_Replace.csv読み込み中・・・");
						ConfigData.Instance.LoadReplaceFile(Program.CsvDir + "_Replace.csv");
                    }
                }
                Config.SetReplace(ConfigData.Instance);
                //ここでBARを設定すれば、いいことに気づいた予感
                console.setStBar(Config.DrawLineString);

				if (Config.UseRenameFile)
                {
					if (File.Exists(Program.CsvDir + "_Rename.csv"))
                    {
                        if (Config.DisplayReport || Program.AnalysisMode)
                            console.PrintLine("_Rename.csv読み込み中・・・");
						ParserMediator.LoadEraExRenameFile(Program.CsvDir + "_Rename.csv");
                    }
                    else
                        console.PrintError("csv\\_Rename.csvが見つかりません");
                }
                if (!Config.DisplayReport)
                {
                    console.PrintLine(Config.LoadLabel);
                    console.RefreshStrings(true);
                }
				gamebase = new GameBase();
				gamebase.LoadGameBaseCsv(Program.CsvDir + "GAMEBASE.CSV");
				console.SetWindowTitle(gamebase.ScriptWindowTitle);
				GlobalStatic.GameBaseData = gamebase;

				ConstantData constant = new ConstantData(gamebase);
				constant.LoadData(Program.CsvDir, console, Config.DisplayReport);
				GlobalStatic.ConstantData = constant;

                vEvaluator = new VariableEvaluator(gamebase, constant);
				GlobalStatic.VEvaluator = vEvaluator;

				idDic = new IdentifierDictionary(vEvaluator.VariableData);
				GlobalStatic.IdentifierDictionary = idDic;

				StrForm.Initialize();
				VariableParser.Initialize();

				exm = new ExpressionMediator(this, vEvaluator, console);
				GlobalStatic.EMediator = exm;

				ErbLoader loader = new ErbLoader(console, exm, this);

				labelDic = new LabelDictionary();
				GlobalStatic.LabelDictionary = labelDic;

                if (Program.AnalysisMode)
                    noError = loader.loadErbs(Program.AnalysisFiles, labelDic);
                else
                    noError = loader.LoadErbFiles(Program.ErbDir, Config.DisplayReport, labelDic);
                initSystemProcess();

            }
            catch (CodeEE e)
            {
                System.Media.SystemSounds.Hand.Play();
                if (e.Position != null)
				{
					console.forceUpdateGeneration();
					console.PrintErrorButton(e.Position.Filename + "の" + e.Position.LineNo.ToString() + "行目でエラーが発生しました", "openFileWithDebug", e.Position);
					console.NewLine();
                    console.PrintError(e.Position.RowLine);
                }
                console.PrintError(e.Message);
                return false;
            }
            catch (Exception)
            {
                System.Media.SystemSounds.Hand.Play();
                console.PrintError("初期化中に致命的なエラーが発生しました");
                return false;
            }
			if (labelDic == null)
			{
				return false;
			}
            //isInitialized = true;
			state.Begin(BeginType.TITLE);
			GC.Collect();
            return true;
		}

		public void ReloadErb()
		{
			saveCurrentState(false);
			//state.ClearFunctionList();
			state.SystemState = SystemStateCode.System_Reloaderb;
            //isInitialized = false;
			//labelDic = null;
			ErbLoader loader = new ErbLoader(console, exm, this);
			//labelDic = new LabelDictionary();
            loader.LoadErbFiles(Program.ErbDir, false, labelDic);
            //isInitialized = true;
			console.ReadAnyKey();
		}

		public void ReloadPartialErb(List<string> path)
		{
			saveCurrentState(false);
			//state.ClearFunctionList();
			state.SystemState = SystemStateCode.System_Reloaderb;
            //isInitialized = false;
			ErbLoader loader = new ErbLoader(console, exm, this);
			loader.loadErbs(path, labelDic);
            //isInitialized = true;
			console.ReadAnyKey();
		}

		public void SetCommnds(Int64 count)
		{
			coms = new List<long>((int)count);
			isCTrain = true;
			Int64[] selectcom = vEvaluator.SELECTCOM_ARRAY;
			if (count >= selectcom.Length)
			{
				throw new CodeEE("CALLTRAIN命令の引数の値がSELECTCOMの要素数を超えています");
			}
			for (int i = 0; i < (int)count; i++)
			{
				coms.Add(selectcom[i + 1]);
			}
		}

		public void InputInteger(Int64 i)
		{
			vEvaluator.RESULT = i;
		}
		public void InputSystemInteger(Int64 i)
		{
			systemResult = i;
		}
		public void InputString(string s)
		{
			vEvaluator.RESULTS = s;
		}

        //private bool isInitialized = false;
		private uint startTime = 0;
		public void DoScript()
		{
			startTime = _Library.WinmmTimer.TickCount;
			state.lineCount = 0;
			while (true)
			{
				methodStack = 0;
				while (state.ScriptEnd && console.IsRunning)
					runSystemProcWithCatch();
				if (!console.IsRunning)
				{
					//    if (console.hasWaitRefresh || console.needRefresh)
					//        console.RefreshStrings(true);
					break;
				}
				runScriptProcWithCatch();
				//if (console.needRefresh)
				//    console.RefreshStrings(true);
			}
			return;
		}

		private void runSystemProcWithCatch()
		{
			try
			{
				runSystemProc();
			}
			catch (Exception e)
			{
                System.Media.SystemSounds.Hand.Play();
                if (e is CodeEE)
                    console.PrintError("関数の終端でエラーが発生しました");
				else if (e is ExeEE)
                    console.PrintError("関数の終端でEmueraのエラーが発生しました");
				else
                    console.PrintError("関数の終端で予期しないエラーが発生しました");
                console.PrintError(e.Message);
				console.ThrowError();
			}
		}

		public void BeginTitle()
		{
			vEvaluator.ResetData();
			state = originalState;
			state.Begin(BeginType.TITLE);
		}

		private void checkInfiniteLoop()
		{
            //lineCount++;
            ////WinmmTimerから時間を取得するのはそれ自体結構なコストがかかるので10000行に一回くらいで。
            //if (lineCount % 10000 != 0)
            //    return;
            //if (StaticConfig.InfiniteLoopAlertTime <= 0)
            //    return;

			//うまく動かない。BEEP音が鳴るのを止められないのでこの処理なかったことに（1.51）
			////フリーズ防止。処理中でも履歴を見たりできる
			//System.Windows.Forms.Application.DoEvents();
			////System.Threading.Thread.Sleep(0);

			//if (!console.Enabled)
			//{
			//    //DoEvents()の間にウインドウが閉じられたらおしまい。
			//    console.ReadAnyKey();
			//    return;
			//}
			uint time = _Library.WinmmTimer.TickCount - startTime;
			if (time < Config.InfiniteLoopAlertTime)
				return;
			LogicalLine currentLine = state.CurrentLine;
			if ((currentLine == null) || (currentLine is NullLine))
				return;//現在の行が特殊な状態ならスルー
			if (!console.Enabled)
				return;//クローズしてるとMessageBox.Showができないので。
			string caption = string.Format("無限ループの可能性があります");
			string text = string.Format(
				"現在、{0}の{1}行目を実行中です。\n最後の入力から{3}ミリ秒経過し{2}行が実行されました。\n処理を中断し強制終了しますか？",
				currentLine.Position.Filename, currentLine.Position.LineNo, state.lineCount, time);
			DialogResult result = MessageBox.Show(text, caption, MessageBoxButtons.YesNo);
			if (result == DialogResult.Yes)
			{
				throw new CodeEE("無限ループの疑いにより強制終了が選択されました");
			}
			else
			{
				state.lineCount = 0;
				startTime = _Library.WinmmTimer.TickCount;
			}
		}

		///DoScript()の一部。エラー処理が長くなったので分割。
		private void runScriptProcWithCatch()
		{
			try
			{
				runScriptProc();
				//checkInfiniteLoop();
			}
			catch (Exception ec)
			{
                System.Media.SystemSounds.Hand.Play();
				LogicalLine currentLine = state.ErrorLine;
				if ((currentLine == null) || (currentLine is NullLine))
					currentLine = null;
				ScriptPosition position = null;

                EmueraException ee = ec as EmueraException;
				if((ee != null) && (ee.Position != null))
					position = ee.Position;
                else if ((currentLine != null) && (currentLine.Position != null))
					position = currentLine.Position;
                console.UseUserStyle = false;
                console.PrintFlush(false);
                if(position != null)
				{
                    if (ec is CodeEE)//*.ERB等の問題と思われる例外
                    {
                        //console.PrintLine(currentLine.Position.Filename + "の" + currentLine.Position.LineNo.ToString() + "行目でエラーが発生しました");
                        console.forceUpdateGeneration();
						console.PrintErrorButton(position.Filename + "の" + position.LineNo.ToString() + "行目でエラーが発生しました", "openFileWithDebug", position);  
                        //console.NewLine();
                    }
                    else if (ec is ExeEE)//emuera.exe本体に起因すると思われる例外。バグ。
                        console.PrintError(position.Filename + "の" + position.LineNo.ToString() + "行目でEmuera.exeのエラーが発生しました");
                    else//SystemException。予期しない例外
                        console.PrintError(position.Filename + "の" + position.LineNo.ToString() + "行目で予期しないエラーが発生しました");
                    console.PrintError(position.RowLine);
				}
				else
				{
					if (ec is CodeEE)//*.ERB等の問題と思われる例外
                        console.PrintError("エラーが発生しました");
					else if (ec is ExeEE)//emuera.exe本体に起因すると思われる例外。バグ。
                        console.PrintError("Emuera.exeのエラーが発生しました");
					else//SystemException。予期しない例外
                        console.PrintError("予期しないエラーが発生しました");
                    console.PrintError("発生箇所を特定できませんでした");
				}
                if (ee != null)
                    console.PrintError(ee.Message);
                else//SystemException。エラー内容を知るためにはMessageよりむしろTypeの方が重要
                {
                    console.Print(ec.GetType().ToString() + ":" + ec.Message);
                    console.NewLine();
                    string[] stack = ec.StackTrace.Split('\n');
                    for (int i = 0; i < stack.Length; i++)
                    {
                        console.PrintLine(stack[i]);
                    }
                    console.PrintFlush(true);
                }
                console.ThrowError();
			}
			return;
		}

		int methodStack = 0;
		public SingleTerm GetValue(CalledFunction call, IOperandTerm[] args)
		{
			methodStack++;
            if (methodStack > 100)
            {
                //StackOverflowExceptionはcatchできない上に再現性がないので発生前に一定数で打ち切る。
                //環境によっては100以前にStackOverflowExceptionがでるかも？
                throw new CodeEE("関数の呼び出しスタックが溢れました(無限に再帰呼び出しされていませんか？)");
            }
            SingleTerm ret = null;
            int temp_current = state.currentMin;
            state.currentMin = state.functionCount;
            call.updateRetAddress(state.CurrentLine);
            try
            {
				//CalledFunction call = CalledFunction.CallFunctionMethod(this, funcname);
				//すでにcallFunctionは作成済みでチェックもできてるはず
				//if ((call == null) || (call.Count == 0) || (call.NextLine == null))
				//    throw new ExeEE("関数\"@" + call.FunctionName + "\"が見つかりません");
				//if (call.Count > 1)
				//    throw new ExeEE("関数\"@" + call.FunctionName + "\"の候補が複数返された");
                //ProcessState temp_state = state;
                //state = state.Clone();           
                state.IntoFunction(call, args, exm);
                //do whileの中でthrow されたエラーはここではキャッチされない。
				//#functionを全て抜けてrunScriptProcWithCatchでキャッチされる。
				//state = temp_state;が行われないため、エラー行は正しく判定される。
    			runScriptProc();
					//if (console.IsError)
					//    break;
					//命令の指定子がおかしくない限りここには絶対に来ない
					//if (!console.IsRunning && !console.RunERBFromMemory)
					//    throw new ExeEE("コンソール状態がRunningでない");//コンソール状態を変化させる命令は__METHOD_SAFE__を外しているはず
                ret = state.MethodReturnValue;
                //state = temp_state;
                //if (console.IsError)
				//{
				//    throw new CodeEE("関数@" + funcname + "の呼び出し中にエラーが発生しました");
				//}
			}
			finally
			{
                if (call.TopLabel.hasPrivVar)
                    call.TopLabel.Out();
                //1756beta2+v3:こいつらはここにないとデバッグコンソールで式中関数が事故った時に大事故になる
                state.currentMin = temp_current;
                methodStack--;
            }
			return ret;
		}

        public void clearMethodStack()
        {
            methodStack = 0;
        }

        public int MethodStack()
        {
            return methodStack;
        }

		public ScriptPosition GetRunningPosition()
		{
			LogicalLine line = state.ErrorLine;
			if (line == null)
				return null;
			return line.Position;
		}

		private readonly string scaningScope = null;
		private string GetScaningScope()
		{
			if (scaningScope != null)
				return scaningScope;
			return state.Scope;
		}

		public LogicalLine scaningLine = null;
		internal LogicalLine GetScaningLine()
		{
			if (scaningLine != null)
				return scaningLine;
			LogicalLine line = state.ErrorLine;
			if (line == null)
				return null;
			return line;
		}


	}
}
