#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <glib/gprintf.h>
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "../include/globals.h"
#include "../include/pdictype.h"
#include "../include/endictype.h"
#include "../include/data.h"

int bitcount(gchar c)
{
	if(!(c&0x80))return 0;
	if(!(c&0x40))return 1;
	if(!(c&0x20))return 2;
	if(!(c&0x10))return 3;
	if(!(c&0x08))return 4;
	if(!(c&0x04))return 5;
	if(!(c&0x02))return 6;
	if(!(c&0x01))return 7;
	return 8;
}

//////////////////////////////////////////////////////////////////
//ƥȥӥ塼ؤΥåν񤭹
void
settreeview(GtkWidget *widget,findword **fw)
{
	GtkTreeView *tview;
	GtkListStore *model;
	GtkTreeIter iter;
	gchar *lev;
	lev=g_strdup_printf("%d",(*fw)->level);
	
	//TreeModelõ
	tview=GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(widget),"dicview"));
	model=GTK_LIST_STORE(gtk_tree_view_get_model(tview));

	//ǽ֤
	gtk_list_store_append(GTK_LIST_STORE (model), &iter);
	//񤭹
	gtk_list_store_set (GTK_LIST_STORE (model),
									&iter, 0, (*fw)->key, 1 , lev, 2, (*fw)->direct, -1);
	g_free(lev);
}
//////////////////////////////////////////////////////////////////
//ӥ塼Υåꥢ
void
cleartreeview(GtkWidget *widget)
{
	GtkTreeView *tview;
	GtkTreeViewColumn *column;
	GtkListStore *model;
	
	//Ģõ
	tview=GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(widget),"dicview"));
	model=GTK_LIST_STORE(gtk_tree_view_get_model(tview));
	gtk_list_store_clear(model);

	column=gtk_tree_view_get_column(tview,2);
	gtk_tree_view_column_set_expand(column,TRUE);
	gtk_tree_view_column_set_fixed_width(column,2);
}
//////////////////////////////////////////////////////////////////
//ܥβ
void
on_btnsearch_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	const gchar *keyword;
	gint16 kbit,eixbit;
	gchar *k_sjis=NULL;
	guint32 count=1;
	GtkWidget *widget;
	GList *dl=NULL,*find=NULL,*fp;
	findword *fw;
	enindex *eix=NULL;

	//ƥȥȥ꡼õ
	widget=lookup_widget(GTK_WIDGET(button),"edkeyword");
	keyword=gtk_entry_get_text(GTK_ENTRY(widget));
	kbit=bitcount(keyword[0]);
	if(kbit){
		k_sjis=g_convert(keyword,strlen(keyword),"shift_jis","utf-8",
										NULL,NULL,NULL);
	}

	if(!strlen(keyword))
		return;

	//ǥåñ򸡺
	dl=g_list_first(indList);

	//Ⱦå
	while(dl){
		eix=dl->data;
		eixbit=bitcount(eix->word[0]);

		//ɤasciiλ
		if(kbit==0){
			//debug
			if(eixbit==0 && strcmp(keyword,eix->word)<=0){
				break;
			}else{
			}
		}
		else{
			if(strcmp(k_sjis,eix->word)<=0){
				break;
			}
		}
		dl=g_list_next(dl);
	}

	if(k_sjis)g_free(k_sjis);

	//dl  NULL ʤǸΥꥹ
	if(dl==NULL)
		dl=g_list_last(indList);
	else
		dl=g_list_previous(dl);

	//̤ξõ
	cleartreeview(GTK_WIDGET(button));

	do{
		eix=dl->data;

		//ޥåñ򸡺
		find=pdicDataRead(eix->h,eix->fp,eix->pos,find,(gchar*)keyword);

		//ޥåΤʤæ
		if(!find) break;

		//ɽ
		fp=g_list_first(find);
		while(fp){
			fw=(findword*)fp->data;
			settreeview(GTK_WIDGET(button),&fw);
			g_free(fw->key);
			g_free(fw->direct);
			fp=g_list_next(fp);
			count++;
		}
		g_list_free(find);
		find=NULL;fp=NULL;
		dl=g_list_next(dl);
	}while(dl);
}
//////////////////////////////////////////////////////////////////
//μΥǡ¤Τ֤
diclistitem *nowdiclistitem(void)
{
	GList *lp;
	diclistitem *item;

	lp=g_list_first(dicList);
	while(lp){
		item=(diclistitem*)(lp->data);
		if(item->h){
			return item;
		}
		lp=g_list_next(lp);
	}
	return NULL;
}
//////////////////////////////////////////////////////////////////
//ѹ
void
on_cmbdiclist_changed                  (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	gint entry;
	GtkComboBoxEntry *cmbdiclist;
	GList *lp;
	diclistitem *item;

	if(!dicloadflag) return;

	//ɤμФ줿Ĵ٤
	cmbdiclist= GTK_COMBO_BOX_ENTRY(combobox);
	entry=gtk_combo_box_get_active(combobox);

	//ɤ߹ޤƤ뼭Υ
	lp=g_list_first(dicList);
	while(lp){
		item=(diclistitem*)(lp->data);
		if(item->h){
			fclose(item->fp);
			ClearDictionary(&(item->h));
			item->h=NULL;
		}
		lp=g_list_next(lp);
	}
	
	//
	lp=g_list_nth(dicList,entry);
	item=(diclistitem*)(lp->data);

	item->h=g_new(newdic3,1);
	LoadDictionary(item->path,item->h,&(item->fp));
}
//////////////////////////////////////////////////////////////////
//
gboolean
on_edkeyword_key_press_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	gchar *keyword=NULL;
	GtkEntry *keyent; 
	
	
	if(event->keyval==GDK_Return){
		//ܥ󲡲٥Ȥ򥳡
		on_btnsearch_clicked(
			GTK_BUTTON(lookup_widget(GTK_WIDGET(widget),"btnsearch")),
			NULL);
	}
	else if(event->keyval==GDK_Tab){
		//䴰
		
		//ʸμ
		keyent=GTK_ENTRY(lookup_widget(GTK_WIDGET(widget),"edkeyword"));
		keyword=(gchar*)gtk_entry_get_text(keyent);

	}
	return FALSE;
}
//////////////////////////////////////////////////////////////////
//ץꥱνλ
void
on_dickeyword_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit();
}
//////////////////////////////////////////////////////////////////
//ɽ
void
on_btnInfo_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *wig;
	gchar *str=NULL,*str2;
	diclistitem *item;
	newdic3 *nd3;

	//󥦥ɥ
	dicinfo = create_dicinfodialog ();

	//Ͽ٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbEntryDics"));
	str=g_strdup_printf("%d",g_list_length(dicList));
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);
	//եѥ٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbShareEndicrc"));
	str=g_strdup_printf("%s/endicrc",PACKAGE_DATA_DIR);
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);
	//Ŀͥեѥ٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbPersonalEndicrc"));
	str=g_strdup_printf("%s/.endicrc",g_getenv("HOME"));
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);

	//ǥå٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbNowDicIndexCount"));
	//ǥåʸѴ
	str=g_strdup_printf("%d",g_list_length(indList));
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);

	//ߤμ
	item=nowdiclistitem();
	//С٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbNowDicVersion"));
	//СֹʸѴ
	nd3=item->h;
	str=g_strdup_printf("%d.%d",(nd3->version>>8),(nd3->version&0xff));
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);
	//ÿ٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbWordCount"));
	str=g_strdup_printf("%ld",nd3->nword);
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);
	//иϿ٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbDicOrder"));
	switch(nd3->dicorder){
		case 0: str=g_strdup("ɽ");break;
		case 1: str=g_strdup("羮ʸƱ");break;
		case 2: str=g_strdup("");break;
		case 3: str=g_strdup("ս");break;
		default: str=g_strdup("");
	}
	str2=g_convert(str,strlen(str),"utf-8","euc-jp",NULL,NULL,NULL);
	gtk_label_set_text(GTK_LABEL(wig),str2);
	g_free(str);
	g_free(str2);
	//°٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbDicTypes"));
	str=g_strnfill(256,0);
	if(nd3->dictype & 0x01) g_strlcat(str," AR",255);
	if(nd3->dictype & 0x02) g_strlcat(str," ¿",255);
	if(nd3->dictype & 0x04) g_strlcat(str," Ź沽",255);
	if(nd3->dictype & 0x08) g_strlcat(str," ĥ꡼",255);
	if(str[0]==0)g_strlcat(str,"ʤ",255);
	str2=g_convert(str,strlen(str),"utf-8","euc-jp",NULL,NULL,NULL);
	gtk_label_set_text(GTK_LABEL(wig),str2);
	g_free(str);
	g_free(str2);
	//٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbUpdateCount"));
	str=g_strdup_printf("%d",nd3->update_count);
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);
	//٥θ
	wig=GTK_WIDGET(lookup_widget(GTK_WIDGET(dicinfo),"LbExtheader"));
	str=g_strdup_printf("%d",nd3->extheader);
	gtk_label_set_text(GTK_LABEL(wig),str);
	g_free(str);

	gtk_widget_show (dicinfo);
	
}
//////////////////////////////////////////////////////////////////
//
void
on_btnClose_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(dicinfo);
}

