#include <string.h>
#include <stdio.h>
#include <glib.h>

#include "../include/globals.h"
#include "../include/loaddic.h"
#include "../include/pdictype.h"
#include "../include/endictype.h"
#include "../include/index.h"
#include "../include/header.h"

///////////////////////////////////////////////////////////////////////////
//
GList* LoadIniFile(gchar *inifile,GList *dlist)
{
	int out=0;
	gsize leng;
	diclistitem *item;
	gchar *line,**lines,**load;
	GIOChannel *gioc=NULL;
	
	//եǥץκ
	gioc=g_io_channel_unix_new(out);
	gioc=g_io_channel_new_file(inifile,"r",NULL);

	//ʾν
	if(gioc==NULL) return NULL;
	
	while(1){	
		//ɤ߹	
		if(g_io_channel_read_line(
														gioc,
														&line,
														&leng,
														NULL,NULL)
			!=G_IO_STATUS_NORMAL){
				//
				break;
		}
		//ȥߥ
		g_strstrip(line);

		if(line[0]=='#'){
			g_free(line);
			continue;//Ƚ
		}
		//ͤ
		//
		//ޥ=
		//
		lines=g_strsplit(line,"=",2);																		
		//ɤ߹Ѥ˻Ȥälineѿ
		g_free(line);
		//ζ
		g_strstrip(lines[0]);
		g_strstrip(lines[1]);

		//
		//ե
		//
		if(!strcmp(lines[0],"load")){
			//ɤ߹
			item=g_new(diclistitem,1);
			load=g_strsplit(lines[1],":",2);
			//̾
			item->dicname=g_strdup(load[0]);
			//եѥ
			item->path=g_strdup(load[1]);
			item->h=g_new(newdic3,1);
			LoadDictionary(item->path,item->h,&(item->fp));
			dlist=g_list_append(dlist,item);
			g_strfreev(load);
		}
		//ȥ꡼Τ
		else if(!strcmp(lines[0],"entry")){
			//ɤ߹
			item=g_new(diclistitem,1);
			load=g_strsplit(lines[1],":",2);
			//̾
			item->dicname=g_strdup(load[0]);
			//եѥ
			item->path=g_strdup(load[1]);
			item->h=NULL;
			item->fp=0;
			dlist=g_list_append(dlist,item);
			g_strfreev(load);
		}
		g_strfreev(lines);
	}
	//եĤ
	g_io_channel_shutdown(gioc,TRUE,NULL);

	dlist=g_list_first(dlist);
	return (GList*)dlist;
}
///////////////////////////////////////////////////////////////////////////
//ɤ߹
int LoadDictionary(gchar *dicfile,newdic3 *h,FILE **filep)
{
	//
	//եǥץϥץ󤷤ޤޤˤ롣
	//ǥץ󤷤եΥǥץ
	//dicList ˳Ǽ빽¤Ρdiclistitemΰ˰Ѥ롣
	//
	FILE *fp;

	if((fp=fopen(dicfile,"rb"))==NULL){
		return -1;
	}
	pdicHeaderLoad(fp,h);
	indList=pdicMakeIndexList(h,fp,indList);

	*filep=fp;

	return g_list_length(indList);
}
///////////////////////////////////////////////////////////////////////////
//¤ΤΥꥢ
void ClearDictionary(newdic3 **h)
{
	//إåΥꥢ
	g_free(*h);
	*h=NULL;
	//ǥåꥹȤΥꥢ
	pdicClearIndexList(&indList);
}
