/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpiringDirectory<K, V>
implements Iterable<Map.Entry<K, V>> {
    private static final Logger logger = Logger.getLogger("map");
    protected long defaultTTL;
    protected long checkInterval;
    private Iterable<Map.Entry<K, ExpiringValue<V>>> iterable;
    private static Timer timer;
    private TimerTask task = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractExpiringDirectory(Iterable<Map.Entry<K, ExpiringValue<V>>> directory, long defaultTTL, long checkInterval) {
        this.iterable = directory;
        this.defaultTTL = defaultTTL;
        this.checkInterval = checkInterval;
        Class<AbstractExpiringDirectory> clazz = AbstractExpiringDirectory.class;
        synchronized (AbstractExpiringDirectory.class) {
            if (timer == null && this.checkInterval > 0L) {
                timer = new Timer("A Timer in ExpiringDirectory", true);
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            this.startExpiringDaemon();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExpiringDaemon() {
        if (this.checkInterval <= 0L) {
            logger.log(Level.INFO, "Expiring interval is less than 0 and no expiring daemon started: " + this.checkInterval);
            return;
        }
        AbstractExpiringDirectory abstractExpiringDirectory = this;
        synchronized (abstractExpiringDirectory) {
            this.stopExpiringDaemon();
            this.task = new ExpiringTask(this, this.iterable);
            timer.schedule(this.task, this.checkInterval, this.checkInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopExpiringDaemon() {
        AbstractExpiringDirectory abstractExpiringDirectory = this;
        synchronized (abstractExpiringDirectory) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        AbstractExpiringDirectory abstractExpiringDirectory = this;
        synchronized (abstractExpiringDirectory) {
            Iterable<Map.Entry<K, ExpiringValue<V>>> iterable = this.iterable;
            synchronized (iterable) {
                for (Map.Entry<K, V> entry : this) {
                    result.add(entry);
                }
            }
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new ExpiringDirIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExpiringDirEntry
    implements Map.Entry<K, V> {
        K k;
        V v;
        ExpiringDirIterator it = null;

        ExpiringDirEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        ExpiringDirEntry(ExpiringDirIterator it, K k, V v) {
            this.it = it;
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V newValue) {
            Object ret = this.v;
            if (this.it != null) {
                this.it.currentEntry.setValue(new ExpiringValue(newValue, AbstractExpiringDirectory.this.defaultTTL));
            }
            return ret;
        }

        public String toString() {
            return this.k + "=" + this.v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpiringDirIterator
    implements Iterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<K, ExpiringValue<V>>> it;
        Map.Entry<K, ExpiringValue<V>> currentEntry;
        ExpiringDirEntry ret;

        ExpiringDirIterator() {
            this.it = AbstractExpiringDirectory.this.iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry internalEntry = this.it.next();
            return new ExpiringDirEntry(this, internalEntry.getKey(), internalEntry.getValue().getValue());
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpiringTask
    extends TimerTask {
        AbstractExpiringDirectory<K, V> dir;
        Iterable<Map.Entry<K, ExpiringValue<V>>> iterable;

        ExpiringTask(AbstractExpiringDirectory<K, V> dir, Iterable<Map.Entry<K, ExpiringValue<V>>> iterable) {
            this.dir = dir;
            this.iterable = iterable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            AbstractExpiringDirectory abstractExpiringDirectory = this.dir;
            synchronized (abstractExpiringDirectory) {
                Iterable iterable = this.iterable;
                synchronized (iterable) {
                    Iterator it = this.iterable.iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        long expiringTime = e.getValue().getExpiringTime();
                        if (currentTime <= expiringTime) continue;
                        it.remove();
                    }
                }
            }
        }
    }
}

