/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.hashmap;

import java.io.File;
import ow.directory.Directory;
import ow.directory.DirectoryProvider;
import ow.directory.DupDirectory;
import ow.directory.hashmap.HashDirectory;
import ow.directory.hashmap.HashDupDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMapProvider
extends DirectoryProvider {
    private static final String NAME = "PersistentMap";
    private static final int SYNC_INTERVAL = 3000;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public <K, V> Directory<K, V> openDirectory(Class typeK, Class typeV, String dir, String dbName) throws Exception {
        return new HashDirectory(typeK, typeV, dir, dbName, PersistentMapProvider.getBackupFilename(dbName), 3000L);
    }

    @Override
    public <K, V> DupDirectory<K, V> openDupDirectory(Class typeK, Class typeV, String dir, String dbName) throws Exception {
        return new HashDupDirectory(typeK, typeV, dir, dbName, PersistentMapProvider.getBackupFilename(dbName), 3000L);
    }

    @Override
    public void removeDirectory(String dir, String dbName) throws Exception {
        File dbFile = new File(dir + dbName);
        File backupFile = new File(dir + PersistentMapProvider.getBackupFilename(dbName) + ".old");
        dbFile.delete();
        backupFile.delete();
    }

    private static String getBackupFilename(String name) {
        return name + ".old";
    }
}

