/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.messaging.udp.SocketPool;
import ow.messaging.udp.UDPMessageSender;
import ow.messaging.udp.UDPMessagingAddress;
import ow.messaging.udp.UDPMessagingConfiguration;
import ow.messaging.udp.UDPMessagingMessageFactory;
import ow.messaging.udp.UDPMessagingProvider;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.StatCollectorFactory;
import ow.msgstat.StatReporter;

public final class UDPMessageReceiver
implements MessageReceiver,
Runnable {
    private static final Logger logger = Logger.getLogger("messaging");
    private UDPMessagingAddress selfAddr;
    protected DatagramChannel sock;
    private UDPMessagingConfiguration config;
    private UDPMessagingProvider provider;
    private UDPMessageSender sender;
    private SocketPool sockPool;
    private Thread receiverThread;
    private Set<Thread> handlerThreads = Collections.synchronizedSet(new HashSet());
    private List<MessageHandler> handlerList = Collections.synchronizedList(new ArrayList());
    private final StatReporter statReporter;
    private Thread holePunchingDaemon = null;
    private final boolean doHolePunching;
    private int punchingRetry;
    private boolean firstPunchingDone = false;
    private boolean firstPunchingOnGoing = false;
    private Object firstPunchingLock = new Object();
    protected UDPMessagingAddress lastSendDest = null;
    private long lastSendTime = 0L;
    private Object punchingLock = new Object();
    private volatile boolean punchReplyReceived;

    protected UDPMessageReceiver(InetAddress selfInetAddr, int port, int portRange, UDPMessagingConfiguration config, UDPMessagingProvider provider) throws IOException {
        this.config = config;
        this.provider = provider;
        this.sock = DatagramChannel.open();
        if (selfInetAddr == null) {
            selfInetAddr = InetAddress.getLocalHost();
        }
        DatagramSocket s = this.sock.socket();
        boolean bound = false;
        if (portRange <= 0) {
            portRange = 1;
        }
        for (int i = 0; i < portRange; ++i) {
            this.selfAddr = new UDPMessagingAddress(selfInetAddr, port + i);
            try {
                s.bind(this.selfAddr.getInetSocketAddress());
                bound = true;
                break;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (!bound) {
            logger.log(Level.SEVERE, "Could not bind to " + this.selfAddr.getInetSocketAddress() + "." + " Specify self hostname with -s option.");
            throw new IOException("Bind failed: " + this.selfAddr.getInetSocketAddress());
        }
        this.sockPool = new SocketPool(config.getSocketPoolSize());
        StatCollectorConfiguration conf = StatCollectorFactory.getDefaultConfiguration();
        this.statReporter = StatCollectorFactory.getStatReporter(conf, provider, this.getSender());
        this.sender = (UDPMessageSender)this.getSender(true);
        this.doHolePunching = this.config.getDoUDPHolePunching();
        this.punchingRetry = this.config.getPunchingRetry();
    }

    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    public int getPort() {
        return this.selfAddr.getPort();
    }

    public StatReporter getStatReporter() {
        return this.statReporter;
    }

    public MessageSender getSender() {
        return this.getSender(false);
    }

    private MessageSender getSender(boolean forReceiver) {
        return new UDPMessageSender(this.sockPool, this.provider, this, this.statReporter, forReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            if (this.receiverThread == null) {
                this.receiverThread = new Thread(this);
                this.receiverThread.setDaemon(true);
                this.receiverThread.setName("UDPMessageReceiver");
                this.receiverThread.setPriority(Thread.currentThread().getPriority() + 1);
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            if (this.receiverThread != null) {
                this.receiverThread.interrupt();
                this.receiverThread = null;
            }
        }
        Thread[] handlerArray = new Thread[this.handlerThreads.size()];
        this.handlerThreads.toArray(handlerArray);
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].interrupt();
        }
        this.handlerThreads.clear();
        UDPMessageReceiver uDPMessageReceiver2 = this;
        synchronized (uDPMessageReceiver2) {
            if (this.holePunchingDaemon != null) {
                this.holePunchingDaemon.interrupt();
                this.holePunchingDaemon = null;
            }
        }
        this.statReporter.notifyStatCollectorOfDeletedNode(new IDAddressPair(null, this.selfAddr), this.selfAddr, -1);
    }

    public void addHandler(MessageHandler handler) {
        this.handlerList.add(handler);
    }

    public void removeHandler(MessageHandler handler) {
        this.handlerList.remove(handler);
    }

    public void run() {
        ByteBuffer buf = ByteBuffer.allocate(UDPMessageSender.MAX_MSG_SIZE);
        InetSocketAddress srcAddr = null;
        while (true) {
            Message msg;
            buf.clear();
            try {
                srcAddr = (InetSocketAddress)this.sock.receive(buf);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "DatagramSocket#receive() threw an Exception and the receiver will die.");
                return;
            }
            buf.rewind();
            logger.log(Level.INFO, "Source address: " + srcAddr);
            try {
                msg = Message.decode(buf);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not decode the received message (corrupted ?).", e);
                continue;
            }
            byte[] acceptableSig = this.provider.getMessageSignature();
            byte[] sig = msg.getSignature();
            if (!Signature.match(sig, acceptableSig)) continue;
            UDPMessageHandler r = new UDPMessageHandler(srcAddr, msg);
            if (this.config.getUseThreadPool()) {
                this.provider.getThreadPool().submit(r);
                continue;
            }
            Thread thr = new Thread(r);
            thr.setDaemon(false);
            thr.setName("UDPMessageHandler: " + srcAddr);
            this.handlerThreads.add(thr);
            thr.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean isFirstPunchingDone() {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            return this.firstPunchingDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beginFirstPunching() {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            if (this.punchingRetry <= 0) {
                return false;
            }
            --this.punchingRetry;
            while (this.firstPunchingOnGoing) {
                try {
                    this.firstPunchingLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.firstPunchingDone) {
                return false;
            }
            this.firstPunchingOnGoing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFirstPunching(boolean success) {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            this.firstPunchingOnGoing = false;
            this.firstPunchingDone = success;
            this.firstPunchingLock.notifyAll();
        }
    }

    protected void setLastSend(UDPMessagingAddress dest) {
        this.lastSendDest = dest;
        if (this.isFirstPunchingDone()) {
            this.lastSendTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void punchHole() {
        long interval;
        if (!this.doHolePunching) {
            return;
        }
        if (this.lastSendDest == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (curTime < this.lastSendTime + (interval = this.config.getPunchingInterval())) {
            return;
        }
        Message reqMsg = UDPMessagingMessageFactory.getPunchHoleReqMessage(new IDAddressPair(null, this.selfAddr));
        Object object = this.punchingLock;
        synchronized (object) {
            this.punchReplyReceived = false;
            try {
                this.sender.send(this.lastSendDest, reqMsg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not send an PUNCH_HOLE_REQ message for UDP hole punching: " + this.lastSendDest + " on " + this.selfAddr, e);
                return;
            }
            if (!this.punchReplyReceived) {
                try {
                    this.punchingLock.wait(this.config.getPunchingRepTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.endFirstPunching(this.punchReplyReceived);
            if (!this.punchReplyReceived) {
                logger.log(Level.WARNING, "Could not receive an PUNCH_HOLE_REP message for UDP hole punching: " + this.lastSendDest + " on " + this.selfAddr);
            }
        }
    }

    private class UDPHolePunchingDaemon
    implements Runnable {
        private UDPHolePunchingDaemon() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(UDPMessageReceiver.this.config.getPunchingCheckInterval());
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "UDPHolePunchingDaemon interrupted and die.", e);
                    break;
                }
                if (Thread.interrupted()) break;
                UDPMessageReceiver.this.punchHole();
            }
        }
    }

    private class UDPMessageHandler
    implements Runnable {
        private InetSocketAddress srcAddr;
        private Message msg;

        UDPMessageHandler(InetSocketAddress srcAddress, Message message) {
            this.srcAddr = srcAddress;
            this.msg = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block25: {
                Serializable[] contents;
                Object src;
                int tag = this.msg.getTag();
                Message ret = null;
                if (tag == Tag.PUNCH_HOLE_REQ.getNumber()) {
                    src = UDPMessageReceiver.this.provider.getMessagingAddress(this.srcAddr);
                    ret = UDPMessagingMessageFactory.getPunchHoleRepMessage(new IDAddressPair(null, UDPMessageReceiver.this.selfAddr), (UDPMessagingAddress)src);
                } else if (tag == Tag.PUNCH_HOLE_REP.getNumber()) {
                    src = UDPMessageReceiver.this.punchingLock;
                    synchronized (src) {
                        UDPMessageReceiver.this.punchReplyReceived = true;
                        UDPMessageReceiver.this.punchingLock.notifyAll();
                    }
                    if (UDPMessageReceiver.this.doHolePunching) {
                        contents = this.msg.getContents();
                        UDPMessagingAddress selfExteriorAddress = (UDPMessagingAddress)contents[0];
                        logger.log(Level.INFO, "UDP hole punching: self exterior address is " + selfExteriorAddress);
                        if (selfExteriorAddress.equals(UDPMessageReceiver.this.selfAddr)) {
                            logger.log(Level.INFO, "UDP hole punching was *not* required.");
                        } else {
                            UDPMessageReceiver.this.selfAddr = selfExteriorAddress;
                            UDPMessageReceiver uDPMessageReceiver = UDPMessageReceiver.this;
                            synchronized (uDPMessageReceiver) {
                                if (UDPMessageReceiver.this.holePunchingDaemon == null) {
                                    logger.log(Level.INFO, "UDP hole punching is required.");
                                    UDPHolePunchingDaemon r = new UDPHolePunchingDaemon();
                                    UDPMessageReceiver.this.holePunchingDaemon = new Thread(r);
                                    UDPMessageReceiver.this.holePunchingDaemon.setName("UDPHolePunchingDaemon");
                                    UDPMessageReceiver.this.holePunchingDaemon.setDaemon(true);
                                    UDPMessageReceiver.this.holePunchingDaemon.start();
                                }
                            }
                        }
                    }
                } else {
                    contents = UDPMessageReceiver.this.handlerList;
                    synchronized (contents) {
                        for (MessageHandler handler : UDPMessageReceiver.this.handlerList) {
                            try {
                                ret = handler.process(this.msg);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                            }
                        }
                    }
                }
                if (ret != null) {
                    logger.log(Level.INFO, "Return a message.");
                    src = this.msg.getSource() != null ? this.msg.getSource().getAddress() : null;
                    try {
                        UDPMessageReceiver.this.sender.send(UDPMessageReceiver.this.sock, this.srcAddr, (MessagingAddress)src, ret, true);
                        if (src != null) {
                            UDPMessageReceiver.this.statReporter.notifyStatCollectorOfMessageSent((MessagingAddress)src, ret);
                        }
                        break block25;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not return a message.");
                        if (src != null) {
                            UDPMessageReceiver.this.statReporter.notifyStatCollectorOfDeletedNode(ret.getSource(), (MessagingAddress)src, ret.getTag());
                        }
                        break block25;
                    }
                }
                logger.log(Level.INFO, "Return no message.");
            }
            UDPMessageReceiver.this.handlerThreads.remove(Thread.currentThread());
        }
    }
}

