/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.msgstat.StatReporter;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingResult;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;
import ow.routing.impl.RecursiveRoutingDriver;
import ow.routing.impl.RoutingDriverMessageFactory;

public final class RecursiveRoutingDriver
extends AbstractRoutingDriver {
    private static final int TAG_NULL = -1;
    private Map<ID, Message> routeResultMsgTable = Collections.synchronizedMap(new HashMap());

    protected RecursiveRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, ExecutorService threadPool, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        super(conf, provider, receiver, threadPool, algoConf, selfID);
        this.prepareHandlers();
    }

    public RoutingResult routeToRootNode(ID target, int numNeighbors) {
        return this.routeOrJoin(true & this.adjustRoot, null, Tag.REC_ROUTE_NONE, target, numNeighbors, null, -1, null, null);
    }

    public RoutingResult routeToClosestNode(ID target, int numNeighbors) {
        return this.routeOrJoin(false, null, Tag.REC_ROUTE_NONE, target, numNeighbors, null, -1, null, null);
    }

    public RoutingResult invokeCallbacksOnRoute(ID target, int numNeighbors, Serializable[] returnedValueContainer, CallbackResultFilter filter, int tag, Serializable[] args) {
        return this.routeOrJoin(true & this.adjustRoot, returnedValueContainer, Tag.REC_ROUTE_INVOKE, target, numNeighbors, filter, tag, args, null);
    }

    public RoutingResult join(MessagingAddress initialContact) {
        RoutingResult res = this.routeOrJoin(true & this.adjustRoot, null, Tag.REC_ROUTE_JOIN, this.getSelfIDAddressPair().getID(), this.config.getNumOfNeighborsRequestedWhenJoining(), null, -1, null, initialContact);
        this.algorithm.join(res.getNeighbors());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoutingResult routeOrJoin(boolean adjustLastHop, Serializable[] resultingCallbackResult, Tag msgType, ID dest, int numNeighbors, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, MessagingAddress joinInitialContact) {
        IDAddressPair[] closestNodes;
        RoutingContext initialRoutingContext;
        Serializable callbackResult = null;
        IDAddressPair[] blackList = new IDAddressPair[]{};
        if (numNeighbors < 1) {
            numNeighbors = 1;
        }
        if (msgType != Tag.REC_ROUTE_JOIN) {
            StatReporter statReporter = this.receiver.getStatReporter();
            statReporter.notifyStatCollectorOfEmphasizeNode(this.getSelfIDAddressPair(), this.getSelfIDAddressPair().getID());
            statReporter.notifyStatCollectorOfMarkedID(this.getSelfIDAddressPair(), dest, 0);
        }
        IDAddressPair[] initialRoute = new IDAddressPair[]{this.getSelfIDAddressPair()};
        if (msgType == Tag.REC_ROUTE_NONE || msgType == Tag.REC_ROUTE_INVOKE) {
            initialRoutingContext = this.algorithm.initialRoutingContext(dest);
            closestNodes = this.algorithm.closestTo(dest, this.config.getNumOfClosestNodesRequested(), initialRoutingContext);
        } else {
            initialRoutingContext = null;
            closestNodes = new IDAddressPair[]{new IDAddressPair(null, joinInitialContact)};
        }
        Map<ID, Message> map = this.routeResultMsgTable;
        synchronized (map) {
            Message nullMsg = new Message(null, -1, new Serializable[0]);
            this.routeResultMsgTable.put(dest, nullMsg);
        }
        boolean sent = this.forwardOrReturnResult(adjustLastHop, true, msgType.getNumber(), null, closestNodes, initialRoutingContext, dest, numNeighbors, this.getSelfIDAddressPair(), this.config.getTTL(), filter, callbackTag, callbackArgs, initialRoute, blackList);
        if (sent) {
            Message resultMsg = null;
            Map<ID, Message> map2 = this.routeResultMsgTable;
            synchronized (map2) {
                while ((resultMsg = this.routeResultMsgTable.get(dest)) == null || resultMsg.getTag() == -1) {
                    try {
                        this.routeResultMsgTable.wait(this.config.getRoutingTimeout());
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "RoutingService#wait() interrupted.", e);
                    }
                }
                resultMsg = this.routeResultMsgTable.remove(dest);
            }
            if (resultMsg != null) {
                Serializable[] contents = resultMsg.getContents();
                ID target = (ID)contents[1];
                RoutingResult res = (RoutingResult)contents[2];
                callbackResult = contents[3];
                IDAddressPair[] route = res.getRoute();
                IDAddressPair selfIDAddress = this.getSelfIDAddressPair();
                for (IDAddressPair p : route) {
                    if (p == null || selfIDAddress.equals(p)) break;
                    this.algorithm.touch(p);
                }
                if (resultingCallbackResult != null) {
                    resultingCallbackResult[0] = callbackResult;
                }
                if (target.equals(dest)) {
                    return res;
                }
                logger.log(Level.INFO, "Received REC_RESULT message is not for the target: " + dest);
            } else {
                logger.log(Level.INFO, "Could not receive a REC_RESULT message within " + this.config.getRoutingTimeout() + " msec.");
            }
        }
        IDAddressPair[] route = new IDAddressPair[]{this.getSelfIDAddressPair()};
        IDAddressPair[] neighbors = this.algorithm.neighbors(numNeighbors);
        return new RoutingResult(route, neighbors);
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                class ARouter
                implements Runnable {
                    Message msg;
                    final /* synthetic */ RecursiveRoutingDriver this$0;

                    ARouter(RecursiveRoutingDriver recursiveRoutingDriver, Message msg) {
                        this.this$0 = recursiveRoutingDriver;
                        this.msg = msg;
                    }

                    public void run() {
                        boolean forward;
                        IDAddressPair[] route;
                        IDAddressPair initiator;
                        ID target;
                        IDAddressPair[] blackList;
                        int numNeighbors = 1;
                        RoutingContext routingContext = null;
                        int ttl = -1;
                        boolean adjustLastHop = false;
                        CallbackResultFilter filter = null;
                        int callbackTag = -1;
                        Serializable[] callbackArgs = null;
                        Serializable[] contents = this.msg.getContents();
                        if (this.msg.getTag() == Tag.REC_ROUTE_NONE.getNumber()) {
                            blackList = (IDAddressPair[])contents[0];
                            target = (ID)contents[1];
                            numNeighbors = (Integer)contents[2];
                            routingContext = (RoutingContext)contents[3];
                            initiator = (IDAddressPair)contents[4];
                            ttl = (Integer)contents[5];
                            adjustLastHop = (Boolean)contents[6];
                            route = (IDAddressPair[])contents[7];
                            forward = true;
                        } else if (this.msg.getTag() == Tag.REC_ROUTE_INVOKE.getNumber()) {
                            blackList = (IDAddressPair[])contents[0];
                            target = (ID)contents[1];
                            numNeighbors = (Integer)contents[2];
                            routingContext = (RoutingContext)contents[3];
                            initiator = (IDAddressPair)contents[4];
                            ttl = (Integer)contents[5];
                            adjustLastHop = (Boolean)contents[6];
                            filter = (CallbackResultFilter)contents[7];
                            callbackTag = (Integer)contents[8];
                            callbackArgs = (Serializable[])contents[9];
                            route = (IDAddressPair[])contents[10];
                            forward = true;
                        } else if (this.msg.getTag() == Tag.REC_ROUTE_JOIN.getNumber()) {
                            blackList = (IDAddressPair[])contents[0];
                            initiator = (IDAddressPair)contents[1];
                            target = initiator.getID();
                            numNeighbors = (Integer)contents[2];
                            routingContext = (RoutingContext)contents[3];
                            ttl = (Integer)contents[4];
                            adjustLastHop = (Boolean)contents[5];
                            route = (IDAddressPair[])contents[6];
                            forward = true;
                        } else if (this.msg.getTag() == Tag.REC_NONE.getNumber()) {
                            blackList = (IDAddressPair[])contents[0];
                            target = (ID)contents[1];
                            numNeighbors = (Integer)contents[2];
                            initiator = (IDAddressPair)contents[3];
                            route = (IDAddressPair[])contents[4];
                            forward = false;
                        } else if (this.msg.getTag() == Tag.REC_INVOKE.getNumber()) {
                            blackList = (IDAddressPair[])contents[0];
                            target = (ID)contents[1];
                            numNeighbors = (Integer)contents[2];
                            initiator = (IDAddressPair)contents[3];
                            filter = (CallbackResultFilter)contents[4];
                            callbackTag = (Integer)contents[5];
                            callbackArgs = (Serializable[])contents[6];
                            route = (IDAddressPair[])contents[7];
                            forward = false;
                        } else {
                            blackList = (IDAddressPair[])contents[0];
                            initiator = (IDAddressPair)contents[1];
                            target = initiator.getID();
                            numNeighbors = (Integer)contents[2];
                            route = (IDAddressPair[])contents[3];
                            forward = false;
                        }
                        IDAddressPair[] lastRoute = route;
                        route = new IDAddressPair[lastRoute.length + 1];
                        System.arraycopy(lastRoute, 0, route, 0, lastRoute.length);
                        route[route.length - 1] = this.this$0.getSelfIDAddressPair();
                        if (ttl <= 0) {
                            forward = false;
                        }
                        for (IDAddressPair p : blackList) {
                            AbstractRoutingDriver.logger.log(Level.INFO, "REC_*calls fail: " + p.getAddress() + " on " + this.this$0.getSelfIDAddressPair().getAddress());
                            this.this$0.fail(p);
                        }
                        if (routingContext == null) {
                            routingContext = this.this$0.algorithm.initialRoutingContext(target);
                        }
                        IDAddressPair[] closestNodes = null;
                        if (forward) {
                            closestNodes = this.this$0.algorithm.closestTo(target, this.this$0.config.getNumOfClosestNodesRequested(), routingContext);
                        }
                        RecursiveRoutingDriver.access$000(this.this$0, adjustLastHop, forward, this.msg.getTag(), this.msg.getSource(), closestNodes, routingContext, target, numNeighbors, initiator, ttl, filter, callbackTag, callbackArgs, route, blackList);
                    }
                }
                ARouter r = new ARouter(RecursiveRoutingDriver.this, msg);
                if (RecursiveRoutingDriver.this.config.getUseThreadPool()) {
                    RecursiveRoutingDriver.this.threadPool.submit(r);
                } else {
                    Thread thr = new Thread(r);
                    thr.setName("A message handler");
                    thr.setDaemon(true);
                    thr.start();
                }
                return RoutingDriverMessageFactory.getRecAckMessage(RecursiveRoutingDriver.this.getSelfIDAddressPair());
            }
        };
        this.addMessageHandler(Tag.REC_ROUTE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_JOIN.getNumber(), handler);
        this.addMessageHandler(Tag.REC_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_JOIN.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                IDAddressPair[] blackList = (IDAddressPair[])contents[0];
                ID target = (ID)contents[1];
                Map map = RecursiveRoutingDriver.this.routeResultMsgTable;
                synchronized (map) {
                    Message nullMsg = (Message)RecursiveRoutingDriver.this.routeResultMsgTable.get(target);
                    if (nullMsg != null && nullMsg.getTag() == -1) {
                        RecursiveRoutingDriver.this.routeResultMsgTable.put(target, msg);
                        RecursiveRoutingDriver.this.routeResultMsgTable.notify();
                    }
                }
                for (IDAddressPair p : blackList) {
                    AbstractRoutingDriver.logger.log(Level.INFO, "REC_RESULT calls fail: " + p.getAddress() + " on " + RecursiveRoutingDriver.this.getSelfIDAddressPair().getAddress());
                    RecursiveRoutingDriver.this.fail(p);
                }
                return null;
            }
        };
        this.addMessageHandler(Tag.REC_RESULT.getNumber(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forwardOrReturnResult(boolean adjustLastHop, boolean forward, int oldMsgTag, IDAddressPair lastHop, IDAddressPair[] closestNodes, RoutingContext routingContext, ID target, int numNeighbors, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[] callbackArgs, IDAddressPair[] route, IDAddressPair[] blackList) {
        Object r;
        HashSet<IDAddressPair> blackListSet = new HashSet<IDAddressPair>();
        for (IDAddressPair a : blackList) {
            blackListSet.add(a);
        }
        boolean sent = false;
        if (forward) {
            IDAddressPair[] adjustedLastHops;
            Message newMsg;
            for (int i = 0; i < closestNodes.length; ++i) {
                IDAddressPair nextHop = closestNodes[i];
                RoutingContext nextContext = null;
                try {
                    nextContext = ((IDAddressRoutingContextTriplet)nextHop).getRoutingContext();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (nextHop == null || (oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_JOIN.getNumber()) && target.equals(nextHop.getID()) || nextHop.getID() != null && blackListSet.contains(nextHop)) continue;
                if (nextHop.getAddress().equals(initiator.getAddress()) && nextContext == null || nextHop.getAddress().equals(this.getSelfIDAddressPair().getAddress()) && (nextContext == null || nextContext.equals(routingContext))) break;
                if (nextHop.getAddress().equals(this.getSelfIDAddressPair().getAddress())) {
                    closestNodes = this.algorithm.closestTo(target, this.config.getNumOfClosestNodesRequested(), nextContext);
                    routingContext = nextContext;
                    IDAddressPair[] lastRoute = route;
                    route = new IDAddressPair[lastRoute.length + 1];
                    System.arraycopy(lastRoute, 0, route, 0, lastRoute.length);
                    route[route.length - 1] = this.getSelfIDAddressPair();
                    i = -1;
                    continue;
                }
                newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecRouteNoneMessage(this.getSelfIDAddressPair(), target, numNeighbors, nextContext, initiator, ttl - 1, adjustLastHop, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecRouteInvokeMessage(this.getSelfIDAddressPair(), target, numNeighbors, nextContext, initiator, ttl - 1, adjustLastHop, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecRouteJoinMessage(this.getSelfIDAddressPair(), initiator, numNeighbors, nextContext, ttl - 1, adjustLastHop, route));
                RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                try {
                    Message ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                    if (nextHop.getID() == null) {
                        nextHop = ack.getSource();
                    }
                    if (this.algorithm != null) {
                        this.algorithm.touch(ack.getSource());
                    }
                    if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                        sent = true;
                        break;
                    }
                    logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                }
                if (nextHop.getID() == null) continue;
                super.fail(nextHop);
                IDAddressPair[] oldBlackList = blackList;
                blackList = new IDAddressPair[oldBlackList.length + 1];
                System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                blackList[blackList.length - 1] = nextHop;
                RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                blackListSet.add(nextHop);
                logger.log(Level.INFO, nextHop.getAddress() + " is added to blacklist on " + this.getSelfIDAddressPair().getAddress());
            }
            if (!sent && adjustLastHop && (adjustedLastHops = this.algorithm.adjustRoot(target)) != null) {
                for (IDAddressPair nextHop : adjustedLastHops) {
                    if (nextHop == null || nextHop.getAddress().equals(this.getSelfIDAddressPair().getAddress())) continue;
                    for (IDAddressPair failedNode : blackList) {
                        if (!nextHop.getAddress().equals(failedNode.getAddress())) continue;
                    }
                    newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecNoneMessage(this.getSelfIDAddressPair(), target, numNeighbors, initiator, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecInvokeMessage(this.getSelfIDAddressPair(), target, numNeighbors, initiator, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecJoinMessage(this.getSelfIDAddressPair(), initiator, numNeighbors, route));
                    RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                    try {
                        Message ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                        this.algorithm.touch(ack.getSource());
                        if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                            sent = true;
                            break;
                        }
                        logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                    }
                    super.fail(nextHop);
                    IDAddressPair[] oldBlackList = blackList;
                    blackList = new IDAddressPair[oldBlackList.length + 1];
                    System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                    blackList[blackList.length - 1] = nextHop;
                    RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                }
            }
        }
        if (forward && ttl <= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("TTL expired:");
            for (IDAddressPair n : route) {
                if (n == null) break;
                sb.append(" ");
                sb.append(n.getAddress());
            }
            logger.log(Level.WARNING, sb.toString());
        }
        if (lastHop != null) {
            this.algorithm.touch(lastHop);
        }
        if (!this.getSelfIDAddressPair().equals(initiator)) {
            this.algorithm.touch(initiator);
        }
        Serializable callbackResult = null;
        if (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() || oldMsgTag == Tag.REC_INVOKE.getNumber()) {
            callbackResult = this.invokeCallbacks(target, filter, callbackTag, callbackArgs, lastHop, !sent);
            if (callbackResult != null) {
                logger.log(Level.INFO, "A callback returned non-null object: " + callbackResult);
            }
        } else if (oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_JOIN.getNumber()) {
            final IDAddressPair copiedJoiningNode = initiator;
            final IDAddressPair copiedLastHop = lastHop;
            final boolean copiedIsRootNode = !sent;
            r = new Runnable(){

                public void run() {
                    RecursiveRoutingDriver.this.algorithm.join(copiedJoiningNode, copiedLastHop, copiedIsRootNode);
                }
            };
            if (this.config.getUseThreadPool()) {
                this.threadPool.submit((Runnable)r);
            } else {
                Thread t = new Thread((Runnable)r);
                t.setName("Message type specific processes");
                t.setDaemon(true);
                t.start();
            }
        }
        if (!sent) {
            IDAddressPair[] neighbors = this.algorithm.neighbors(numNeighbors);
            RoutingResult res = new RoutingResult(route, neighbors);
            Message repMsg = RoutingDriverMessageFactory.getRecResultMessage(this.getSelfIDAddressPair(), target, res, callbackResult);
            RoutingDriverMessageFactory.setBlackList(repMsg, blackList);
            if (this.getSelfIDAddressPair().equals(initiator)) {
                r = this.routeResultMsgTable;
                synchronized (r) {
                    Message nullMsg = this.routeResultMsgTable.get(target);
                    if (nullMsg != null && nullMsg.getTag() == -1) {
                        this.routeResultMsgTable.put(target, repMsg);
                        this.routeResultMsgTable.notify();
                    }
                }
                sent = true;
            } else {
                try {
                    this.sender.send(initiator.getAddress(), repMsg);
                    sent = true;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Replying failed: " + initiator.getAddress() + " on " + this.getSelfIDAddressPair().getAddress());
                    super.fail(initiator);
                }
            }
        }
        return sent;
    }

    static /* synthetic */ boolean access$000(RecursiveRoutingDriver x0, boolean x1, boolean x2, int x3, IDAddressPair x4, IDAddressPair[] x5, RoutingContext x6, ID x7, int x8, IDAddressPair x9, int x10, CallbackResultFilter x11, int x12, Serializable[] x13, IDAddressPair[] x14, IDAddressPair[] x15) {
        return x0.forwardOrReturnResult(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15);
    }
}

