/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.routing.RoutingAlgorithm;
import ow.routing.impl.AbstractContactList;

public final class SortedContactList
extends AbstractContactList {
    private SortedSet<IDAddressPair> nodeList;

    public SortedContactList(ID target, RoutingAlgorithm algorithm) {
        this(target, algorithm, -1);
    }

    public SortedContactList(ID target, RoutingAlgorithm algorithm, int maxNodes) {
        super(maxNodes);
        this.nodeList = new TreeSet<IDAddressPair>(new AlgoBasedTowardTargetIDAddrComparator(algorithm, target));
    }

    public synchronized int size() {
        return this.nodeList.size();
    }

    public void clear() {
        this.nodeList.clear();
    }

    public synchronized boolean add(IDAddressPair contact, IDAddressPair lastContact) {
        IDAddressPair lastFirstContact = this.first(false);
        this.nodeList.add(contact);
        if (lastContact != null && !contact.equals(lastContact)) {
            this.lastContactMap.put(contact, lastContact);
        }
        if (this.maxNodes > 0) {
            while (this.nodeList.size() > this.maxNodes) {
                IDAddressPair p = this.nodeList.last();
                this.nodeList.remove(p);
                this.lastContactMap.remove(p);
            }
        }
        return !this.first(false).equals(lastFirstContact);
    }

    public synchronized boolean remove(IDAddressPair contact) {
        return this.nodeList.remove(contact);
    }

    public IDAddressPair first() {
        return this.first(true);
    }

    private synchronized IDAddressPair first(boolean registerToContactedSet) {
        IDAddressPair ret = null;
        try {
            ret = this.nodeList.first();
            if (registerToContactedSet) {
                this.contactedSet.add(ret);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ret;
    }

    public synchronized IDAddressPair firstExceptContactedNode() {
        for (IDAddressPair p : this.nodeList) {
            if (this.contactedSet.contains(p)) continue;
            this.contactedSet.add(p);
            return p;
        }
        return null;
    }
}

