/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.linearwalker;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedFromSrcIDAddrPairComparator;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.linearwalker.LinearWalkerConfiguration;
import ow.routing.linearwalker.LinearWalkerMessgeFactory;
import ow.routing.linearwalker.SuccessorList;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.util.HTMLUtil;

public class LinearWalker
extends AbstractRoutingAlgorithm {
    public Comparator<IDAddressPair> towardSelfComparator;
    Comparator<IDAddressPair> fromSelfComparator;
    public LinearWalkerConfiguration config;
    private final BigInteger sizeOfIdSpace;
    public final RoutingAlgorithm algorithm;
    public boolean stopped = false;
    public boolean suspended = true;
    public final int idSizeInBit;
    public final SuccessorList successorList;
    public IDAddressPair predecessor;
    private Thread stabilizerThread;

    protected LinearWalker(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (LinearWalkerConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not ConsistentHashingConfiguration.");
        }
        this.idSizeInBit = config.getIDSizeInByte() * 8;
        this.sizeOfIdSpace = BigInteger.ONE.shiftLeft(this.idSizeInBit);
        this.algorithm = this;
        this.towardSelfComparator = new AlgoBasedTowardTargetIDAddrComparator(this, this.selfIDAddress.getID());
        this.fromSelfComparator = new AlgoBasedFromSrcIDAddrPairComparator(this, this.selfIDAddress.getID());
        this.successorList = new SuccessorList(this, this.selfIDAddress, this.config.getSuccessorListLength());
        this.predecessor = this.selfIDAddress;
        this.prepareHandlers();
        if (!((LinearWalkerConfiguration)config).getAggressiveJoiningMode()) {
            Stabilizer r = new Stabilizer();
            this.stabilizerThread = new Thread(r);
            this.stabilizerThread.setName("Stabilizer");
            this.stabilizerThread.setDaemon(true);
            this.stabilizerThread.start();
        }
    }

    public synchronized void reset() {
        this.successorList.clear();
        this.predecessor = this.selfIDAddress;
    }

    public void stop() {
        this.stopped = true;
        if (this.stabilizerThread != null) {
            this.stabilizerThread.interrupt();
            this.stabilizerThread = null;
        }
    }

    public synchronized void suspend() {
        this.suspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        this.suspended = false;
        LinearWalker linearWalker = this;
        synchronized (linearWalker) {
            this.notifyAll();
        }
    }

    public BigInteger distance(ID to, ID from) {
        BigInteger fromInt;
        BigInteger toInt = to.toBigInteger();
        BigInteger distance = toInt.subtract(fromInt = from.toBigInteger());
        if (distance.compareTo(BigInteger.ZERO) <= 0) {
            distance = distance.add(this.sizeOfIdSpace);
        }
        return distance;
    }

    public void join(IDAddressPair[] neighbors) {
        if (this.config.getAggressiveJoiningMode()) {
            boolean succeed = false;
            for (IDAddressPair succ : neighbors) {
                try {
                    this.connectToSuccessor(succ);
                    succeed = true;
                    break;
                }
                catch (IOException e) {
                }
            }
        } else {
            this.successorList.addAll(neighbors);
        }
        this.resume();
    }

    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        return this.successorList.closestNodes(target, true);
    }

    public IDAddressPair[] neighbors(int maxNum) {
        return this.successorList.neighbors(maxNum);
    }

    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return this.successorList.toArray();
    }

    public void touch(IDAddressPair from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(IDAddressPair failedNode) {
        this.successorList.remove(failedNode);
        LinearWalker linearWalker = this;
        synchronized (linearWalker) {
            if (this.predecessor != null && this.predecessor.equals(failedNode)) {
                this.predecessor = null;
            }
        }
    }

    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        return this.fromSelfComparator.compare(existingEntry, newEntry) > 0;
    }

    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        ID joiningNodeID;
        ID iD = joiningNodeID = joiningNode != null ? joiningNode.getID() : null;
        if (!this.selfIDAddress.getID().equals(joiningNodeID)) {
            this.resume();
        }
    }

    public String getRoutingTableString() {
        IDAddressPair[] slArray;
        StringBuilder sb = new StringBuilder();
        sb.append("predecessor:\n ");
        sb.append(this.predecessor);
        sb.append("\n");
        sb.append("successor list: [");
        for (IDAddressPair entry : slArray = this.successorList.toArray()) {
            sb.append("\n ");
            sb.append(entry);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String getRoutingTableHTMLString() {
        String url;
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Predecessor</h4>\n");
        sb.append("<table>\n");
        if (this.predecessor != null) {
            url = XmlRpcDHTServer.convertMessagingAddressToURL(this.predecessor.getAddress());
            sb.append("<tr><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(this.predecessor.getID().toString()) + "</td></tr>\n");
        } else {
            sb.append("<tr><td>null</td></tr>\n");
        }
        sb.append("</table>\n");
        sb.append("<h4>Successor List</h4>\n");
        IDAddressPair[] slArray = this.successorList.toArray();
        sb.append("<table>\n");
        for (IDAddressPair entry : slArray) {
            url = XmlRpcDHTServer.convertMessagingAddressToURL(entry.getAddress());
            sb.append("<tr><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(entry.getID().toString()) + "</td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public IDAddressPair requestPredecessor(IDAddressPair successor) throws IOException {
        if (successor == null || successor.getID().equals(this.selfIDAddress.getID())) {
            return null;
        }
        Message reqMsg = LinearWalkerMessgeFactory.getReqConnectMessage(this.selfIDAddress);
        Message repMsg = null;
        try {
            repMsg = this.sender.sendAndReceive(successor.getAddress(), reqMsg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send a REQ_CONNECT msg or receive a REP_CONNECT msg.", e);
            this.fail(successor);
            throw e;
        }
        if (repMsg.getTag() != Tag.REP_CONNECT.getNumber()) {
            String receivedMsgName = Tag.getStringByNumber(repMsg.getTag());
            logger.log(Level.WARNING, "Expected message is REP_CONNECT: " + receivedMsgName);
            throw new IOException("Invalid message received: " + receivedMsgName);
        }
        Serializable[] contents = repMsg.getContents();
        IDAddressPair predCandidate = (IDAddressPair)contents[0];
        IDAddressPair[] successors = (IDAddressPair[])contents[1];
        this.successorList.addAll(successors);
        this.algorithm.touch(successor);
        return predCandidate;
    }

    private boolean connectToSuccessor(IDAddressPair successor) throws IOException {
        boolean successorChanged = false;
        IDAddressPair predOfSucc = this.requestPredecessor(successor);
        if (predOfSucc != null) {
            boolean contained = this.successorList.contains(predOfSucc);
            this.successorList.add(predOfSucc);
            IDAddressPair newSuccessor = this.successorList.first();
            if (!contained && newSuccessor.equals(predOfSucc)) {
                try {
                    this.connectToSuccessor(predOfSucc);
                }
                catch (StackOverflowError e) {
                    logger.log(Level.WARNING, "Stack over flow (due to incorrect routing result?).", e);
                }
                successorChanged = true;
            }
        }
        return successorChanged;
    }

    public void prepareHandlers() {
        ReqConnectMessageHandler handler = new ReqConnectMessageHandler();
        this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
    }

    private class Stabilizer
    implements Runnable {
        private Random rnd = new Random(System.currentTimeMillis());

        private Stabilizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long interval = LinearWalker.this.config.getStabilizeMinInterval();
            try {
                while (true) {
                    if (LinearWalker.this.suspended) {
                        LinearWalker linearWalker = LinearWalker.this;
                        synchronized (linearWalker) {
                            LinearWalker.this.wait();
                        }
                    }
                    if (LinearWalker.this.stopped) break;
                    boolean successorChanged = false;
                    try {
                        IDAddressPair successor = LinearWalker.this.successorList.first();
                        try {
                            successorChanged = LinearWalker.this.connectToSuccessor(successor);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "connectToSuccessor() failed.", e);
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    if (successorChanged || LinearWalker.this.selfIDAddress.equals(LinearWalker.this.predecessor)) {
                        interval = LinearWalker.this.config.getStabilizeMinInterval();
                    } else if ((interval <<= 1) > LinearWalker.this.config.getStabilizeMaxInterval()) {
                        interval = LinearWalker.this.config.getStabilizeMaxInterval();
                    }
                    double playRatio = LinearWalker.this.config.getStabilizeIntervalPlayRatio();
                    double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    Thread.sleep((long)((double)interval * intervalRatio));
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Stabilizer interrupted and die.", e);
            }
        }
    }

    public class ReqConnectMessageHandler
    implements MessageHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message process(Message msg) {
            LinearWalker.this.algorithm.touch(msg.getSource());
            IDAddressPair lastPredecessor = LinearWalker.this.predecessor;
            IDAddressPair predCandidate = msg.getSource();
            LinearWalker linearWalker = LinearWalker.this;
            synchronized (linearWalker) {
                if (!LinearWalker.this.config.getAggressiveJoiningMode()) {
                    if (LinearWalker.this.predecessor == null || LinearWalker.this.towardSelfComparator.compare(predCandidate, LinearWalker.this.predecessor) < 0) {
                        LinearWalker.this.predecessor = predCandidate;
                    }
                } else {
                    LinearWalker.this.predecessor = predCandidate;
                }
            }
            IDAddressPair[] successorArray = LinearWalker.this.successorList.toArray();
            Message repMsg = LinearWalkerMessgeFactory.getRepConnectMessage(LinearWalker.this.selfIDAddress, lastPredecessor, successorArray);
            LinearWalker.this.successorList.add(predCandidate);
            return repMsg;
        }
    }
}

