/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import ow.id.IDAddressPair;
import ow.routing.plaxton.Plaxton;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoutingTableRow
implements Serializable {
    private int rowIndex;
    private IDAddressPair[] entries;
    private volatile int selfDigit;
    private boolean isEmpty = true;

    protected RoutingTableRow(int rowIndex, int colSize, int selfDigit, IDAddressPair selfIDAddress) {
        this.rowIndex = rowIndex;
        this.entries = new IDAddressPair[colSize];
        this.selfDigit = selfDigit;
        this.entries[this.selfDigit] = selfIDAddress;
    }

    public int size() {
        return this.entries.length;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private boolean checkEmptyOrNot() {
        for (int i = 0; i < this.entries.length; ++i) {
            if (i == this.selfDigit || this.entries[i] == null) continue;
            this.isEmpty = false;
            return false;
        }
        this.isEmpty = true;
        return true;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public IDAddressPair get(int col) {
        return this.entries[col];
    }

    protected synchronized IDAddressPair set(int col, IDAddressPair entry) {
        if (col == this.selfDigit) {
            return null;
        }
        if (entry == null) {
            return null;
        }
        IDAddressPair old = this.entries[col];
        this.entries[col] = entry;
        this.isEmpty = false;
        return old;
    }

    protected synchronized IDAddressPair merge(int col, IDAddressPair entry, Plaxton algo) {
        IDAddressPair existingEntry = this.get(col);
        if (existingEntry == null || algo.toReplace(existingEntry, entry)) {
            return this.set(col, entry);
        }
        return null;
    }

    protected synchronized IDAddressPair remove(int col) {
        IDAddressPair old = this.entries[col];
        this.entries[col] = null;
        this.checkEmptyOrNot();
        return old;
    }

    public synchronized Set<IDAddressPair> getAllNodes() {
        HashSet<IDAddressPair> set = new HashSet<IDAddressPair>();
        for (int i = 0; i < this.entries.length; ++i) {
            IDAddressPair p = this.entries[i];
            if (p == null) continue;
            set.add(this.entries[i]);
        }
        return set;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onlyAddress) {
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        for (int i = 0; i < this.entries.length; ++i) {
            IDAddressPair entry;
            if (i == this.selfDigit || (entry = this.entries[i]) == null) continue;
            if (empty) {
                sb.append(this.rowIndex);
                empty = false;
            }
            sb.append(" ");
            sb.append(Integer.toHexString(i));
            sb.append(":");
            if (onlyAddress) {
                sb.append(entry.getAddress());
                continue;
            }
            sb.append(entry);
        }
        return sb.toString();
    }

    public String toHTMLString() {
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        for (int i = 0; i < this.entries.length; ++i) {
            IDAddressPair entry;
            if (i == this.selfDigit || (entry = this.entries[i]) == null) continue;
            String url = XmlRpcDHTServer.convertMessagingAddressToURL(entry.getAddress());
            if (empty) {
                sb.append("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(this.rowIndex)) + "</td><td></td><td></td></tr>\n");
                empty = false;
            }
            sb.append("<tr><td></td><td>" + HTMLUtil.stringInHTML(Integer.toHexString(i)) + "</td>" + "<td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td></tr>\n");
        }
        return sb.toString();
    }
}

