/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.dht.DHT;
import ow.messaging.util.AccessController;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.tool.dhtshell.commands.ClearCommand;
import ow.tool.dhtshell.commands.GetCommand;
import ow.tool.dhtshell.commands.HaltCommand;
import ow.tool.dhtshell.commands.HelpCommand;
import ow.tool.dhtshell.commands.InitCommand;
import ow.tool.dhtshell.commands.LocaldataCommand;
import ow.tool.dhtshell.commands.PutCommand;
import ow.tool.dhtshell.commands.QuitCommand;
import ow.tool.dhtshell.commands.RemoveCommand;
import ow.tool.dhtshell.commands.ResumeCommand;
import ow.tool.dhtshell.commands.StatusCommand;
import ow.tool.dhtshell.commands.SuspendCommand;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;
import ow.tool.util.toolframework.AbstractDHTBasedTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main
extends AbstractDHTBasedTool<String>
implements EmulatorControllable,
Interruptible {
    private static final String COMMAND = "owdhtshell";
    private static final int SHELL_PORT = -1;
    protected static final int XMLRPC_PORT_DIFF = 1;
    private static final int XMLRPC_PORT_RANGE = 100;
    public static final String ENCODING = "UTF-8";
    private static final Class[] COMMANDS = new Class[]{InitCommand.class, GetCommand.class, PutCommand.class, RemoveCommand.class, LocaldataCommand.class, StatusCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class, ClearCommand.class, SuspendCommand.class, ResumeCommand.class};
    private Thread mainThread = null;

    @Override
    protected void usage(String command) {
        super.usage(command, "[-p <shell port>] [--acl <ACL file>] [-n] [-x]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        try {
            this.start(0, args, new BufferedReader(new InputStreamReader(System.in, "US-ASCII")), System.out, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(int id, String[] args, BufferedReader in, PrintStream out) {
        this.start(id, args, in, out, false);
    }

    private void start(int id, String[] args, BufferedReader in, PrintStream out, boolean interactive) {
        int shellPort = -1;
        AccessController ac = null;
        boolean disableStdin = false;
        boolean invokeXMLRPCServer = false;
        this.mainThread = Thread.currentThread();
        Options opts = this.getInitialOptions();
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        opts.addOption("n", "disablestdin", false, "disable standard input");
        opts.addOption("x", "xmlrpc", false, "invoke an XML-RPC server");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        String optVal = cmd.getOptionValue('p');
        if (optVal != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return;
            }
        }
        if (cmd.hasOption('n')) {
            disableStdin = true;
        }
        if (cmd.hasOption('x')) {
            invokeXMLRPCServer = true;
        }
        DHT<String> dht = null;
        try {
            dht = super.initialize((short)1, (short)0, COMMAND, cmd);
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return;
        }
        XmlRpcDHTServer rpcServer = null;
        if (invokeXMLRPCServer) {
            rpcServer = new XmlRpcDHTServer(dht);
            int xmlrpcPort = dht.getConfiguration().getContactPort() + 1;
            try {
                String url = rpcServer.start(xmlrpcPort, 100);
                System.out.println("Web and XML-RPC server: " + url);
            }
            catch (Exception e) {
                System.err.println("Failed to start a web server.");
                e.printStackTrace();
                return;
            }
        }
        ShellServer<DHT<String>> shellServ = new ShellServer<DHT<String>>(COMMANDS, dht, shellPort, ac);
        shellServ.addInterruptible(this);
        if (rpcServer != null) {
            shellServ.addInterruptible(rpcServer);
        }
        if (disableStdin) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {}
        } else {
            Shell<DHT<String>> stdioShell = new Shell<DHT<String>>(in, out, shellServ, dht, interactive);
            stdioShell.run();
        }
    }

    @Override
    public void interrupt() {
        if (this.mainThread != null && !this.mainThread.equals(Thread.currentThread())) {
            this.mainThread.interrupt();
        }
    }
}

