/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithm;
import ow.tool.dhtshell.Utility;
import ow.tool.util.shellframework.Interruptible;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcDHTServer
implements Interruptible {
    public static final String ENCODING = "UTF-8";
    private DHT<String> dht;
    private int idSizeInByte;
    private int port;
    private XmlRpcHandler handler;
    private Server webServer;

    public XmlRpcDHTServer(DHT<String> dht) {
        this.dht = dht;
        this.idSizeInByte = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        this.handler = new XmlRpcDHTRequestHandler();
    }

    public String start(int port, int range) throws Exception {
        return this.start(port, range, null);
    }

    private String start(int port, int range, InetAddress selfAddress) throws Exception {
        this.webServer = null;
        Exception lastException = null;
        XmlRpcDHTServlet servlet = new XmlRpcDHTServlet();
        for (int p = port; p < port + range; ++p) {
            this.webServer = new Server(p);
            Context root = new Context((HandlerContainer)this.webServer, "/", 1);
            root.addServlet(new ServletHolder((Servlet)servlet), "/*");
            try {
                this.webServer.start();
                this.port = p;
                break;
            }
            catch (Exception e) {
                lastException = e;
                continue;
            }
        }
        if (this.webServer == null) {
            throw lastException;
        }
        return XmlRpcDHTServer.convertMessagingAddressToURL(this.dht.getSelfIDAddressPair().getAddress(), this.port);
    }

    public void stop() {
        try {
            this.webServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webServer = null;
    }

    @Override
    public void interrupt() {
        this.stop();
    }

    public int getPort() {
        return this.port;
    }

    public static String convertMessagingAddressToURL(MessagingAddress addr) {
        return XmlRpcDHTServer.convertMessagingAddressToURL(addr, addr.getPort() + 1);
    }

    private static String convertMessagingAddressToURL(MessagingAddress addr, int port) {
        return "http://" + addr.getHostname() + ":" + port + "/";
    }

    private class XmlRpcDHTRequestHandler
    implements XmlRpcHandler {
        private XmlRpcDHTRequestHandler() {
        }

        public Object execute(XmlRpcRequest req) throws XmlRpcException {
            String methodName = req.getMethodName();
            int numParams = req.getParameterCount();
            if (methodName.equals("get_details") || methodName.equals("get")) {
                Set values;
                if (numParams != 4) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                int maxVals = (Integer)req.getParameter(1);
                byte[] placeMarkBytes = (byte[])req.getParameter(2);
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                int placeMark = 0;
                if (placeMarkBytes != null && placeMarkBytes.length > 0) {
                    for (int i = 0; i < 4; ++i) {
                        placeMark |= (placeMarkBytes[i] & 0xFF) << (3 - i << 3);
                    }
                }
                if ((values = XmlRpcDHTServer.this.dht.get(hashedKey)) == null) {
                    values = new HashSet();
                }
                if (values.size() > maxVals || placeMark != 0) {
                    HashSet truncatedValues = new HashSet(maxVals);
                    int i = 0;
                    for (ValueInfo v : values) {
                        if (i >= placeMark + maxVals) break;
                        if (i >= placeMark) {
                            truncatedValues.add(v);
                        }
                        ++i;
                    }
                    if (placeMark + maxVals >= values.size()) {
                        placeMarkBytes = new byte[]{};
                    } else {
                        placeMark = i;
                        placeMarkBytes = new byte[]{(byte)(placeMark >>> 24), (byte)(placeMark >>> 16), (byte)(placeMark >>> 8), (byte)placeMark};
                    }
                    values = truncatedValues;
                }
                Object[] ret = new Object[2];
                ret[1] = placeMarkBytes;
                if (methodName.equals("get")) {
                    byte[][] vals = new byte[values.size()][];
                    ret[0] = vals;
                    int i = 0;
                    for (ValueInfo v : values) {
                        try {
                            vals[i] = ((String)v.getValue()).toString().getBytes(XmlRpcDHTServer.ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                } else {
                    Object[][] vals;
                    ret[0] = vals = new Object[values.size()][];
                    int i = 0;
                    for (ValueInfo v : values) {
                        vals[i] = new Object[4];
                        try {
                            vals[i][0] = ((String)v.getValue()).toString().getBytes(XmlRpcDHTServer.ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        vals[i][1] = (int)(v.getTTL() / 1000L);
                        vals[i][2] = "SHA";
                        ByteArray sec = v.getSecret();
                        vals[i][3] = sec != null ? sec.getBytes() : new byte[20];
                        ++i;
                    }
                }
                return ret;
            }
            if (methodName.equals("put_removable") || methodName.equals("put")) {
                int ttl;
                boolean put_removable = methodName.equals("put_removable");
                if (numParams != (put_removable ? 6 : 4)) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                byte[] plainValueBytes = (byte[])req.getParameter(1);
                String hashAlgo = null;
                byte[] hashedSecretBytes = null;
                if (put_removable) {
                    hashAlgo = (String)req.getParameter(2);
                    hashedSecretBytes = (byte[])req.getParameter(3);
                    ttl = (Integer)req.getParameter(4);
                } else {
                    ttl = (Integer)req.getParameter(2);
                }
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                String value = null;
                try {
                    value = new String(plainValueBytes, XmlRpcDHTServer.ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                ByteArray hashedSecret = null;
                if (put_removable && "SHA".equals(hashAlgo)) {
                    hashedSecret = new ByteArray(hashedSecretBytes);
                }
                try {
                    if (put_removable) {
                        XmlRpcDHTServer.this.dht.put(hashedKey, value, (long)ttl * 1000L, hashedSecret);
                    } else {
                        XmlRpcDHTServer.this.dht.put(hashedKey, value, (long)ttl * 1000L);
                    }
                }
                catch (Exception e) {
                    System.err.println("An Exception thrown during putting:");
                    e.printStackTrace();
                    return 2;
                }
                return 0;
            }
            if (methodName.equals("rm")) {
                if (numParams != 6) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                byte[] valueHashBytes = (byte[])req.getParameter(1);
                String hashAlgo = (String)req.getParameter(2);
                byte[] secretBytes = (byte[])req.getParameter(3);
                int ttl = (Integer)req.getParameter(4);
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                ID valueHash = ID.getID(valueHashBytes, XmlRpcDHTServer.this.idSizeInByte);
                ByteArray hashedSecret = null;
                if ("SHA".equals(hashAlgo)) {
                    ByteArray plainSecret = new ByteArray(secretBytes);
                    hashedSecret = plainSecret.hashWithSHA1();
                }
                XmlRpcDHTServer.this.dht.remove(hashedKey, valueHash, hashedSecret);
                return 0;
            }
            throw new XmlRpcException("No such method: " + methodName);
        }
    }

    private class Mapper
    implements XmlRpcHandlerMapping {
        private Mapper() {
        }

        public XmlRpcHandler getHandler(String arg0) throws XmlRpcNoSuchHandlerException, XmlRpcException {
            return XmlRpcDHTServer.this.handler;
        }
    }

    private class XmlRpcDHTServlet
    extends XmlRpcServlet {
        private XmlRpcDHTServlet() {
        }

        protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
            return new Mapper();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            req.setCharacterEncoding(XmlRpcDHTServer.ENCODING);
            res.setCharacterEncoding(XmlRpcDHTServer.ENCODING);
            String resultString = null;
            String op = null;
            String key = null;
            String value = null;
            String ttl = null;
            String secret = null;
            Set getResults = null;
            boolean lookupPerformed = false;
            String qs = req.getQueryString();
            if (qs != null) {
                String[] tokens;
                HashMap<String, String> paramTable = new HashMap<String, String>();
                for (String t : tokens = qs.split("&")) {
                    int eqIndex = t.indexOf(61);
                    if (eqIndex <= 0) continue;
                    paramTable.put(t.substring(0, eqIndex), t.substring(eqIndex + 1));
                }
                op = (String)paramTable.get("op");
                key = (String)paramTable.get("key");
                value = (String)paramTable.get("value");
                ttl = (String)paramTable.get("ttl");
                secret = (String)paramTable.get("secret");
                if (key != null) {
                    key = URLDecoder.decode(key, XmlRpcDHTServer.ENCODING);
                }
                if (value != null) {
                    value = URLDecoder.decode(value, XmlRpcDHTServer.ENCODING);
                }
                if (secret != null) {
                    secret = URLDecoder.decode(secret, XmlRpcDHTServer.ENCODING);
                }
                if (op != null && key != null) {
                    ID keyID = Utility.parseID(key, XmlRpcDHTServer.this.dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
                    if (op.equals("get")) {
                        getResults = XmlRpcDHTServer.this.dht.get(keyID);
                        lookupPerformed = true;
                        resultString = getResults == null || getResults.size() <= 0 ? "No value tied with \"" + key + "\"." : "Get results:";
                    } else if (op.equals("put")) {
                        if (value == null || value.length() <= 0 || ttl == null) {
                            resultString = "Error: put requires a value and a TTL.";
                        } else {
                            long ttlNum = Long.parseLong(ttl) * 1000L;
                            try {
                                if (secret == null) {
                                    XmlRpcDHTServer.this.dht.put(keyID, value, ttlNum);
                                } else {
                                    ByteArray hashedSecret = new ByteArray(secret.getBytes(XmlRpcDHTServer.ENCODING)).hashWithSHA1();
                                    XmlRpcDHTServer.this.dht.put(keyID, value, ttlNum, hashedSecret);
                                }
                                lookupPerformed = true;
                                resultString = "Put succeeded.";
                            }
                            catch (Exception e) {}
                        }
                    } else if (op.equals("remove")) {
                        if (secret == null) {
                            resultString = "Error: remove requires a secret.";
                        } else {
                            if (value == null || value.length() <= 0) {
                                value = null;
                            }
                            ByteArray hashedSecret = new ByteArray(secret.getBytes(XmlRpcDHTServer.ENCODING)).hashWithSHA1();
                            boolean removed = false;
                            if (value == null) {
                                Set s = XmlRpcDHTServer.this.dht.remove(keyID, hashedSecret);
                                lookupPerformed = true;
                                if (s == null) {
                                    resultString = "There is no such key-and-value pair.";
                                } else {
                                    resultString = "Removed:";
                                    for (ValueInfo vi : s) {
                                        resultString = resultString + " \"" + (String)vi.getValue() + "\"";
                                    }
                                }
                            } else {
                                ValueInfo<String> vi = XmlRpcDHTServer.this.dht.remove(keyID, value, hashedSecret);
                                lookupPerformed = true;
                                resultString = vi == null ? "There is no such key-and-value pair." : "Removed: \"" + vi.getValue() + "\"";
                            }
                        }
                    }
                }
            }
            PrintWriter wtr = res.getWriter();
            DHTConfiguration dhtConf = XmlRpcDHTServer.this.dht.getConfiguration();
            IDAddressPair idAddr = XmlRpcDHTServer.this.dht.getSelfIDAddressPair();
            String url = XmlRpcDHTServer.convertMessagingAddressToURL(idAddr.getAddress());
            res.setContentType("text/html");
            res.setStatus(200);
            wtr.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            wtr.println("<html>");
            wtr.println("<head>");
            wtr.println("<title>Overlay Weaver Node: " + HTMLUtil.stringInHTML(url) + "</title>");
            wtr.println("<style type=text/css>");
            wtr.println("h3 { border-left: solid 0.6em #208020; border-bottom: solid 1pt }");
            wtr.println("</style>");
            wtr.println("</head>");
            wtr.println();
            wtr.println("<body>");
            wtr.println("<h1>Overlay Weaver Node Status</h1>");
            wtr.println();
            wtr.println("<h3>Node Information</h3>");
            wtr.println("<table>");
            wtr.println("<tr><td>URL:</td><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td></tr>");
            wtr.println("<tr><td>Node ID:</td><td>" + HTMLUtil.stringInHTML(idAddr.getID().toString()) + "</td></tr>");
            wtr.println("<tr><td>Lookup algorithm:</td><td>" + HTMLUtil.stringInHTML(dhtConf.getRoutingAlgorithm()) + "</td></tr>");
            wtr.println("<tr><td>Lookup style:</td><td>" + HTMLUtil.stringInHTML(dhtConf.getRoutingStyle()) + "</td></tr>");
            wtr.println("<tr><td># of stored keys:</td><td>" + HTMLUtil.stringInHTML(Integer.toString(XmlRpcDHTServer.this.dht.getGlobalKeys().size())) + "</td></tr>");
            wtr.println("</table>");
            wtr.println();
            wtr.println("<h3>Routing Table</h3>");
            RoutingAlgorithm algo = XmlRpcDHTServer.this.dht.getRoutingService().getRoutingAlgorithm();
            wtr.println(algo.getRoutingTableHTMLString());
            wtr.println("<h3>Put, Get and Remove Operations</h3>");
            wtr.println("<table>");
            wtr.println("<tr><th>operation</th><th>key</th><th>value</th><th>TTL (sec)</th><th>secret</th></tr>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"get\">");
            wtr.println("<tr>");
            wtr.println("<td>get</td>");
            wtr.println("<td colspan=\"4\"><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"put\">");
            wtr.println("<tr>");
            wtr.println("<td>put</td>");
            wtr.println("<td><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"text\" name=\"value\" size=\"10\"" + (value != null ? " value=\"" + HTMLUtil.stringInHTML(value) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"text\" name=\"ttl\" size=\"6\" value=\"" + (ttl != null ? ttl : "600") + "\"></td>");
            wtr.println("<td><input type=\"text\" name=\"secret\" size=\"10\"" + (secret != null ? " value=\"" + HTMLUtil.stringInHTML(secret) + "\"" : "") + "> (option)</td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"remove\">");
            wtr.println("<tr>");
            wtr.println("<td>remove</td>");
            wtr.println("<td><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td colspan=\"2\"><input type=\"text\" name=\"value\" size=\"10\"" + (value != null ? " value=\"" + HTMLUtil.stringInHTML(value) + "\"" : "") + "> (option)</td>");
            wtr.println("<td><input type=\"text\" name=\"secret\" size=\"10\"" + (secret != null ? " value=\"" + HTMLUtil.stringInHTML(secret) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("</table>");
            wtr.println();
            if (resultString != null) {
                wtr.println("<h3>Results</h3>");
                wtr.println("<p>");
                wtr.println(HTMLUtil.stringInHTML(resultString));
                wtr.println("</p>");
                if (getResults != null) {
                    wtr.println("<table>");
                    wtr.println("<tr><td>key:</td><td>" + HTMLUtil.stringInHTML(key) + "</td></tr>");
                    for (ValueInfo vInfo : getResults) {
                        String v = (String)vInfo.getValue();
                        wtr.println("<tr><td>value:</td><td>" + HTMLUtil.stringInHTML(v) + "</td></tr>");
                    }
                    wtr.println("</table>");
                }
            }
            if (lookupPerformed) {
                IDAddressPair[] route = XmlRpcDHTServer.this.dht.getLastRoutingResult().getRoute();
                wtr.println("<h3>Route</h3>");
                wtr.println("<table>");
                wtr.println("<tr><th>Hop</th><th>Node</th><th>ID</th></tr>");
                int i = 0;
                for (IDAddressPair hop : route) {
                    url = XmlRpcDHTServer.convertMessagingAddressToURL(hop.getAddress());
                    wtr.print("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(i)) + "</td>");
                    wtr.print("<td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td>");
                    wtr.println("<td>" + HTMLUtil.stringInHTML(hop.getID().toString()) + "</td></tr>");
                    ++i;
                }
                wtr.println("</table>");
            }
            wtr.println();
            wtr.println("</body>");
            wtr.println("</html>");
        }
    }
}

