/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.net.UnknownHostException;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.messaging.MessagingAddress;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"init"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "init <host>[:<port>] [<port>]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) throws UnknownHostException {
        MessagingAddress contactAddr;
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        DHTConfiguration config = dht.getConfiguration();
        int port = config.getSelfPort();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        if ((contactAddr = dht.joinOverlay(args[0], port)) != null) {
            out.print("contact: " + contactAddr.getHostAddress() + ":" + contactAddr.getPort() + "\r\n");
        } else {
            out.print("joining failed.\r\n");
        }
        out.flush();
        return false;
    }
}

