/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator;

import java.io.BufferedWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ow.tool.emulator.ControlPipeTable;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.RemoteControlPipeTable;
import ow.tool.emulator.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmulatorContext {
    private PrintStream out;
    private int numOfEmulatorControllable;
    Set<Thread> threadSet = new HashSet<Thread>();
    private EmulatorMode emulatorMode;
    private int nextID;
    private ControlPipeTable controlPipeTable;
    private Timer timer;
    private long controlStartTime = 0L;
    private long lastExitingTime = 0L;
    private Class currentClass;
    private Method currentMainMethod;
    private String[] currentArguments = new String[0];
    private String currentDirectory = null;
    private String currentJavaPath = null;
    private String currentJVMOption = null;
    private int currentRelativePriority = 0;
    private long currentTimeOffset = 500L;

    protected EmulatorContext(PrintStream out, int initialHostID, ControlPipeTable pipeTable, EmulatorMode mode) {
        this.out = out;
        this.nextID = initialHostID;
        this.controlPipeTable = pipeTable;
        this.emulatorMode = mode;
        this.numOfEmulatorControllable = 0;
        this.timer = new Timer("A Timer in Emulator", true);
        this.controlStartTime = 0L;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public void establishControlPipes() {
        Set<Thread> s = null;
        if (this.emulatorMode == EmulatorMode.MASTER) {
            RemoteControlPipeTable workerTable = (RemoteControlPipeTable)this.controlPipeTable;
            if (!workerTable.isPipeEstablished()) {
                s = workerTable.establishControlPipes(this.getRemoteDirectory(), this.getRemoteJavaPath(), this.getRemoteJVMOption(), System.out);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.threadSet.addAll(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThreadToBeJoined(Thread t) {
        Set<Thread> set = this.threadSet;
        synchronized (set) {
            this.threadSet.add(t);
            this.threadSet.notify();
        }
    }

    public void joinRegisteredThread() {
        long sleepPeriod = 0L;
        if (this.lastExitingTime > 0L) {
            sleepPeriod = this.lastExitingTime - System.currentTimeMillis() + 1000L;
        }
        try {
            Thread.sleep(sleepPeriod);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public EmulatorMode getEmulatorMode() {
        return this.emulatorMode;
    }

    public synchronized int getNextHostID() {
        return this.nextID++;
    }

    public int getMaxHostID() {
        return this.nextID - 1;
    }

    public void scheduleTask(long time, TimerTask task) {
        this.scheduleTask(time, 0L, 1, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(long time, long interval, int times, TimerTask task) {
        EmulatorContext emulatorContext = this;
        synchronized (emulatorContext) {
            if (this.controlStartTime <= 0L) {
                this.controlStartTime = System.currentTimeMillis();
            }
        }
        long timing = this.controlStartTime + this.currentTimeOffset + time;
        Date timingDate = new Date(timing);
        if (times <= 0 && interval >= 0L) {
            this.timer.scheduleAtFixedRate(task, timingDate, interval);
        } else {
            for (int i = 0; i < times; ++i) {
                this.timer.schedule(task, timingDate);
                task = (TimerTask)((Object)((Task)((Object)task)).clone());
                timingDate = new Date(timing += interval);
            }
        }
        if (this.lastExitingTime <= 0L) {
            this.lastExitingTime = Long.MAX_VALUE;
        }
        if (((Task)((Object)task)).doesExit()) {
            this.lastExitingTime = timing;
        }
    }

    public BufferedWriter getControlPipe(int hostID) {
        return this.controlPipeTable.get(hostID);
    }

    public void setControlPipe(int hostID, BufferedWriter out) {
        this.controlPipeTable.set(hostID, out);
        if (hostID >= this.numOfEmulatorControllable) {
            this.numOfEmulatorControllable = hostID + 1;
        }
    }

    public Collection<BufferedWriter> getAllControlPipes() {
        return this.controlPipeTable.getAllControlPipes();
    }

    public Class getCurrentClass() {
        return this.currentClass;
    }

    public Class setCurrentClass(Class clazz) {
        Class old = this.currentClass;
        this.currentClass = clazz;
        return old;
    }

    public Method getCurrentMainMethod() {
        return this.currentMainMethod;
    }

    public Method setCurrentMainMethod(Method method) {
        Method old = this.currentMainMethod;
        this.currentMainMethod = method;
        return old;
    }

    public String[] getCurrentArguments() {
        return this.currentArguments;
    }

    public String[] setCurrentArguments(String[] args) {
        String[] old = this.currentArguments;
        this.currentArguments = args;
        return old;
    }

    public String getRemoteDirectory() {
        return this.currentDirectory;
    }

    public String setRemoteDirectory(String dir) {
        String old = this.currentDirectory;
        this.currentDirectory = dir;
        return old;
    }

    public String getRemoteJavaPath() {
        return this.currentJavaPath;
    }

    public String setRemoteJavaPath(String path) {
        String old = this.currentJavaPath;
        this.currentJavaPath = path;
        return old;
    }

    public String getRemoteJVMOption() {
        return this.currentJVMOption;
    }

    public String setRemoteJVMOption(String classpath) {
        String old = this.currentJVMOption;
        this.currentJVMOption = classpath;
        return old;
    }

    public int getCurrentRelativePriority() {
        return this.currentRelativePriority;
    }

    public int setCurrentRelativePriority(int prio) {
        int old = this.currentRelativePriority;
        this.currentRelativePriority = prio;
        return old;
    }

    public long getCurrentTimeOffset() {
        return this.currentTimeOffset;
    }

    public long setCurrentTimeOffset(long wait) {
        long old = this.currentTimeOffset;
        this.currentTimeOffset = wait;
        return old;
    }
}

