/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"schedule"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "schedule <time>[,<interval>[,<times>]] <another command> [...]";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        long startTime = 0L;
        long interval = 0L;
        int times = 1;
        try {
            startTime = Long.parseLong(args[0]);
        }
        catch (NumberFormatException e0) {
            StringTokenizer st = new StringTokenizer(args[0], ",");
            try {
                startTime = Long.parseLong(st.nextToken());
                interval = Long.parseLong(st.nextToken());
                times = 0;
            }
            catch (NoSuchElementException e) {
                out.println("Syntax error: " + args[0]);
                e.printStackTrace(out);
                System.exit(1);
            }
            try {
                times = Integer.parseInt(st.nextToken());
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        Map<String, Command<EmulatorContext>> commandTable = context.getShellServer().getCommandTable();
        Command<EmulatorContext> command = commandTable.get(args[1]);
        if (command == null) {
            out.println("No such command: " + args[1]);
            return !context.isInteractive();
        }
        SchedulableCommand schedulableCommand = null;
        try {
            schedulableCommand = (SchedulableCommand)command;
        }
        catch (ClassCastException e) {
            out.println("Command is not schedulable: " + args[1]);
            return !context.isInteractive();
        }
        String[] taskArgs = new String[args.length - 2];
        System.arraycopy(args, 2, taskArgs, 0, taskArgs.length);
        context.setArguments(taskArgs);
        TimerTask task = null;
        try {
            task = schedulableCommand.getTimerTask(context);
        }
        catch (Exception e) {
            out.println("An exception thrown during parsing command: " + args[1]);
            return !context.isInteractive();
        }
        cxt.scheduleTask(startTime, interval, times, task);
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            out.print("schedule: " + schedulableCommand.getNames()[0]);
            for (int i = 0; i < taskArgs.length; ++i) {
                out.print(" " + taskArgs[i]);
            }
            out.println();
        }
        return false;
    }
}

