/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.ipmulticast.Group;
import ow.ipmulticast.IPMulticast;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.DecodedMessageOnOverlay;
import ow.tool.mrouted.ForwarderAddress;
import ow.tool.mrouted.GroupTable;
import ow.tool.mrouted.ProtocolOnOverlay;

final class OverlayTrafficForwarder
implements Runnable {
    private static final Logger logger = Logger.getLogger("mrouted");
    private final ApplicationLevelMulticastRouterConfiguration config;
    private Inet4Address group = null;
    private GroupTable groupTable;
    private DatagramSocket sockForOverlay;
    private IPMulticast mcast;
    private Thread receivingThread = null;
    private ForwarderAddress parent;
    private ForwarderAddress[] children;
    private long loopbackMessageReceivedTime;

    OverlayTrafficForwarder(ApplicationLevelMulticastRouterConfiguration config, GroupTable groupTable, DatagramSocket sockForOverlay, IPMulticast mcast) {
        this.config = config;
        this.groupTable = groupTable;
        this.sockForOverlay = sockForOverlay;
        this.mcast = mcast;
        this.reset();
    }

    protected void reset() {
        this.loopbackMessageReceivedTime = System.currentTimeMillis();
    }

    protected synchronized void start() {
        if (this.receivingThread == null) {
            this.receivingThread = new Thread(this);
            this.receivingThread.setName("Overlay Traffic Forwarder");
            this.receivingThread.setDaemon(true);
            this.receivingThread.start();
        }
    }

    protected synchronized void stop() {
        if (this.receivingThread != null) {
            this.receivingThread.interrupt();
            this.receivingThread = null;
        }
    }

    protected Inet4Address getGroupAddress() {
        return this.group;
    }

    protected Inet4Address setGroupAddress(Inet4Address group) {
        Inet4Address old = this.group;
        this.group = group;
        return old;
    }

    protected ForwarderAddress getParent() {
        return this.parent;
    }

    protected synchronized ForwarderAddress setParent(ForwarderAddress parent) {
        ForwarderAddress old = this.parent;
        this.parent = parent;
        return old;
    }

    protected ForwarderAddress[] getChildren() {
        return this.children;
    }

    protected synchronized ForwarderAddress[] setChildren(ForwarderAddress[] children) {
        ForwarderAddress[] old = this.children;
        this.children = children;
        return old;
    }

    protected long getLoopbackMessageReceivedTime() {
        return this.loopbackMessageReceivedTime;
    }

    protected long setLoopbackMessageReceivedTime(long time) {
        long old = this.loopbackMessageReceivedTime;
        this.loopbackMessageReceivedTime = time;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int datagramBufSize = this.config.getDatagramBufferSize();
        byte[] datagramBuf = new byte[datagramBufSize];
        DatagramPacket packet = new DatagramPacket(datagramBuf, datagramBufSize);
        int decodedDataSize = this.config.getDatagramBufferSize() - 22;
        byte[] decodedData = new byte[decodedDataSize];
        DecodedMessageOnOverlay decodedMessage = new DecodedMessageOnOverlay(decodedData);
        while (!Thread.interrupted()) {
            try {
                this.sockForOverlay.receive(packet);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "An Exception thrown during receiving a datagram.", e);
                continue;
            }
            ForwarderAddress from = null;
            Inet4Address fromInet4Address = null;
            try {
                fromInet4Address = (Inet4Address)packet.getAddress();
            }
            catch (ClassCastException e) {
                logger.log(Level.WARNING, "A received datagram has an IPv6 address: " + packet.getAddress());
                continue;
            }
            from = new ForwarderAddress(fromInet4Address, packet.getPort());
            byte[] encoded = packet.getData();
            int overlayTTL = ProtocolOnOverlay.getOverlayTTL(encoded);
            if (--overlayTTL <= 0) {
                logger.log(Level.WARNING, "TTL expired when forwarding. from: " + from);
                return;
            }
            ProtocolOnOverlay.setOverlayTTL(encoded, overlayTTL);
            Inet4Address dest = ProtocolOnOverlay.getDestAddress(encoded);
            OverlayTrafficForwarder overlayTrafficForwarder = this;
            synchronized (overlayTrafficForwarder) {
                if (this.parent != null && !from.equals(this.parent)) {
                    packet.setAddress(this.parent.getAddress());
                    packet.setPort(this.parent.getPort());
                    try {
                        this.sockForOverlay.send(packet);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to forward to " + this.parent.getAddress() + ":" + this.parent.getPort() + ".", e);
                    }
                }
                if (this.children != null) {
                    for (ForwarderAddress addr : this.children) {
                        if (from.equals(addr)) continue;
                        packet.setAddress(addr.getAddress());
                        packet.setPort(addr.getPort());
                        try {
                            this.sockForOverlay.send(packet);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Failed to forward to " + addr.getAddress() + ":" + addr.getPort() + ".", e);
                        }
                    }
                }
            }
            Group group = this.groupTable.getJoinedGroup(dest);
            if (group == null) continue;
            ProtocolOnOverlay.decode(decodedMessage, encoded);
            this.mcast.send(decodedMessage.getSrcAddress(), decodedMessage.getSrcPort(), dest, decodedMessage.getDestPort(), decodedMessage.getID(), decodedMessage.getIPTTL(), decodedMessage.getDataLength(), decodedMessage.getData());
        }
    }
}

