/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.dht;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityInformationParser;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.DHTFactory;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.messaging.MessagingAddress;

public class Chord {
    private static DHT<String> dht = null;
    public static int PORT = 3997;
    private static final int TTL = 10000;
    private static Chord instance = new Chord();
    private EntityInformationParser parser;
    public static String routingStyle = "Iterative";
    public static String routingAlgolithm = "Chord";
    public static final String ENCODING = "UTF-8";
    private ByteArray secret;
    boolean init = false;
    int idSize = 0;
    private Map<ID, String> entry = new HashMap<ID, String>();
    private Object syncObj = new Object();

    private Chord() {
        this.parser = EntityInformationParser.getInstance();
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        try {
            this.secret = ByteArray.valueOf((String)now.toString(), (String)ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.secret = this.secret.hashWithSHA1();
    }

    public static Chord getInstance() {
        return instance;
    }

    public boolean init() throws Exception {
        DHTConfiguration config = DHTFactory.getDefaultConfiguration();
        config.setRoutingStyle(routingStyle);
        config.setRoutingAlgorithm(routingAlgolithm);
        config.setSelfPort(PORT);
        try {
            dht = DHTFactory.getDHT((DHTConfiguration)config);
        }
        catch (Exception e) {
            Random rand = new Random();
            config.setSelfPort(PORT + rand.nextInt(20));
            dht = DHTFactory.getDHT((DHTConfiguration)config);
        }
        System.out.println("A DHT object initialized.");
        this.init = true;
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                while (true) {
                    try {
                        block6: while (true) {
                            1.sleep(9900L);
                            Object object = Chord.this.syncObj;
                            // MONITORENTER : object
                            Set set = Chord.this.entry.keySet();
                            Iterator iterator = set.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    // MONITOREXIT : object
                                    continue block6;
                                }
                                ID id = (ID)iterator.next();
                                String value = (String)Chord.this.entry.get(id);
                                if (dht == null) continue;
                                dht.put(id, (Serializable)((Object)value), 10000L, Chord.this.secret);
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        th.start();
        return this.init;
    }

    public boolean init(String host, int port) throws Exception {
        boolean ret = this.init();
        MessagingAddress addr = dht.joinOverlay(host, port);
        this.init = true;
        return addr != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insertEntity(Entity entity) throws Exception {
        String[] keywords;
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        if ((keywords = entity.getKeywords()).length == 0) return false;
        Object object = this.syncObj;
        synchronized (object) {
            String[] stringArray = keywords;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String keyword = stringArray[n];
                ID key = null;
                try {
                    key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                EntityInformation ei = new EntityInformation(entity);
                String value = ei.toXML();
                dht.put(key, (Serializable)((Object)value), 10000L, this.secret);
                this.entry.put(key, value);
                ++n;
            }
            return true;
        }
    }

    public Entity[] getEntities(String keyword) {
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        ID key = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Set valueSet = dht.get(key);
        if (valueSet == null) {
            return new Entity[0];
        }
        Entity[] entities = new Entity[valueSet.size()];
        int num = 0;
        for (ValueInfo s : valueSet) {
            String str = (String)((Object)s.getValue());
            try {
                EntityInformation info = this.parser.parse(str);
                EntityImpl entity = new EntityImpl(info);
                entities[num++] = entity;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return entities;
    }

    public boolean isInitiated() {
        return this.init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertEntity(String keyword, Entity entity) {
        if (dht == null) {
            return false;
        }
        if (this.idSize == 0) {
            this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        }
        ID key = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        EntityInformation ei = new EntityInformation(entity);
        try {
            String value = ei.toXML();
            Object object = this.syncObj;
            synchronized (object) {
                dht.put(key, (Serializable)((Object)value), 10000L, this.secret);
                this.entry.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean removeEntity(String keyword, Entity entity) {
        this.idSize = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        ID key = null;
        try {
            key = ID.getSHA1BasedID((byte[])keyword.getBytes(ENCODING), (int)this.idSize);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Set valueSet = dht.get(key);
        if (valueSet == null) {
            return false;
        }
        for (ValueInfo s : valueSet) {
            EntityInformation info;
            String str = (String)((Object)s.getValue());
            try {
                info = this.parser.parse(str);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (!info.getUri().equals(entity.getURI().toString())) continue;
            ValueInfo ret = dht.remove(key, (Serializable)((Object)str), this.secret);
            this.entry.remove(key);
            return ret != null;
        }
        return false;
    }
}

