/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataParser;
import jp.ac.naka.ec.sensor.SensorDataParserImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EntityInformationParser
implements ErrorHandler {
    private static DocumentBuilder db;
    private static EntityInformationParser instance;
    private static SensorDataParser parser;

    static {
        instance = new EntityInformationParser();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
            db.setErrorHandler(instance);
            parser = SensorDataParserImpl.getInstance();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static EntityInformationParser getInstance() {
        return instance;
    }

    public EntityInformation parse(String content) throws SAXException, IOException {
        return this.parse(content.getBytes());
    }

    public EntityInformation parse(byte[] content) throws SAXException, IOException {
        Node temp;
        Document doc = db.parse(new ByteArrayInputStream(content), "UTF-8");
        Element eiml = doc.getDocumentElement();
        String name = null;
        String uri = null;
        String type = null;
        String description = "";
        Location location = null;
        SensorData[] sensors = null;
        Element root = (Element)eiml.getElementsByTagName("service").item(0);
        EntityInformation info = new EntityInformation();
        name = root.getAttribute("name");
        uri = root.getAttribute("uri");
        type = root.getAttribute("type");
        NodeList list = root.getElementsByTagName("location");
        location = this.getLocation(list.item(0));
        list = root.getElementsByTagName("sensor");
        sensors = new SensorData[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            sensors[i] = parser.parse(element);
            ++i;
        }
        list = root.getElementsByTagName("description");
        Node node = list.item(0);
        if (node != null && (temp = node.getFirstChild()) != null) {
            description = temp.getNodeValue();
        }
        info.setServiceName(name);
        info.setServiceType(type);
        info.setDescription(description);
        info.setSensors(sensors);
        info.setUri(uri);
        info.setLocation(location);
        return info;
    }

    private Location getLocation(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap oAttrs = node.getAttributes();
        String name = oAttrs.getNamedItem("name").getNodeValue();
        String lat = oAttrs.getNamedItem("latitude").getNodeValue();
        String lon = oAttrs.getNamedItem("longitude").getNodeValue();
        Location location = name != null ? new Location(name, lat, lon) : new Location(lat, lon);
        return location;
    }

    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }
}

