/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.AudioPlayer;

public class AudioReceiverEntity
extends AbstractEntity {
    Entity callee;
    AudioPlayer ap;
    ButtonFrame button;

    public void init() {
        int port = 22224;
        this.setEntityType(EntityType.MEDIA_RECEIVER);
        this.addKeyword("audio_receiver");
        this.ap = new AudioPlayer(port);
        this.button = new ButtonFrame("Audio Receiver");
    }

    public void receiveMessage(EntityEvent e) {
    }

    public void receiveAnswer(EntityEvent evt) {
        SessionDescription sdp = evt.getSessionDescription();
        try {
            System.out.println("start");
            this.ap.receiveMediaStream(sdp);
            Component comp = this.ap.getReceiverController();
            this.button.add(comp);
            this.button.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requestMedia() {
        if (this.callee != null) {
            return;
        }
        EntityContainer con = this.getContainer();
        Entity[] set = null;
        SessionDescription sdp = null;
        set = con.searchEntities("audio_transmitter");
        try {
            sdp = this.ap.getRequestSessionDescription(this);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        Entity[] entityArray = set;
        int n = 0;
        int n2 = entityArray.length;
        while (n < n2) {
            Entity entity = entityArray[n];
            if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER) {
                this.sendOffer(sdp, entity);
                this.callee = entity;
                break;
            }
            ++n;
        }
    }

    public void receiveBye(EntityEvent e) {
        if (this.ap.isPlaying()) {
            this.ap.stopReceivingMediaStream();
        }
        this.callee = null;
    }

    public static void main(String[] args) {
        EntityCollaborator ec = EntityCollaborator.getInstance();
        try {
            ec.initiateSipCore();
            ec.addEntity(new AudioReceiverEntity());
            ec.findPeer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ButtonFrame
    extends JFrame {
        JButton jb;
        JButton bye;
        JPanel panel;

        public ButtonFrame(String name) {
            super(name);
            this.jb = new JButton("Request Media!");
            this.bye = new JButton("BYE");
            this.panel = new JPanel();
            this.panel.add(this.jb);
            this.panel.add(this.bye);
            this.setLayout(new GridLayout(2, 1));
            this.jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AudioReceiverEntity.this.requestMedia();
                }
            });
            this.bye.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((ButtonFrame)ButtonFrame.this).AudioReceiverEntity.this.callee != null) {
                        AudioReceiverEntity.this.sendBye(((ButtonFrame)ButtonFrame.this).AudioReceiverEntity.this.callee);
                        ((ButtonFrame)ButtonFrame.this).AudioReceiverEntity.this.ap.stopReceivingMediaStream();
                        ((ButtonFrame)ButtonFrame.this).AudioReceiverEntity.this.callee = null;
                        System.out.println("end");
                    }
                }
            });
            this.add((Component)this.panel, 0);
            this.pack();
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }
    }
}

