/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.SupportedHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.RequestDelegate;
import jp.ac.naka.ec.sip.ResponseDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultListener
implements SipListener {
    public static final List<String> supportMethods;
    private SipCore sipCore;
    protected List<String> extensions;
    protected List<String> requires;
    private static Log logger;
    MethodDelegate delegate = new RequestDelegate();
    ResponseDelegate resDelegate = new ResponseDelegate();

    static {
        logger = LogFactory.getLog(DefaultListener.class);
        String[] methods = new String[]{"INVITE", "MESSAGE", "SUBSCRIBE", "NOTIFY", "ACK", "REGISTER"};
        supportMethods = Arrays.asList(methods);
    }

    public void processRequest(RequestEvent evt) {
        if (this.sipCore == null) {
            this.sipCore = SipCore.getInstance();
        }
        Request req = evt.getRequest();
        FromHeader from = (FromHeader)req.getHeader("From");
        logger.info((Object)(String.valueOf(evt.getRequest().getMethod()) + " Message from: " + from.getAddress().getURI()));
        try {
            this.methodInspection(evt);
            this.headerInspection(evt);
            this.contentProcessing(evt);
            this.applyingExtensions(evt);
            if (!this.isAuthorized(evt)) {
                this.sipCore.sendResponse(401, evt.getRequest());
                return;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        this.delegate.forward(evt);
    }

    private boolean isAuthorized(RequestEvent evt) {
        return true;
    }

    public void processResponse(ResponseEvent evt) {
        Response res = evt.getResponse();
        ToHeader to = (ToHeader)res.getHeader("To");
        logger.info((Object)(String.valueOf(res.getStatusCode()) + " Response from: " + to.getAddress().toString()));
        this.resDelegate.forward(evt);
    }

    public void processTimeout(TimeoutEvent evt) {
        ClientTransaction transaction = null;
        if (!evt.isServerTransaction()) {
            transaction = evt.getClientTransaction();
        }
    }

    protected void methodInspection(RequestEvent evt) throws SipException, ParseException, InvalidArgumentException {
        Request req = evt.getRequest();
        RequireHeader require = (RequireHeader)req.getHeader("Require");
        if (require == null) {
            return;
        }
        String method = req.getMethod();
        if (!supportMethods.contains(method)) {
            this.sipCore.sendResponse(405, req);
            throw new SipException("METHOD_NOT_ALLOWED :" + method);
        }
    }

    protected void headerInspection(RequestEvent evt) throws SipException, ParseException, InvalidArgumentException {
        Request req = evt.getRequest();
        if (!this.checkURIScheme(req)) {
            this.sipCore.sendResponse(416, req);
            throw new SipException("UNSUPPORTED_URI_SCHEME :" + evt.getRequest().getRequestURI());
        }
        RequireHeader rHeader = (RequireHeader)req.getHeader("Require");
        if (rHeader == null) {
            return;
        }
        String tag = rHeader.getOptionTag();
        if (this.extensions == null || !this.extensions.contains(tag)) {
            if (supportMethods.contains(tag)) {
                return;
            }
            this.sipCore.sendResponse(420, req);
            throw new SipException("BAD_EXTENSION :" + tag);
        }
        if (this.extensions != null && this.extensions.contains(tag)) {
            return;
        }
        if (this.mergeCheck(req)) {
            this.sipCore.sendResponse(482, req);
        }
    }

    protected void contentProcessing(RequestEvent evt) throws SipException, ParseException, InvalidArgumentException {
        Request req = evt.getRequest();
        byte[] raw = req.getRawContent();
        if (raw == null) {
            return;
        }
        ContentTypeHeader contentType = (ContentTypeHeader)req.getHeader("Content-Type");
        ContentDispositionHeader disposition = req.getContentDisposition();
        if (disposition == null) {
            return;
        }
        if (disposition.getDispositionType().equals("handling=required")) {
            this.sipCore.sendResponse(415, req);
            throw new SipException("UNSUPPORTED_MEDIA_TYPE :" + contentType.toString());
        }
    }

    protected void applyingExtensions(RequestEvent evt) throws SipException, ParseException, InvalidArgumentException {
        Request req = evt.getRequest();
        SupportedHeader support = (SupportedHeader)req.getHeader("Supported");
        if (this.requires == null) {
            return;
        }
        if (!this.requires.contains(support)) {
            this.sipCore.sendResponse(421, req);
            throw new SipException("EXTENSION_REQUIRED :" + this.requires.toString());
        }
    }

    private boolean checkURIScheme(Request req) {
        URI uri = req.getRequestURI();
        return uri instanceof SipURI;
    }

    protected boolean mergeCheck(Request req) {
        return false;
    }

    protected boolean checkContent(Request req) {
        return true;
    }

    public List getSupportMethods() {
        return supportMethods;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public void processDialogTerminated(DialogTerminatedEvent evt) {
        logger.info((Object)("Dialog terminated :" + evt.getDialog()));
    }

    public void processIOException(IOExceptionEvent arg0) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent evt) {
        evt.isServerTransaction();
    }
}

