/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction {
    private ConcurrentHashMap sipDialogs;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private ServerResponseInterface respondTo;
    private SIPDialog defaultDialog;

    protected SIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        this.setBranch(Utils.generateBranchId());
        this.messageProcessor = newChannelToUse.messageProcessor;
        this.setEncapsulatedChannel(newChannelToUse);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating clientTransaction " + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.sipDialogs = new ConcurrentHashMap();
    }

    public void setResponseInterface(ServerResponseInterface newRespondTo) {
        this.respondTo = newRespondTo;
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders = messageToTest.getViaHeaders();
        String messageBranch = ((Via)viaHeaders.getFirst()).getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().toLowerCase().startsWith("z9hg4bk") && messageBranch.toLowerCase().startsWith("z9hg4bk");
        boolean transactionMatches = false;
        if (TransactionState.COMPLETED == this.getState()) {
            transactionMatches = rfc3261Compliant ? this.getBranch().equalsIgnoreCase(((Via)viaHeaders.getFirst()).getBranch()) && this.getMethod().equals(messageToTest.getCSeq().getMethod()) : this.getBranch().equals(messageToTest.getTransactionId());
        } else if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (viaHeaders != null && this.getBranch().equalsIgnoreCase(((Via)viaHeaders.getFirst()).getBranch())) {
                    transactionMatches = this.getOriginalRequest().getCSeq().getMethod().equals(messageToTest.getCSeq().getMethod());
                }
            } else {
                transactionMatches = this.getBranch() != null ? this.getBranch().equalsIgnoreCase(messageToTest.getTransactionId()) : this.getOriginalRequest().getTransactionId().equalsIgnoreCase(messageToTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    public void sendMessage(SIPMessage messageToSend) throws IOException {
        SIPRequest transactionRequest = (SIPRequest)messageToSend;
        Via topVia = (Via)transactionRequest.getViaHeaders().getFirst();
        try {
            topVia.setBranch(this.getBranch());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Sending Message " + messageToSend);
            this.sipStack.getLogWriter().logDebug("TransactionState " + this.getState());
        }
        if ((TransactionState.PROCEEDING == this.getState() || TransactionState.CALLING == this.getState()) && transactionRequest.getMethod().equals("ACK")) {
            if (this.isReliable()) {
                this.setState(TransactionState.TERMINATED);
            } else {
                this.setState(TransactionState.COMPLETED);
            }
            super.sendMessage(transactionRequest);
            return;
        }
        try {
            this.lastRequest = transactionRequest;
            if (this.getState() == null) {
                this.setOriginalRequest(transactionRequest);
                if (transactionRequest.getMethod().equals("INVITE")) {
                    this.setState(TransactionState.CALLING);
                } else if (transactionRequest.getMethod().equals("ACK")) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.TRYING);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                if (this.isInviteTransaction()) {
                    this.enableTimeoutTimer(64);
                } else {
                    this.enableTimeoutTimer(64);
                }
            }
            super.sendMessage(transactionRequest);
        }
        catch (IOException e) {
            this.setState(TransactionState.TERMINATED);
            throw e;
        }
    }

    public synchronized void processResponse(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) {
        if (this.getState() == null) {
            return;
        }
        if ((TransactionState.COMPLETED == this.getState() || TransactionState.TERMINATED == this.getState()) && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
            this.sipStack.logWriter.logDebug("dialog = " + dialog);
        }
        this.lastResponse = transactionResponse;
        if (dialog != null && transactionResponse.getStatusCode() != 100 && transactionResponse.getTo().getTag() != null) {
            dialog.setLastResponse(this, transactionResponse);
            this.setDialog(dialog, transactionResponse.getDialogId(false));
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel, dialog);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel, dialog);
            }
        }
        catch (IOException ex) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog sipDialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TRYING == this.getState()) {
            if (statusCode / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semaphore.release();
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.getSIPStack().logWriter.logDebug(" Not sending response to TU! " + this.getState());
            }
            this.semaphore.release();
        }
    }

    private void inviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TERMINATED == this.getState()) {
            this.semaphore.release();
            return;
        }
        if (TransactionState.CALLING == this.getState()) {
            if (statusCode / 100 == 2) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.TERMINATED);
            } else if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
                this.setState(TransactionState.PROCEEDING);
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
            } else if (statusCode / 100 == 2) {
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getState() && 300 <= statusCode && statusCode <= 699) {
            try {
                this.semaphore.release();
                this.sendMessage((SIPRequest)this.createAck());
            }
            catch (SipException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public void sendRequest() throws SipException {
        SIPRequest sipRequest = this.getOriginalRequest();
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("sendRequest() " + sipRequest);
        }
        try {
            sipRequest.checkHeaders();
        }
        catch (ParseException ex) {
            this.sipStack.logWriter.logError("missing required header");
            throw new SipException(ex.getMessage());
        }
        if (this.getMethod().equals("SUBSCRIBE") && sipRequest.getHeader("Expires") == null) {
            this.sipStack.logWriter.logWarning("Expires header missing in outgoing subscribe -- Notifier will assume implied value on event package");
        }
        try {
            if (this.getOriginalRequest().getMethod().equals("CANCEL")) {
                SIPClientTransaction ct = (SIPClientTransaction)this.sipStack.findCancelTransaction(this.getOriginalRequest(), false);
                if (ct == null) {
                    throw new SipException("Could not find original tx to cancel. RFC 3261 9.1");
                }
                if (ct.getState() == null) {
                    throw new SipException("State is null no provisional response yet -- cannot cancel RFC 3261 9.1");
                }
                if (!ct.getMethod().equals("INVITE")) {
                    throw new SipException("Cannot cancel non-invite requests RFC 3261 9.1");
                }
            } else if (this.getOriginalRequest().getMethod().equals("BYE") || this.getOriginalRequest().getMethod().equals("NOTIFY")) {
                SIPDialog dialog = this.sipStack.getDialog(this.getOriginalRequest().getDialogId(false));
                if (this.getSipProvider().isAutomaticDialogSupportEnabled() && dialog != null) {
                    throw new SipException("Dialog is present and AutomaticDialogSupport is enabled for  the provider -- Send the Request using the Dialog.sendRequest(transaction)");
                }
            }
            this.isMapped = true;
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            this.setState(TransactionState.TERMINATED);
            throw new SipException("IO Error sending request");
        }
    }

    protected void fireRetransmissionTimer() {
        block6: {
            try {
                if (this.getState() == null || !this.isMapped) {
                    return;
                }
                if (TransactionState.CALLING != this.getState() && TransactionState.TRYING != this.getState() || this.lastRequest == null) break block6;
                if (this.sipStack.generateTimeStampHeader && this.lastRequest.getHeader("Timestamp") != null) {
                    long milisec = System.currentTimeMillis();
                    TimeStamp timeStamp = new TimeStamp();
                    try {
                        timeStamp.setTimeStamp(milisec);
                    }
                    catch (InvalidArgumentException ex) {
                        InternalErrorHandler.handleException(ex);
                    }
                    this.lastRequest.setHeader(timeStamp);
                }
                super.sendMessage(this.lastRequest);
            }
            catch (IOException e) {
                this.raiseIOExceptionEvent();
                this.raiseErrorEvent(2);
            }
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("fireTimeoutTimer " + this);
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if ((TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState() || TransactionState.PROCEEDING == this.getState()) && dialog != null) {
            if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod())) {
                dialog.setState(3);
            } else if (this.getOriginalRequest().getMethod().equalsIgnoreCase("BYE") && dialog.isTerminatedOnBye()) {
                dialog.setState(3);
            }
        }
        if (TransactionState.COMPLETED != this.getState()) {
            this.raiseErrorEvent(1);
        } else {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (!originalRequest.getMethod().equals("INVITE")) {
            throw new SipException("Only INIVTE may be cancelled");
        }
        if (originalRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        return originalRequest.createCancelRequest();
    }

    public Request createAck() throws SipException {
        Route route;
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest ackRequest = originalRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            Contact contact = null;
            if (this.lastResponse.getContactHeaders() != null) {
                contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRoute rr = (RecordRoute)li.previous();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
        }
        Contact contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (contact != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
            }
            Route firstRoute = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            ackRequest.setRequestURI(uri);
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public void clearState() {
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        super.setState(newState);
    }

    protected void startTransactionTimer() {
        TransactionTimer myTimer = new TransactionTimer();
        this.sipStack.timer.schedule((TimerTask)myTimer, 500L, 500L);
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        SipStackImpl sipStack = (SipStackImpl)this.getSIPStack();
        String dialogId = sipResponse.getDialogId(false);
        SIPDialog dialog = this.getDialog(dialogId);
        if (dialog == null) {
            SIPClientTransaction sIPClientTransaction = this;
            synchronized (sIPClientTransaction) {
                if (this.defaultDialog != null && sipStack.isDialogCreated(sipResponse.getCSeq().getMethod()) && sipResponse.getStatusCode() != 100 && sipResponse.getFromTag() != null && sipResponse.getToTag() != null) {
                    SIPResponse dialogResponse = this.defaultDialog.getLastResponse();
                    String defaultDialogId = this.defaultDialog.getDialogId();
                    if (dialogResponse == null || sipResponse.getCSeq().getMethod().equals("SUBSCRIBE") && dialogResponse.getCSeq().getMethod().equals("NOTIFY") && defaultDialogId.equals(dialogId)) {
                        this.defaultDialog.setLastResponse(this, sipResponse);
                        dialog = this.defaultDialog;
                    } else if (this.getDialog(dialogId) == null) {
                        dialog = sipStack.getDialog(dialogId);
                        if (dialog == null) {
                            dialog = new SIPDialog(this, sipResponse);
                        }
                    } else {
                        dialog = this.getDialog(dialogId);
                        dialog.setLastResponse(this, sipResponse);
                    }
                    this.setDialog(dialog, dialog.getDialogId());
                }
            }
        }
        if (dialog == null) {
            dialog = this.defaultDialog;
        }
        this.processResponse(sipResponse, incomingChannel, dialog);
    }

    public synchronized Dialog getDialog() {
        SIPDialog retval = null;
        if (this.lastResponse != null && this.lastResponse.getFromTag() != null && this.lastResponse.getToTag() != null && this.lastResponse.getStatusCode() != 100) {
            String dialogId = this.lastResponse.getDialogId(false);
            retval = this.getDialog(dialogId);
        }
        if (retval == null) {
            retval = this.defaultDialog;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(" sipDialogs =  " + this.sipDialogs + " default dialog " + this.defaultDialog + " retval " + retval);
        }
        return retval;
    }

    public synchronized SIPDialog getDialog(String dialogId) {
        SIPDialog retval = (SIPDialog)this.sipDialogs.get((Object)dialogId);
        return retval;
    }

    public synchronized void setDialog(SIPDialog sipDialog, String dialogId) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("setDialog: " + dialogId + "sipDialog = " + sipDialog);
        }
        if (sipDialog == null) {
            this.sipStack.logWriter.logError("NULL DIALOG!!");
            throw new NullPointerException("bad dialog null");
        }
        if (this.defaultDialog == null) {
            this.defaultDialog = sipDialog;
        }
        if (dialogId != null && sipDialog.getDialogId() != null) {
            this.sipDialogs.put((Object)dialogId, (Object)sipDialog);
        }
    }

    public synchronized SIPDialog getDefaultDialog() {
        return this.defaultDialog;
    }

    public class TransactionTimer
    extends TimerTask {
        public void run() {
            SIPClientTransaction clientTransaction = SIPClientTransaction.this;
            SIPTransactionStack sipStack = clientTransaction.sipStack;
            if (clientTransaction.isTerminated()) {
                block10: {
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.logWriter.logDebug("removing  = " + clientTransaction + " isReliable " + clientTransaction.isReliable());
                    }
                    sipStack.removeTransaction(clientTransaction);
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException ex) {
                        if (sipStack.isAlive()) break block10;
                        return;
                    }
                }
                if (!sipStack.cacheClientConnections && clientTransaction.isReliable()) {
                    int newUseCount = clientTransaction.getMessageChannel() instanceof TCPMessageChannel ? --((TCPMessageChannel)clientTransaction.getMessageChannel()).useCount : --((TLSMessageChannel)clientTransaction.getMessageChannel()).useCount;
                    if (newUseCount <= 0) {
                        SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer(SIPClientTransaction.this);
                        sipStack.timer.schedule((TimerTask)myTimer, 8000L);
                    }
                } else if (sipStack.isLoggingEnabled() && clientTransaction.isReliable()) {
                    int useCount = clientTransaction.getMessageChannel() instanceof TCPMessageChannel ? ((TCPMessageChannel)clientTransaction.getMessageChannel()).useCount : ((TLSMessageChannel)clientTransaction.getMessageChannel()).useCount;
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.logWriter.logDebug("Client Use Count = " + useCount);
                    }
                }
            } else {
                clientTransaction.fireTimer();
            }
        }
    }
}

