/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity;

import javax.sdp.SessionDescription;
import javax.sip.address.SipURI;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.sensor.SensorData;

/**
 * 
 * @author Takashi Kasuya
 * 
 */
public interface Entity extends EntityListener {

	/**
	 * SDPw肵ăZbṼNGXg
	 * 
	 * @param sdp
	 * @param target
	 * @return
	 */
	public boolean sendOffer(SessionDescription sdp, Entity target);

	/**
	 * SDPw肹ɃNGXgASDPɂtH[}bg̎wɏ]B
	 * 
	 * @param target
	 * @return
	 */
	public boolean sendOffer(Entity target);

	/**
	 * bZ[WSẴXiɑ΂ĔzM
	 * 
	 * @param msg
	 */
	public boolean sendMessage(String msg);

	
	/**
	 * ^[Qbgw肵ăbZ[W̑M
	 * 
	 * @param msg
	 * @param targetName
	 */
	public boolean sendMessage(String msg, Entity target);

	/**
	 * BYEbZ[W̑M
	 * 
	 * @param target
	 * @return
	 */
	public boolean sendBye(Entity target);

	/**
	 * EntityType̎擾
	 * 
	 * @return
	 */
	public EntityType getEntityType();

	/**
	 * 
	 * @param type
	 */
	public void setEntityType(EntityType type);

	/**
	 * EntityContainer̎擾
	 * 
	 * @return
	 */
	public EntityContainer getContainer();
	public void setEntityContainer(EntityContainer impl);
	public void setDescrpition(String description);
	public String getDescription();
	public void setName(String name);
	public String getName();
	public void setLocal(boolean b);
	public void addKeyword(String str);
	public String[] getKeywords();


	/**
	 * SUBSCRIBEM
	 * 
	 * 
	 */
	public boolean subscribe(Entity target);
	public boolean unsubscribe(Entity target);
	
	public Location getLocation();
	public void setLocation (Location location);

	/**
	 * [JɂEntityǂB
	 * 
	 * @return
	 */
	public boolean isLocal();

	/**
	 * 
	 * @param uri
	 */
	public void setURI(SipURI uri);

	/**
	 * 
	 * @return
	 */
	public SipURI getURI();

	public String createPIDF();

	public boolean removeSensorData(SensorData sensor);
	public void addSensorData(SensorData sensor);
	public SensorData[] getSensors();

}
