package jp.ac.naka.ec.entity.test;

import javax.sdp.SessionDescription;
import javax.swing.JFrame;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.AudioPlayer;

public class AudioTransmitterEntity extends AbstractEntity {
	Entity caller;

	AudioPlayer ap;
	String path = null;

	@Override
	public void init() {
		int port = 22224;
		ap = new AudioPlayer(port);
		setEntityType(EntityType.MEDIA_TRANSMITTER);
		addKeyword("audio_transmitter");
		
		// audio fileiȗꍇ̓Lv`[j
		//path = "C:\\Documents and Settings\\kasuya\\My Documents\\My Music\\iTunes\\iTunes Music\\Angela Aki\\Home\01 Kiss Me Good-Bye.mp3";
	}

	@Override
	public void receiveMessage(EntityEvent e) {
	}

	@Override
	public SessionDescription receiveOffer(EntityEvent evt) {
		if (caller != null)
			return null;
		if (ap == null) {
			int port = 22224;
			ap = new AudioPlayer(port);
		}
		caller = (Entity) evt.getSource();
		SessionDescription sdp = evt.getSessionDescription();
		SessionDescription temp = null;
		try {
			temp = ap.getResponseSessionDescription(sdp);
			if (temp != null && !ap.isPlaying()) {
				ap.sendMediaStream(path, sdp);
				showController();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return temp;
	}

	JFrame jf;
	
	private void showController() {
		jf = new JFrame("controller");
		jf.add(ap.getTransmitterController());
		jf.pack();
		jf.setVisible(true);
	}

	@Override
	public void receiveBye(EntityEvent e) {
		if (ap.isPlaying())
			ap.stopReceivingMediaStream();
		caller = null;
		jf.setVisible(false);
		jf = null;
	}
	public static void main(String[] args) {
		EntityCollaborator ec = EntityCollaborator.getInstance();
		try {
			ec.initiateSipCore();
			ec.addEntity(new AudioTransmitterEntity());
			ec.findPeer();
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
}
