/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JFrame;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;

/**
 * eXgpEntityB{^ƃCxg𔭉΁B
 * 
 * @author Takashi Kasuya
 * 
 */

public class ButtonEntity extends AbstractEntity {
	private String name = "ButtonEntity";

	String message = "Push Button!";

	@Override
	public void init() {
		new ButtonFrame(name, this);
		setEntityType(EntityType.SENSOR);
	}

	public void receiveMessage(EntityEvent e) {
		System.out.println("Button : " + e.getMessage());
	}

	

	private void dispatchEvent() {

		// BroadCast
		//this.sendMessage(message);
		EntityContainer con = getContainer();
		
		Entity[] e = null;
			e = con.searchEntities("hoge");
	
		for (Entity entity : e) {
			sendMessage(message, entity);
		}
		/*
		Entity[] e = con.getEntities();
		for (Entity entity : e) {
			sendMessage(message, entity);
		}*/

	}

	private class ButtonFrame extends JFrame {
		JButton jb = new JButton("Push!");

		final ButtonEntity parent;

		public ButtonFrame(String name, ButtonEntity p) {
			super(name);
			this.parent = p;

			jb.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					parent.dispatchEvent();
				}
			});
			getContentPane().add(jb);
			pack();
			this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			setVisible(true);
		}
	}

	public void setButtonName(String name) {
		this.name = name;
	}

	/**
	 * {^ĔzM郁bZ[Wݒ
	 * 
	 * @param str
	 */
	public void setMessage(String str) {
		this.message = str;
	}
	
	public static void main(String[] args) {
		try {
			EntityCollaborator ec = EntityCollaborator.getInstance("en1");
			ec.initiateSipCore();
			ec.addEntity(new ButtonEntity());
			ec.findPeer();
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
}
