/* gdra.c
   Copyright (C) 2007
   NAKANISHI Shin

   This file is part of SBL.

   SBL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   SBL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with SBL; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#include <btron.h>

ERR gdra_lin(GID gid, PNT p1, PNT p2, LATTR attr, PAT *pat, DCM mode)
{
  /* gid, attr, mode, pat Ͼά */
#ifdef NOGID
  line_vga(1, p1.x + swin_x, p1.y + swin_y, p2.x + swin_x, p2.y + swin_y,
           BLACK, 0);
#else
  line_vga(1, p1.x, p1.y, p2.x, p2.y, BLACK, 0);
#endif /* NOGID */
  return 0;
}

ERR gdra_pnt(GID gid, PNT p, PIXVAL val, DCM mode)
{
  /* gid, val, mode Ͼά */
#ifdef NOGID
  point_vga(1, p.x + swin_x, p.y + swin_y, BLACK, 0);
#else
  point_vga(1, p.x, p.y, BLACK, 0);
#endif /* NOGID */
  return 0;
}

ERR gfra_rec(GID gid, RECT r, LATTR attr, PAT *pat, DEG angle, DCM mode)
{
  /* gid, attr, pat, angle, mode Ͼά */
#ifdef NOGID
  box_vga(1, r.c.left + swin_x, r.c.top + swin_y, r.c.right + swin_x,
          r.c.bottom + swin_y, BLACK, 0);
#else
  box_vga(1, r.c.left, r.c.top, r.c.right, r.c.bottom, BLACK, 0);
#endif /* NOGID */
  return 0;
}

ERR gfil_rec(GID gid, RECT r, PAT *pat, DEG angle, DCM mode)
{
  /* gid, pat, angle, mode Ͼά */
#ifdef NOGID
  fillbox_vga(1, r.c.left + swin_x, r.c.top + swin_y, r.c.right + swin_x, r.c.bottom + swin_y, BLACK, 0);
#else
  fillbox_vga(1, r.c.left, r.c.top, r.c.right, r.c.bottom, BLACK, 0);
#endif
  return 0;
}

ERR gfra_ovl(GID gid, RECT r, LATTR attr, PAT *pat, DEG angle, DCM mode)
{
  /* gid, attr, pat, angle, mode Ͼά */
#ifdef NOGID
  ellipse_vga(1, r.c.left + swin_x, r.c.top + swin_y, r.c.right + swin_x,
              r.c.bottom + swin_y, BLACK, 0);
#else
  ellipse_vga(1, r.c.left, r.c.top, r.c.right, r.c.bottom, BLACK, 0);
#endif /* NOGID */
  return 0;
}

ERR gfil_ovl(GID gid, RECT r, PAT *pat, DEG angle, DCM mode)
{
  /* gid, pat, angle, mode Ͼά */
#ifdef NOGID
  fillellipse_vga(1, r.c.left + swin_x, r.c.top + swin_y, r.c.right + swin_x,
                  r.c.bottom + swin_y, BLACK, 0);
#else
  fillellipse_vga(1, r.c.left, r.c.top, r.c.right, r.c.bottom, BLACK, 0);
#endif /* NOGID */
  return 0;
}

