/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.anzip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ANZip {
    protected static final String JAVA_HOME = "anzip.javahome";
    protected static final String OUT_FOLDER = "anzip.out";
    protected static final String PATH_SEPARATOR = "path.separator";
    protected static final String CLASS_PATH = "java.class.path";

    private ANZip() {
    }

    public static void main(String[] stringArray) {
        ANZip aNZip = new ANZip();
        aNZip.execute(stringArray);
    }

    protected void execute(String[] stringArray) {
        if (this.isOutCheck()) {
            System.err.println("anzip.out is not folder.");
            return;
        }
        if (stringArray.length < 1 || 2 < stringArray.length) {
            System.err.println("paramater error");
            System.err.println("\tjava -Danzip.javahome=c:\\java2 -jar ANZip.jar in.jar [target.class]");
            return;
        }
        try {
            if (stringArray.length == 1) {
                this.fullPrint(stringArray[0]);
            } else if (this.isClassFile(stringArray[1])) {
                this.classPrint(stringArray[0], stringArray[1]);
            } else {
                this.filePrint(stringArray[0], stringArray[1]);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    protected void fullPrint(String string) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file = new File(zipEntry.getName());
            int n = file.getName().lastIndexOf(46);
            if (n <= 0) continue;
            if (this.isClassFile(zipEntry.getName())) {
                this.classPrint(string, zipEntry.getName());
                continue;
            }
            this.filePrint(zipFile, zipEntry);
        }
        zipFile.close();
    }

    protected void classPrint(String string, String string2) throws IOException {
        String string3 = System.getProperty(JAVA_HOME);
        String string4 = "javap.exe";
        if (string3 != null) {
            string4 = string3 + File.separator + "bin" + File.separator + string4;
        }
        String[] stringArray = new String[5];
        String string5 = string2.substring(0, string2.lastIndexOf(46));
        stringArray[0] = string4;
        stringArray[1] = "-private";
        stringArray[2] = "-classpath";
        stringArray[3] = string;
        if (System.getProperty(PATH_SEPARATOR) != null && System.getProperty(CLASS_PATH) != null) {
            stringArray[3] = stringArray[3] + System.getProperty(PATH_SEPARATOR) + System.getProperty(CLASS_PATH);
        }
        stringArray[4] = ANZip.change(string5);
        OutputStream outputStream = this.getOutputStream(string2);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        ANRunnable aNRunnable = new ANRunnable(process.getErrorStream(), System.err);
        Thread thread = new Thread(aNRunnable);
        thread.start();
        ANRunnable aNRunnable2 = new ANRunnable(process.getInputStream(), outputStream);
        Thread thread2 = new Thread(aNRunnable2);
        thread2.start();
        try {
            while (thread.isAlive() || thread2.isAlive()) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("InterruptedException :" + interruptedException.getMessage());
        }
        if (outputStream != System.out) {
            outputStream.close();
        }
    }

    protected void filePrint(String string, String string2) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        ZipEntry zipEntry = zipFile.getEntry(string2);
        this.filePrint(zipFile, zipEntry);
    }

    protected void filePrint(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        int n;
        OutputStream outputStream = this.getOutputStream(zipEntry.getName());
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        while ((n = inputStream.read(byArray = new byte[1024])) > 0) {
            outputStream.write(byArray, 0, n);
        }
        if (outputStream != System.out) {
            outputStream.close();
        }
    }

    protected boolean isOutCheck() {
        String string = System.getProperty(OUT_FOLDER);
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return !file.isDirectory();
    }

    protected OutputStream getOutputStream(String string) throws IOException {
        String string2 = System.getProperty(OUT_FOLDER);
        if (string2 == null) {
            return System.out;
        }
        File file = new File(string);
        String string3 = file.getName();
        int n = string3.lastIndexOf(46);
        if (n <= 0) {
            throw new FileNotFoundException("this is directory");
        }
        String string4 = file.getPath();
        String string5 = string2;
        while (true) {
            if ((n = string4.indexOf(47)) < 0) {
                n = string4.indexOf(92);
            }
            if (n < 0) break;
            File file2 = new File(string5 = string5 + File.separator + string4.substring(0, n));
            if (file2.isDirectory() || file2.mkdir()) {
                // empty if block
            }
            string4 = string4.substring(n + 1);
        }
        string5 = file.getPath();
        if (this.isClassFile(string5)) {
            n = string5.lastIndexOf(46);
            string5 = string5.substring(0, n) + ".java";
        }
        string2 = string2 + File.separator + string5;
        return new FileOutputStream(new File(string2));
    }

    protected boolean isClassFile(String string) {
        int n = string.lastIndexOf(46);
        try {
            return string.substring(n + 1).toLowerCase().equals("class");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String change(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\') {
                stringBuffer.replace(n, n + 1, ".");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private class ANRunnable
    implements Runnable {
        private InputStream istream;
        private OutputStream ostream;

        public ANRunnable(InputStream inputStream, OutputStream outputStream) {
            this.istream = inputStream;
            this.ostream = outputStream;
        }

        public void run() {
            try {
                byte[] byArray;
                int n;
                while ((n = this.istream.read(byArray = new byte[1024])) > 0) {
                    this.ostream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
    }
}

