;;; epocclib.el -- The Editing Process Organizer / extension CC-mode lib.
;;<plaintext>

(defconst epocclib-revision-number
  "4.2.45" "epojava/epocc/epoxml revision number")

;; Author: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Maintainer: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Version: $Lastupdate: Sat Mar 15 11:28:22 2003 $ on inspire.
;; Created: 2001 Feb 10.
;; URL : http://park.ruru.ne.jp/ando/work/who/epojava/

;;; Code:

;; Abstract.
;;   This is lib file.
;------------------------------------------------------------------------

(defvar epocclib-erase-illegal-document t
  "* KandR style command delete illgal document")
(defvar epocclib-keyword-to-space nil
  "* KandR style \'keyword space (\' sytle ")
(defvar epocclib-delete-alltab t
  "* KandR style delete all tab (I dislike vi !)")
(defvar epocclib-function-check t
  "* KandR style Function(Class) \'{\' check.")
;;;-------------------------------------------------------------
(defvar epocclib-explicit-shell-file-name "nil"
  "*If non-nil, is file name to use for explicitly requested inferior shell(Meadow).") 
(defvar epocclib-shell-file-name "cmdproxy"
  "*This option is unchanged from its epocclib setting(Meadow).") 
(defvar epocclib-shell-command-switch "-c"
  "*Switch used to have the shell execute its command line argument(Meadow).")
;;;-------------------------------------------------------------
(defvar epocclib-save-file "~/.epocclib"
  "* epocclib enviroment save file name")
(defvar epocclib-table-mode-map nil "epocclib-table key map")
(defvar epocclib-table-buffer-name "* epocclib-table *" "epocclib-table")
(defvar epocclib-table-data nil "epocclib-table display buffer")
(defvar epocclib-table-save-window-buffer nil "epocclib-table save buffer")
(defvar epocclib-table-regexp nil "*epocclib-table hit list")
;;;-------------------------------------------------------------
(defvar epocclib-dos (memq system-type '(ms-dos windows-nt OS/2))
  "if this parameter is true then windows mode")
(defconst epojava-mode-name  "epojava" "Epo Java-mode mode name")
(defconst epocclib-table-mode-name
  "epocclib-table" "Epo CC table monde name")
;;;------------------------------------------------------------
(defconst epocclib-table-font-lock-keywords-1
  '(("\\([_A-Za-z0-9]*\\)\\." 1 font-lock-keyword-face)
    ("^\\sw+[:;]" . font-lock-comment-face)))
(defvar epocclib-table-font-lock-keywords epocclib-table-font-lock-keywords-1
  "*Default expressions to highlight in epojava-table mode.")
(defvar epocclib-archive-regrep "\\.\\(zip\\|[jw]ar\\)$"
  "* for archive-mode")
;;-

;;;
;; Define key.
;;;
(require 'epo)

;;;
;;; person and sea stratage (In Japan. Called by jinkai-senjutu).
(defun epocclib-structure-b-input ()
  (interactive)
  (epoi*structure-input (assq ?b (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-s-input ()
  (interactive)
  (epoi*structure-input (assq ?s (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-f-input ()
  (interactive)
  (epoi*structure-input (assq ?f (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-l-input ()
  (interactive)
  (epoi*structure-input (assq ?l (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-n-input ()
  (interactive)
  (epoi*structure-input (assq ?n (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-att-input ()
  (interactive)
  (epoi*structure-input (assq ?@ (epo*get-cur-lang-alist 'structure))))
(defun epocclib-structure-ext-input ()
  (interactive)
  (epoi*structure-input (assq ?! (epo*get-cur-lang-alist 'structure))))

(defun epocclib-define-menu (keymap bindlist)
  "for yatexlib.el ...
http://www.yatex.org/

Define KEYMAP(symbol)'s menu-bindings according to BINDLIST.
KEYMAP should be a quoted symbol of newly allocated keymap.
BINDLIST consists of binding list.  Each element is as follows.

 '(menusymbol DOC_String . contents)

CONTENTS is one of lambda-form, interactive function, or other keymap."
  (cond
   ((featurep 'xemacs)
    (let (name)
      (if (keymapp (symbol-value keymap))
	  (progn
	    (setq name (keymap-name (symbol-value keymap)))
	    (set keymap nil))
	(setq name (car (symbol-value keymap)))
	(set keymap (cdr (symbol-value keymap))))
      (mapcar
       (function
	(lambda (bind)
	  (setq bind (cdr bind))
	   (if (eq (car-safe (cdr bind)) 'lambda)
	       (setcar (cdr bind) 'progn))
	   (if (stringp (car-safe (cdr bind)))
	       (set keymap
		    (cons (cdr bind) (symbol-value keymap)))
	     (set keymap
		  (cons (vector (car bind) (cdr bind) t)
			(symbol-value keymap))))))
       bindlist)
      (set keymap (cons name (symbol-value keymap)))))
   (t
    (mapcar
     (function
      (lambda (bind)
	(define-key (symbol-value keymap) (vector (car bind)) (cdr bind))))
     bindlist))))

;---------------------------------------------------------------------

(defun epocclib-translate-region (beg end)
  "Translate inhibited literals."
  (interactive "r")
  (require 'yahtml nil t)
  (if (fboundp 'yahtml-translate-region)
      (yahtml-translate-region beg end)
    (message "yahtml is not installed.")))

(defun epocclib-untranslate-region (beg end)
  "Translate un-inhibited literals."
  (interactive "r")
  (require 'yahtml nil t)
  (if (fboundp 'yahtml-translate-region)
      (yahtml-translate-reverse-region beg end)
    (message "yahtml is not installed.")))

(defun epocclib-uncomment-region (beg end &optional arg)
  "uncomment each line in the region."
  (interactive "r\nP")
 (comment-region beg end '(1)))

(defun epocclib-indent-all ()
 "c++-indent-command all lines"
 (interactive)
 (save-excursion
   (goto-char (point-min))
   (while (not (eobp))
     (if (looking-at "^[\t ]*$")
	 (replace-match "")
       (if (and indent-line-function (fboundp indent-line-function))
	   (funcall indent-line-function)))
     (forward-line 1)
     (if (buffer-file-name)
	 (message "%s:%d"
		  (file-name-nondirectory (buffer-file-name))
		  (count-lines (point-min) (point)))
       (message ":%d" (count-lines (point-min) (point)))))
   (message "success.")))

(defun epocclib-kandr-style ()
  "formating K&R style"
  (interactive)
  (save-excursion
    ;;;
    ;;;;; replace example ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;;
    ;
    (message "delete front tab")
    (goto-char (point-min))
    (while (re-search-forward "^[\t ]*\t[\t ]" nil t) (replace-match "    "))
    ;;
    (if epocclib-delete-alltab
	(progn
	  (message "delete tab")
	  (goto-char (point-min))
	  (while (re-search-forward "\t+" nil t) (replace-match " "))))
    ;;
    (message "delete rear space")
    (goto-char (point-min))
    (while (re-search-forward "[\t ]+$" nil t) (replace-match ""))
    ;;
    (message "delete \";\" befor space")
    (goto-char (point-min))
    (while (re-search-forward "[\t ]+;$" nil t) (replace-match ";"))
    ;;
    (if epocclib-erase-illegal-document
	(progn
	  ;; from
	  ;;    #endif HOGEHOGE_H /* hogehoge */
	  ;; to
	  ;;    #endif
	  (message "delete #.. illegal document")
	  (goto-char (point-min))
	  (while (re-search-forward "^#\\(else\\|endif\\)[ \t]+[A-Za-z_]*[ \t]*\\(//[^\r\n]*\\|/\\*[^\r\n/]*\\*/[ \t]*\\)*$" nil t)
	    (replace-match "#\\1" t))
	  
	  ;;
	  ;; from
	  ;;    while(...) {
	  ;;        ....
	  ;;    } /* while */
	  ;; to
	  ;;    while() {
	  ;;    }
	  (message "repair \"}\" illegal document")
	  (goto-char (point-min))
	  (while (re-search-forward "\\(}\\|[ \t]+else\\)[ \t]*/\\(/[^\r\n]*\\|\\*[^\r\n/]*\\*/[ \t]*\\)$" nil t)
	    (replace-match "\\1" t))))

    (message "repair \"if\" after space")
    (if epocclib-keyword-to-space
	(progn
          ;;; from          ;;; from
          ;;;    if(...     ;;;    else
	  ;;;               ;;;    if (...
          ;;; to            ;;; to
          ;;;    if (...    ;;;    else if (...
	  (goto-char (point-min))
	  (while (re-search-forward "\\([ \t]\\)\\(if\\|do\\|for\\|while|\\switch\\)[ \n\r\t]*(" nil t)
	    (replace-match "\\1\\2 (" t))
	  (goto-char (point-min))
	  (while (re-search-forward
		  "\\([ \t]else\\)[ \n\r\t]*if[ \n\r\t]*(" nil t)
	    (replace-match "\\1 if (" t)))
      (progn
          ;;; from          ;;; from
          ;;;    if(...     ;;;    else
	  ;;;               ;;;    if (...
          ;;; to            ;;; to
          ;;;    if (...    ;;;    else if (...
	  (goto-char (point-min))
	  (while (re-search-forward "\\([ \t]\\)\\(if\\|do\\|for\\|while\\|switch\\)[ \n\r\t]*(" nil t)
	    (replace-match "\\1\\2(" t))
	  (goto-char (point-min))
	  (while (re-search-forward
		  "\\([ \t]else\\)[ \n\r\t]*if[ \n\r\t]*(" nil t)
	    (replace-match "\\1 if(" t))))

    ;; from
    ;;    }
    ;;    else
    ;; to
    ;;    } else
    (message "repair \"else\" befor space")
    (goto-char (point-min))
    (while (re-search-forward "}[ \n\r\t]*\\(else\\|catch\\|final\\)\\([ \n\r\t]\\|{\\|(\\)" nil t)
      (replace-match "} \\1\\2" t))
    
    ;; from                    ;; from
    ;;    if(...)              ;;    else
    ;;    {                    ;;    {
    ;; to                      ;; to
    ;;    if(...) {            ;;    else {
    (message "repair \"else\" after space")
    (goto-char (point-min))
    (while (re-search-forward "\\()\\|[ \t]\\(else\\|final\\|try\\)\\)[ \n\r\t]*{" nil t)
      (replace-match "\\1 {" t))

    ;; for java-------------
    ;; from
    ;;     public class {
    ;; to
    ;;     public class
    ;;     {
    ;;
    ;; for C++/c----------------
    ;; from
    ;;    void foo(...) {
    ;; to
    ;;    void foo(...)
    ;;    {
    (message "repair function space")
    (goto-char (point-min))
    (if (equal mode-name epojava-mode-name)
	(while (re-search-forward "^\\(\\w[^;{]*\\w\\)[ \t\r\n]*{" nil t)
	  (if epocclib-function-check
	      (replace-match "\\1\n{" t)
	    (replace-match "\\1 {" t)))
      (while (re-search-forward "^\\(\\w[^;(]*([^;)]*\\))[ \t]*{" nil t)
	(if epocclib-function-check (replace-match "\\1)\n{" t))))
      
    ;;; indent all.
    (epocclib-indent-all)))

(defun epocclib-switch-to-buffer (file &optional other)
  "epocc buffer open session"
  (interactive "Fswitch to file: ")
  (if (null file) (error "no not yet"))
  (if (null (file-exists-p file)) (error "can not open file %s" file))
  (if (get-file-buffer file)
      (if other
	  (switch-to-buffer-other-window (get-file-buffer file))
	(switch-to-buffer (get-file-buffer file)))
    (if other
	(find-file-other-window file)
      (find-file file))))

(defun epocclib-version ()
  "epocc version"
  (interactive)
  (message "%s %s / EPO %s"
	   mode-name epocclib-revision-number epo-revision-number))

;;;
;;; table -------------------------------------------------------------
;;;

(if epocclib-table-mode-map
    nil
  (setq epocclib-table-mode-map   (make-sparse-keymap))
  (suppress-keymap epocclib-table-mode-map)
  (epo-define-key epocclib-table-mode-map "v"  'epocclib-view-file)
  (define-key     epocclib-table-mode-map "v"  'epocclib-view-file)
  (define-key     epocclib-table-mode-map "\r" 'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "\n" 'epocclib-table-insert)
  (define-key     epocclib-table-mode-map " "  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "e"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "j"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "b"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "c"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "l"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "s"  'epocclib-table-insert)
  (epo-define-key epocclib-table-mode-map "C-r" 'epocclib-table-insert)
  (epo-define-key epocclib-table-mode-map "g"  'epocclib-table-insert)
  (define-key     epocclib-table-mode-map "g"  'epocclib-table-insert)
  (epo-define-key epocclib-table-mode-map "h"  'describe-mode)
  (define-key     epocclib-table-mode-map "h"  'describe-mode)
  (epo-define-key epocclib-table-mode-map "q"  'epocclib-table-quit)
  (define-key     epocclib-table-mode-map "q"  'epocclib-table-quit))

(defun epocclib-table-mode-in (&optional other)
  "epocclib-mode class/function detail display

Key bindings:
 g : open.
 C-u \\[epocclib-view-file] : open same window.
 \\[epocclib-view-file] : view mode.
 \\[epocclib-table-quit] : quit."
  (interactive "P")
  (let ((line (count-lines (point-min) (point))) (ans 0) (number 0))
    (epocclib-table-mode (buffer-file-name) other)
    (goto-char 0)
    (while (and (< ans line) (re-search-forward "^\\([0-9]*\\)[:;]" nil t))
      (setq ans (string-to-int
		 (buffer-substring (match-beginning 1) (match-end 1))))
      (setq number (count-lines (point-min) (point))))
      (goto-line number)))

(defun epocclib-table-mode (word &optional other)
  "epocclib-mode create class/function detail display"
  (setq epocclib-table-save-window-buffer (current-window-configuration))
  (setq epocclib-table-data nil)
  (set-buffer (find-file word))
  (let ((case-fold-search nil) (buff))
    (save-excursion
      (goto-char 0)
      (while (re-search-forward	epocclib-table-regexp nil t)
	(setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	(setq num (format "%d" (count-lines (point-min) (point))))
	(setq epocclib-table-data
	      (concat epocclib-table-data num ":" buff "\n"))) ))
  ;;
  (set-window-configuration epocclib-table-save-window-buffer)
  (if (not other)
      (progn
	(if (one-window-p) (split-window (selected-window)))
	(other-window 1)))
  (switch-to-buffer (get-buffer-create epocclib-table-buffer-name))
  ;;
  (kill-all-local-variables)
  ;;
  (setq major-mode 'epocclib-table-mode
	mode-name   epocclib-table-mode-name)
  (use-local-map  epocclib-table-mode-map)
  ;;
  (setq buffer-read-only nil)
  (erase-buffer)
  (insert (concat "0;" word "\n"))
  (cd (file-name-directory word))
  (if epocclib-table-data (insert epocclib-table-data))
  (goto-line 0)
  (set-buffer-modified-p nil)
  (setq buffer-read-only t)
  (setq truncate-lines t)
  ;;
  (message "g)go v)view q)quit...")
  (setq indent-tabs-mode nil)
  (run-hooks 'epocclib-table-mode-hook))

(defun epocclib-table-quit ()
  "epocclib-table-mode quit"
  (interactive)
  (kill-buffer epocclib-table-buffer-name)
  (set-window-configuration epocclib-table-save-window-buffer))

(defun epocclib-table-insert (&optional other)
  "open file and kill epocclib-table-buffer-name"
  (interactive "P")
  (beginning-of-line)
  (looking-at "\\([0-9]*\\)\\([:;]\\)")
  (let ((ans nil)
	(number (buffer-substring (match-beginning 1) (match-end 1)))
	(next   (buffer-substring (match-beginning 2) (match-end 2))))
    (setq number (string-to-int number))
    (if (string-equal next ";")
	(beginning-of-line) (goto-char 0))
    (looking-at "[0-9]*[:;]\\(.*\\)")
    (setq ans (buffer-substring (match-beginning 1) (match-end 1)))
    (epocclib-switch-to-buffer ans other)
    (goto-line number))) ;;; not kill-buffer

(defun epocclib-view-file ()
  (interactive)
  "go to epocclib-table-mode (to view mode)"
  (interactive)
  (save-excursion
    (beginning-of-line)
    (looking-at "\\([0-9]*\\)\\([:;]\\)")
    (let ((ans nil)
	(number (buffer-substring (match-beginning 1) (match-end 1)))
	(next   (buffer-substring (match-beginning 2) (match-end 2))))
      (setq number (string-to-int number))
      (if (string-equal next ";")
	  (beginning-of-line) (goto-char 0))
      (looking-at "[0-9]*[:;]\\(.*\\)")
      (setq ans (buffer-substring (match-beginning 1) (match-end 1)))
      (view-file ans)  ;;; switch-to-buffer
      (goto-line number)))) ;;; not kill-buffer

;;
;; tag file jump
;;
(defun epocclib-get-word ()
  "get cursor word"
  (save-excursion
    (skip-chars-backward "a-zA-Z0-9_")
    (if (looking-at "\\([a-zA-Z0-9_]+\\)")
	(buffer-substring (match-beginning 1) (match-end 1)))))

(defun epocclib-wordjump (include-buf include-extension other)
  "create wordjump display"
  (let ((word (epocclib-get-word)))
    (setq word (if word word ""))
    (setq word (read-string "Search word : " word))
    (epocclib-wordjump-word include-buf include-extension word other)))

(defun epocclib-wordjump-word (include-buf include-extension word other)
  "create wordjump display"
  (setq epocclib-table-save-window-buffer (current-window-configuration))
  ;;
  (let ((buf) (file-name (buffer-file-name)))
    (setq epocclib-table-data
	  (list (concat (format "%d" (count-lines (point-min) (point)))
			";" (buffer-file-name) "\n")))
    ;;
    (if (not other)
	(progn
	  (if (one-window-p t)
	      (split-window (selected-window))
	    (screen-height) window-min-height 1)
	  (select-window (get-lru-window))))
    (switch-to-buffer (get-buffer-create epocclib-table-buffer-name))
    ;;
    (setq buffer-read-only nil)
    (cd (file-name-directory file-name))
    (epocclib-wordjump-display include-buf include-extension word)
    (setq buf epocclib-table-data)
    (erase-buffer)
    (while buf
      (insert (car buf))
      (setq buf (cdr buf))))
  ;;
  (kill-all-local-variables)
  ;;
  (setq major-mode 'epocclib-table-mode
	mode-name   epocclib-table-mode-name)
  (use-local-map  epocclib-table-mode-map)
  (goto-line 0)
  (set-buffer-modified-p nil)
  (setq buffer-read-only t)
  (setq truncate-lines t)
  ;;
  (if (not window-system) nil
    (make-local-variable 'font-lock-defaults)
    (setq font-lock-defaults '(epocclib-table-font-lock-keywords nil t))
    (if (featurep 'xemacs) nil
      (font-lock-mode nil)
      (font-lock-mode 1)) )
  ;;
  (message "g)go v)view q)quit...")
  (setq indent-tabs-mode nil) ;;; free memory.
  (run-hooks 'epocclib-wordjump-mode-hook))

(defun epocclib-wordjump-display (include-buf include-extension word)
  "repaint table data"
  (let ((buf) (filename) (extension))
    (setq extension (concat "\\(\\" (car include-extension)))
    (setq buf (cdr include-extension))
    (while buf
      (setq extension (concat extension "\\|\\" (car buf)))
      (setq buf (cdr buf)))
    (setq extension (concat extension "\\)$"))
    (setq buf include-buf)
    (while buf
      (setq filename (car buf))
      (epocclib-wordjump-open filename extension word)
      (setq buf (cdr buf)))))

(defun epocclib-wordjump-open (filename extension word)
  "repaint project"
  (message (concat "find file= " filename ))
  (let ((expfile (expand-file-name filename))
	(list nil) (now nil))
    (setq list (directory-files expfile t extension))
    (while list
      (epocclib-wordjump-open-file (car list) word)
      (setq list (cdr list)))
    (setq list (directory-files expfile t))
    (while list
      (setq now (file-name-nondirectory  (car list)))
      (if (and (file-directory-p (car list))
	       (not (or (equal "" now)
			(equal "." now)
			(equal ".." now)
			(equal "CVS" now))))
	  (epocclib-wordjump-open (car list) extension word))
      (setq list (cdr list)))))

(defun epocclib-wordjump-open-file (filename word)
  (if (and word (not (string-equal "" word)))
      (save-excursion
	(fundamental-mode)
	(erase-buffer)
	(insert-file-contents filename)
	(goto-char (point-min))
	(let ((case-fold-search nil))
	  (if (search-forward word nil t)
	      (setq epocclib-table-data
		    (append
		     epocclib-table-data
		     (list (concat
			    (format "%d" (count-lines (point-min) (point)))
			    ";" filename "\n")))))))
    (setq epocclib-table-data
	  (append epocclib-table-data
		  (list (concat "1;" filename "\n"))))))
;;;
;;; project
(defun epocclib-project-release (alist)
  "delete project"
  (let ((word (completing-read "release project : " alist nil t))
	(buf (reverse alist)))
    (setq alist nil)
    (while buf
      (if (equal word (car (car buf)))
	  nil
	(setq alist (cons (car buf) alist)))
      (setq buf (cdr buf))))
  (setq alist alist))

(defun epocclib-project-set (alist)
  "add/modify project"
  (let ((word (completing-read "add project name : " alist))
	(dir nil)
	(table nil)
	(dir-work)
	(buf (reverse alist)))
    (setq table (assoc word alist))
    (setq dir-work (if table (car (cdr table)) nil))
    (setq dir (read-file-name "project path : " dir-work dir-work))
    (setq dir
	  (if (or (string-match epocclib-archive-regrep dir)
		  (file-directory-p dir))
	      dir
	    (file-name-directory dir)))

    (setq alist nil)
    (while buf
      (if (or (equal word (car (car buf)))
	      (string-equal
	       (file-name-directory dir)
	       (file-name-directory (car (cdr (car buf))))))
	  nil
	(setq alist (cons (car buf) alist)))
      (setq buf (cdr buf)))
    (setq alist (cons (list word dir) alist)))) ;; return allist.

(defun epocclib-project-save ()
  "save enviroment"
  (interactive)
  (require 'epojava)
  (require 'epocc)
  (save-excursion
    (set-buffer
     (find-file-noselect
      (setq epocclib-save-file
	    (read-file-name
	     "save env : " epocclib-save-file epocclib-save-file nil))))
    (erase-buffer)
    (insert "(setq epojava-table-alist '")
    (prin1 epojava-table-alist (current-buffer))
    (insert ")\n\n")
    (insert "(setq epocc-include '")
    (prin1 epocc-include (current-buffer))
    (insert ")\n\n")
    (basic-save-buffer)
    (kill-buffer (get-buffer epocclib-save-file)))
  (message "save file [%s]" epocclib-save-file))

(defun epocclib-project-load (&optional nofilnd-file)
  "load enviroment"
  (interactive)
  (save-excursion
    (set-buffer
     (find-file-noselect
      (setq
       epocclib-save-file
       (if nofilnd-file
	   epocclib-save-file
	 (read-file-name
	  "load env : " epocclib-save-file epocclib-save-file t)))))
    (widen)
    (goto-char (point-min))
    (message "load file [%s]" epocclib-save-file)
    (condition-case err
	(eval-buffer)
      (error "file broken (%s)" epocclib-save-file))
    (kill-buffer (get-buffer epocclib-save-file))))

(defun epocclib-start-menu (&optional ask)
  "epocclib process starting menu."
  (interactive "P")
  (defvar explicit-shell-file-name "nil" "dummy") 
  (defvar shell-file-name "cmdproxy" "dummy") 
  (defvar shell-command-switch "-c" "dummy")
  (let ((explicit-shell-file-name explicit-shell-file-name)
	(shell-file-name shell-file-name)
	(shell-command-switch shell-command-switch))
    (if (and epocclib-dos (not (featurep 'xemacs)))
	(progn
	  (setq explicit-shell-file-name epocclib-explicit-shell-file-name
		shell-file-name epocclib-shell-file-name
		shell-command-switch epocclib-shell-command-switch)))
    (epop-start-menu ask)))

(defun epocclib-update-file (&optional other)
  "full update file buffer."
  (interactive "P")
  (let ((buff (buffer-list)) (now) (file))
    (while buff
      (setq now (car buff))
      (setq file (buffer-file-name now))
      (if (and file other)
	  (kill-buffer now)
	(if (and file (not (verify-visited-file-modtime now)))
	    (if (not (file-exists-p file))
		(kill-buffer now)
	      (set-buffer now)
	      (revert-buffer t t))))
      (setq buff (cdr buff)))))

(defun epocclib-enable (language)
  "epo-enable for language"
  (setq epo-language-alist
	(delete (assoc (symbol-name major-mode)
		       epo-language-alist) epo-language-alist))
  (setq epo-language-alist
	(cons (cons (symbol-name major-mode) language) epo-language-alist))
  (epo-enable))

(defun epocclib-per-folder-indent (filename extension)
  "Per folder indent / All files are indented in folder.
And all lines are indented in files."
  (message (concat "find folder= " filename ))
  (let ((now nil) (list nil))
    (setq list (directory-files (expand-file-name filename) t extension))
    (while list
      (if (file-exists-p (car list))
	  (progn (set-buffer (find-file-noselect (car list)))
		 (epocclib-kandr-style)
		 (basic-save-buffer)
		 (kill-buffer nil) ))
      (setq list (cdr list)))
    (setq list (directory-files (expand-file-name filename) t))
    (while list
      (setq now (file-name-nondirectory (car list)))
      (if (and (file-directory-p (car list))
	       (not (or (equal "" now)
			(equal "." now)
			(equal ".." now)
			(equal "CVS" now))))
	  (epocclib-per-folder-indent (car list) extension))
      (setq list (cdr list))))
  (message "sucsess..."))

;  end.
(provide 'epocclib)
;;; epocc.el ends here
