;;; epojava.el -- Editing Process Organizer / java-mode for emacs.
;;<plaintext>

;; Author: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Maintainer: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Created: 2001 Feb.10
;; Version: $Lastupdate: Sat Oct 05 11:09:27 2002 $ on inspire.
;; URL : http://park.ruru.ne.jp/ando/work/who/epojava/
;; Keywords: epo, c , c++ , java

;; Abstract.
;;   This program support functions.
;;     * epo support.
;;     * Jakarta-Ant support.
;;     * class view.
;;     * method view.
;;     * word jump.
;;     * replace indent all lines.
;;     * replace KandR style format.
;;
;; Setting epojava.
;;     looking for the epoan.el
;;
;----------------------------------------------------------------------
(require 'epocclib)
(require 'cc-mode)
(require 'epo-ant)

;; vs jde...
;;(if (fboundp 'jde-mode) (require 'jde)) ;; what's image??
(setq auto-mode-alist
      (delete (rassoc 'java-mode auto-mode-alist) auto-mode-alist))
(setq auto-mode-alist
      (delete (rassoc 'jde-mode auto-mode-alist) auto-mode-alist))
;---------------------------------------------------------------------

(defvar epojava-table-alist 
  (if epocclib-dos
      (setq epojava-table-alist
	    '(("tools" "c:/java2/lib/tools.jar")
	      ("jdk" "C:/java2/src/") ))
    (setq epojava-table-alist  '(("jdk" "/opt/java/JDK/src/"))))
  "* Add search path in your .emacs (This is option).

1.For UNIX example

    (setq epojava-table-alist
      \'((\"jdk\" \"/opt/java/JDK/src/\")))

        jdk ................... project name.
        /opt/java/JDK/src/ .... project target folder name.

2.For Windows (Meadow / mule for win32 / etc...) example.

    (setq epojava-table-alist
      \'(((\"jdk\" \"C:/java2/src/\") (\"demo\" \"C:/java2/demo/\"))))

---- For Japanese.

  pbP[WƁAtH_ʒů֌WB
  (car)pbP[WAE(cdr)ΉtH_B
C-c a ŕҏWł܂BpbP[W͉p݂̂ɂĂB")

(defvar epojava-append-process-alist nil "* appended process alist")
(defvar epojava-ant-process-alist
  '((?j (type . compile)
	(command "ant" epo-ant-process "-f"
		 epo-ant-other-makefile epo-ant-other-target))
    (?p (type . compile)
	(command "ant2" epo-ant-process
		 "-emacs" "-f" epo-ant-other-makefile epo-ant-other-target))
    (?a (type . version)
	(command "antVer" epo-ant-process "-version"))
    (?v (type . version)
	(command "ver" "java" "-version")))
  "* java/ant process-alist")
(defvar epojava-default-process-alist
  '((?j (type . compile)
	(command "compile" "make" "-f" epo-ant-other-makefile))
    (?p (type . run) (command "run" "make" "-f" epo-ant-other-makefile "run"))
    (?c (type . run)
	(command "clean" "make" "-f" epo-ant-other-makefile "clean")))
  "*Java dependent process alists")

;----------------------------------------------------------------------
(defvar epojava-mode-map nil "epojava keymap")
(defvar epojava-table-mode-map nil "epojava-table keymap")
(defvar epojava-table-buffer-name "* epojava-table *" "epojava table")

(defvar epojava-c-style
  '((c-basic-offset . 4)
    (c-comment-only-line-offset . (0 . 0))
    ;; the following preserves Javadoc starter lines
    (c-hanging-comment-starter-p . nil)
    (c-offsets-alist
     . ((inline-open . 0)
	(topmost-intro-cont    . +)
	(statement-block-intro . +)
	(knr-argdecl-intro     . 5)
	(substatement-open     . +)
	(label                 . 0)
	(statement-case-open   . +)
	(statement-cont        . +)
;;; 	(arglist-intro  . c-lineup-arglist-intro-after-paren)
	(arglist-intro  . +)
	(arglist-close  . c-lineup-arglist)
	(access-label   . 0)
	(inher-cont     . c-lineup-java-inher)
	(func-decl-cont . c-lineup-java-throws))))
  "epojava java Programming Style")
(defvar epojava-table-regexp
  "^\\s *\\(\\(i\\(nterface\\|mport\\)\\|p\\(ackage\\|ublic\\|rotected\\|rivate\\)\\|\\abstract\\|final\\|native\\|s\\(ynchronized\\|tatic\\)\\|class\\)\\s +.*\\|\\(\\([a-z]+\\.\\)*[A-Z]\\sw+\\|void\\|int\\|double\\|short\\|long\\|flort\\|char\\|byte\\|boolean\\)\\s *[][]*\\s +[a-z]\\sw+(\\s *\\()\\|\\sw+\\s +\\sw+\\).*\\)$"
  "*epojava-table java hit list")

;---------------------------------------------------------------------
;;
;; Define key table
;;
(if epojava-mode-map
    nil
  (cond 
;;   ((boundp 'jde-mode-map)
;;    (setq epojava-mode-map (copy-keymap jde-mode-map)))
   ((boundp 'java-mode-map)
    (setq epojava-mode-map (copy-keymap java-mode-map)))
   (t (setq epojava-mode-map (copy-keymap c++-mode-map))))
  (substitute-key-definition
   'epo-version 'epocclib-version epo-mode-map)
  (substitute-key-definition
   'epop-start-menu 'epocclib-start-menu epo-mode-map)
  (define-key epojava-mode-map "\M-q"  'epocclib-indent-all)
  (define-key epojava-mode-map "\M-Q"  'epocclib-kandr-style)
  (define-key epojava-mode-map "\M-\r" 'epoi-intelligent-newline)
  (epo-define-key epojava-mode-map "u" 'epocclib-update-file)
  (epo-define-key epojava-mode-map "t" 'epocclib-start-menu)
  (epo-define-key epojava-mode-map "b" 'epocclib-structure-b-input)
  (epo-define-key epojava-mode-map "s" 'epocclib-structure-s-input)
  (epo-define-key epojava-mode-map "f" 'epocclib-structure-f-input)
  (epo-define-key epojava-mode-map "l" 'epocclib-structure-t-input)
  (epo-define-key epojava-mode-map "h" 'describe-mode)
  (epo-define-key epojava-mode-map "g" 'epojava-corresponding-include)
  (epo-define-key epojava-mode-map "G" 'epocclib-table-mode-in)
  (epo-define-key epojava-mode-map "d" 'epojava-wordjump)
  (epo-define-key epojava-mode-map "a" 'epojava-project)
  (epo-define-key epojava-mode-map ";" 'epocclib-untranslate-region)
  (epo-define-key epojava-mode-map ":" 'epocclib-translate-region)
  (epo-define-key epojava-mode-map "<" 'epocclib-uncomment-region)
  (epo-define-key epojava-mode-map ">" 'comment-region)

  (defvar epojava-mode-menu-comp-map (make-sparse-keymap "Completention"))
  (epocclib-define-menu
   'epojava-mode-menu-comp-map
   (nreverse
    (list
     (cons (list 'block "Block")
	   (cons "Block" 'epocclib-structure-b-input))
     (cons (list 'section "Identifer")
	   (cons "Identifer" 'epocclib-structure-s-input))
     (cons (list 'large "Try")
	   (cons "Try" 'epocclib-structure-t-input))
     (cons (list 'func "Function")
	   (cons "Function" 'epocclib-structure-f-input))) ))
  (defvar epojava-mode-menu-project-map (make-sparse-keymap "Project"))
  (epocclib-define-menu
   'epojava-mode-menu-project-map
   (nreverse
    (list
     (cons (list 'load "Load") (cons "Load" 'epocclib-project-load))
     (cons (list 'save "Save") (cons "Save" 'epocclib-project-save))
     (cons (list 'disp "Display")
	   (cons "Display"
		 '(lambda () (interactive)
		    (describe-variable 'epojava-table-alist))))
     (cons (list 'set "Add/modify") (cons "Add/modify" 'epojava-project-set))
     (cons (list 'rel "Release") (cons "Release" 'epojava-project-release)))))
  (defvar epojava-mode-menu-goto-map (make-sparse-keymap "Goto"))
  (epocclib-define-menu
   'epojava-mode-menu-goto-map
   (nreverse
    (list
     (cons (list 'make "Makefile")
	   (cons "Makefile" 'epojava-ant-find))
     (cons (list 'class "Class")
	   (cons "Class" 'epojava-corresponding-include))
     (cons (list 'method "Method")
	   (cons "Method" 'epocclib-table-mode-in))
     (cons (list 'word "Word")
	   (cons "Word" 'epojava-wordjump)))))
  (defvar epojava-mode-menu-map (make-sparse-keymap epojava-mode-name))
  (epocclib-define-menu
   'epojava-mode-menu-map
   (nreverse
    (list
     (cons (list 'comp "Completion")
	   (cons "Completion" epojava-mode-menu-comp-map))
     (cons (list 'typeset "Typeset")
	   (cons "Typeset" 'epocclib-start-menu))
     (cons (list 'project "Project")
	   (cons "Project" epojava-mode-menu-project-map))
     (cons (list 'goto "Goto jump")
	   (cons "Goto jump" epojava-mode-menu-goto-map))
     (cons (list 'replace "Replace source")
	   (cons "Replace source" 'epocclib-kandr-style))
     (cons (list 'indent "Indent all(file)")
	   (cons "Indent all(file)" 'epocclib-indent-all))
     (cons (list 'infile "Indent all(folder)")
	   (cons "Indent all(folder)" 'epojava-per-folder-indent))
     (cons (list 'update "Update all file")
	   (cons "Update all file" 'epocclib-update-file))
     (cons (list 'ver "Version")
	   (cons "Version" 'epocclib-version))
     (cons (list 'help "For help")
	   (cons "For help" 'describe-mode)) )))

  (define-key epojava-mode-map [menu-bar epojava]
    (cons epojava-mode-name epojava-mode-menu-map))
  (if (featurep 'xemacs)
      (add-hook
       'epojava-mode-hook
       '(lambda ()
	  (or (assoc epojava-mode-name current-menubar)
	      (progn
		(set-buffer-menubar (copy-sequence current-menubar))
		(add-submenu nil epojava-mode-menu-map)))))))

(if epojava-table-mode-map
    nil
  (setq epojava-table-mode-map (copy-keymap epocclib-table-mode-map))
  (define-key  epojava-table-mode-map "a"  'epojava-project)
  (substitute-key-definition
   'epocclib-table-insert 'epojava-table2-inseart epojava-table-mode-map)
  (substitute-key-definition
   'epocclib-view-file 'epojava-table2-inseart epojava-table-mode-map)
  (substitute-key-definition
   'epocclib-table-quit 'epojava-table-quit epojava-table-mode-map))
;;;---------------------------------------------------------------------
(defun epojava-mode ()
  "The Editing Process Organizer / java mode for GNU emacs.

Key bindings:
 \\[epojava-corresponding-include] : display class list
 C-u \\[epojava-corresponding-include] : display class list (same window)
 \\[epocclib-table-mode-in] : display my class detail
 C-u \\[epocclib-table-mode-in] : display my class detail (same window)
 \\[epojava-ant-find] : display my ant file
 C-u \\[epojava-ant-find] : display my ant file (same window)
 \\[epojava-wordjump] : display woad jump alist
 C-u \\[epojava-wordjump] : display woad jump alist (same window)
 \\[epojava-project] : display project menu
 \\[epojava-project] a: project add/modify
 \\[epojava-project] d: project delete
 \\[epojava-project] s: project save
 \\[epojava-project] l: project load
 \\[epocclib-indent-all] : indent-command all lines
 \\[epocclib-kandr-style] : replace K&R style format
 \\[describe-mode] : for help"
  (interactive)
  (kill-all-local-variables)
  (cond
;;;   ((fboundp 'jde-mode) (jde-mode))
   ((fboundp 'java-mode) (java-mode))
   (t (c++-mode)))
  (setq major-mode 'epojava-mode
	mode-name epojava-mode-name
	defun-prompt-regexp nil)
  (epocclib-enable "java") ;; invoke epo-mode
  (make-local-variable 'epocclib-table-regexp)
  (setq epocclib-table-regexp epojava-table-regexp)
  (if (featurep 'xemacs)
      (if (not window-system) nil
	(font-lock-mode nil) ; font lock
	(make-local-variable 'font-lock-defaults)
	(setq
	 font-lock-defaults
	 (list
	  (cond
	   ((boundp 'java-font-lock-keywords-5) 'java-font-lock-keywords-5)
	   ((boundp 'java-font-lock-keywords-4) 'java-font-lock-keywords-4)
	   ((boundp 'java-font-lock-keywords-3) 'java-font-lock-keywords-3)
	   ((boundp 'java-font-lock-keywords-2) 'java-font-lock-keywords-2)
	   ((boundp 'c++-font-lock-keywords-3) 'c++-font-lock-keywords-3)
	   ((boundp 'c++-font-lock-keywords-2) 'c++-font-lock-keywords-2)
	   (t c-font-lock-keywords-2))
	  nil t)) ))
  (if window-system (font-lock-mode 1))
  (use-local-map epojava-mode-map)
  (if (fboundp 'java-mode)
      (progn
	(setq c-inexpr-class-key nil)
	(c-add-style epojava-mode-name epojava-c-style t)))
  (setq indent-tabs-mode nil)
  (if (and (getenv "ANT_HOME") (getenv "JAVA_HOME"))
      (progn
	(setq epo-java-process-alist
	      (append epojava-ant-process-alist
		      epojava-append-process-alist))
	(setq epo-java-tagjump-alist epo-ant-tagjump-alist))
    (setq epo-java-process-alist
	  (append epojava-default-process-alist
		  epojava-append-process-alist)))
  (run-hooks 'epojava-mode-hook))

(defun epojava-table-display ()
  "repaint table data"
  (interactive)
  (setq buffer-read-only nil)
  (erase-buffer)
  (let ((buf epojava-table-alist) (project) (filename))
    (setq epo-java-freq-funcs nil)
    (while buf
      (setq project (car (car buf))
	    filename (car (cdr (car buf))))
      (if (string-match epocclib-archive-regrep filename)
	  (insert (concat project ":" filename "\n"))
	(epojava-open-project project filename ""))
      (setq epo-java-structure-alist
	    (cons '(?f (type . class)
		       (structure keyword)
		       (table . epo-java-freq-funcs))
		  (delete (assoc ?f epo-java-structure-alist)
			  epo-java-structure-alist)))
      (setq buf (cdr buf))))
  (set-buffer-modified-p nil)
  (setq buffer-read-only t) 
  (setq truncate-lines t)
  (goto-char 0))

(defun epojava-open-project (project filename dir)
  "repaint project"
  (message (concat "find file= " project ":" filename ))
  (let ((expfile (expand-file-name filename))
	(list nil) (now nil) (dir2 dir))
    (setq list (directory-files expfile t "\\.java$"))
    (while list
      (setq epo-java-freq-funcs
	    (cons (list (file-name-nondirectory
			 (file-name-sans-extension (car list))))
			epo-java-freq-funcs))
      (insert (concat project ":" dir "/"
		      (file-name-nondirectory (car list)) "\n"))
      (setq list (cdr list)))
    (setq list (directory-files expfile t))
    (while list
      (setq now (file-name-nondirectory  (car list)))
      (if (and (file-directory-p (car list))
	       (not (or (equal "" now)
			(equal "." now)
			(equal ".." now)
			(equal "CVS" now))))
	  (progn
	    (setq dir2 (concat dir "/" now))
	    (epojava-open-project project (car list) dir2)))
      (setq list (cdr list)))))

(defun epojava-corresponding-include (&optional other)
  "c-c g transaction (include)"
  (interactive "P")
  (let* ((name nil) (peol nil) (ans nil))
    (save-excursion
      (end-of-line)
      (setq peol (point))
      (beginning-of-line)
      (if (not
	   (re-search-forward
	    "\\(import\\|package\\)\\s \\([A-Za-z0-9_.]*\\)\\(\\.\\*\\|;\\)"
	    peol t))
	  (setq ans t)
	(setq word (buffer-substring (match-beginning 2) (match-end 2)))
	(epojava-corresponding-include2 word other)))
    (if ans (epojava-table-mode other))))

(defun epojava-corresponding-include2 (word other)
  "import or package search. After operation."
  (let ((buf epojava-table-alist) (work) (hit nil))
    (while (string-match "\\([^.]*\\)\\.\\(.*\\)" word)
      (setq word 
	    (concat
	     (substring word (match-beginning 1) (match-end 1))
	     "/"
	     (substring word (match-beginning 2) (match-end 2)))))
    (while buf
      (setq work (expand-file-name (concat (car (cdr (car buf))) "/" word)))
      (if (file-directory-p work)
	  (progn
	    (epocclib-wordjump-word (list work) (list ".java") nil other)
	    (setq buf nil)
	    (setq hit t)))
      (setq work (concat work ".java"))
      (if (file-exists-p work)
	  (progn
	    (epocclib-switch-to-buffer work other)
	    (setq buf nil)
	    (setq hit t)))
      (setq buf (cdr buf)))
    (if (not hit) (message "package/import target is not found"))))

(defun epojava-table-mode (&optional other)
  "epojava-mode class display

Key bindings:
 g,v : open.
 C-u g : open same window.
 \\[epojava-table-quit] : quit"
  (interactive "P")
  (let ((word (epocclib-get-word)) (baseFile) (oldPos))
    (setq epocclib-save-window-buffer (current-window-configuration)
	  baseFile (buffer-file-name))
    (if (get-buffer epojava-table-buffer-name)
	(set-buffer (get-buffer epojava-table-buffer-name))
      (progn
	(set-buffer (get-buffer-create epojava-table-buffer-name))
	(epojava-table-display)))
    (if (not other)
	(progn
	  (if (one-window-p) (split-window (selected-window)))
	  (other-window 1)))
    (switch-to-buffer epojava-table-buffer-name)
    (setq major-mode 'epojava-table-mode
	  mode-name  "epojava-table")
    (use-local-map  epojava-table-mode-map)
    ;;
    (setq oldPos (point))
    (goto-char (point-max))
    (if (re-search-backward (concat "/" word ".java" ) nil t)
	nil ; ڕWƂPꂪ΂ֈړ
      (goto-char 0)
      (if (and baseFile
	       (re-search-forward
		(concat "/" (file-name-nondirectory baseFile)) nil t))
	  nil ; ̃t@C΂ֈړ
	(goto-char oldPos)))
    (make-local-variable 'epocclib-table-regexp)
    (setq epocclib-table-regexp epojava-table-regexp)
    (if (or (featurep 'xemacs) (not window-system)) nil
      (make-local-variable 'font-lock-defaults)
      (setq font-lock-defaults '(epocclib-table-font-lock-keywords nil t))
      (font-lock-mode nil)
      (font-lock-mode 1))
    (message "g,v)jump a)project-edit q)quit...")
    (run-hooks 'epojava-table-mode-hook)))

(defun epojava-table-quit ()
  "epojava-table-mode quit"
  (interactive)
  (set-window-configuration epocclib-save-window-buffer)
  (kill-buffer epojava-table-buffer-name))

(defun epojava-table2-inseart (&optional other)
  "epojava-mode class detail display (for epojava-table)"
  (interactive "P")
  (let ((header) (a) (b) (buf epojava-table-alist) (word nil))
    (save-excursion
      (beginning-of-line)
      (re-search-forward "^\\([^:]*\\):" nil t)
      (setq header (buffer-substring (match-beginning 1) (match-end 1)))
      (catch 'epojava-table2-inseart-tag
	(while buf
	  (if (equal header (car (car buf)))
	      (throw 'epojava-table2-inseart-tag t))
	  (setq buf (cdr buf))))
      (setq header (car (cdr (car buf))))
      (setq a (point))
      (end-of-line)
      (setq b (point))
      (setq word (concat header "." (buffer-substring a b))))
    (if (string-match epocclib-archive-regrep header)
	(epocclib-switch-to-buffer header other)
	(epocclib-table-mode word other))))

;;;---------------------------------------------------------------------

(defun epojava-project ()
  "pakage editor"
  (interactive)
  (describe-variable 'epojava-table-alist)
  (message "a)add/modify r)release l)load s)save")
  (let ((c (read-char)))
    (cond 
     ((= ?a c) (epojava-project-set))
     ((= ?s c) (epocclib-project-save))
     ((= ?l c) (epocclib-project-load))
     ((= ?r c) (epojava-project-release))
     (nil)))
  (describe-variable 'epojava-table-alist))

(defun epojava-project-set ()
  "add/modify epojava-table-alist"
  (interactive)
  (setq epojava-table-alist
	(epocclib-project-set epojava-table-alist)))

(defun epojava-project-release ()
  "delete epojava-table-alist"
  (interactive)
  (setq epojava-table-alist
	(epocclib-project-release epojava-table-alist)))

;;;---------------------------------------------------------------------
(defun epojava-wordjump (&optional other)
    "epojava wordjump display

Key bindings:
 g : open.
 C-u g : open same window.
 \\[epocclib-view-file] : view mode.
 \\[epocclib-table-quit] : quit."
  (interactive "P")
  (let ((alist
	 (append epojava-table-alist
		 '(("./" "./") ("../" "../") ("../../" "../../")
		   ("../../../" "../../../")))))
    (epocclib-wordjump
     (cdr (assoc (completing-read "Project : " alist nil t) alist))
     '(".java") other)))

;;;
;;; makefile -----------------------------------------------------------
;;;

(defun epojava-ant-find (&optional other)
  "jump to jakarta-ant xml file"
  (interactive)
  (epo-ant-other-makefile)
  (epocclib-switch-to-buffer epo-ant-other-makefile-value other))

;;;
;;; archive hook
;;;
(add-hook 'archive-extract-hooks '(lambda () (setq buffer-read-only t)))
(defun epojava-arcive-mode-hook ()
  "set anzip.jar"
  (let ((dirs load-path) (file nil))
    (setq file
	  (catch 'epojava-arcive-mode-hook-tag
	    (while dirs
	      (setq file (concat (car dirs) "/anzip.jar"))
	      (setq dirs (cdr dirs))
	      (if (file-exists-p file)
		  (throw 'epojava-arcive-mode-hook-tag
			 (expand-file-name file))))))
    (if file
	(setq archive-zip-extract
	      (list (expand-file-name
		     (if (getenv "JAVA_HOME")
			 (concat (getenv "JAVA_HOME") "/bin/" "java.exe")
		       "java.exe"))
		    "-classpath"
		    (epojava-get-classpath)
		    "-jar"
		    (if (getenv "JAVA_HOME")
			(concat "-Danzip.javahome=" (getenv "JAVA_HOME")))
		    file)))))
(defun epojava-get-classpath ()
  "class path making"
  (let ((buf epojava-table-alist) (work "."))
    (while buf
      (if (string-match epocclib-archive-regrep (car (cdr (car buf))))
	  (setq work (concat work (if epocclib-dos ";" ":")
			     (car (cdr (car buf))))))
      (setq buf (cdr buf)))
    work))

(defun epojava-per-folder-indent (filename)
  "Per folder indent / All Java files are indented in folder.
And all lines are indented in files."
  (interactive "DTarget Firectory: ")
  (epocclib-per-folder-indent filename "\\.java$"))

; end.
(provide 'epojava)
;;; epojava.el ends here
