% This is change file of floating-point arithmetic in e-pTeX.
% By Hironori Kitagawa (h_kitagawa2001 at yahoo.co.jp)

@x
@d advance=max_internal+1 {advance a register or parameter ( \.{\\advance} )}
@y
@d float_arith=max_internal+1 {floating point operation (\.{\\fpadd} etc.~)}
@d float_init=float_arith+1 {initialize floating operation}
@d float_dest=float_init+1 {deallocate work area for aloating point operation}
@d advance=float_dest+1 {advance a register or parameter ( \.{\\advance} )}
@z

@x
@d etex_convert_codes=etex_convert_base+1 {end of \eTeX's command codes}
@y
@d fp_out_frac_code=etex_convert_base+1 {command code for \.{\\fpfrac}}
@d fp_out_expr_code=etex_convert_base+2 {command code for \.{\\fpexpr}}
@d etex_convert_codes=etex_convert_base+3 {end of \eTeX's command codes}
@z
@x
  eTeX_revision_code: print_esc("eTeXrevision");
  othercases print_esc("jobname")
@y
  eTeX_revision_code: print_esc("eTeXrevision");
  fp_out_frac_code: print_esc("fpfrac");
  fp_out_expr_code: print_esc("fpexpr");
  othercases print_esc("jobname")
@z

@x
font_name_code: scan_font_ident;
eTeX_revision_code: do_nothing;
@y
font_name_code: scan_font_ident;
fp_out_frac_code,fp_out_expr_code: scan_float;
eTeX_revision_code: do_nothing;
@z

@x
eTeX_revision_code: print(eTeX_revision);
job_name_code: print(job_name);
@y
eTeX_revision_code: print(eTeX_revision);
fp_out_frac_code: do_fp_out_frac;
fp_out_expr_code: do_fp_out_expr;
job_name_code: print(job_name);
@z

@x
eTeX_expr-int_val+mu_val: print_esc("muexpr");
@y
eTeX_expr-int_val+mu_val: print_esc("muexpr");
@<FL Cases of |last_item| for |print_cmd_chr|@>
@z

@x
@<Process an expression and |return|@>=
begin if m<eTeX_mu then
  begin case m of
@y 
@<Process an expression and |return|@>=
begin 
if m>eTeX_expr-int_val+mu_val then 
  @<FL process floating point arithmetical commands@>
else 
 begin if m<eTeX_mu then
   begin case m of
@z
@x
  else negate(cur_val);
@y
    else negate(cur_val);
end;
@z

@x
@* \[55] Index.
@y
@* \[60] Floating point arithmetic.
In \epTeX, floating point arithmetic is implemented. 

This section is intended to implement floating point arithmetic
internally. To yield acculacy, floating point number which we deal
with in this section, can be arbitary high precision; code is based
from ``Multiple Precision Arithmetic'' in TAOCP Vol.\ 2. This approach
makes floating point arithmetic very slow.

\medskip
 
 In next section, we will implements user-level commands.

@d max_eight_digit_int=99999999
@d max_nine_digit_int=999999999
@d ninth_digit_offset=100000000
@d expr_bias=32767
@d sign_flag_offset=65536000
@d fp_sign(#)==mem[#].hh.lh { sign bit }
@d fp_exp(#)==mem[#+1].int { exponent part without bias |expr_bias| }
@d fp_length(#)==mem[#].hh.rh { length }


@<Declare \eTeX\ procedures for ex...@>=
  @<FL internal codes@>

@ @<Glob...@>=
@!fp_arith_error: integer; { 1: overflow, 2: NaN}
@!fp_temp_four_ope: pointer; {work area of addition, subtraction etc.}

@ This procedure is used for debugging.

@<FL internal codes@>=
procedure fp_out_debug(@!a: pointer);
var @!i,n: integer;
begin
  n:=fp_length(a);@/
  print_nl("fp_out_debug length=");
  print_int(fp_length(a));@/
  print(" flag=");
  print_int(fp_sign(a));@/
  print(" exp=");
  print_int(fp_exp(a));
  print(" frac:");
  for i:=n+2 downto 2 do 
    begin print_int(mem[a+i].int); print(":");@+end;
end;


@ This function gets a new node and unpack a glue specification which
represents a float to it. First parameter is a pointer to the glue
specification, and the second is length of array which will contain
fraction part, |n|. Actually we allocate new node of size $|n|+3$; 3
words are used to store exponent part, length of (fractional part's)
array, and for carry flags. We shall identify these arrays as floats,
and we say |n| as ``length of float''.

Some functions return a float whose length is bigger than that of
parameters. We indicate these functions as {\bf INCPREC}.

@<FL internal codes@>=
function fp_unpack(@!a: pointer; @!n: integer): pointer;
var @!m: pointer; @!i: integer;
begin
 m:=get_node(n+3); fp_unpack:=m;@/
 mem[m+n+2].int:=0; {used as carry bits}@/
 mem[m+n+1].int:=width(a) mod 1000;@/
 mem[m+n].int:=stretch(a) div 1000000;@/
 mem[m+n-1].int:=(stretch(a) div 1000) mod 1000;@/
 mem[m+n-2].int:=stretch(a) mod 1000;@/
 mem[m+n-3].int:=shrink(a) div 1000000;@/
 mem[m+n-4].int:=(shrink(a) div 1000) mod 1000;@/
 mem[m+n-5].int:=shrink(a) mod 1000;@/
 for i:=m+2 to m+n-6 do mem[i].int:=0;@/
 fp_exp(m):=(width(a) div 1000) mod 65536 - expr_bias;@/
 fp_sign(m):=width(a) div sign_flag_offset;@/
 fp_length(m):=n; fp_arith_error:=0; { error flag is initialized }
end;

@ In the following we define procedure which duplicates the array, and
macro which frees the array.

@d fp_free(#)==free_node(#,fp_length(#)+3);

@<FL internal codes@>=
procedure fp_copy(@!a,@!j: pointer);
var @!i: integer;
begin
  for i:=2 to fp_length(a)+2 do mem[j+i].int:=mem[a+i].int;
  fp_sign(j):=fp_sign(a);  fp_exp(j):=fp_exp(a); 
  fp_length(j):=fp_length(a);
end;

@ Next function is for packing a float into a glue specification.  We
assume the validity of the array (i.e., the array is normalised and
its exponent part is within collect range) in this procedure. This
function returns a pointer of result glue specification.

@<FL internal codes@>=
function fp_pack(@!a: pointer): pointer;
var @!m: pointer; @!i,@!n,@!k: integer;
begin
 m:=new_spec(zero_glue); fp_pack:=m; n:=fp_length(a); 
 width(m):=(fp_exp(a)+expr_bias+fp_sign(a)*65536)*1000+mem[a+n+1].int;
 stretch(m):=mem[a+n].int*1000000+mem[a+n-1].int*1000+mem[a+n-2].int;
 shrink(m):=mem[a+n-3].int*1000000+mem[a+n-4].int*1000+mem[a+n-5].int;
 if (fp_arith_error=2)or(fp_sign(a)=2) then @<FL NaN error@>
 else if (fp_arith_error=1)or(fp_exp(a)=32768) then @<FL Overflow error@>
 else @<FL round to nearest even, in |fp_pack|@>;
 fp_arith_error:=0; { error flag is initialized }
end;

@ @<FL round to nearest even, in |fp_pack|@>=
if (n>=8)and((mem[a+n-6].int>500)@|or
    ((mem[a+n-6].int=500)and odd(mem[a+n-5].int))) then
   begin 
   k:=1; i:=a+n+1; while i>=a+n-5 do begin
    if mem[a+i].int<>999 then@+begin k:=0; i:=-5;@+end; i:=i-1; end;
   if k=0 then begin
     shrink(m):=shrink(m)+1;
     if shrink(m)>max_nine_digit_int then begin
       stretch(m):=stretch(m)+1; shrink(m):=shrink(m)-1000000000;
       if stretch(m)>max_nine_digit_int then begin
         width(m):=width(m)+1; stretch(m):=stretch(m)-1000000000;
         if (width(m) mod 1000)=0 then width(m):=width(m)+100;
         end;
       end;
     end;
   end

@ Next two fragments are handling errors:
@<FL Overflow error@>=
begin 
print_err("Floating arithmetic overflow");
@.Floating arithmetic overflow@>
  help2("While processing this operation, overflow error is occured.")@/
    ("`result' will not be collect result.");
  error;
end

@ @<FL NaN error@>=
begin
print_err("Floating arithmetic exception");
@.Floating arithmetic exception@>
  help2("While processing this operation, NaN is produced. ")@/
    ("`result' will not be collect result.");
  error;
end

@ We divide normalization of an array into two parts: collection of
sign bit and aligning fraction part. Former will be implemented where
we deal with subtraction, so we don't need to write it now. Before
writing the latter, we have to write program for left shift of one
digit of right shift. 

@<FL internal codes@>=
function fp_right_shift(@!a: pointer;@!t: boolean): integer;
  { |t|: should we round? Output is last digit}
label exit;
var @!i,@!j,@!m,@!n: integer;
begin
 if (fp_exp(a)=32768)or(fp_sign(a)=2) then return { We do not anything }
 else if fp_exp(a)=32767 then { result will be infinity } begin 
   fp_exp(a):=32768; fp_arith_error:=1;@+end
 else fp_exp(a):=fp_exp(a)+1;
 n:=fp_length(a); j:=mem[a+n+2].int mod 10; @/
 mem[a+n+2].int:=mem[a+n+2].int div 10;
 for i:=n+1 downto 2 do begin
   m:=mem[a+i].int mod 10; @/mem[a+i].int:=mem[a+i].int div 10 + 100*j; j:=m;
   end;
 fp_right_shift:=j;
 if t then
   if ((m=5)and odd(mem[a+2].int))or(m>5) then { round to nearest even } begin 
     j:=1; m:=2; while m<=n+1 do 
     if mem[a+m].int<>999 then@+begin j:=0; m:=a+n+2;@+end;
     if j=0 then begin
       mem[a+2].int:=mem[a+2].int+1; m:=2;
       while m<=n+2 do 
         if mem[a+m].int>=1000 then begin
           mem[a+m].int:=mem[a+m].int-1000; mem[a+m+1].int:=mem[a+m+1].int+1; 
           m:=m+1; end
         else m:=n+4;
       end;
    end;
exit: end;
@#
procedure fp_left_shift(@!a: pointer); { We don't have to round }
var @!i,@!j,@!m,@!n: integer;
begin
 fp_exp(a):=fp_exp(a)-1; n:=fp_length(a);@/
 j:=mem[a+2].int div 100; mem[a+2].int:=(mem[a+2].int mod 100)*10;
 for i:=3 to n+2 do begin
  m:=mem[a+i].int div 100; @/mem[a+i].int:=(mem[a+i].int mod 100)*10 + j; j:=m;
  end;
end;

@ Moreover, we write procedure of adjustment of
exponent part (to specified value) here.

@<FL internal codes@>=
procedure fp_adjust_exp_part(@!a: pointer; @!e: integer); 
  { |e|: exponent without bias. |a| will be shifted right.  We don't round}
label exit;
var @!m,@!n: integer; 
begin
  n:=fp_length(a);
  if fp_exp(a)=e then return;
  if (e-fp_exp(a))>(3*n+1) then begin
    fp_exp(a):=e;
    for m:=2 to n+2 do mem[a+m].int:=0;
    end
  else for m:=1 to e-fp_exp(a) do n:=fp_right_shift(a,false);
end;

@ Following code is aligning fraction part. We don't have to deal with
sign bit anymore, so we have only to use |fp_left_shift| or
|fp_adjust_exp_part|.

@<FL internal codes@>=
procedure fp_adjust_frac(@!a: pointer; @!z: boolean); 
  { We assume |a| is not infinity nor NaN. |z| means 
    if should we round |a| to zero if |a|is too small }
label exit;
var @!i,@!n: integer;
begin
  n:=fp_length(a);
  if mem[a+n+2].int<>0 then { In this case, |mem[a+n+2]| is in $[1,9]$ }
    if (fp_exp(a)=-32767) and z then begin
        fp_exp(a):=0; for i:=2 to n+2 do mem[a+i].int:=0;
      end
    else begin
      n:=fp_right_shift(a,true); return;@+end
  else begin { We may do |fp_left_shift| several times }
    i:=2;
    while i<=n+2 do
      if mem[a+i].int<>0 then begin
        while mem[a+n+1].int<100 do fp_left_shift(a);
        return;
        end
      else i:=i+1;
    end;
  fp_exp(a):=0; fp_sign(a):=0; { In this case, |a| is zero }
exit: end;


@ Here we can write addition/subtraction of absolute value. In this
procedure we assume flags of two floats are same, and the length of
arrays are same. In these procedures, we fix sign bit, but don't
align fraction part.

@<FL internal codes@>=
procedure fp_add_absolute_value(@!a,@!b,@!c: pointer);
var @!d: pointer; 
@!j,@!k,@!l: integer;
begin
  if fp_exp(a)=32768 then fp_copy(a,c)
  else if fp_exp(b)=32768 then fp_copy(b,c)
  else begin 
    if fp_exp(a)<fp_exp(b) then begin d:=b; fp_copy(a,fp_temp_four_ope);@+end
    else begin d:=a; fp_copy(b,fp_temp_four_ope);@+end;
    fp_adjust_exp_part(fp_temp_four_ope,fp_exp(d)); j:=2; k:=0;
    for j:=2 to fp_length(a)+1 do begin
      l:=mem[d+j].int+mem[fp_temp_four_ope+j].int+k;@/
      mem[c+j].int:=l mod 1000; k:=l div 1000;
    end; 
    mem[c+fp_length(a)+2].int:=k; fp_length(c):=fp_length(a);@/
    fp_exp(c):=fp_exp(d); fp_sign(c):=fp_sign(a);
    end;
end; 

@ @<FL internal codes@>=
procedure fp_sub_absolute_value(@!a,@!b,@!c: pointer);
var @!d: pointer; 
@!i,@!j,@!k,@!l,@!n: integer;
begin
  if fp_exp(a)=32768 then begin fp_copy(a,c);
    if fp_exp(b)=32768 then@+begin
      fp_sign(c):=2; fp_arith_error:=2;@+end
    end
  else if fp_exp(b)=32768 then begin@+ 
    fp_copy(b,c); fp_sign(c):=1-fp_sign(c);@+end
  else begin 
    n:=fp_length(a); fp_length(c):=n;
    j:=2; k:=0; i:=0; @/
    if fp_exp(a)<fp_exp(b) then begin
      d:=b; fp_copy(a,fp_temp_four_ope); i:=1;@+end
    else begin d:=a; fp_copy(b,fp_temp_four_ope);@+end;
    fp_exp(c):=fp_exp(d); fp_sign(c):=fp_sign(d);
    if i=1 then fp_sign(c):=1-fp_sign(c);
    fp_adjust_exp_part(fp_temp_four_ope,fp_exp(d)); 
    for j:=2 to n+1 do begin
      l:=mem[d+j].int-mem[fp_temp_four_ope+j].int+k; 
      if l>=0 then@+begin mem[c+j].int:=l; k:=0;@+end
      else begin mem[c+j].int:=l+1000; k:=-1;@+end;
    end; 
    mem[c+n+2].int:=0; @/
    @<FL adjust flag in subtraction, if needed @>@;
  end;
end; 

@ @<FL adjust flag in subtraction, if needed @>=
    if k=-1 then begin
      j:=2; i:=n+1; fp_sign(c):=1-fp_sign(c);
      while j<n+1 do begin
        if mem[c+j].int<>0 then begin i:=j; j:=n+2;@+end;
        j:=j+1;
        end;
      mem[c+i].int:=1000-mem[c+i].int;
      for j:=i+1 to n+1 do mem[c+j].int:=999-mem[c+j].int;
      end;


@ Finally, we can deal with addition/subtraction of two floats. In
this procedure, we normalize result.

@<FL internal codes@>=
procedure fp_add_or_sub(@!a,@!b: pointer; @!s:integer;
  @!r: pointer);
var @!i: integer;
begin
  if (fp_sign(a)=2)or(fp_sign(b)=2) then begin
    fp_length(r):=fp_length(a);
    fp_exp(r):=0; for i:=2 to fp_length(a)+2 do mem[r+i].int:=0; 
    fp_sign(r):=2;
    end
  else begin
    if mem[a+fp_length(a)+1].int=0 then fp_exp(a):=-32767;
    if mem[b+fp_length(b)+1].int=0 then fp_exp(b):=-32767;
    i:=fp_sign(b);
    if s=1 then fp_sign(b):=1-fp_sign(b);
    if fp_sign(b)=fp_sign(a) then fp_add_absolute_value(a,b,r)
    else begin fp_sign(b):=1-fp_sign(b); 
      fp_sub_absolute_value(a,b,r);@+end;
    fp_sign(b):=i;
    if (fp_sign(r)<>2)and(fp_exp(r)<32768) then fp_adjust_frac(r,true);
    end;
end;

@ Next, we consider multiplication of floats. To multiply two floats,
whose length are $m$ and $n$ respectively, needs length
$m+n-1$. 

However, sometimes we don't need result of multiplication in $m+n-1$
length. So, we define procedures for shrink or extend length of a
float here. We assume the float was normalized, and we want that
result will be normalized, too. Therefore, code of shrinking float is
slightly longer than that of extending.

@ @<FL internal codes@>=
procedure fp_adjust_length_ovw(@!a: pointer; @!n: integer);
var @!m: pointer; 
@!i,@!j,@!r,@!k: integer;
begin
  if n>fp_length(a) then { error, we do nothing }
    begin print_err("This can't happen (fp_adjust_length_ovw)");
@.This can't happen@>
    help1("I'm broken. Please show this to someone who can fix can fix");
    end
  else if n<fp_length(a) then begin
    j:=fp_length(a)-n; k:=mem[a+1+j].int;@/
    r:=mem[a+1+j].int; fp_length(a):=n; 
    for i:=2 to n+2 do
      mem[a+i].int:=mem[a+i+j].int;
    if (k>500)or((k=500)and odd(r)) then { round to nearest even } begin 
      r:=1; i:=2; 
      while i<=n+1 do begin
        if mem[a+i].int<>999 then begin r:=0; i:=n+2;@+end; i:=i+1; end;
      if r=1 then begin
        mem[a+2].int:=mem[a+2].int+1; i:=2;
        while i<=n+1 do 
          if mem[a+i].int>=1000 then begin
            mem[a+i].int:=mem[a+i].int-1000; mem[a+i+1].int:=mem[a+i+1].int+1; 
            i:=i+1; end
          else i:=n+4;
        end;
      end;
    end;
end;

@ @<FL internal codes@>=
procedure fp_adjust_length_ncr(@!a: pointer; @!n: integer; @!m: pointer);
var @!i,@!j,@!r: integer;
begin
  if n>=fp_length(a) then { In this case, we extend length of float }
    begin
    fp_length(m):=n; j:=n-fp_length(a); fp_exp(m):=fp_exp(a);@/
    fp_sign(m):=fp_sign(a);
    for i:=n+2 downto 2 do mem[m+i].int:=0;
    for i:=fp_length(a)+1 downto 2 do
      mem[m+i+j].int:=mem[a+i].int;
    end
  else begin
    fp_length(m):=n; j:=fp_length(a)-n; @/
    fp_exp(m):=fp_exp(a); fp_sign(m):=fp_sign(a);
    for i:=n+2 downto 2 do
      mem[m+i].int:=mem[a+i+j].int;
    if (mem[a+1+j].int>500)
      or ((mem[a+1+j].int=500)and odd(mem[a+2+j].int)) then { round to nearest even }
      begin 
      r:=1; i:=2; 
      while i<=n+1 do begin
        if mem[m+i].int<>999 then begin r:=0; i:=n+2;@+end; i:=i+1; end;
      if r=1 then begin
        mem[m+2].int:=mem[m+2].int+1; i:=2;
        while i<=n+1 do 
          if mem[m+i].int>=1000 then begin
            mem[m+i].int:=mem[m+i].int-1000; mem[m+i+1].int:=mem[m+i+1].int+1; 
            i:=i+1; end
          else i:=n+4;
        end;
      end;    
    end;
end;


@ Here, we can write |fp_mul| function. This function takes two
floats, whose length are $m$ and $n$ respectively, and returns float
whose length is $m+n-1$ and which is normalized. 

@<FL internal codes@>=
procedure fp_mul(@!a,@!b,@!c: pointer); 
label exit;
var @!i,@!j,@!k,@!m,@!n,@!t: integer;
begin
  m:=fp_length(a); n:=fp_length(b);
  fp_length(fp_temp_four_ope):=m+n;
  if (fp_sign(a)=2)or(fp_sign(b)=2) then begin
    fp_sign(fp_temp_four_ope):=2;@/
    fp_adjust_length_ncr(fp_temp_four_ope,m,c);return;end;
  for j:=2 to m+n+2 do mem[fp_temp_four_ope+j].int:=0; j:=0;
  while j<n do begin
    if mem[b+j+2].int=0 then mem[fp_temp_four_ope+j+m+2].int:=0
    else begin i:=0; k:=0;
      for i:=0 to m-1 do begin 
        t:=mem[a+i+2].int*mem[b+j+2].int@|+mem[fp_temp_four_ope+i+j+2].int+k;@/
        mem[fp_temp_four_ope+i+j+2].int:=t mod 1000; k:=t div 1000;
        end;
      mem[fp_temp_four_ope+j+m+2].int:=k;
      end;
    j:=j+1;
    end;
  @<FL set sign and exponent part, in multiplication@>;
exit: end; 

@ @<FL set sign and exponent part, in multiplication@>=
  fp_sign(fp_temp_four_ope):=(fp_sign(a)+fp_sign(b)) mod 2;@/
  fp_exp(fp_temp_four_ope):=0; i:=fp_exp(a)+fp_exp(b)+1;
  if mem[fp_temp_four_ope+m+n+1].int<100 then fp_left_shift(fp_temp_four_ope);
  if i+fp_exp(fp_temp_four_ope)>=32768 then begin
    fp_exp(fp_temp_four_ope):=32768; fp_arith_error:=1;@+end
  else if i+fp_exp(fp_temp_four_ope)<-32767 then
    for i:=m+n+1 downto 2 do mem[fp_temp_four_ope+i].int:=0
  else fp_exp(fp_temp_four_ope):=i+fp_exp(fp_temp_four_ope);
  fp_adjust_length_ncr(fp_temp_four_ope,m,c);

@ Finally, we handle division such as $n$-length float |a| by
$n$-length float |b|. We will obtain $n$-length result; to do this, we
extend |a| to $2n+1$-length. Then we use classical algorithm in TAOCP,
and normalize this result. We don't check length of |a| and |b| are
same.

@<FL internal codes@>=
procedure fp_div(@!a,@!b,@!q: pointer); 
label done1,exit;
var @!ca,@!cb,@!g,@!qw: pointer;
@!d,@!n,@!j,@!v,@!s,@!t,@!k,@!l: integer;
@!f: boolean; 
begin
  n:=fp_length(a); d:=1000 div (mem[b+n+1].int+1);@/
  ca:=fp_temp_four_ope; cb:=fp_temp_four_ope+2*n+4;@/ 
  g:=fp_temp_four_ope+3*n+7; qw:=fp_temp_four_ope+4*n+10;@/
  fp_length(qw):=n+2; fp_exp(qw):=0;
  for j:=2 to n+4 do mem[qw+j].int:=0;
  @<FL handle if |a| or |b| is  not finite number or zero, in division@>;
  fp_adjust_length_ncr(a,2*n+1,ca); fp_copy(b,cb); 
  @<FL Multiply |ca| and |cb| by |d| to yield accuracy in long division@>;
  j:=n+1;
  while j>=0 do begin 
    s:=mem[ca+2+j+n].int*1000+mem[ca+1+j+n].int;@/
    v:=s div mem[cb+1+n].int; t:=s mod mem[cb+1+n].int;
    while t<1000 do
      if (v>=1000)or(v*mem[cb+n].int>1000*t+mem[ca+j+n].int) then begin
        v:=v-1; t:=t+mem[cb+1+n].int;@+end
      else goto done1;
done1: @<FL multiply and subtract, and new |ca| ensure positive@>;
    mem[qw+j+2].int:=v; 
    if f then begin
      mem[qw+j+2].int:=v-1; 
      @<FL add back |ca| to fragment of |cb|, to cancel ``borrow'' in long division @>;
    end;
    j:=j-1;
    end;
  @<FL adjusting exponent part and round in division@>;
exit: end;

@ @<FL handle if |a| or |b| is  not finite number or zero, in division@>=
  fp_length(q):=n;
  if mem[a+n+1].int=0 then begin
    if mem[b+n+1].int=0 then  begin fp_sign(q):=2; fp_arith_error:=2@+ end
    else begin fp_exp(q):=0; fp_sign(q):=0;@+end;
    for j:=1 to n+2 do  mem[q+j].int:=0; return;
    end
  else if mem[b+n+1].int=0 then begin
    fp_sign(q):=(fp_sign(a)+fp_sign(b))mod 2;@/
    fp_exp(q):=32768; fp_arith_error:=1; return;
  end
  else if fp_exp(b)=32768 then begin
    for j:=2 to n+2 do  mem[q+j].int:=0; fp_exp(q):=0;
    if fp_exp(a)=32768 then begin fp_sign(q):=2; fp_arith_error:=2;@+end
    else begin fp_exp(q):=0; fp_sign(q):=0;@+end;
    return;
   end

@ @<FL Multiply |ca| and |cb| by |d| to yield accuracy in long division@>=
k:=0;
for l:=2 to 2*n+3 do begin@/
  k:=mem[ca+l].int*d+k; mem[ca+l].int:=k mod 1000; k:=k div 1000;@+end;
k:=0;
for l:=2 to n+2 do begin@/
  k:=mem[cb+l].int*d+k; mem[cb+l].int:=k mod 1000; k:=k div 1000;@+end;

@ @<FL add back |ca| to fragment of |cb|, to cancel ``borrow'' in long division @>=
k:=0;
for l:=2 to n+1 do begin@/
  k:=mem[ca+l+j].int+mem[cb+l].int+k;@/ 
  mem[ca+l+j].int:=k mod 1000; k:=k div 1000;
end; 
k:=mem[ca+n+2+j].int+k;@/
mem[ca+n+2+j].int:=k mod 1000;

@ @<FL multiply and subtract, and new |ca| ensure positive@>=
fp_copy(cb,g); k:=0; { short multiplication by |v| }
for l:=2 to n+1 do begin@/
  k:=mem[g+l].int*v+k; mem[g+l].int:=k mod 1000;@/
  k:=k div 1000; end; 
mem[g+n+2].int:=k; 
k:=0;
for l:=2 to n+1 do begin
  k:=mem[ca+l+j].int-mem[g+l].int+k; 
  if k<0 then@+begin mem[ca+l+j].int:=k+1000; k:=-1;@+ end
  else begin mem[ca+l+j].int:=k; k:=0;@+ end;
end; 
k:=mem[ca+n+2+j].int-mem[g+n+2].int+k; 
if k<0 then@+begin f:=true; mem[ca+n+2+j].int:=k+1000;@+ end
else begin f:=false; mem[ca+n+2+j].int:=k;
@+ end;

@ @<FL adjusting exponent part and round in division@>=
  fp_sign(qw):=(fp_sign(a)+fp_sign(b)) mod 2;@/
  fp_exp(qw):=0; k:=fp_exp(a)-fp_exp(b)+2;
  if k+fp_exp(qw)>=32768 then@+begin
    fp_exp(qw):=32768; fp_arith_error:=1;@+end
  else if k+fp_exp(qw)<-32767 then@+
    for k:=n+4 downto 2 do mem[qw+k].int:=0
  else fp_exp(qw):=k+fp_exp(qw);
  fp_adjust_frac(qw,false);
  fp_adjust_length_ncr(qw,n,q);

@ Following function takes a float |a| and an integer |n|, which is
greater than 0 and less than 1000, and returns $a/n$.  To calucarate
transcendential function, we use Taylor series of that function, and
while evaluating this Taylor series, this short division will be
freqently used.

@<FL internal codes@>=
procedure fp_short_div(@!a: pointer;@!b: integer;@!q: pointer);
label done1,exit;
var @!ca,@!qw: pointer;
@!n,@!j,@!s,@!t,@!k,@!l: integer;
@!f: boolean; 
begin
  n:=fp_length(a); ca:=fp_temp_four_ope;@/
  qw:=fp_temp_four_ope+n+5; @/
  fp_length(qw):=n+2; fp_exp(q):=0;
  for j:=2 to n+4 do mem[qw+j].int:=0;
  @<FL handle if |a| is zero, in short division@>;
  fp_adjust_length_ncr(a,n+2,ca); t:=0;
  for j:=n+1 downto 0 do begin
    t:=1000*t+mem[ca+j+2].int; @/
    mem[qw+j+2].int:=t div b; t:=t mod b;
  end;
  @<FL adjusting exponent part and round in short division@>;
exit: end;

@ @<FL handle if |a| is zero, in short division@>=
  if mem[a+n+1].int=0 then begin
    fp_length(q):=n; fp_exp(q):=0; fp_sign(q):=0; 
    for j:=2 to n+2 do mem[q+j].int:=0;
    return;
    end

@ @<FL adjusting exponent part and round in short division@>=
  fp_sign(qw):=fp_sign(a);
  fp_exp(qw):=0; k:=fp_exp(a);
  if k+fp_exp(q)>=32768 then@+begin
    fp_exp(q):=32768; fp_arith_error:=1;@+end
  else if k+fp_exp(qw)<-32767 then
    for k:=n+2 downto 2 do mem[q+k].int:=0
  else fp_exp(qw):=k+fp_exp(qw);
  fp_adjust_frac(qw,false);
  fp_adjust_length_ncr(qw,n,q);

@ Square operation of a float is often performed in computing
transcendential functions, such as sin, cos.  We can do square
operation faster than normal multiplication.

@<FL internal codes@>=
procedure fp_square(@!a,@!r: pointer); 
label exit;
var @!i,@!j,@!k,@!m,@!n,@!t: integer;
begin
  n:=fp_length(a);
  fp_length(fp_temp_four_ope):=2*n;
  if fp_sign(a)=2 then begin 
    fp_length(r):=n; fp_sign(r):=2; fp_arith_error:=2; 
    for j:=1 to n+2 do mem[r+j].int:=0; j:=0;return;
    end;
  for j:=2 to 2*n+2 do mem[fp_temp_four_ope+j].int:=0; j:=0;
  @<FL main loop in |fp_square|@>@/
  fp_sign(fp_temp_four_ope):=0;@/
  fp_exp(fp_temp_four_ope):=0; i:=2*fp_exp(a)+1;
  if mem[fp_temp_four_ope+2*n+1].int<100 then fp_left_shift(fp_temp_four_ope);
  if i+fp_exp(fp_temp_four_ope)>=32768 then begin
    fp_exp(fp_temp_four_ope):=32768; fp_arith_error:=1;@+end
  else if i+fp_exp(fp_temp_four_ope)<-32767 then
    for i:=2*n+1 downto 2 do mem[fp_temp_four_ope+i].int:=0
  else fp_exp(fp_temp_four_ope):=i+fp_exp(fp_temp_four_ope);
  fp_adjust_length_ncr(fp_temp_four_ope,n,r);
exit: end; 

@ @<FL main loop in |fp_square|@>=
  while j<n do begin
    if mem[a+j+2].int=0 then mem[fp_temp_four_ope+j+n+2].int:=0
    else begin i:=0; k:=0;
      for i:=0 to j-1 do begin 
        t:=2*mem[a+i+2].int*mem[a+j+2].int+mem[fp_temp_four_ope+i+j+2].int+k;
        mem[fp_temp_four_ope+i+j+2].int:=t mod 1000; k:=t div 1000;
        end;
      t:=mem[a+j+2].int*mem[a+j+2].int+mem[fp_temp_four_ope+2*j+2].int+k;
      mem[fp_temp_four_ope+i+j+2].int:=t mod 1000; k:=t div 1000;
      for i:=j+1 to n-1 do begin 
        t:=mem[fp_temp_four_ope+i+j+2].int+k;
        mem[fp_temp_four_ope+i+j+2].int:=t mod 1000; k:=t div 1000;
        end;
      mem[fp_temp_four_ope+j+n+2].int:=k;
      end;
    j:=j+1;
    end;

@ We programmed addition, subtraction, multiplication, division of
float and vice versa, in previous section. So in rest of this section,
we will cope with transcendental function, such as $\sqrt x$, $\sin
x$, $\exp x$.  Many operationa of float are needed to compute
transcendental functions, so we need to add extra precision.

@ First, we compute square root of $x$. We actually compute $1/\sqrt
x$ in Newton method, which is indicated as $x_{n+1}:=(3-ax_n^2)x_n/2$. 

@<FL internal codes@>=
procedure fp_sqrt(@!a,@!k,@!w: pointer);
label exit,done;
var @!th,@!b,@!q,@!c: pointer; 
@!i,@!e,@!n,@!s,@!t,@!nn: integer;
begin
  n:=fp_length(a); if n>=12 then nn:=n else nn:=n+5;
  th:=w; b:=w+nn+3; q:=w+2*nn+6; c:=w+3*nn+9;
  @<FL handle illegal argument and zero, in |fp_sqrt|@>@/
  @<FL set initial value for square root@>@/
  for i:=1 to n+5 do begin 
    fp_square(c,b); fp_mul(b,a,q);@/
    fp_add_or_sub(th,q,1,b); fp_mul(b,c,q); fp_short_div(q,2,c); 
    end;
  fp_mul(a,c,b);
  fp_adjust_length_ncr(b,n,k); @/
  fp_exp(k):=fp_exp(k)+e; @/
  fp_exp(a):=fp_exp(a)+2*e;
exit: end;

@ @<FL handle illegal argument and zero, in |fp_sqrt|@>=
  if (fp_sign(a)=2)or((mem[a+n+1].int<>0)and(fp_sign(a)=1)) then begin
    fp_length(k):=n; for i:=2 to n+2 do mem[k+i].int:=0; 
    fp_sign(k):=2; fp_arith_error:=2; return;end
  else if fp_exp(a)=32768 then begin
    fp_length(k):=n; for i:=2 to n+2 do mem[k+i].int:=0; 
    fp_sign(k):=0; fp_exp(k):=32768; fp_arith_error:=1; return;end
  else if mem[a+n+1].int=0 then begin 
    fp_length(k):=n; for i:=2 to n do mem[k+i].int:=0; 
    fp_sign(k):=0; mem[k+n+1].int:=100;@/
    mem[k+n+2].int:=0; fp_exp(k):=0; return;end;


@ We reduce |a| into $[0.1,10)$, to yield accuracy.

@<FL set initial value for square root@>=
  for i:=2 to nn+2 do mem[c+i].int:=0; 
  fp_length(c):=nn; fp_exp(c):=0; fp_sign(c):=0;
  fp_copy(a,b);
  if fp_exp(a)>=0 then e:=(fp_exp(a)+1) div 2 else e:=-((1-fp_exp(a)) div 2);
  if odd(fp_exp(a)) then fp_left_shift(b); 
  fp_exp(a):=fp_exp(a)-2*e;
  i:=mem[b+n+2].int*10000000+mem[b+n+1].int*10000@|
    +mem[b+n].int*10+(mem[b+n-1].int div 100); 
    { this value is used for computing initial value. }
  s:=1; t:=i;
  while s<t do@+begin s:=2*s; t:=t div 2;@+end;
  loop@+begin
    t:=s; s:=(s + i div s) div 2; 
    if s>=t then goto done;
    end; 
done: 
  fp_length(b):=nn; for i:=2 to nn-1 do mem[b+i].int:=0;@/
  fp_sign(b):=0; fp_exp(b):=fp_exp(a); @/
  mem[b+nn+1].int:=t div 10; mem[b+nn].int:=t mod 10; 
  for i:=2 to nn+2 do mem[th+i].int:=0;@/
  fp_length(th):=nn; fp_exp(th):=0; fp_sign(th):=0;@/
  mem[th+nn+1].int:=100; fp_div(th,b,c);@/
  mem[th+nn+1].int:=300; 

@ To compute $\exp x$, first we reduce $x$ such that $x\in [0,2]$ using
identities $\exp x=\sqrt{\exp 2x}$ and $\exp -x=1/\exp x$. Name of
this procedure is |fp_exponent|, because name |fp_exp| is used for
indicate exponent part of a float already.

@<FL internal codes@>=
@<FL test relation of two float@>
procedure fp_exponent(@!a,@!k,@!w: pointer);
label done1,done2,exit;
var @!b,@!z,@!p,@!q,@!tmp: pointer;
@!f,@!i,@!j,@!n: integer;
begin
  n:=fp_length(a); q:=w; b:=w+n+8; z:=w+2*n+16; p:=w+3*n+24;
  @<FL treat NaN, too large/small argument, and zero, in |fp_exponent|@>;
  @<FL reduce |a| such that $|a|\in[0,0.5]$, in |fp_exponent|@>;
  fp_sign(p):=0; fp_length(p):=n+5; mem[p+n+6].int:=100;mem[p+n+7].int:=0;
  for i:=1 to n+5 do mem[p+i].int:=0; 
  fp_copy(p,q); i:=0; 
  loop@+begin
    i:=i+1; fp_mul(q,b,z); fp_short_div(z,i,q);@/
    fp_add_or_sub(p,q,0,z); tmp:=p; p:=z; z:=tmp; 
    if fp_exp(q)<-3*(n+6) then goto done2; 
    end;
done2: for j:=1 to f do@+begin
    fp_square(p,q); tmp:=p; p:=q; q:=tmp;@+
    end; 
  if fp_sign(a)=1 then begin
    fp_sign(z):=0; fp_length(z):=n+5;@/
    mem[z+n+6].int:=100;mem[z+n+7].int:=0; 
    for i:=1 to n+5 do mem[z+i].int:=0; 
    fp_div(z,p,q); tmp:=p; p:=q; q:=tmp; 
    end;
  fp_adjust_length_ncr(p,n,k);
exit: end;

@ We have $\log 10^{32768}=75451.108327\ldots$. So if |a| is equal or greater
than $75451.108328$, the result will be $\infty$. If |a| is equal or smaller
than $-75451.108328$, the result will be zero. If |a| is NaN, of
course the result will be NaN.

@<FL treat NaN, too large/small argument, and zero, in |fp_exponent|@>=
  fp_copy(a,k);
  if fp_sign(a)=2 then@+begin 
    fp_arith_error:=2; return;@+end
  else fp_sign(k):=0;
  fp_length(z):=4; fp_exp(z):=4; fp_sign(z):=0;@/
  mem[z+6].int:=0; mem[z+5].int:=754; mem[z+4].int:=511;@/
  mem[z+3].int:=083; mem[z+2].int:=280;@/
  i:=fp_test_rel(k,z);
  if i<>1 then begin { If |k| is equal or greater than 75451.108328 }
    for i:=2 to n+2 do mem[k+i].int:=0;
    if fp_sign(a)=0 then begin fp_exp(k):=32768; fp_arith_error:=1;@+end
    else fp_exp(k):=0;
    return;
    end;
  if mem[k+n+1].int=0 then begin fp_exp(k):=0;mem[k+n+1].int:=100; return;@+end;
  fp_adjust_length_ncr(k,n+5,b); 

@ This fragments reduces |a| such that $|a|\in[0,0.5]$. |a| is
unchanged, and result will be in |b|. |f| will be that how many times
divide |a| by 2.

@<FL reduce |a| such that $|a|\in[0,0.5]$, in |fp_exponent| @>=
  fp_exp(z):=-1; mem[z+5].int:=500; mem[z+4].int:=0;@/
  mem[z+3].int:=0; mem[z+2].int:=0; f:=0; 
  loop@+begin 
    if fp_test_rel(b,z)<>3 then goto done1;
    fp_short_div(b,16,p);tmp:=p; p:=b; b:=tmp;f:=f+4; 
    end;
done1:
  if fp_test_rel(b,z)=3 then begin
    fp_short_div(b,4,p); tmp:=p; p:=b; b:=tmp; f:=f+2;
  end;
  if fp_test_rel(b,z)=3 then begin
    fp_short_div(b,2,p); tmp:=p; p:=b; b:=tmp; f:=f+1;
  end;

@ To compute trigonometric functions, we have to compute constant
$\pi$ and floor function.  We need $\pi$ in (less than) 60 digits
only, because glue specification can store 21 digits only, and
internal compution of transcendental function will be done in
$36=21+25$ digits.

@<Glob...@>=
@!fp_pi_location: pointer;

@ @<FL set $\pi$@>=
  fp_pi_location:=get_node(23); fp_length(fp_pi_location):=20;@/ 
  fp_exp(fp_pi_location):=0; fp_sign(fp_pi_location):=0;@/
  mem[fp_pi_location+22].int:=0;@/
  mem[fp_pi_location+21].int:=314; mem[fp_pi_location+20].int:=159; 
  mem[fp_pi_location+19].int:=265; mem[fp_pi_location+18].int:=358; 
  mem[fp_pi_location+17].int:=979; mem[fp_pi_location+16].int:=323;
  mem[fp_pi_location+15].int:=846; mem[fp_pi_location+14].int:=264; 
  mem[fp_pi_location+13].int:=338; mem[fp_pi_location+12].int:=327; 
  mem[fp_pi_location+11].int:=950; mem[fp_pi_location+10].int:=288;
  mem[fp_pi_location+ 9].int:=419; mem[fp_pi_location+ 8].int:=716; 
  mem[fp_pi_location+ 7].int:=939; mem[fp_pi_location+ 6].int:=937; 
  mem[fp_pi_location+ 5].int:=510; mem[fp_pi_location+ 4].int:=582;
  mem[fp_pi_location+ 3].int:=097; mem[fp_pi_location+ 2].int:=494; 

@ Ceiling  and floor function is not so complicated. 

@<FL internal codes@>=
procedure fp_ceil_floor(@!a: pointer; @!m: integer;@!b:pointer); 
  { $|m|=0$: floor, $|m|=1$: ceiling }
label done,done2,exit;
var @!d:pointer; 
@!i,j,n: integer;
begin
  n:=fp_length(a); fp_copy(a,b);
  if (fp_sign(a)=2)or(fp_exp(a)>=3*fp_length(a)-1)
    or(mem[a+n+1].int=0) then return;
  if fp_exp(a)<=-1 then begin
    fp_exp(b):=0; for i:=2 to n+2 do mem[b+i].int:=0;
    if fp_sign(a)<>m then mem[b+n+1].int:=100;
    end
  else if fp_sign(a)=m then @<FL flooring absolute value @>
  else @<FL ceiling absolute value @>;
exit: end;

@ @<FL flooring absolute value @>=
begin
  j:=n+1-(fp_exp(b) div 3);
  for i:=2 to j-1 do mem[b+i].int:=0;
  case fp_exp(a) mod 3 of
    0: mem[b+j].int:=(mem[b+j].int div 100)*100;
    1: mem[b+j].int:=(mem[b+j].int div 10)*10;
  end;
end

@ @<FL ceiling absolute value @>=
begin
  j:=n+1-(fp_exp(a) div 3);
  for i:=2 to j-1 do if mem[b+i].int<>0 then goto done;
  case fp_exp(a) mod 3 of
    0: if (mem[b+j].int mod 100)<>0 then goto done;
    1: if (mem[b+j].int mod 10)<>0 then goto done;
  end;  
  goto done2;
done: 
  fp_sign(fp_temp_four_ope):=fp_sign(a);@/
  fp_length(fp_temp_four_ope):=n;@/
  fp_exp(fp_temp_four_ope):=0;
  for i:=2 to n do mem[fp_temp_four_ope+i].int:=0;
  mem[fp_temp_four_ope+n+1].int:=100;@/
  mem[fp_temp_four_ope+n+2].int:=0;@/
  fp_add_or_sub(fp_temp_four_ope,a,0,b);@/
  @<FL flooring absolute value @>;
done2: end

@ Here we compute trigonometric functions and hyperbolic functions.

@<FL internal codes@>=
procedure fp_tri_hyp(@!a: pointer;@!w:integer;@!b,@!y: pointer); { {\bf INCPREC} }@/
  { 1: $\sin |a|$,  2: $\cos |a|$,  3: $\tan |a|$, 
    4: $\sinh |a|$, 5: $\cosh |a|$, 6: $\tanh |a|$. }
label done1,done2, exit;
var @!f,@!i,@!j,@!n,@!u: integer;
@!s,@!q,@!r,@!c,@!z,@!tmp: pointer;
begin
  n:=fp_length(a); s:=y; q:=y+n+8; r:=y+2*n+16;@/
  c:=y+3*n+24; z:=y+4*n+32;@/
  @<FL reduce argument in |fp_tri_hyp|@>; @<FL Main loop in |fp_tri_hyp|@>@/
  @<FL use relations to compute ``actual'' value, in |fp_tri_hyp|@>@/
exit: end;

@ This is where computes Taylor series.

@<FL Main loop in |fp_tri_hyp|@>=
  fp_sign(s):=0; fp_length(s):=n+5;
  for i:=1 to n+7 do mem[s+i].int:=0; { |s| and |c| are is $0$. }
  fp_copy(s,c);fp_copy(s,q);
  mem[q+n+6].int:=100; { |q| is $b^0=1$. }
  i:=0; u:=0; 
  loop@+begin
    i:=i+1; fp_mul(q,b,r);fp_short_div(r,i,q);@/
    fp_add_or_sub(s,q,u,r);tmp:=r; r:=s; s:=tmp;@/
    i:=i+1; fp_mul(q,b,r);fp_short_div(r,i,q);
    if w<4 then begin fp_add_or_sub(c,q,1-u,r); u:=1-u;@+end
    else fp_add_or_sub(c,q,0,r);@/
    tmp:=r; r:=c; c:=tmp;
    if (fp_exp(s)-fp_exp(q)>=3*(n+6)) @|
      and (fp_exp(c)-fp_exp(q)>=3*(n+6)) then goto done2;
    end;
done2: 


@ We have $\log(2\cdot10^{32768})=75451.801474\ldots$. So if
$\vert|a|\vert$ is equal or greater than 75451.801475, the $\sinh a$, $\cosh a$
will be infinity, and $\tanh a$ will be $\pm1$.

If |a| is NaN, of
course the result will be NaN.

@<FL reduce argument in |fp_tri_hyp|@>=
  fp_adjust_length_ncr(a,n+5,b); fp_sign(b):=0;
  if fp_sign(a)=2 then@+begin 
    fp_arith_error:=2; fp_sign(b):=2;return;@+end;
  if w>=4 then begin
    @<FL treat too large/small argument, and zero, in |fp_tri_hyp|@>;
    @<FL reduce |a| such that $|a|\in[0,0.5]$, in |fp_tri_hyp|@>;
  end
  else begin
    if fp_exp(a)=32768 then begin 
      fp_arith_error:=2; fp_sign(b):=2;return;@+end
    else if mem[b+n+6].int=0 then begin fp_exp(b):=0; 
      if w=2 then mem[b+n+6].int:=100; return;@+end;
    @<FL reduce |a| such that $|a|\in[0,\pi/4]$, in |fp_tri_hyp|@>;
  end;

@ @<FL treat too large/small argument, and zero, in |fp_tri_hyp|@>=
  fp_length(z):=4; fp_exp(z):=4; fp_sign(z):=0;@/
  mem[z+6].int:=0; mem[z+5].int:=754; mem[z+4].int:=518;@/
  mem[z+3].int:=014; mem[z+2].int:=750;
  if fp_test_rel(b,z)<>1 then begin 
    for i:=2 to n+5 do mem[b+i].int:=0;@/
    mem[b+n+6].int:=100; mem[b+n+7].int:=100; 
    case w*10+fp_sign(a) of
      41: begin fp_exp(b):=32768; fp_arith_error:=1; fp_sign(b):=1;@+ end;
      60: begin fp_exp(b):=0;@+ end;
      61: begin fp_exp(b):=0; fp_sign(b):=1;@+ end;
      othercases begin fp_exp(b):=32768; fp_arith_error:=1;@+ end
    endcases;
    return;@+end;
  fp_exp(z):=-1; mem[z+5].int:=500; mem[z+4].int:=0; @/
  mem[z+3].int:=0; mem[z+2].int:=0; 
  if mem[b+n+6].int=0 then begin { if |a| is zero }
    fp_exp(b):=0;
    case w of
      4,6: mem[b+n+6].int:=0;
      othercases mem[b+n+6].int:=100
    endcases; return;@+end;

@ @<FL reduce |a| such that $|a|\in[0,0.5]$, in |fp_tri_hyp|@>=
  f:=0;
  loop@+begin 
    if fp_test_rel(b,z)<>3 then goto done1;
    fp_short_div(b,16,c); fp_copy(c,b); f:=f+4;
    end;
done1: 
  if fp_test_rel(b,z)=3 then begin
    fp_short_div(b,4,c); fp_copy(c,b); f:=f+2;
  end;
  if fp_test_rel(b,z)=3 then begin
    fp_short_div(b,2,c); fp_copy(c,b);f:=f+1;
  end;

@ @<FL reduce |a| such that $|a|\in[0,\pi/4]$, in |fp_tri_hyp|@>=
  fp_adjust_length_ncr(fp_pi_location,n+5,s);@/
  fp_length(z):=4; fp_sign(z):=0; fp_exp(z):=0;@/
  mem[z+5].int:=200; mem[z+4].int:=0; mem[z+3].int:=0; mem[z+2].int:=0; @/
  fp_mul(s,z,q); fp_div(b,q,c); fp_ceil_floor(c,0,s);@/
  fp_mul(s,q,r); fp_add_or_sub(b,r,1,z); fp_short_div(z,8,b); f:=3;
  
@ We computed hyperbolic sine and hyperbolic cosine, or sine and
cosine for ``reduced'' arguments, but this is not what we want.

@<FL use relations to compute ``actual'' value, in |fp_tri_hyp|@>=
fp_length(z):=4; fp_sign(z):=0;mem[z+6].int:=0; fp_exp(z):=0;@/
mem[z+5].int:=200; mem[z+4].int:=0; mem[z+3].int:=0; mem[z+2].int:=0; @/
for j:=1 to f do begin
  fp_mul(s,z,q); fp_mul(q,c,r);fp_add_or_sub(q,r,0,b);@/
  fp_square(s,r); fp_mul(r,z,c);
  if (w<=3) and (fp_sign(c)<2) then fp_sign(c):=1-fp_sign(c);
  fp_copy(b,s);
  end; 

@ Finally, we compute tangent or hyperbolic tangent if needed.

@<FL use relations to compute ``actual'' value, in |fp_tri_hyp|@>=
if (w mod 3)=1 then begin
  fp_copy(s,b);fp_sign(s):=fp_sign(a); return;@+end;
fp_sign(z):=0; fp_length(z):=n+5; mem[z+n+6].int:=100;mem[z+n+7].int:=0;@/
for i:=1 to n+5 do mem[z+i].int:=0;@/
fp_add_or_sub(c,z,0,q); 
if (w mod 3)=2 then fp_copy(q,b)
else fp_div(s,q,b); 

@ \def\arcsinh{\mathop{\rm arcsinh}}
\def\arccosh{\mathop{\rm arccosh}}
\def\arctanh{\mathop{\rm arctanh}}
We will compute $\log x$ and inverse hyperbolic functions.  This
procedure computes $\arctanh u$, $|u|<1$. Taylor series of
$\arctanh x$ is similar to that of $\arctan x$, so we handle
these two functions here. FIXME

@<FL internal codes@>=
procedure fp_log_inner(@!u: pointer;@!w: boolean;@!k,@!v:pointer);
{ |false|: arctanh, |true|: arctan }
label done,exit;
var @!q,@!s,@!r,@!z,@!tmp: pointer;
@!i,@!n,@!l: integer;
begin@/
  n:=fp_length(u);@/
  q:=v; s:=v+n+3; r:=v+2*n+6; z:=v+3*n+9;@/
  @<FL handle when |u| is 0, in |fp_log_inner| @>; 
  fp_square(u,k); fp_copy(k,q); fp_sign(z):=0; fp_length(z):=n;@/
  for i:=1 to n do mem[z+i].int:=0; mem[z+n+1].int:=100; 
  mem[z+n+2].int:=0; {|z| is 1 }@/
  i:=3; if w then l:=1@+ else l:=0; @/
  loop@+begin
    fp_short_div(q,i,r); fp_add_or_sub(z,r,l,s); tmp:=z;z:=s;s:=tmp;@/
    i:=i+2; fp_mul(q,k,r); tmp:=r;r:=q;q:=tmp;@/
    if w then l:=1-l;
    if fp_exp(q)<-3*(n+1) then goto done; @/
  end;
done: fp_mul(z,u,k);
end;

@ @<FL handle when |u| is 0, in |fp_log_inner| @>=
  if mem[u+fp_length(u)+1].int=0 then@+begin@+fp_copy(u,k); return;@+end; 

@ Here we compute $\log x$. Instead of Taylor series of $\log x$, we
use Taylor series of $\arctanh x$, i.e., |fp_log_inner| procedure.

@<Glob...@>=
@!logx,@!loga: pointer;

@ @<FL internal codes@>=
procedure fp_log(@!a,@!b,@!w: pointer); 
label done,exit;
var @!p,@!r,@!q,@!z,@!tmp: pointer;
@!v,@!i,@!j,@!n,@!m,@!nn: integer;
begin@/
  n:=fp_length(a); if n>=12 then nn:=n else nn:=n+5;@/
  p:=w; r:=w+nn+8; q:=w+2*nn+16; z:=w+3*nn+24;@/
  @<FL treat NaN, infinities, negative number and zero, in |fp_log|@>;@/
  @<FL reduce argument into $[1/2,2]$ in |fp_log|@>;@/
  fp_sign(z):=0; fp_length(z):=nn;@/
  for i:=1 to nn do mem[z+i].int:=0; @/
  mem[z+nn+1].int:=100; mem[z+nn+2].int:=0; { |z| is 1 }@/
  fp_add_or_sub(p,z,1,q); fp_add_or_sub(p,z,0,r);@/
  fp_div(q,r,p);fp_log_inner(p,false,r,q); @/
  fp_length(z):=3; fp_exp(z):=0; fp_sign(z):=0;@/
  mem[z+2].int:=0; mem[z+3].int:=0; mem[z+4].int:=200; mem[z+5].int:=0;@/
  fp_mul(r,z,q); @/
  @<FL addition of $\log 2$, etc.@>@; @<FL addition of $\log 10$@>@/
  fp_adjust_length_ncr(r,n,b);
exit: end;

@ @<FL addition of $\log 10$@>=
  fp_exp(z):=4;@/
  if fp_exp(a)>=0 then fp_sign(z):=0 else fp_sign(z):=1;@/
  mem[z+2].int:=0; mem[z+3].int:=10*(m mod 100); @/
  mem[z+4].int:=m div 100; mem[z+5].int:=0;@/
  fp_adjust_frac(z,false); fp_adjust_length_ncr(logx,nn,r);@/
  fp_mul(r,z,p); fp_add_or_sub(q,p,0,r);

@ @<FL addition of $\log 2$, etc.@>=
  if v>=1 then begin
    fp_adjust_length_ncr(loga,nn,p);@/
    fp_short_div(p,(6 div v),r);@/
    fp_add_or_sub(q,r,0,p); tmp:=q; q:=p; p:=tmp;
    end;

@ @<FL set $\log 10$, $\log 64$ @>=
  logx:=get_node(23); fp_length(logx):=20;@/ 
  fp_exp(logx):=0; fp_sign(logx):=0;@/
  mem[logx+22].int:=0;   mem[logx+21].int:=230; mem[logx+20].int:=258; 
  mem[logx+19].int:=509; mem[logx+18].int:=299; mem[logx+17].int:=404; 
  mem[logx+16].int:=568; mem[logx+15].int:=401; mem[logx+14].int:=799; 
  mem[logx+13].int:=145; mem[logx+12].int:=468; mem[logx+11].int:=436; 
  mem[logx+10].int:=420; mem[logx+ 9].int:=760; mem[logx+ 8].int:=110; 
  mem[logx+ 7].int:=148; mem[logx+ 6].int:=862; mem[logx+ 5].int:=877; 
  mem[logx+ 4].int:=297; mem[logx+ 3].int:=603; mem[logx+ 2].int:=333; 

@ @<FL set $\log 10$, $\log 64$ @>=
  loga:=get_node(23); fp_length(loga):=20;@/ 
  fp_exp(loga):=0; fp_sign(loga):=0;@/
  mem[loga+22].int:=0;   mem[loga+21].int:=415; mem[loga+20].int:=888; 
  mem[loga+19].int:=308; mem[loga+18].int:=335; mem[loga+17].int:=967; 
  mem[loga+16].int:=185; mem[loga+15].int:=650; mem[loga+14].int:=339; 
  mem[loga+13].int:=272; mem[loga+12].int:=874; mem[loga+11].int:=905; 
  mem[loga+10].int:=940; mem[loga+ 9].int:=845; mem[loga+ 8].int:=300; 
  mem[loga+ 7].int:=080; mem[loga+ 6].int:=616; mem[loga+ 5].int:=153; 
  mem[loga+ 4].int:=152; mem[loga+ 3].int:=472; mem[loga+ 2].int:=408; 

@ @<FL treat NaN, infinities, negative number and zero, in |fp_log|@>=
  fp_copy(a,b);
  if fp_sign(b)=2 then@+begin fp_arith_error:=2; return;@+end;
  if mem[a+n+1].int=0 then begin@/
    fp_arith_error:=1; fp_sign(b):=1; fp_exp(b):=32768;@/
    mem[b+n+6].int:=100;  return; end;
  if fp_sign(a)=1 then@+begin@/
    fp_arith_error:=2; fp_sign(b):=2; return;@+end;
  if fp_exp(a)=32768 then@+begin@/
    fp_arith_error:=1; return;@+end;
  fp_adjust_length_ncr(b,nn,p);

@ @<FL reduce argument into $[1/2,2]$ in |fp_log|@>=
  m:=fp_exp(a); fp_exp(p):=0; v:=0;
  if m<0 then m:=-m; 
  if mem[p+nn+6].int>=150 then begin
    if mem[p+nn+6].int>=600 then begin fp_short_div(p,8,q); v:=3;@+end
    else if mem[p+nn+6].int>=300 then begin fp_short_div(p,4,q); v:=2;@+end
    else begin fp_short_div(p,2,q); v:=1;@+end;
    fp_copy(q,p);
    end;

@ This procedure computes $\arcsinh x$, $\arccosh x$ and $\arctanh
x$. If absolute value of $x$ is less than or equal to 0.2,
|fp_log_inner| is used for computing $\arctanh x$. Otherwise, we
compute $\arctanh x$ as $0.5\log (1-x)/(1+x)$ using |fp_log|
procedure. Similarly, if absolute value of $x$ is less than or equal
to $10^{-n-5}$, where $n$ is length of $x$, we compute $\arcsinh x$ by
Taylor series. $\arccos x$ is computed using formulas that contains
log.

@<FL internal codes@>=
procedure fp_arc_hyp(@!a: pointer; @!w: integer;@!p,@!y:pointer); { {\bf INCPREC} }@/
  { 1: $\arcsinh |a|$,  2: $\arccosh |a|$,  3: $\arctanh |a|$ }
label exit;
var @!z,@!b,@!q,@!r,@!tmp: pointer;
@!i,@!j,@!n,@!f: integer;
begin@/
  n:=fp_length(a);@/
  b:=y; r:=y+n+8; z:=y+2*n+16; q:=y+3*n+24;
  @<FL handle invalid argument and prepare |b| in |fp_arc_hyp|@>@/
  if f=1 then fp_log_inner(b,false,p,z) 
  else if f=0 then fp_log(b,p,z)
  else @<FL computes Taylor series of $\arcsinh x$@>;@/
  if w<>2 then fp_sign(p):=fp_sign(a);
  if (f=0) and (w=3) then@+begin 
    fp_short_div(p,2,q); fp_copy(q,p);@+end;
exit: end;

@ @<FL handle invalid argument and prepare |b| in |fp_arc_hyp|@>=
  fp_sign(z):=0; fp_length(z):=n+5; mem[z+n+6].int:=100; mem[z+n+7].int:=0;@/
  for i:=1 to n+5 do mem[z+i].int:=0; @/
  fp_adjust_length_ncr(a,n+5,b); fp_sign(b):=0; f:=0;@/
  if fp_sign(a)=2 then begin 
    fp_arith_error:=2; fp_copy(b,p); fp_sign(p):=2; return;@+end;
  if w=1 then begin
    if fp_exp(a)=32768 then begin 
      fp_arith_error:=1; fp_copy(b,p); fp_sign(p):=fp_sign(a); return; 
      @+end;
    if fp_exp(a)<-(n+5) then f:=2
    else begin
      fp_square(b,q);fp_add_or_sub(q,z,0,p);fp_sqrt(p,q,y+4*n+32);@/
      fp_add_or_sub(q,b,0,r); tmp:=b; b:=r; r:=tmp;@+end;
    end
  else if w=2 then begin
    if fp_test_rel(a,z)=1 then begin 
      fp_arith_error:=2; fp_copy(b,p);fp_sign(p):=2; return;@+end
    else if fp_exp(a)=32768 then@+begin fp_arith_error:=1;fp_copy(b,p); return;@+end
    else begin
      fp_square(b,q);fp_add_or_sub(q,z,1,p); fp_sqrt(p,q,y+4*n+32); @/
      fp_add_or_sub(q,b,0,r); tmp:=b; b:=r; r:=tmp;@+end;
    end
  else begin { $|w|=3$ }
    if fp_test_rel(b,z)<>1 then@+begin fp_copy(b,p); fp_sign(p):=2; return;@+end;
    fp_exp(z):=-1; mem[z+n+6].int:=200;
    if fp_test_rel(b,z)=3 then begin
      fp_exp(z):=0; mem[z+n+6].int:=100;fp_add_or_sub(z,b,1,p);@/
      fp_add_or_sub(b,z,0,q);fp_div(p,q,r); tmp:=b; b:=r; r:=tmp;
      end
    else f:=1;
    end;
 
@ @<FL computes Taylor series of $\arcsinh x$@>=
  begin
    fp_square(b,q); fp_short_div(q,6,p);@/
    fp_add_or_sub(z,p,1,q); fp_mul(q,b,p);@+end

@ Here we compute inverse trigonometric functions. We only need to
compute Taylor series of $\arctan x$, because $\arcsin x=\arctan
(x/\!\sqrt{1-x^2})$ and $\arccos x=\pi/2-\arcsin x$. Calculation of
Taylor series of $\arctan x$ is already handled in |fp_log_inner|.

@<FL internal codes@>=
procedure fp_arc_tri(@!a: pointer; @!w: integer;@!p,@!y: pointer); { {\bf INCPREC} }
  { 1: $\arcsin |a|$,  2: $\arccos |a|$,  3: $\arctan |a|$ }
label done,exit;
var @!z,@!q,@!r,@!b,@!tmp: pointer;
@!i,@!n,@!f: integer;
begin@/
  n:=fp_length(a);@/
  b:=y; r:=y+n+8; z:=y+2*n+16; q:=y+3*n+24;
  @<FL handle invalid argument and prepare |b| in |fp_arc_tri|@>; @/
  @<FL reduce |b| such that $|b|\in[0,\sqrt 2-1]$ in |fp_arc_tri|@>; @/
  fp_log_inner(b,true,r,z);@/
  @<FL unreduce |p| in |fp_arc_tri|@>;
exit: end;

@ @<FL handle invalid argument and prepare |b| in |fp_arc_tri|@>=
  fp_sign(z):=0; fp_length(z):=n+5; @/
  for i:=1 to n+5 do mem[z+i].int:=0; @/
  mem[z+n+6].int:=100; mem[z+n+7].int:=0; { |z| is 1 }@/
  fp_adjust_length_ncr(a,n+5,b); fp_sign(b):=0;@/
  if fp_sign(a)=2 then begin 
    fp_arith_error:=2; fp_copy(b,p); fp_sign(p):=2; return; 
    @+end
  else if mem[a+n+1].int=0 then @<FL handle $|a|=0$ in |fp_arc_tri|@>;
  if w<>3 then begin
    i:=fp_test_rel(b,z);
    if i=3 then 
      begin fp_arith_error:=2; fp_copy(b,p); fp_sign(p):=2;return;@+end
    else if i=2 then @<FL handle $|a|=\pm 1$ in |fp_arc_tri|@>;
    fp_square(b,q); fp_add_or_sub(z,q,1,p); fp_sqrt(p,q,y+4*n+32);@/
    fp_div(b,q,r); tmp:=b; b:=r; r:=tmp; 
    end
  else if fp_exp(a)=32768 then begin 
    fp_adjust_length_ncr(fp_pi_location,n+5,q); fp_short_div(q,2,p);@/
    fp_sign(p):=fp_sign(a); return;
    end;

@ @<FL handle $|a|=0$ in |fp_arc_tri|@>=
    begin 
    if w=2 then begin 
      fp_adjust_length_ncr(fp_pi_location,n+5,q); fp_short_div(q,2,p);@+
      end
    else begin 
      fp_sign(p):=0; fp_length(p):=n+5; 
      for i:=1 to n+7 do mem[p+i].int:=0;
      end;
    return;@+
    end

@ @<FL handle $|a|=\pm 1$ in |fp_arc_tri|@>=
    begin 
    if w=1 then begin
      fp_adjust_length_ncr(fp_pi_location,n+5,q);@/
      fp_short_div(q,2,p); fp_sign(p):=fp_sign(a); 
      end
    else if fp_sign(a)=0 then begin
      for i:=1 to n+7 do mem[p+i].int:=0;
      fp_sign(p):=0; fp_length(p):=n+5; 
      end
    else fp_adjust_length_ncr(fp_pi_location,n+5,p);
    return;
    end

@ We use $\arctan x=\pi/2 - \arctan x^{-1}$, $\arctan x=\pi/4 - \arctan
((1-x)/(1+x))$ to reduce |b|.

@<FL reduce |b| such that $|b|\in[0,\sqrt 2-1]$ in |fp_arc_tri|@>=
  f:=0;@/ 
  if fp_test_rel(b,z)=3 then { ensure $|b|\le 1$ } begin 
    f:=2; fp_div(z,b,p); fp_copy(p,b); @+end;
  mem[z+n+6].int:=200; fp_sqrt(z,p,y+4*n+32); mem[z+n+6].int:=100;
  fp_add_or_sub(p,z,1,q); 
  if fp_test_rel(b,q)=3 then { ensure $|b|\le \sqrt 2 - 1$ } begin 
    fp_add_or_sub(z,b,1,p); fp_add_or_sub(z,b,0,r);@/
    fp_div(p,r,b); f:=f+1;
    end;

@ @<FL unreduce |p| in |fp_arc_tri|@>=
  if f=2 then begin 
    fp_adjust_length_ncr(fp_pi_location,n+5,b);@/
     fp_short_div(b,2,q); fp_add_or_sub(q,r,1,p);end
  else if f<>0 then begin 
    fp_adjust_length_ncr(fp_pi_location,n+5,b);@/
     fp_short_div(b,4,q); fp_add_or_sub(q,r,(3-f) div 2,p);end
  else fp_copy(r,p);
  fp_sign(p):=fp_sign(a);
  if w=2 then begin
    fp_adjust_length_ncr(fp_pi_location,n+5,r); fp_short_div(r,2,q);@/
    fp_add_or_sub(q,p,1,r); fp_copy(r,p);
    end;

@ To compute $a^b$, since we have $\log x$ and $\exp x$, we can use
formula $a^b=\exp(b\log a)$. However, this method cannot handle when
$a<0$. In this case $b$ must be an integer, because $a^b\notin{\bf R}$
if $a<0\wedge b\notin{\bf Z}$.

@<FL internal codes@>=
procedure fp_pow_int(@!a:pointer;@!m:integer;@!b,@!w:pointer);
var @!p,@!q,@!r,@!tmp: pointer;
@!n,@!l,@!i: integer;
begin
  n:=fp_length(a); p:=w; q:=w+n+8; r:=w+2*n+16;
  if m<0 then l:=-m else l:=m;
  fp_length(p):=n+5; fp_sign(p):=0; mem[p+n+6].int:=100; mem[p+n+7].int:=0; 
  for i:=1 to n+5 do mem[p+i].int:=0;
  fp_adjust_length_ncr(a,n+5,q);
  while l<>0 do begin  
    if odd(l) then begin fp_mul(p,q,r); tmp:=r; r:=p; p:=tmp; end;
    fp_square(q,r); tmp:=r; r:=q; q:=tmp; l:=l div 2;
    end;
  if m<0 then begin
    fp_sign(q):=0; mem[q+n+6].int:=100; mem[q+n+7].int:=0; 
    for i:=1 to n+5 do mem[q+i].int:=0;
    fp_div(q,p,r); fp_adjust_length_ncr(r,n,b);
    end
  else fp_adjust_length_ncr(p,n,b);
end;

@* \[61] Floating point arithmetic, continued. A float is stored in a
glue specification. We regard a glue specification as 96-bit integer
(`the most significant 32bits' is |width| part, and `the least ...' is
|shrink| part). We count bits of this 96 bits from the leftmost bit.

\yskip\textindent{1)}Bits 0--1, 32--33, 64--65 are unused.

\textindent{2)}Bits 2--31, are regarded as base-10 9-digit integer,
bits 33--63, 65--95 are similar.  We name these integers $a$, $b$,
$c$, respectively. When we write $a=|sign_flag_offset|\cdot
a_0+1000a_1+a_2$, when $0\le a_2<1000$, $0\le a_1<65536$, $0\le a_0\le
2$. $a_0$ is sign bit, $a_1$ is the exponent part biased by
|expr_bias|, and $a_2$, $b$, $c$ are the significand.

\textindent{3)}If $|a_0|=2$, this glue specification represents
NaN. If exponent part is 32768 (without bias), this glue specification
represents $\pm\infty$ (sign depends on $a_0$).

\textindent{4)}The significand must be normalized in the following
sense; $a_2$ must be between 100 and 999. 

@ We define {\it all} commands related to floating point operation here.

@<Generate all \eTeX...@>=
primitive("real",last_item,eTeX_expr-int_val+mu_val+3);@/@!@:real_}{\.{\\real} primitive@>
primitive("fpinit",float_init,0);@!@:fpinit_}{\.{\\fpinit} primitive@>
primitive("fpdest",float_dest,0);@!@:fpdest_}{\.{\\fpdest} primitive@>@/
@#
primitive("fpadd",float_arith,1);@!@:fpadd_}{\.{\\fpadd} primitive@>
primitive("fpsub",float_arith,2);@!@:fpsub_}{\.{\\fpsub} primitive@>@/
primitive("fpmul",float_arith,3);@!@:fpmul_}{\.{\\fpmul} primitive@>
primitive("fpdiv",float_arith,4);@!@:fpdiv_}{\.{\\fpdiv} primitive@>@/
primitive("fppow",float_arith,5);@!@:fppow_}{\.{\\fppow} primitive@>
primitive("fppowi",float_arith,201);@!@:fppowi_}{\.{\\fppowi} primitive@>
@#
primitive("fpneg",float_arith,101);@!@:fpneg_}{\.{\\fpneg} primitive@>
primitive("fpsqr",float_arith,102);@!@:fpsqr_}{\.{\\fpsqr} primitive@>
primitive("fpexp",float_arith,103);@!@:fpexp_}{\.{\\fpexp} primitive@>
primitive("fpabs",float_arith,104);@!@:fpabs_}{\.{\\fpabs} primitive@>
primitive("fpceil",float_arith,105);@!@:fpceil_}{\.{\\fpceil} primitive@>
primitive("fpfloor",float_arith,106);@!@:fpfloor_}{\.{\\fpfloor} primitive@>
primitive("fpsin",float_arith,107);@!@:fpsin_}{\.{\\fpsin} primitive@>
primitive("fpcos",float_arith,108);@!@:fpcos_}{\.{\\fpcos} primitive@>
primitive("fptan",float_arith,109);@!@:fptan_}{\.{\\fptan} primitive@>
primitive("fpsinh",float_arith,110);@!@:fpsinh_}{\.{\\fpsinh} primitive@>
primitive("fpcosh",float_arith,111);@!@:fpcosh_}{\.{\\fpcosh} primitive@>
primitive("fptanh",float_arith,112);@!@:fptanh_}{\.{\\fptanh} primitive@>
@#
primitive("fplog",float_arith,113);@!@:fplog_}{\.{\\fplog} primitive@>
primitive("fpasinh",float_arith,114);@!@:fpasinh_}{\.{\\fpasinh} primitive@>
primitive("fpacosh",float_arith,115);@!@:fpacosh_}{\.{\\fpacosh} primitive@>
primitive("fpatanh",float_arith,116);@!@:fpatanh_}{\.{\\fpatanh} primitive@>
primitive("fpasin",float_arith,117);@!@:fpasin_}{\.{\\fpasin} primitive@>
primitive("fpacos",float_arith,118);@!@:fpacos_}{\.{\\fpacos} primitive@>
primitive("fpatan",float_arith,119);@!@:fpatan_}{\.{\\fpatan} primitive@>
@#
primitive("fpfrac",convert,fp_out_frac_code);
@!@:fpfrac_}{\.{\\fpfrac} primitive@>
primitive("fpexpr",convert,fp_out_expr_code);
@!@:fpexpr_}{\.{\\fpexpr} primitive@>@/
primitive("fptoint",last_item,eTeX_expr-int_val+mu_val+6);
@!@:fp_to_inte_}{\.{\\fptoint} primitive@>
primitive("fptodim",last_item,eTeX_expr-int_val+mu_val+7);
@!@:fp_to_dim_}{\.{\\fptodim} primitive@>

@ @<FL process floating point arithmetical commands@>=
begin case m-(eTeX_expr-int_val+mu_val) of
  3: @<FL scan float and pack it into glue specification@>;@/
  6: do_fp_convert_to_int;@/
  7: do_fp_convert_to_dim;@/
  end;@+end

@ @<Assignments@>=
float_arith: do_float_operation(a,cur_chr);

@ @<Cases of |main_control| that don't...@>=
any_mode(float_arith):prefixed_command;
any_mode(float_init):@<FL initialize constants@>;
any_mode(float_dest):@<FL abandon constants@>;

@ @<FL Cases of |last_item| for |print_cmd_chr|@>=
eTeX_expr-int_val+mu_val+3: print_esc("real");
eTeX_expr-int_val+mu_val+6: print_esc("fptoint");
eTeX_expr-int_val+mu_val+7: print_esc("fptodim");

@ @<Cases of |print_cmd_chr|...@>=
float_init: print_esc("fpinit");
float_dest: print_esc("fpdest");
float_arith: case chr_code of
1: print_esc("fpadd");@+
2: print_esc("fpsub");
3: print_esc("fpmul");@+
4: print_esc("fpdiv");
5: print_esc("fppow");@+
201: print_esc("fppowi");
101: print_esc("fpneg");@+
102: print_esc("fpsqr");@+
103: print_esc("fpexp");
104: print_esc("fpabs");@+
105: print_esc("fpceil");@+
106: print_esc("fpfloor");
107: print_esc("fpsin");@+
108: print_esc("fpcos");@+
109: print_esc("fptan");
110: print_esc("fpsinh");@+
111: print_esc("fpcosh");@+
112: print_esc("fptanh");
113: print_esc("fplog");@+
114: print_esc("fpasinh");@+
115: print_esc("fpacosh");
116: print_esc("fpatanh");@+
117: print_esc("fpasin");@+
118: print_esc("fpacos");
119: print_esc("fpatan");
end;

@ Our first goal is \.{\\real} command, which reads representation of
a float and pack it into a glue. You can use this command like
\.{\\real 1.3e2}; and for example, \.{\\real \\skip 32} is treated as
\.{\\skip 32}.

@ To express exponental part in \TeX\
source, One can write like {\tt 1.23e12}. Uppercase `E' is of course
permitted. 

@d exponent_e_token=letter_token+"e" {lowercase `e'} 
@d exponent_E_token=letter_token+"E" {uppercase `E'} 
@d other_exponent_e_token=other_token+"e" {lowercase `e' of type |other_token|} 
@d other_exponent_E_token=other_token+"E" {uppercase `E' of type |other_token|}

@<FL scan float and pack it into glue specification@>=
begin scan_float; m:=cur_val; 
  cur_val:=fp_pack(m); fp_free(m); cur_val_level:=glue_val; 
  end

@ Here we define |scan_float| procedure, which sets |cur_val| to an
array which represents float.
@p
procedure scan_float; 
label done1;
var
@!n: integer; {counter}
@!already_point: boolean; {already found the decimal point?}
@!already_digit: boolean; {already found non-zero digit?}
@!negative: boolean; {should the answer be negated?}
@!OK_so_far:boolean; {has an error message been issued?}
@!q: pointer; {new glue specification}
@!m,@!d: integer;
begin OK_so_far:=true;
@<Get the next non-blank non-sign token...@>;
if (cur_cmd>=min_internal)and(cur_cmd<=max_internal) then begin
  scan_something_internal(glue_val,negative);
  if cur_val_level=glue_val then begin
    decr(glue_ref_count(cur_val)); { decrease reference count }
    @<FL check a glue specification is a valid representaion of a float@>
    end
  else begin
    @<FL convert integer into float@>;
    if cur_val_level=dimen_val then @<FL convert 1$\,$pt into 1.0 @>;
    end;
  end
else begin
 @<FL scan fraction part@>;@/
 @<FL scan exponent part@>; @<FL pack a float@>@;@+ end; 
end;

@ @<FL scan fraction part@>=
 q:=get_node(11);  fp_sign(q):=0;  fp_exp(q):=0; 
 fp_length(q):=8; for n:=2 to 10 do mem[q+n].int:=0; 
 n:=9; m:=100; already_digit:=false; already_point:=false;
 loop@+ begin
 if (cur_tok>=zero_token)and (cur_tok<=zero_token+9) then
   begin 
     d:=cur_tok-zero_token; 
     if (d<>0)or(already_digit) then begin
       already_digit:=true;
       if n>=2 then begin
         mem[q+n].int:=mem[q+n].int+m*d;
         if m=1 then@+begin n:=n-1; m:=100;@+end
         else m:=m div 10;
         if not already_point then fp_exp(q):=fp_exp(q)+1;
         end
       else if not already_point then fp_exp(q):=fp_exp(q)+1; 
       end
     else if already_point=true then fp_exp(q):=fp_exp(q)-1;
   end
 else if (cur_tok=point_token)or(cur_tok=continental_point_token) then 
   already_point:=true
 else goto done1;
   get_x_token;
 end

@ @<FL scan exponent part@>=
done1: {exponent part}
if cur_tok=exponent_E_token then cur_tok:=exponent_e_token
else if cur_tok=other_exponent_E_token then cur_tok:=exponent_e_token
else if cur_tok=other_exponent_e_token then cur_tok:=exponent_e_token;
if cur_tok=exponent_e_token then begin
  scan_int;
  if (cur_val<=-65536) then cur_val:=-32767
  else if (cur_val>=65536) then begin 
    @<FL Overflow error@>; cur_val:=65536; OK_so_far:=false;@+end;
  end
else begin
  if cur_cmd<>spacer then back_input;
  cur_val:=0;
  end;
@<Scan an optional space@>;

@ @<FL pack a float@>=
m:=cur_val+fp_exp(q)-1;
if m>=32768 then begin {too large exponent}
  if OK_so_far then @<FL Overflow error@>; fp_exp(q):=32767;
  if negative then fp_sign(q):=1;
end
else begin
  fp_exp(q):=m;
  if negative then fp_sign(q):=1;
end;
cur_val:=get_node(10); fp_adjust_length_ncr(q,7,cur_val);
free_node(q,11);

@ Following three fragments are for converting integer/dimension to
float (actually, a glue spec.\ which representing a float).  Dimension
is represented by scaled integer in \TeX, so we have only to write
code for integer and code to divide by 65536.
  
@<FL check a glue specification is a valid representaion of a float@>=
begin
if (width(cur_val)<0)or(width(cur_val)>=3*sign_flag_offset)@|
    or(stretch(cur_val)<0)or(stretch(cur_val)>max_nine_digit_int)@|
    or(shrink(cur_val)<0)or(shrink(cur_val)>max_nine_digit_int) then
begin 
print_err("Invalid glue specification for representing float");
@.Invalid glue specification for representing float@>
  help2("This glue spacification doesn't representing float.")@/
    ("So I changed this `result' to NaN.");
  error;
  cur_val:=get_node(10);
  fp_sign(cur_val):=2; fp_exp(cur_val):=0; fp_length(cur_val):=7;
  for m:=2 to 9 do mem[cur_val+m].int:=0;
end
else cur_val:=fp_unpack(cur_val,7);
end

@ @<FL convert integer into  float@>=
begin
m:=cur_val; cur_val:=get_node(10);
fp_sign(cur_val):=0; fp_exp(cur_val):=8; fp_length(cur_val):=7;
if m<0 then begin m:=-m; fp_sign(cur_val):=1-fp_sign(cur_val);@+end;
for d:=2 to 5 do mem[cur_val+d].int:=0;
mem[cur_val+9].int:=m div 1000000000;@/
mem[cur_val+8].int:=(m div 1000000) mod 1000;@/
mem[cur_val+7].int:=(m div 1000) mod 1000;@/
mem[cur_val+6].int:=m mod 1000;@/
fp_adjust_frac(cur_val,false);
end

@ @<FL convert 1$\,$pt into 1.0 @>=
begin
  m:=get_node(10); d:=get_node(10);@/
  fp_length(m):=7; fp_sign(m):=0; fp_exp(m):=4;@/
  mem[m+8].int:=655; mem[m+7].int:=360; mem[m+6].int:=0;@/
  mem[m+5].int:=0; mem[m+4].int:=0; mem[m+3].int:=0; @/
  mem[m+2].int:=0;@/
  fp_div(cur_val,m,d); fp_free(m); free_node(cur_val,10);
  cur_val:=d;
end 

@ Next fragments initialize constants $\pi$, $\log 10$, $\log 64$ and
prepare work area for fundamental operations.

@<Glob...@>=
fp_temp_func_ope: pointer;

@ @<FL initialize constants@>=
begin
  print_nl("Floating operation initialized.");print_nl("");@/
  fp_temp_four_ope:=get_node(80); fp_temp_func_ope:=get_node(184); @/
  @<FL set $\pi$@>;@+@<FL set $\log 10$, $\log 64$ @>;
end

@ @<FL abandon constants@>=
begin
  free_node(fp_temp_four_ope,80); free_node(fp_temp_func_ope,184); @/
  free_node(fp_pi_location,23); free_node(logx,23); free_node(loga,23);
end


@ Next, we deal with operation of floats.

@<Declare subprocedures for |prefixed_command|@>=
procedure do_float_operation(@!a:small_number;@!f:halfword);
label found,exit;
var @!l,@!q,@!r,@!s,@!t,@!gh:pointer; {for list manipulation}
@!e:boolean; {does |l| refer to a sparse array element?}
begin 
@<FL scan first argument, in |do_float_operation|@>;@/
r:=get_node(16); t:=fp_unpack(s,8);
if f<100 then @<FL cases for binary operation, in |do_float_operation|@>@/
else if f>200 then  @/
@<FL cases for binary operation whose operand is a float and an integer@>@/
else @<FL cases for unary operation, in |do_float_operation|@>;
free_node(t,11); cur_val:=fp_pack(r); free_node(r,16);@/
sa_define(l,cur_val)(l,glue_ref,cur_val);
exit: end;

@ @<FL scan first argument, in |do_float_operation|@>=
e:=false; {just in case, will be set |true| for sparse array elements}
get_x_token;
if cur_cmd=assign_glue then begin l:=cur_chr; goto found; end;
if cur_cmd<>register then begin
  print_err("You can't use `"); print_cmd_chr(cur_cmd,cur_chr);
@.You can't use x after ...@>
  print("' after "); print_cmd_chr(q,0);
  help1("I'm forgetting what you said and not changing anything.");
  error; return; end;
if (cur_chr<mem_bot)or(cur_chr>lo_mem_stat_max) then
  begin l:=cur_chr; e:=true; end
else  begin scan_register_num;
  if cur_val>255 then
    begin find_sa_element(glue_val,cur_val,true); l:=cur_ptr; e:=true;
    end
  else l:=cur_val+skip_base;
end;
found: if e then s:=sa_ptr(l)@+else s:=equiv(l);

@ @<FL cases for binary operation, in |do_float_operation|@>=
begin 
  if scan_keyword("by") then do_nothing; {optional `\.{by}'}
  scan_float; q:=get_node(11); @/
  fp_adjust_length_ncr(cur_val,8,q); free_node(cur_val,10);
  case f of
    1,2: fp_add_or_sub(t,q,f-1,r);
    3: fp_mul(t,q,r);
    4: fp_div(t,q,r);
    5: @<FL do power operation@>;
  end; 
  free_node(q,11);
  end

@ @<FL cases for binary operation whose operand is a float and an integer@>=
begin
  if scan_keyword("by") then do_nothing; {optional `\.{by}'}
  scan_int;
  case f of
    201: fp_pow_int(t,cur_val,r,fp_temp_func_ope);
  {there are no other cases}
  end;@+end

@ @<FL cases for unary operation, in |do_float_operation|@>=
case f of
    101: @<FL do negate operation@>;
    102: fp_sqrt(t,r,fp_temp_func_ope);
    103: fp_exponent(t,r,fp_temp_func_ope);
    104: @<FL take absolute value@>;
    105,106: fp_ceil_floor(t,106-f,r);
    107,108,109,110,111,112: fp_tri_hyp(t,f-106,r,fp_temp_func_ope);
    113: fp_log(t,r,fp_temp_func_ope);
    114,115,116: fp_arc_hyp(t,f-113,r,fp_temp_func_ope);
    117,118,119: fp_arc_tri(t,f-116,r,fp_temp_func_ope);
  end

@ @<FL do negate operation@>=
begin 
  fp_copy(t,r); if fp_sign(r)<>2 then fp_sign(r):=1-fp_sign(r);
end

@ @<FL take absolute value@>=
begin 
  fp_copy(t,r); if fp_sign(r)<>2 then fp_sign(r):=0;
end

@ @<FL do power operation@>=
begin 
  f:=fp_arith_error;@/
  fp_log(t,r,fp_temp_func_ope); fp_mul(r,q,t);fp_exponent(t,r,fp_temp_func_ope);@/
  if (f=0)and(fp_arith_error=1) then fp_arith_error:=0;
  end


@ Next two procedures outputs the fraction part and the exponent part
of flost, respectively. We don't support number formatting; since
output of dimension doesn't have this feature, neither. 

@d fp_frac_out_macro(#)== repeat dig[k]:=j mod 10; j:=j div 10; incr(k);@+until k=#;

@p procedure do_fp_out_frac;
label exit;
var @!i,@!k,@!j,@!l,@!m: integer;
begin
  if fp_sign(cur_val)>=2 then@+begin print("NaN"); goto exit;@+end;
  if fp_exp(cur_val)=32768 then@+begin if fp_sign(cur_val)=1 then print("-");
     print("Infinity"); goto exit;@+end;
  k:=0; for m:=1 to 7 do@+begin j:=mem[cur_val+m+1].int; fp_frac_out_macro(3*m);@+end;
  k:=0; 
  while k<=21 do@+if dig[k]<>0 then k:=30+k@+else k:=k+1;
  if k=22 then print("0.0")
  else begin k:=k-30;
    if fp_sign(cur_val)=1 then print("-");
    print_char("0"+dig[20]); 
    print_char("."); if k=20 then print_char("0");
    for i:=19 downto k do print_char("0"+dig[i]);@+end;
  fp_free(cur_val);
exit: end;
@#
procedure do_fp_out_expr;
begin
  print_int(fp_exp(cur_val));  fp_free(cur_val);@+end;

@ The conditional \.{\\iffp} primitive tests relations between two floats.

@d if_fp_code=25 { `\.{\\iffp}' }

@<Generate all \eTeX...@>=
primitive("iffp",if_test,if_fp_code);@/
@!@:if_fp_}{\.{\\iffp} primitive@>

@ This procedure compares two floats. It is used in |fp_exponent|
while reducing arguments in $[0,2]$.

@<FL test relation of two float@>=
function fp_test_rel(@!a,@!b: pointer): small_number;
label exit;
var @!c,@!d: pointer; @!i,@!n: integer;
begin
  if fp_length(a)>fp_length(b) then n:=fp_length(a)
  else n:=fp_length(b);
  @<FL handle |a| or |b| is NaN, $\pm\infty$, 0, in |fp_test_rel|@>
  if fp_sign(a)<>fp_sign(b) then@+begin
    fp_test_rel:=3-2*fp_sign(a); return;@+end
  else if fp_exp(a)>fp_exp(b) then@+begin
    fp_test_rel:=3-2*fp_sign(a); return;@+end
  else if fp_exp(a)<fp_exp(b) then@+begin
    fp_test_rel:=1+2*fp_sign(a); return;@+end;
  c:=fp_temp_four_ope; d:=fp_temp_four_ope+n+3;@/
  fp_adjust_length_ncr(a,n,c); fp_adjust_length_ncr(b,n,d);@/
  fp_test_rel:=2;
  for i:=n+1 downto 2 do begin
    if mem[c+i].int>mem[d+i].int then begin
      fp_test_rel:=3-2*fp_sign(a); return;@+end
    else if mem[c+i].int<mem[d+i].int then begin
      fp_test_rel:=1+2*fp_sign(a); return;@+end;
    end;
exit: end;

@ @<FL handle |a| or |b| is NaN, $\pm\infty$, 0, in |fp_test_rel|@>=
  if fp_exp(a)=32768 then mem[a+fp_length(a)+1].int:=100;
  if fp_exp(b)=32768 then mem[b+fp_length(b)+1].int:=100;
  if (fp_sign(a)=2)or(fp_sign(b)=2) then@+begin
    fp_test_rel:=0; return;@+end
  else if mem[a+fp_length(a)+1].int=0 then begin
    if mem[b+fp_length(b)+1].int=0 then fp_test_rel:=2
    else if fp_sign(b)=0 then fp_test_rel:=1
    else fp_test_rel:=3;
    return;
    end
  else if mem[b+fp_length(b)+1].int=0 then begin
    if fp_sign(a)=0 then fp_test_rel:=3@+
    else fp_test_rel:=1;
    return;
    end
  else 

@ @<Cases of |if_test| for |print_cmd_chr|@>=
if_fp_code:print_esc("iffp");

@ @<Cases for |conditional|@>=
if_fp_code: begin scan_float;
n:=cur_val; @<Get the next non-blank non-call...@>;
if (cur_tok>=other_token+"<")and(cur_tok<=other_token+">") then@/
  r:=cur_tok-other_token
else  begin print_err("Missing = inserted for ");
@.Missing = inserted@>
  print_cmd_chr(if_test,this_if);@/
  help1("I was expecting to see `<', `=', or `>'. Didn't.");
  back_error; r:="=";@+ end;
  scan_float; p:=fp_test_rel(n,cur_val); 
  fp_free(n); fp_free(cur_val); 
  case r of
    "<": b:=(p=1);@+
    "=": b:=(p=2);@+
    ">": b:=(p=3);
    end;@+
end;

@ Last things we have to define are convert a float to an integer
or an dimension.  Of course, an float `1.0' is regard as an integer
`1', or a dimension `1.0$\,$pt'.  If absolute value of an float is too
large for an integer/a dimension, Over flow error is occured.  On the
other hand, If absolute value of an float is too small, the float is
converted to zero.

@p procedure do_fp_convert_to_int; {round down}
var @!p: pointer;
begin
  scan_float; p:=cur_val;
  if fp_exp(p)>=10 then{ overflow } begin 
    print_err("Number too big");@/
@.Number too big@>
    help2("I can only go up to 2147483647='17777777777=""7FFFFFFF,")@/
      ("so I'm using that number instead of yours.");
    error; cur_val:=infinity; if fp_sign(p)=1 then cur_val:=-cur_val;
    end
  else if fp_sign(p)=2 then { NaN }
  begin  print_err("This float is not a number");@/
@.This float is not a number@>
    help2("This float is NaN (Not A Number),")@/
      ("so I changed`result' to zero.");
    error; cur_val:=0;
    end
  else begin
    fp_adjust_exp_part(p,9);
    cur_val:=mem[p+8].int*1000000+mem[p+7].int*1000+mem[p+6].int;
    if (cur_val>214748364)or((cur_val=214748364)and@|
      ((mem[p+5].int div 100)>=8)) then begin
      print_err("Number too big");
@.Number too big@>
      help2("I can only go up to 2147483647='17777777777=""7FFFFFFF,")@/
        ("so I'm using that number instead of yours.");
      error; cur_val:=infinity; 
      end
    else cur_val:=cur_val*10+mem[p+5].int div 100;
    if fp_sign(p)=1 then cur_val:=-cur_val;
  end;
  fp_free(p); cur_val_level:=int_val; 
end;


@ Procedure |do_fp_convert_to_dim| is similar to above code. 
@p procedure do_fp_convert_to_dim; {round down}
label exit;
var @!p,@!q: pointer;
begin
  scan_float; p:=cur_val; 
  if(fp_exp(p)>=14) then { overflow, before converting } begin 
    @<Report that this dimension is out of range@>;
    if fp_sign(p)=1 then cur_val:=-cur_val;
    goto exit;
    end;
  q:=get_node(10); fp_length(q):=7; fp_sign(q):=0; fp_exp(q):=4;{ |q| will be $2^{16}$ }@/
  mem[q+8].int:=655; mem[q+7].int:=360;mem[q+6].int:=0;@/
  mem[q+5].int:=0;mem[q+4].int:=0; mem[q+3].int:=0; mem[q+2].int:=0;@/ 
  cur_val:=get_node(10); fp_mul(p,q,cur_val); fp_free(p); fp_free(q); p:=cur_val;
  if fp_exp(p)>=10 then{ overflow } begin 
    @<Report that this dimension is out of range@>;
    if fp_sign(p)=1 then cur_val:=-cur_val;
    end
  else if fp_sign(p)=2 then begin { Not a Number }
    print_err("This float is not a number");@/
@.This float is not a number@>
    help2("This float is NaN (Not A Number),")@/
      ("so I changed`result' to zero.");
    error; cur_val:=0;
    end
  else begin
    fp_adjust_exp_part(p,9); 
    cur_val:=mem[p+8].int*1000000+mem[p+7].int*1000+mem[p+6].int;
    if (cur_val>107374182)or((cur_val=107374182)@|
      and((mem[p+5].int div 100)>=4)) then begin
      @<Report that this dimension is out of range@>
      end
    else cur_val:=cur_val*10+mem[p+5].int div 100;
    if fp_sign(p)=1 then cur_val:=-cur_val;
  end;
  fp_free(p); cur_val_level:=dimen_val;
exit: end;

@* \[62] Index.
@z
