#!/bin/bash
# Build Step 3 - install binary and setting fonts

. ./option

if [[ ${EUID} != 0 ]] ; then
  echo 
  echo "This script may not run correctly because you are not root."
  echo "Press Return to continue, Ctrl+C to abort."
  read -r &>/dev/null
fi

echo "[copy  ] some CMap from ptexlive"
cp -r $CMP_TEMP/ptexlive-*/cmap/* $TL/texmf/fonts/cmap/
echo "[remove] \$TEXMFVAR/web2c/fmtutil.cnf"
rm $TL/texmf-var/web2c/fmtutil.cnf
echo "[remove] \$TEXMF/ptex/platex/config/hyphen.cfg"
rm $CMP_TEMP/texlive-*-source/inst/texmf/ptex/platex/config/hyphen.cfg
echo "[copy  ] binary to \$TL/"
cp -r $CMP_TEMP/texlive-*-source/inst/* $TL/

ARCH=`ls $CMP_TEMP/texlive-20080816-source/inst/bin`
echo "[exec  ] mktexlsr"
PATH="$TL/bin/$ARCH:$PATH" mktexlsr &>/dev/null
echo "[exec  ] regenerating formats"
PATH="$TL/bin/$ARCH:$PATH" fmtutil-sys --all &>/dev/null
echo "[copy  ] updmap"
cp $SRC/updmap-tl08 $TL/bin/$ARCH/updmap

echo 
echo "*** Font setting ***"

otffnt () {
  echo 
  echo "A. Fonts for utf/otf packages"
  echo "    1: Morisawa OTF         2: Hiragino OTF"
  echo "    3: IPA fonts            4: Kozuka   OTF"
  echo "    5: Do not embed fonts"
  echo "  This choice also affects xdvi fonts."
  echo -n "  Choose 1--5 >> "
  read OTF
  case $OTF in
  1)
     PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-morisawa.map &>/dev/null
     ;;
  2)
     PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-hiragino.map &>/dev/null
     ;;
  3)
     PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-ipa.map &>/dev/null
     ;;
  4)
     PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-kozuka.map &>/dev/null
     ;;
  5)
     PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-noEmbed.map &>/dev/null
     ;;
  *)
     echo " Please choose between 1 and 5."
     otffnt
     ;;
esac
}
PATH="$TL/bin/$ARCH:$PATH" updmap-sys  --nomkmap --enable KanjiMap otf-cktx.map &>/dev/null

otffnt

cat <<EOF > $CMP_TEMP/xdvi-ja.map
rml        JIS-H        @min
rmlv       JIS-V        @min
gbm        JIS-H        @goth
gbmv       JIS-V        @goth

fmin       JIS-H        @fmin
fgoth      JIS-H        @fgoth
maru       JIS-H        @maru

% UTF package
unijmin-h  Unicode-H    @min       % \UTF font
unijmin-v  Unicode-V    @min       % \UTF font
cidmin-h   Identity-H   @min       % \CID font
cidmin-v   Identity-V   @min       % \CID font
hmr        JIS-H        @min
hmrv       JIS-V        @min

unijgoth-h  Unicode-H   @goth      % \UTF font
unijgoth-v  Unicode-V   @goth      % \UTF font
cidgoth-h   Identity-H  @goth      % \CID font
cidgoth-v   Identity-V  @goth      % \CID font
hkb         JIS-H       @goth
hkbv        JIS-V       @goth

% OTF package
otf-ujmr-h  Unicode-H   @min
otf-ujmr-v  Unicode-V   @min
otf-cjmr-h  Identity-H  @min
otf-cjmr-v  Identity-V  @min
hminr-h     JIS-H       @min
hminr-v     JIS-V       @min

otf-ujgr-h  Unicode-H   @ugoth
otf-ujgr-v  Unicode-V   @ugoth
otf-cjgr-h  Identity-H  @ugoth
otf-cjgr-v  Identity-V  @ugoth
hgothr-h    JIS-H       @ugoth
hgothr-v    JIS-V       @ugoth

otf-ujmb-h  Unicode-H   @fmin
otf-ujmb-v  Unicode-V   @fmin
otf-cjmb-h  Identity-H  @fmin
otf-cjmb-v  Identity-V  @fmin
hminb-h     JIS-H       @fmin
hminb-v     JIS-V       @fmin

otf-ujgb-h  Unicode-H   @fgoth
otf-ujgb-v  Unicode-V   @fgoth
otf-cjgb-h  Identity-H  @fgoth
otf-cjgb-v  Identity-V  @fgoth
hgothb-h    JIS-H       @fgoth
hgothb-v    JIS-V       @fgoth

otf-ujmgr-h  Unicode-H  @maru
otf-ujmgr-v  Unicode-V  @maru
otf-cjmgr-h  Identity-H @maru
otf-cjmgr-v  Identity-V @maru
hmgothr-h    JIS-H      @maru
hmgothr-v    JIS-V      @maru

% upTeX
urml            Unicode-H       @min
urmlv           Unicode-V       @min
ugbm            Unicode-H       @goth
ugbmv           Unicode-V       @goth

uprml-h         Unicode-H       @min
uprml-v         Unicode-V       @min
upgbm-h         Unicode-H       @goth
upgbm-v         Unicode-V       @goth
uprml-hq        Unicode-H       @min
upgbm-hq        Unicode-H       @goth

uphminr-h       Unicode-H       @min
uphminr-v       Unicode-V       @min
uphminb-h       Unicode-H       @fmin
uphminb-v       Unicode-V       @fmin
uphgothr-h      Unicode-H       @goth
uphgothr-v      Unicode-V       @goth
uphgothb-h      Unicode-H       @fgoth
uphgothb-v      Unicode-V       @fgoth
uphmgothr-h     Unicode-H       @maru
uphmgothr-v     Unicode-V       @maru
EOF
mkdir -p $TL/texmf/fonts/map/xdvi/
xdvijp () {
    echo
    echo "B. Fonts for japanese xdvi fonts"
    if [ "$OTF" == "5" ] ; then
      echo "    1: Morisawa OTF         2: Hiragino OTF"
      echo "    3: IPA fonts            4: Kozuka   OTF"
      echo "  This choice also affects xdvi fonts."
      echo -n "  Choose 1--4 >> "
      read OTF
    else
      echo "  Use same setting as utf/otf packages."
    fi
    case $OTF in
	1)
	    cat $CMP_TEMP/xdvi-ja.map | \
		sed "s/@min/A-OTF-RyuminPro-Light.otf/;
                     s/@goth/A-OTF-GothicBBBPro-Medium.otf/;
                     s/@ugoth/A-OTF-GothicBBBPro-Medium.otf/;
                     s/@fmin/A-OTF-FutoMinA101Pro-Bold.otf/;
                     s/@fgoth/A-OTF-FutoGoB101Pro-Bold.otf/;
                     s/@maru/A-OTF-Jun101Pro-Light.otf/" \
		 > $TL/texmf/fonts/map/xdvi/xdvi-ptex.map
	    ;;
	2)
	    cat $CMP_TEMP/xdvi-ja.map | \
		sed "s/@min/HiraMinPro-W3.otf/;
                     s/@goth/HiraKakuPro-W6.otf/;
                     s/@ugoth/HiraKakuPro-W3.otf/;
                     s/@fmin/HiraMinPro-W6.otf/;
                     s/@fgoth/HiraKakuPro-W6.otf/;
                     s/@maru/HiraMaruPro-W4.otf/" \
		 > $TL/texmf/fonts/map/xdvi/xdvi-ptex.map
	    ;;
	3)
	    cat $CMP_TEMP/xdvi-ja.map | \
		sed "s/@min/ipam.ttf/;
                     s/@goth/ipag.ttf/;
                     s/@ugoth/ipag.ttf/;
                     s/@fmin/ipam.ttf,Bold/;
                     s/@fgoth/ipag.ttf,Bold/;
                     s/@maru/ipag.ttf,BoldItalic/" \
		 > $TL/texmf/fonts/map/xdvi/xdvi-ptex.map
	    ;;
	4)
	    cat $CMP_TEMP/xdvi-ja.map | \
		sed "s/@min/KozMinPro-Regular-Acro.otf/;
                     s/@goth/KozGoStd-Regular.otf/;
                     s/@ugoth/KozGoStd-Regular.otf/;
                     s/@fmin/KozMinStd-Bold.otf/;
                     s/@fgoth/KozGoStd-Bold.otf/;
                     s/@maru/KozGoStd-Heavy.otf/" \
		 > $TL/texmf/fonts/map/xdvi/xdvi-ptex.map
	    ;;
	*)
	    echo " Please choose between 1 and 4."
	    OTF=5
	    xdvijp
	    ;;
    esac
}

xdvijp

echo
echo "C. Fonts for chinese/korean xdvi fonts"
echo "  Using default xdvi settings."
cat <<EOF >> $TL/texmf/fonts/map/xdvi/xdvi-ptex.map
%% upTeX Chinese & Korean
upstsl-h        Unicode-H       gbsn00lp.ttf
upstsl-v        Unicode-V       gbsn00lp.ttf
upstht-h        Unicode-H       gkai00mp.ttf
upstht-v        Unicode-V       gkai00mp.ttf
upmsl-h         Unicode-H       bsmi00lp.ttf
upmsl-v         Unicode-V       bsmi00lp.ttf
upmhm-h         Unicode-H       bkai00mp.ttf
upmhm-v         Unicode-V       bkai00mp.ttf
uphysmjm-h      Unicode-H       UnBatang.ttf
uphysmjm-v      Unicode-V       UnBatang.ttf
uphygt-h        Unicode-H       UnDotum.ttf
uphygt-v        Unicode-V       UnDotum.ttf

%% traditional Chinese
% Arphic (http://www.ring.gr.jp/pub/GNU/non-gnu/chinese-fonts-truetype/)
ootf-utmr-h  Unicode-H   bsmi00lp.ttf
otf-utmr-v  Unicode-V   bsmi00lp.ttf

otf-utgr-h  Unicode-H   bkai00mp.ttf
otf-utgr-v  Unicode-V   bkai00mp.ttf

%% simplified Chinese
% Arphic (http://www.ring.gr.jp/pub/GNU/non-gnu/chinese-fonts-truetype/)
otf-ucmr-h  Unicode-H   gbsn00lp.ttf
otf-ucmr-v  Unicode-V   gbsn00lp.ttf

otf-ucgr-h  Unicode-H   gkai00mp.ttf
otf-ucgr-v  Unicode-V   gkai00mp.ttf

%% Korean
% un-fonts (http://kldp.net/projects/unfonts/)
otf-ukmr-h  Unicode-H   UnBatang.ttf
otf-ukmr-v  Unicode-V   UnBatang.ttf

otf-ukgr-h  Unicode-H   UnDotum.ttf
otf-ukgr-v  Unicode-V   UnDotum.ttf

EOF

echo "*** Finalizing..."
echo "p +jis.map" >>  $TL/texmf/dvips/config/config.ps
echo "p +morisawa.map" >>  $TL/texmf/dvips/config/config.ps
cp $SRC/updmap-tl08 $TL/bin/$ARCH/updmap
echo "f kanjix.map" >> $TL/texmf/dvipdfmx/dvipdfmx.cfg
mkdir -p $TL/texmf/fonts/truetype/
mkdir -p $TL/texmf/fonts/opentype/

echo "[exec  ] updmap-sys"
PATH="$TL/bin/$ARCH:$PATH" updmap-sys &>/dev/null

echo "[clean ] Cleaning $CMP_TEMP..."
cd $CMP_TEMP
rm -rf ptexlive-* texlive-*-source uptex-* xdvi-ja.map up-tl08.patch uptex-base-tmp.patch

cat <<EOF

****************
TeX Live 2008 + (pTeX etc.) is compiled.

However, before using TeX Live you must do:

A. Setting PATH.
  (sh/bash user):  export PATH=$TL/bin/$ARCH:\$PATH
  (csh/tcsh user): setenv PATH $TL/bin/$ARCH:\$PATH
B. Symbolic link TTF/OTF/CMap files
  example (maybe these directories don't exist):
    # ln -s /opt/Adobe/Reader8/Resource/CMap/ $TL/texmf/fonts/cmap/acro
    # ln -s /opt/Adobe/Reader8/Resource/CIDFont/ $TL/texmf/fonts/truetype/acro
    # ln -s /opt/Adobe/Reader8/Resource/CIDFont/ $TL/texmf/fonts/opentype/acro
    # ln -s /usr/share/fonts/ $TL/texmf/fonts/truetype/x11ttf
    # ln -s /usr/share/fonts/ $TL/texmf/fonts/opentype/x11otf
C: (OPTIONAL) Download chinese/korean Truetype font for xdvi
  For example, locale these files in $TL/texmf/fonts/truetype/ck
  * traditional Chinese => bsmi00lp.ttf, bkai00mp.ttf (Arphic)
  * simplified Chinese  => gbsn00lp.ttf, gkai00mp.ttf (Arphic)
  * korean              => UnBatang.ttf, UnDotum.ttf  (un-fonts)
C. Rerun mktexlsr
    # mktexlsr

****************
EOF
