#!/bin/bash
# Build Step 1 - extracting / patching source file and build

cd ../ptexlive-*
. common.sh
cd ../ptl08-compile
. ./option

### ptexlive
PTEXLIVE_VER=`ls  $ESRC/ptexlive-*.tar.gz|sed "s/.*ptexlive-//;s/.tar.gz//"`

cd $ESRC

UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
echo ">>> Version of upTeX: $UPTEX_VER"
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
echo ">>> Version of e-pTeX: $EPTEX_VER"
PTEXENC_VER=`ls  $ESRC/ptexlive-$PTEXLIVE_VER/archive/ptexenc-*.tar.lzma|\
             sed "s/.*ptexenc-//;s/.tar.lzma//"`
echo ">>> Version of ptexenc: $PTEXENC_VER"

echo "[unpack] uptex-*.tar.gz"
tarx $ESRC/uptex-*.tar.gz $SRC/../
echo "[unpack] eptex-*.tar.gz"
tarx $ESRC/eptex-*.tar.bz2 $SRC/texk/web2c/

cd $SRC/texk/

# ptexenc-1.0.3 removed "ENC_UPTEX" etc. 
if test `echo $PTEXENC_VER|sed s/\\\.//g` -gt 102 ; then
  echo "ptexenc's version >= 1.0.3."
  echo "[patch ] ptexenc-1.0.3-enc_uptex.diff"
  cd ptexenc
  patch -p1 < $ESRC/ptl08-compile/ptexenc-1.0.3-enc_uptex.diff || exit 1
  cd ..
else
  echo "ptexenc's version <= 1.0.2."
fi


# patch for e-pTeX
echo "[copy  ] ptexdir -> eptexdir"
cp -r web2c/ptexdir web2c/eptexdir
cp -r web2c/eptex-*/* web2c/eptexdir/ 
cd ..
echo "[patch ] ep-tl08.patch"
cat $ESRC/ptl08-compile/ep-ptl08.patch | sed "s/PATCH/$PATCH/" > ep-ptl08.patch
$PATCH -p1 < ep-ptl08.patch || exit 1
$RM -f ep-ptl08.patch

# patch for upTeX
cd texk
mv dvipsk dvipsk-orig
mv pdvipsk dvipsk
mv xdvik xdvik-orig
mv pxdvik xdvik
cd web2c/
echo "[copy  ] ptexdir -> uptexdir"
cp -r ptexdir/ uptexdir
cd uptexdir
mv ptex-base.ch uptex-base.ch
mv ptftopl.ch uptftopl.ch
mv ppltotf.ch uppltotf.ch
mv pdvitype.ch updvitype.ch
mv pbibtex.ch  upjbibtex.ch
cd ../../../
echo "[copy  ] upovp2ovf"
cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web 
cp texk/web2c/omegaware/ovp2ovf.ch texk/web2c/omegaware/upovp2ovf.ch 
echo "[patch ] uptex_src-*.patch"
cat $SRC/../uptex-*/patch/ptetex3-*_uptex_src-*.patch \
  |sed "s/3.141592/3.1415926/" > $SRC/../uptex-base-tmp.patch
$PATCH -p2 -f < $SRC/../uptex-base-tmp.patch &>/dev/null

# patch for qa53556
if [ $UPTEX_VER = "u0.27" ] ; then
  echo "[patch ] uptex-0.27-qa53556.diff"
  cd texk/web2c/
  patch -p1 < $ESRC/ptl08-compile/uptex-0.27-qa53556.diff || exit 1
  cd ../..
fi

cd texk/web2c/
echo "[copy  ] uptexdir -> euptexdir"
cp -r uptexdir/ euptexdir
cd euptexdir/      
cat ../eptexdir/etex.diff | sed "s/, Version 3.141592/, Version 3.1415926/" > etex.diff
cd ../../..
echo "[patch ] up-ptl08.patch"
cat $ESRC/ptl08-compile/up-ptl08.patch \
  | sed "s/UPTEXVER/$UPTEX_VER/;s/PTENCVAR/$PTEXENC_VER/;s/EPTEXVER/$EPTEX_VER/" \
  | sed "s/PATCH/$PATCH/" > $SRC/../up-ptl08.patch 
$PATCH -p1 <$SRC/../up-ptl08.patch  || exit 1
cd texk/ptexenc
echo "[patch ] uptex_ptexenc-1.0.4.patch"
$PATCH -p1 < $ESRC/ptl08-compile/uptex_ptexenc-1.0.4.patch || exit 1
cd ../
mv dvipsk pdvipsk
mv dvipsk-orig dvipsk
mv xdvik pxdvik
mv xdvik-orig xdvik
cd ../

echo "[patch ] texmfmem.h           (for e-pTeX)"
cat texk/web2c/texmfmem.h \
  | sed "s/\!defined(Aleph)/\!defined(Aleph)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" \
  > texk/web2c/texmfmem2.h
mv texk/web2c/texmfmem.h texk/web2c/texmfmem.h.orig
cp -f  texk/web2c/texmfmem2.h texk/web2c/texmfmem.h

# patch for FAM256 
if test "$FAM256" = "1"; then
  echo "[patch ] eptexdir/kanji.h etc (for FAM256 patch)"
cat <<EOF >> texk/web2c/eptexdir/kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> texk/web2c/eptexdir/eptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
cat <<EOF >> texk/web2c/euptexdir/kanji.h
#define getintone(w) (w).cint1
#define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> texk/web2c/euptexdir/euptex.defines
  @define function getintone( );
  @define procedure setintone( );
EOF
fi

# BUILD
cd $ESRC/ptexlive-*
make stage3


# FAM256 
if test "$FAM256" = "1"; then
  echo "*** Make FAM256 enabled binaries of e-pTeX and e-upTeX ***"
  echo "         Return key to continue, or Ctrl+C to abort"
  read
  cd $SRC/Work/texk/web2c

echo "[update] Banner of e-pTeX and e-upTeX"
  sed s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version`_FAM256-PATCHED/ \
     ../../../texk/web2c/eptexdir/ptexextra.in >eptexdir/eptexextra.h
  cat ../../../texk/web2c/euptexdir/ptexextra.in \
         | sed s/PTEX-VERSION/`cat ptexdir/ptex.version`/ \
         | sed s/UPTEX-VERSION/`cat uptexdir/uptex.version`/ \
         | sed "s/EPTEX-VERSION/`cat eptexdir/eptex.version`_FAM256-PATCHED/" \
         >euptexdir/euptexextra.h

echo "[patch ] Applying FAM256 patch to e-pTeX"
  cp eptex.web eptex.web.orig
  ./tie -m eptex.web eptex.web.orig ../../../texk/web2c/eptexdir/fam256.ch || exit 1

echo "[patch ] Applying FAM256 patch to e-upTeX"
  cp euptex.web euptex.web.orig
  cat <<EOF > fam256.diff
--- fam256.ch.orig      2009-03-04 23:26:27.000000000 +0900
+++ fam256.ch   2009-03-05 09:45:26.062449559 +0900
@@ -267,9 +267,9 @@
 @z
 %-----------------------------------------------
 @x
-char_given,math_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given: scanned_result(cur_chr)(int_val);
 @y
-char_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
 @z
 %-----------------------------------------------
 @x
@@ -1079,6 +1079,7 @@
 @d mu_skip_def_code=5 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=6 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=7 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=8 {|shorthand_def| for \.{\\\\kchardef}}
 @y
 @d omath_char_def_code=2 {|shorthand_def| for \.{\\\\omathchardef}}
 @d count_def_code=3 {|shorthand_def| for \.{\\\\countdef}}
@@ -1087,6 +1088,7 @@
 @d mu_skip_def_code=6 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=7 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=8 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=9 {|shorthand_def| for \.{\\\\kchardef}}
 @z
 %-----------------------------------------------
 @x
EOF
  cp ../../../texk/web2c/eptexdir/fam256.ch fam256.ch
  $PATCH -p0 < fam256.diff || exit 1
  ./tie -m euptex.web euptex.web.orig fam256.ch  || exit 1

echo "[build ] eptex"
  rm eptex.p eptex.pool eptexextra.o 
  $MAKE eptex || exit 1

echo "[build ] euptex"
  rm euptex.p euptex.pool euptexextra.o 
  $MAKE euptex || exit 1

echo "[copy  ] e-pTeX / e-upTeX binary to inst/bin/"
  ARCH=`ls $SRC/inst/bin`
  cp eptex ../../../inst/bin/$ARCH/
  cp euptex ../../../inst/bin/$ARCH/
fi

echo "------------------------"
ARCH=`ls $SRC/inst/bin`
$SRC/inst/bin/$ARCH/eptex -version  |head -1
$SRC/inst/bin/$ARCH/euptex -version |head -1


#This script ends here.
$RM -f $SRC/../up-ptl08.patch $SRC/../uptex-base-tmp.patch
exit 0


# DEBUG: Making ptl08-compile-*.tar.lzma
cd $ESRC
rm -f ptl08-compile/*~
tar --lzma -cvf ptl08-compile-`date +%y%m%d`.tar.lzma ptl08-compile/
