#!/bin/bash
# Build Step 2 - extract [u]ptex-texmf and macros

cd ../ptexlive-*
. common.sh
cd ../ptl08-compile
. ./option

pushd $ESRC
UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
echo ">>> Version of upTeX: $UPTEX_VER"
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
echo ">>> Version of e-pTeX: $EPTEX_VER"
cd ptexlive-????????
make stage4 || exit
popd

echo "[unpack] uptex_font-*.tar.gz"
tarx $ESRC/uptex_font-*.tar.gz $TEXMF || exit
$RM -r $TEXMF/fonts/*uptex* || exit
echo "[patch ] ptetex3-*_uptex_texmf-*.patch"
mv $TEXMF/fonts/map/dvipdfm/ptexlive/ptex-*.map $TEXMF/fonts/map/dvipdfm/
mv $TEXMF/fonts/map/dvipdfm/ptex-ipa-ttf.map $TEXMF/fonts/map/dvipdfm/ptex-ipa.map
zpatch $SRC/../uptex-*/patch/ptetex3-*_uptex_texmf-*.patch 3 $TEXMF
mv $TEXMF/fonts/map/dvipdfm/ptex-ipa.map $TEXMF/fonts/map/dvipdfm/ptex-ipa-ttf.map
cat $TEXMF/fonts/map/dvipdfm/ptex-ipa-ttf.map|sed s/ttf/otf/ > $TEXMF/fonts/map/dvipdfm/ptex-ipa-otf.map
mv $TEXMF/fonts/map/dvipdfm/ptex-*.map $TEXMF/fonts/map/dvipdfm/ptexlive/

echo "[copy  ] eptex.src, euptex.src, eptexdefs.lib"
cp $SRC/texk/web2c/eptex-*/*.src $TEXMF/ptex/plain/base/
cp $SRC/texk/web2c/eptex-*/eptexdefs.lib $TEXMF/ptex/plain/base/

cp 5macro_euptex.sh ../ptexlive-*/
pushd ../ptexlive-*
./5macro_euptex.sh clean default utf 2>&1 | tee log-$DATE
zpatch $SRC/../uptex-0.27/patch/utfsrc*uptex*.patch 1 $TEXMF/packages/utfsrc
./5macro_euptex.sh otf 2>&1 | tee -a log-$DATE
popd

$RM -f $SRC/uptex-0.27 