#!/bin/bash

. ./common.sh
. ../tl07-compile/option
cp -f ../tl07-compile/5macro_uptex.sh .

if test -f $SRC/uptex-*.tar.gz; then
  DATE=`date +%m%d-%H%M`
  ./5macro_uptex.sh clean default utf 2>&1 | tee log-$DATE
  if test -f $TEXMF/xdvi/xdvi.cfg ; then
    if test "$JAPANESE" = "international"; then
    mv $TEXMF/xdvi/xdvi.cfg $TEXMF/xdvi/xdvi.cfg.orig
    cp -f  $TEXMF/xdvi/pxdvi.cfg $TEXMF/xdvi/xdvi.cfg
    fi
    cpatch $TMP_PREFIX/uptex-*/patch/xdvi_cfg*uptex*.patch 1 $TEXMF/xdvi
    if test "$JAPANESE" = "international"; then
    mv $TEXMF/xdvi/xdvi.cfg $TEXMF/xdvi/pxdvi.cfg
    mv $TEXMF/xdvi/xdvi.cfg.orig $TEXMF/xdvi/xdvi.cfg
    fi
  fi
  #cpatch jsclasses-*uptex*.patch 1 $TEXMF/packages/jsclasses
  cpatch $TMP_PREFIX/uptex-*/patch/utfsrc*uptex*.patch 1 $TEXMF/packages/utfsrc
  
  if test "$OTFINST" = "1"; then
    ./5macro_uptex.sh otf  2>&1 | tee log-$DATE
  fi
else
  make stage5
  if test "$OTFINST" = "1"; then
    make  otf  2>&1
  fi
fi

make babel
fmtutil-sys --byfmt eptex   || exit
fmtutil-sys --byfmt eplatex || exit

rm -rf $TMP_PREFIX/uptex-*/

if test -f $SRC/uptex-*.tar.gz; then
  fmtutil-sys --byfmt uptex   || exit
  fmtutil-sys --byfmt uplatex || exit
  fmtutil-sys --byfmt euptex   || exit
  fmtutil-sys --byfmt euplatex || exit
  echo "-----------------------------------------"
  echo "ptexlive + e-pTeX + upTeX make succeeded."
else
  echo "-----------------------------------------"
  echo "ptexlive + e-pTeX make succeeded."
fi

echo "Your next steps are following."
echo "  make font (or 'fonty')"
echo "  make test"
echo "  make install (by root)"
