#!/bin/bash
# Build Step 1 - extracting / patching source file and build

. ./option
export CFLAGS
unset CXXFLAGS
unset LDFLAGS

### TeX Live 2008 source
mkdir -p $CMP_TEMP
cd $CMP_TEMP
echo "[clean ]"
rm -rf texlive-*-source uptex-*
echo "[unpack] texlive-*-source.tar.lzma"
unlzma -dc $SRC/texlive-*-source.tar.lzma | $TAR -xf - 
# !TODO! xz-utils 対応

### ptexlive
cd $CMP_TEMP
PTEXLIVE_VER=`ls  $SRC/ptexlive-*.tar.gz|sed "s/.*ptexlive-//;s/.tar.gz//"`
echo ">>> Version of ptexlive: $PTEXLIVE_VER"
echo "[unpack] ptexlive-*.tar.gz"
$TAR zxf $SRC/ptexlive-*.tar.gz 


pushd $SRC &>/dev/null
### update dvipdfmx
if test -f $SRC/dvipdfmx-*.tar.gz; then
  DVIPDFMX=`ls  dvipdfmx-*.tar.gz|sed "s/.tar.gz//"`
  echo "[update] $DVIPDFMX"
  pushd $CMP_TEMP/texlive-*-source/texk &>/dev/null
  rm -rf dvipdfmx
  $TAR zxf $SRC/dvipdfmx-*.tar.gz
  mv $DVIPDFMX dvipdfmx
  popd &>/dev/null
else
  echo "*** Don't update dvipdfmx"
fi

UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
echo ">>> Version of upTeX: $UPTEX_VER"
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
echo ">>> Version of e-pTeX: $EPTEX_VER"
PTEXENC_VER=`ls  $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/ptexenc-*.tar.lzma|\
             sed "s/.*ptexenc-//;s/.tar.lzma//"`
echo ">>> Version of ptexenc: $PTEXENC_VER"

popd &>/dev/null

### extract sources
echo "[unpack] uptex-*.tar.gz"
$TAR zxf $SRC/uptex-*.tar.gz 
cd texlive-*-source/texk
echo "[unpack] makejvf-1.1a.tar.gz"
$TAR zxf $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/makejvf-1.1a.tar.gz
echo "[unpack] mendexk2.6e.tar.gz"
$TAR zxf $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/mendexk2.6e.tar.gz

echo "[unpack] ptexenc-*.tar.lzma"
unlzma -dc $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/ptexenc-*.tar.lzma | $TAR -xf - 
cd web2c
echo "[unpack] ptex-src-3.1.10.tar.gz"
$TAR zxf $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/ptex-src-3.1.10.tar.gz
echo "[patch]  Fixing bug of pTeX-3.1.10 (QA:53287 etc.)"
(cd ptex-src-3.1.10/ && patch -p0 < $SRC/tl08-compile/ptex-src-3.1.10-forum327.patch)

echo "[unpack] eptex-*.tar.gz"
$TAR jxf $SRC/eptex-*.tar.bz2
mv ptex-src-3.1.10/ ptexdir
cd ..
mv makejvf-1.1a/ makejvf
mv mendexk2.6e/ mendexk
mv ptexenc-*/ ptexenc
echo "[patch ] ptexlive's patch"
. ptexenc/patches/texlive2008.sh  &> /dev/null

# ptexenc-1.0.3 removed "ENC_UPTEX" etc. 
if test `echo $PTEXENC_VER|sed s/\\\.//g` -gt 102 ; then
  echo "ptexenc's version >= 1.0.3."
  echo "[patch ] ptexenc-1.0.3-enc_uptex.diff"
  cd ptexenc
  patch -p1 < $SRC/tl08-compile/ptexenc-1.0.3-enc_uptex.diff || exit 1
  cd ..
else
  echo "ptexenc's version <= 1.0.2."
fi
cd ..

# patch for e-pTeX
echo "[copy  ] ptexdir -> eptexdir"
cp -r texk/web2c/ptexdir texk/web2c/eptexdir
cp -r texk/web2c/eptex-*/* texk/web2c/eptexdir/ 
echo "[patch ] ep-tl08.patch"
cat $SRC/tl08-compile/ep-tl08.patch | sed "s/PATCH/$PATCH/" > ep-tl08.patch
$PATCH -p1 < ep-tl08.patch || exit 1
rm -f ep-tl08.patch

# patch for dvipsk
cd texk/dvipsk
echo "[unpack] dvipsk-5.97-p1.7b-tl.tar.gz"
$TAR zxf $CMP_TEMP/ptexlive-$PTEXLIVE_VER/archive/dvipsk-5.97-p1.7b-tl.tar.gz 
echo "[patch ] dvipsk-5.97-p1.7b-tl.diff"
$PATCH -p1 < dvipsk-5.97-p1.7b-tl.diff &>/dev/null

# patch for xdvik
cd ../xdvik
echo "[patch ] xdvik-tl08.patch.gz"
$ZCAT $SRC/tl08-compile/xdvik-tl08.patch.gz | $PATCH -p1 &>/dev/null
autoconf

# patch for upTeX
cd ../web2c/
echo "[copy  ] ptexdir -> uptexdir"
cp -r ptexdir/ uptexdir
cd uptexdir
mv ptex-base.ch uptex-base.ch
mv ptftopl.ch uptftopl.ch
mv ppltotf.ch uppltotf.ch
mv pdvitype.ch updvitype.ch
mv jbibtex.ch  upjbibtex.ch
cd ../../../
echo "[copy  ] upovp2ovf"
cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web 
cp texk/web2c/omegaware/ovp2ovf.ch texk/web2c/omegaware/upovp2ovf.ch 
echo "[patch ] uptex_src-*.patch"
cat $CMP_TEMP/uptex-*/patch/ptetex3-*_uptex_src-*.patch \
  |sed "s/3.141592/3.1415926/" > $CMP_TEMP/uptex-base-tmp.patch
$PATCH -p2 -f < $CMP_TEMP/uptex-base-tmp.patch &>/dev/null
cd texk/web2c/
echo "[copy  ] uptexdir -> euptexdir"
cp -r uptexdir/ euptexdir
cd euptexdir/      
cat ../eptexdir/etex.diff | sed "s/, Version 3.141592/, Version 3.1415926/" > etex.diff
cd ../../..
echo "[patch ] up-tl08.patch"
cat $SRC/tl08-compile/up-tl08.patch \
  | sed "s/UPTEXVER/$UPTEX_VER/;s/PTENCVAR/$PTEXENC_VER/;s/EPTEXVER/$EPTEX_VER/" \
  | sed "s/PATCH/$PATCH/" > $CMP_TEMP/up-tl08.patch 
$PATCH -p1 < $CMP_TEMP/up-tl08.patch  || exit 1
cd texk/ptexenc
echo "[patch ] uptex_ptexenc-0.999.patch"
$PATCH -p1 < $SRC/tl08-compile/uptex_ptexenc-0.999.patch || exit 1
cd ../..

echo "[patch ] texmfmem.h           (for e-pTeX)"
cat texk/web2c/texmfmem.h \
  | sed "s/\!defined(Aleph)/\!defined(Aleph)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" \
  > texk/web2c/texmfmem2.h
mv texk/web2c/texmfmem.h texk/web2c/texmfmem.h.orig
cp -f  texk/web2c/texmfmem2.h texk/web2c/texmfmem.h

# patch for FAM256 
if test "$FAM256" = "1"; then
  echo "[patch ] eptexdir/kanji.h etc (for FAM256 patch)"
cat <<EOF >> texk/web2c/eptexdir/kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> texk/web2c/eptexdir/eptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
cat <<EOF >> texk/web2c/euptexdir/kanji.h
#define getintone(w) (w).cint1
#define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> texk/web2c/euptexdir/euptex.defines
  @define function getintone( );
  @define procedure setintone( );
EOF
fi

# Applying misc. patches
cd $SRC/tl08-compile/patches
for x in * ; do
  echo "[patch] $x"
  (cd $CMP_TEMP/texlive-*-source && patch -p1 < $SRC/tl08-compile/patches/$x &>/dev/null || exit 0)
done


# BUILD!
cd $CMP_TEMP/texlive-*-source
./Build $CONF_OPT

# FAM256 
if test "$FAM256" = "1"; then
  echo "*** Make FAM256 enabled binaries of e-pTeX and e-upTeX ***"
  echo "         Return key to continue, or Ctrl+C to abort"
  read
  cd $CMP_TEMP/texlive-*-source/Work/texk/web2c

echo "[update] Banner of e-pTeX and e-upTeX"
  sed s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version`_FAM256-PATCHED/ \
     ../../../texk/web2c/eptexdir/ptexextra.in >eptexdir/eptexextra.h
  cat ../../../texk/web2c/euptexdir/ptexextra.in \
         | sed s/PTEX-VERSION/`cat ptexdir/ptex.version`/ \
         | sed s/UPTEX-VERSION/`cat uptexdir/uptex.version`/ \
         | sed "s/EPTEX-VERSION/`cat eptexdir/eptex.version`_FAM256-PATCHED/" \
         >euptexdir/euptexextra.h

echo "[patch ] Applying FAM256 patch to e-pTeX"
  cp eptex.web eptex.web.orig
  ./tie -m eptex.web eptex.web.orig ../../../texk/web2c/eptexdir/fam256.ch || exit 1

echo "[patch ] Applying FAM256 patch to e-upTeX"
  cp euptex.web euptex.web.orig
  cat <<EOF > fam256.diff
--- fam256.ch.orig      2009-03-04 23:26:27.000000000 +0900
+++ fam256.ch   2009-03-05 09:45:26.062449559 +0900
@@ -267,9 +267,9 @@
 @z
 %-----------------------------------------------
 @x
-char_given,math_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given: scanned_result(cur_chr)(int_val);
 @y
-char_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
 @z
 %-----------------------------------------------
 @x
@@ -1079,6 +1079,7 @@
 @d mu_skip_def_code=5 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=6 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=7 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=8 {|shorthand_def| for \.{\\\\kchardef}}
 @y
 @d omath_char_def_code=2 {|shorthand_def| for \.{\\\\omathchardef}}
 @d count_def_code=3 {|shorthand_def| for \.{\\\\countdef}}
@@ -1087,6 +1088,7 @@
 @d mu_skip_def_code=6 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=7 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=8 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=9 {|shorthand_def| for \.{\\\\kchardef}}
 @z
 %-----------------------------------------------
 @x
EOF
  cp ../../../texk/web2c/eptexdir/fam256.ch fam256.ch
  $PATCH -p0 < fam256.diff || exit 1
  ./tie -m euptex.web euptex.web.orig fam256.ch  || exit 1

echo "[build ] eptex"
  rm eptex.p eptex.pool eptexextra.o 
  $MAKE eptex || exit 1

echo "[build ] euptex"
  rm euptex.p euptex.pool euptexextra.o 
  $MAKE euptex || exit 1

echo "[copy  ] e-pTeX / e-upTeX binary to inst/bin/"
  ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
  cp eptex ../../../inst/bin/$ARCH/
  cp euptex ../../../inst/bin/$ARCH/
fi

echo "------------------------"
ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
$CMP_TEMP/texlive-*-source/inst/bin/$ARCH/eptex -version  |head -1
$CMP_TEMP/texlive-*-source/inst/bin/$ARCH/euptex -version |head -1


#This script ends here.
exit 0


# DEBUG: install binary
CMP_TEMP=/tmp
TL=/opt/TeX
ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/eptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/euptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/ptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/uptex $TL/bin/$ARCH/
exit 0

# DEBUG: Making tl08-compile-*.tar.bz2
cd $SRC
rm -f tl08-compile/*~
tar --lzma -cvf tl08-compile-`date +%y%m%d`.tar.lzma tl08-compile/
